/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.telegram.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppSupport;
import org.spin.queue.notification.telegram.support.Telegram;
import org.spin.util.ISetupDefinition;

public class Deploy
implements ISetupDefinition {
    public String doIt(Properties context, String transactionName) {
        this.createRegistration(context, transactionName);
        this.createSystemConfigHost(context, transactionName);
        this.createSystemConfigCode(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createRegistration(Properties context, String transactionName) {
        MADAppRegistration registration = (MADAppRegistration)new Query(context, "AD_AppRegistration", "EXISTS(SELECT 1 FROM AD_AppSupport s WHERE s.AD_AppSupport_ID = AD_AppRegistration.AD_AppSupport_ID AND s.ApplicationType = ?AND s.IsActive = 'Y'AND s.Classname = ?)", transactionName).setParameters(new Object[]{"STG", Telegram.class.getName()}).setClient_ID().first();
        if (registration != null && registration.getAD_AppRegistration_ID() > 0) {
            return;
        }
        MADAppSupport applicationSupport = (MADAppSupport)new Query(context, "AD_AppSupport", "Classname = ?", transactionName).setParameters(new Object[]{Telegram.class.getName()}).first();
        if (applicationSupport == null) {
            throw new AdempiereException("@AD_AppSupport_ID@ @NotFound@");
        }
        registration = new MADAppRegistration(context, 0, transactionName);
        registration.setApplicationType(applicationSupport.getApplicationType());
        registration.setAD_AppSupport_ID(applicationSupport.getAD_AppSupport_ID());
        registration.setAD_Org_ID(0);
        registration.setValue("Custom-Telegram-Sender");
        registration.setName("Custom Telegram Sender");
        registration.setVersionNo("1.0");
        registration.setHost("localhost");
        registration.setPort(0);
        registration.setTimeout(0);
        registration.saveEx();
        registration.setUUID("(*AutomaticSetup*)");
        registration.setIsDirectLoad(true);
        registration.saveEx();
    }

    private void createSystemConfigHost(Properties context, String transactionName) {
        MSysConfig systemConfig = new MSysConfig(context, 0, transactionName);
        systemConfig.setName("CLIENT_HOST");
        systemConfig.setDescription("Host for current client or tenant");
        systemConfig.setEntityType("ECA34");
        systemConfig.setConfigurationLevel("C");
        systemConfig.setAD_Org_ID(0);
        systemConfig.setValue("https://localhost");
        systemConfig.saveEx();
        systemConfig.setUUID("(*AutomaticSetup*)");
        systemConfig.setIsDirectLoad(true);
        systemConfig.saveEx();
    }

    private void createSystemConfigCode(Properties context, String transactionName) {
        MSysConfig systemConfig = new MSysConfig(context, 0, transactionName);
        systemConfig.setName("CLIENT_CODE");
        systemConfig.setDescription("Client Code or identification");
        systemConfig.setEntityType("ECA34");
        systemConfig.setConfigurationLevel("C");
        systemConfig.setAD_Org_ID(0);
        systemConfig.setValue("localhost");
        systemConfig.saveEx();
        systemConfig.setUUID("(*AutomaticSetup*)");
        systemConfig.setIsDirectLoad(true);
        systemConfig.saveEx();
    }
}

