/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.telegram.util;

import org.compiere.util.Util;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.model.MADNotificationRecipient;
import org.spin.queue.notification.telegram.util.ITelegramMessage;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;

public class BaseMessage
implements ITelegramMessage {
    public static SendMessage createBaseMessage() {
        SendMessage messageToSend = new SendMessage();
        messageToSend.setParseMode("Markdown");
        messageToSend.enableMarkdown(true);
        messageToSend.enableWebPagePreview();
        return messageToSend;
    }

    public static SendMessage createBaseMessage(String message, String chatId) {
        SendMessage messageToSend = new SendMessage();
        messageToSend.setParseMode("Markdown");
        messageToSend.enableMarkdown(true);
        messageToSend.enableWebPagePreview();
        messageToSend.setText(message);
        messageToSend.setChatId(chatId);
        return messageToSend;
    }

    @Override
    public SendMessage createAndGetMessage(MADNotificationQueue notification, MADNotificationRecipient recipient) {
        SendMessage message = BaseMessage.createBaseMessage();
        StringBuilder messageInfo = new StringBuilder();
        if (!Util.isEmpty((String)notification.getDescription())) {
            messageInfo.append("*").append(notification.getDescription().trim()).append("*").append("\n");
        }
        if (!Util.isEmpty((String)notification.getText())) {
            messageInfo.append(notification.getText());
        }
        message.setText(messageInfo.toString());
        message.setChatId(recipient.getAccountName());
        return message;
    }
}

