/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.legacy.apache.ecs;

import org.adempiere.legacy.apache.ecs.Element;
import org.adempiere.legacy.apache.ecs.Printable;
import org.adempiere.legacy.apache.ecs.SinglePartElement;

public class Doctype
extends SinglePartElement
implements Printable {
    private static final long serialVersionUID = -2075836145789129398L;
    public static final String elementName = "!DOCTYPE";
    public static final String PUBLIC = "PUBLIC";
    protected String name;
    protected String visibility;
    protected String identifier;
    protected String uri;

    public Doctype() {
        this.setElementType(elementName);
        this.setCase(1);
        this.updateElementType();
    }

    public Doctype(String name, String id, String uri) {
        this.setElementType(elementName);
        this.setCase(1);
        this.name = name;
        this.visibility = PUBLIC;
        this.identifier = id;
        this.uri = uri;
        this.updateElementType();
    }

    public Doctype(String name, String visibility, String id, String uri) {
        this.setElementType(elementName);
        this.setCase(1);
        this.name = name;
        this.visibility = visibility;
        this.identifier = id;
        this.uri = uri;
        this.updateElementType();
    }

    protected void updateElementType() {
        this.setElementType("!DOCTYPE " + this.name + " " + this.visibility + " " + this.identifier + " " + this.uri);
    }

    public Doctype setName(String name) {
        this.name = name;
        this.updateElementType();
        return this;
    }

    public Doctype setVisibility(String visibility) {
        this.visibility = visibility;
        this.updateElementType();
        return this;
    }

    public Doctype setIdentifier(String identifier) {
        this.identifier = identifier;
        this.updateElementType();
        return this;
    }

    public Doctype setUri(String uri) {
        this.uri = uri;
        this.updateElementType();
        return this;
    }

    public Doctype addElement(String hashcode, Element element) {
        this.addElementToRegistry(hashcode, element);
        return this;
    }

    public Doctype addElement(String hashcode, String element) {
        this.addElementToRegistry(hashcode, element);
        return this;
    }

    public Doctype addElement(Element element) {
        this.addElementToRegistry(element);
        return this;
    }

    public Doctype addElement(String element) {
        this.addElementToRegistry(element);
        return this;
    }

    public Doctype removeElement(String hashcode) {
        this.removeElementFromRegistry(hashcode);
        return this;
    }

    public static class XHtml10Frameset
    extends Doctype {
        private static final long serialVersionUID = 4590750316568237831L;

        public XHtml10Frameset() {
            this.name = "html";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD XHTML 1.0 Frameset//EN\"";
            this.uri = "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\"";
            this.updateElementType();
        }
    }

    public static class XHtml10Transitional
    extends Doctype {
        private static final long serialVersionUID = -79107605400685902L;

        public XHtml10Transitional() {
            this.name = "html";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD XHTML 1.0 Transitional//EN\"";
            this.uri = "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"";
            this.updateElementType();
        }
    }

    public static class XHtml10Strict
    extends Doctype {
        private static final long serialVersionUID = 906251485117803601L;

        public XHtml10Strict() {
            this.name = "html";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD XHTML 1.0 Strict//EN\"";
            this.uri = "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html40Frameset
    extends Doctype {
        private static final long serialVersionUID = 5442355270707253725L;

        public Html40Frameset() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.0 Frameset//EN\"";
            this.uri = "\"http://www.w3.org/TR/REC-html40/frameset.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html40Transitional
    extends Doctype {
        private static final long serialVersionUID = -2561532059315520359L;

        public Html40Transitional() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.0 Transitional//EN\"";
            this.uri = "\"http://www.w3.org/TR/REC-html40/loose.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html40Strict
    extends Doctype {
        private static final long serialVersionUID = -6768117303055082689L;

        public Html40Strict() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.0//EN\"";
            this.uri = "\"http://www.w3.org/TR/REC-html40/strict.dtd\"";
            this.updateElementType();
        }
    }
}

