/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.client;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Tag;
import com.erudika.para.core.User;
import com.erudika.para.core.rest.Signer;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.core.validation.Constraint;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import nl.altindag.ssl.SSLFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParaClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ParaClient.class);
    private static final String DEFAULT_ENDPOINT = "https://paraio.com";
    private static final String DEFAULT_PATH = "/v1/";
    private static final String JWT_PATH = "/jwt_auth";
    private final String protocols = Para.getConfig().clientSslProtocols();
    private final String keystorePath = Para.getConfig().clientSslKeystore();
    private final String keystorePass = Para.getConfig().clientSslKeystorePassword();
    private final String truststorePath = Para.getConfig().clientSslTruststore();
    private final String truststorePass = Para.getConfig().clientSslTruststorePassword();
    private String endpoint;
    private String path;
    private String accessKey;
    private String secretKey;
    private String tokenKey;
    private Long tokenKeyExpires;
    private Long tokenKeyNextRefresh;
    private int chunkSize = 0;
    private boolean throwExceptionOnHTTPError;
    private final CloseableHttpClient httpclient;
    private final ObjectMapper mapper;

    public ParaClient(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        if (StringUtils.length((CharSequence)secretKey) < 6) {
            logger.warn("Secret key appears to be invalid. Make sure you call 'signIn()' first.");
        }
        this.throwExceptionOnHTTPError = false;
        this.mapper = ParaObjectUtils.getJsonMapper();
        this.mapper.setSerializationInclusion(JsonInclude.Include.USE_DEFAULTS);
        SSLFactory sslFactory = null;
        if (!StringUtils.isBlank((CharSequence)this.truststorePath)) {
            sslFactory = SSLFactory.builder().withTrustMaterial(Paths.get(this.truststorePath, new String[0]), this.truststorePass.toCharArray()).withProtocols(new String[]{this.protocols}).build();
        }
        if (!StringUtils.isBlank((CharSequence)this.keystorePath)) {
            sslFactory = SSLFactory.builder().withIdentityMaterial(Paths.get(this.keystorePath, new String[0]), this.keystorePass.toCharArray()).withTrustMaterial(Paths.get(this.truststorePath, new String[0]), this.truststorePass.toCharArray()).withProtocols(new String[]{this.protocols}).build();
        }
        if (sslFactory == null) {
            sslFactory = SSLFactory.builder().withDefaultTrustMaterial().build();
        }
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setHostnameVerifier(sslFactory.getHostnameVerifier()).setSslContext(sslFactory.getSslContext()).build()).build();
        int timeout = 30;
        this.httpclient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).setConnectionReuseStrategy((hr, hr1, hc) -> false).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build()).build();
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void close() {
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
    }

    public App getApp() {
        return (App)this.me();
    }

    public String getEndpoint() {
        if (StringUtils.isBlank((CharSequence)this.endpoint)) {
            return DEFAULT_ENDPOINT;
        }
        return this.endpoint;
    }

    public void setApiPath(String path) {
        this.path = path;
    }

    public String getApiPath() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return DEFAULT_PATH;
        }
        if (!this.path.endsWith("/")) {
            this.path = this.path + "/";
        }
        return this.path;
    }

    public String getAccessToken() {
        return this.tokenKey;
    }

    public String getServerVersion() {
        Map res = (Map)this.invokeGet("", null, Map.class);
        if (res == null || StringUtils.isBlank((CharSequence)((String)res.get("version")))) {
            return "unknown";
        }
        return (String)res.get("version");
    }

    public void setAccessToken(String token) {
        if (!StringUtils.isBlank((CharSequence)token)) {
            try {
                String payload = Utils.base64dec((String)StringUtils.substringBetween((String)token, (String)".", (String)"."));
                Map decoded = (Map)this.mapper.readValue(payload, Map.class);
                if (decoded != null && decoded.containsKey("exp")) {
                    this.tokenKeyExpires = (Long)decoded.get("exp");
                    this.tokenKeyNextRefresh = (Long)decoded.get("refresh");
                }
            }
            catch (Exception ex) {
                this.tokenKeyExpires = null;
                this.tokenKeyNextRefresh = null;
            }
        }
        this.tokenKey = token;
    }

    private void clearAccessToken() {
        this.tokenKey = null;
        this.tokenKeyExpires = null;
        this.tokenKeyNextRefresh = null;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void throwExceptionOnHTTPError(boolean enabled) {
        this.throwExceptionOnHTTPError = enabled;
    }

    private String key(boolean refresh) {
        if (this.tokenKey != null) {
            if (refresh) {
                this.refreshToken();
            }
            return "Bearer " + this.tokenKey;
        }
        return this.secretKey;
    }

    private <T> T readEntity(HttpEntity respEntity, Class<?> returnType, int statusCode, String reason) throws IOException {
        if (respEntity != null) {
            if (statusCode == 200 || statusCode == 201 || statusCode == 304) {
                return this.readEntity(respEntity, returnType);
            }
            if (statusCode != 404 && statusCode != 304 && statusCode != 204) {
                Map error = (Map)this.readEntity(respEntity, Map.class);
                if (error != null && error.containsKey("code")) {
                    String msg = error.containsKey("message") ? (String)error.get("message") : "error";
                    RuntimeException e = new RuntimeException((Integer)error.get("code") + " - " + msg);
                    logger.error("{} - {}", error.get("code"), (Object)e.getMessage());
                    if (this.throwExceptionOnHTTPError) {
                        throw e;
                    }
                } else {
                    logger.error("{} - {}", (Object)statusCode, (Object)reason);
                    if (this.throwExceptionOnHTTPError) {
                        throw new RuntimeException(statusCode + " - " + reason);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readEntity(HttpEntity entity, Class<?> type) {
        try (InputStream in = entity.getContent();){
            if (in == null) return null;
            if (type == null) return null;
            if (type.isAssignableFrom(String.class)) {
                String string = new String(IOUtils.toByteArray((InputStream)in), Para.getConfig().defaultEncoding());
                return (T)string;
            }
            Object object = this.mapper.readerFor(type).readValue(in);
            return (T)object;
        }
        catch (Exception ex) {
            logger.debug(null, (Throwable)ex);
            return null;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
    }

    protected String getFullPath(String resourcePath) {
        if (StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)JWT_PATH)) {
            return resourcePath;
        }
        if (resourcePath == null) {
            resourcePath = "";
        } else if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        return this.getApiPath() + resourcePath;
    }

    public <T> T invokeGet(String resourcePath, MultivaluedMap<String, String> params, Class<?> returnType) {
        logger.debug("GET {}, params: {}", (Object)this.getFullPath(resourcePath), params);
        return this.invokeSignedRequest(this.accessKey, this.key(!JWT_PATH.equals(resourcePath)), App.AllowedMethods.GET.toString(), this.getEndpoint(), this.getFullPath(resourcePath), null, params, null, returnType);
    }

    public <T> T invokePost(String resourcePath, Object entity, Class<?> returnType) {
        logger.debug("POST {}, entity: {}", new Object[]{this.getFullPath(resourcePath), entity, returnType});
        return this.invokeSignedRequest(this.accessKey, this.key(true), App.AllowedMethods.POST.toString(), this.getEndpoint(), this.getFullPath(resourcePath), null, null, entity, returnType);
    }

    public <T> T invokePut(String resourcePath, Object entity, Class<?> returnType) {
        logger.debug("PUT {}, entity: {}", (Object)this.getFullPath(resourcePath), entity);
        return this.invokeSignedRequest(this.accessKey, this.key(true), App.AllowedMethods.PUT.toString(), this.getEndpoint(), this.getFullPath(resourcePath), null, null, entity, returnType);
    }

    public <T> T invokePatch(String resourcePath, Object entity, Class<?> returnType) {
        logger.debug("PATCH {}, entity: {}", (Object)this.getFullPath(resourcePath), entity);
        return this.invokeSignedRequest(this.accessKey, this.key(true), App.AllowedMethods.PATCH.toString(), this.getEndpoint(), this.getFullPath(resourcePath), null, null, entity, returnType);
    }

    public <T> T invokeDelete(String resourcePath, MultivaluedMap<String, String> params, Class<?> returnType) {
        logger.debug("DELETE {}, params: {}", (Object)this.getFullPath(resourcePath), params);
        return this.invokeSignedRequest(this.accessKey, this.key(true), App.AllowedMethods.DELETE.toString(), this.getEndpoint(), this.getFullPath(resourcePath), null, params, null, returnType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T invokeSignedRequest(String accessKey, String secretKey, String method, String apiURL, String path, Map<String, String> headers, MultivaluedMap<String, String> params, Object entity, Class<?> returnType) {
        boolean isJWT = StringUtils.startsWithIgnoreCase((CharSequence)secretKey, (CharSequence)"Bearer");
        try {
            Object uri = this.getEndpoint() + path;
            Map signedHeaders = new HashMap();
            byte[] jsonEntity = this.getJsonEntityAsBytes(entity);
            Signer signer = new Signer();
            if (!isJWT) {
                signedHeaders = signer.signRequest(accessKey, secretKey, method, this.getEndpoint(), path, headers, params, jsonEntity);
            }
            uri = this.setQueryParameters((String)uri, params);
            HttpUriRequest req = this.getHttpUriRequest((String)uri, method, jsonEntity);
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    req.addHeader(header.getKey(), (Object)header.getValue());
                }
            }
            if (isJWT) {
                req.setHeader("Authorization", (Object)secretKey);
            } else {
                req.setHeader("Authorization", signedHeaders.get("Authorization"));
                req.setHeader("X-Amz-Date", signedHeaders.get("X-Amz-Date"));
            }
            if (Para.getConfig().clientUserAgentEnabled()) {
                String userAgent = "Para client " + Para.getVersion() + " " + accessKey + " (Java " + System.getProperty("java.runtime.version") + ")";
                req.setHeader("User-Agent", (Object)userAgent);
            }
            try (CloseableHttpResponse resp = this.httpclient.execute((ClassicHttpRequest)req);){
                HttpEntity respEntity = resp.getEntity();
                int statusCode = resp.getCode();
                String reason = resp.getReasonPhrase();
                T t = this.readEntity(respEntity, returnType, statusCode, reason);
                return t;
            }
            catch (Exception ex) {
                String msg = "Failed to execute signed " + method + " request to " + path + ": " + ex.getMessage();
                if (this.throwExceptionOnHTTPError) {
                    throw new RuntimeException(msg);
                }
                logger.error(msg);
                return null;
            }
        }
        catch (URISyntaxException ex) {
            logger.error(null, (Throwable)ex);
        }
        return null;
    }

    private byte[] getJsonEntityAsBytes(Object entity) {
        if (entity != null) {
            try {
                return ParaObjectUtils.getJsonWriterNoIdent().writeValueAsBytes(entity);
            }
            catch (JsonProcessingException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return null;
    }

    private String setQueryParameters(String uri, MultivaluedMap<String, String> params) {
        if (params != null) {
            LinkedList<CallSite> paramz = new LinkedList<CallSite>();
            for (Map.Entry param : params.entrySet()) {
                String key = (String)param.getKey();
                List value = (List)param.getValue();
                if (value == null || value.isEmpty() || value.get(0) == null) continue;
                for (String pv : value) {
                    paramz.add((CallSite)((Object)(key + "=" + Utils.urlEncode((String)pv))));
                }
            }
            if (!paramz.isEmpty()) {
                uri = (String)uri + "?" + String.join((CharSequence)"&", paramz);
            }
        }
        return uri;
    }

    private HttpUriRequest getHttpUriRequest(String uri, String method, byte[] jsonEntity) throws URISyntaxException {
        HttpGet req;
        switch (method) {
            case "GET": {
                req = new HttpGet(uri);
                break;
            }
            case "POST": {
                req = new HttpPost(uri);
                if (jsonEntity == null) break;
                ((HttpPost)req).setEntity((HttpEntity)new ByteArrayEntity(jsonEntity, ContentType.APPLICATION_JSON));
                break;
            }
            case "PUT": {
                req = new HttpPut(uri);
                if (jsonEntity == null) break;
                ((HttpPut)req).setEntity((HttpEntity)new ByteArrayEntity(jsonEntity, ContentType.APPLICATION_JSON));
                break;
            }
            case "PATCH": {
                req = new HttpPatch(uri);
                if (jsonEntity == null) break;
                ((HttpPatch)req).setEntity((HttpEntity)new ByteArrayEntity(jsonEntity, ContentType.APPLICATION_JSON));
                break;
            }
            case "DELETE": {
                req = new HttpDelete(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return req;
    }

    public MultivaluedMap<String, String> pagerToParams(Pager ... pager) {
        Pager p;
        MultivaluedHashMap map = new MultivaluedHashMap();
        if (pager != null && pager.length > 0 && (p = pager[0]) != null) {
            map.put((Object)"page", Collections.singletonList(Long.toString(p.getPage())));
            map.put((Object)"desc", Collections.singletonList(Boolean.toString(p.isDesc())));
            map.put((Object)"limit", Collections.singletonList(Integer.toString(p.getLimit())));
            if (p.getLastKey() != null) {
                map.put((Object)"lastKey", Collections.singletonList(p.getLastKey()));
            }
            if (p.getSortby() != null) {
                map.put((Object)"sort", Collections.singletonList(p.getSortby()));
            }
            if (!p.getSelect().isEmpty()) {
                map.put((Object)"select", Collections.singletonList(StringUtils.join((Iterable)p.getSelect(), (String)",")));
            }
        }
        return map;
    }

    public <P extends ParaObject> List<P> getItemsFromList(List<?> result) {
        if (result != null && !result.isEmpty()) {
            ArrayList<ParaObject> objects = new ArrayList<ParaObject>(result.size());
            for (Object map : result) {
                ParaObject p = ParaObjectUtils.setAnnotatedFields((Map)((Map)map));
                if (p == null) continue;
                objects.add(p);
            }
            return objects;
        }
        return Collections.emptyList();
    }

    public <P extends ParaObject> List<P> getItems(String at, Map<String, Object> result, Pager ... pager) {
        if (result != null && !result.isEmpty() && !StringUtils.isBlank((CharSequence)at) && result.containsKey(at)) {
            if (pager != null && pager.length > 0 && pager[0] != null) {
                if (result.containsKey("totalHits")) {
                    pager[0].setCount(((Integer)result.get("totalHits")).longValue());
                }
                if (result.containsKey("lastKey")) {
                    pager[0].setLastKey((String)result.get("lastKey"));
                }
            }
            return this.getItemsFromList((List)result.get(at));
        }
        return Collections.emptyList();
    }

    private <P extends ParaObject> List<P> getItems(Map<String, Object> result, Pager ... pager) {
        return this.getItems("items", result, pager);
    }

    private int getNumChunks(List<?> objects, int size) {
        return size <= 0 ? 1 : (objects.size() + size - 1) / size;
    }

    private List<?> partitionList(List<?> objects, int i, int size) {
        return size <= 0 ? objects : objects.subList(i * size, Math.min((i + 1) * size, objects.size()));
    }

    public <P extends ParaObject> P create(P obj) {
        if (obj == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)obj.getId()) || StringUtils.isBlank((CharSequence)obj.getType())) {
            return (P)((ParaObject)this.invokePost(Utils.urlEncode((String)obj.getType()), obj, obj.getClass()));
        }
        return (P)((ParaObject)this.invokePut(obj.getObjectURI(), obj, obj.getClass()));
    }

    public <P extends ParaObject> P read(String type, String id) {
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (P)((ParaObject)this.invokeGet(Utils.urlEncode((String)type).concat("/").concat(Utils.urlEncode((String)id)), null, ParaObjectUtils.toClass((String)type)));
    }

    public <P extends ParaObject> P read(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Map data = (Map)this.invokeGet("_id/".concat(Utils.urlEncode((String)id)), null, Map.class);
        return (P)ParaObjectUtils.setAnnotatedFields((Map)data);
    }

    public <P extends ParaObject> P update(P obj) {
        if (obj == null) {
            return null;
        }
        return (P)((ParaObject)this.invokePatch(obj.getObjectURI(), obj, obj.getClass()));
    }

    public <P extends ParaObject> void delete(P obj) {
        if (obj == null || obj.getId() == null) {
            return;
        }
        this.invokeDelete(obj.getObjectURI(), null, null);
    }

    public <P extends ParaObject> List<P> createAll(List<P> objects) {
        if (objects == null || objects.isEmpty() || objects.get(0) == null) {
            return Collections.emptyList();
        }
        int size = this.chunkSize;
        return IntStream.range(0, this.getNumChunks(objects, size)).mapToObj(i -> this.partitionList(objects, i, size)).map(chunk -> this.invokePost("_batch", chunk, List.class)).map(response -> (List)response).map(entity -> this.getItemsFromList((List<?>)entity)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public <P extends ParaObject> List<P> readAll(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        int size = this.chunkSize;
        return IntStream.range(0, this.getNumChunks(keys, size)).mapToObj(i -> this.partitionList(keys, i, size)).map(chunk -> {
            MultivaluedHashMap ids = new MultivaluedHashMap();
            ids.put((Object)"ids", chunk);
            return this.invokeGet("_batch", (MultivaluedMap<String, String>)ids, List.class);
        }).map(response -> (List)response).map(entity -> this.getItemsFromList((List<?>)entity)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public <P extends ParaObject> List<P> updateAll(List<P> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        int size = this.chunkSize;
        return IntStream.range(0, this.getNumChunks(objects, size)).mapToObj(i -> this.partitionList(objects, i, size)).map(chunk -> this.invokePatch("_batch", chunk, List.class)).map(response -> (List)response).map(entity -> this.getItemsFromList((List<?>)entity)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void deleteAll(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        int size = this.chunkSize;
        IntStream.range(0, this.getNumChunks(keys, size)).mapToObj(i -> this.partitionList(keys, i, size)).forEach(chunk -> {
            MultivaluedHashMap ids = new MultivaluedHashMap();
            ids.put((Object)"ids", chunk);
            this.invokeDelete("_batch", (MultivaluedMap<String, String>)ids, null);
        });
    }

    public <P extends ParaObject> List<P> list(String type, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return Collections.emptyList();
        }
        return this.getItems((Map)this.invokeGet(Utils.urlEncode((String)type), this.pagerToParams(pager), Map.class), pager);
    }

    public <P extends ParaObject> P findById(String id) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"id", (Object)id);
        List<P> list = this.getItems(this.find("id", (MultivaluedMap<String, String>)params), new Pager[0]);
        return (P)(list.isEmpty() ? null : (ParaObject)list.get(0));
    }

    public <P extends ParaObject> List<P> findByIds(List<String> ids) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.put((Object)"ids", ids);
        return this.getItems(this.find("ids", (MultivaluedMap<String, String>)params), new Pager[0]);
    }

    public <P extends ParaObject> List<P> findNearby(String type, String query, int radius, double lat, double lng, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"latlng", (Object)(lat + "," + lng));
        params.putSingle((Object)"radius", (Object)Integer.toString(radius));
        params.putSingle((Object)"q", (Object)query);
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("nearby", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findPrefix(String type, String field, String prefix, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"field", (Object)field);
        params.putSingle((Object)"prefix", (Object)prefix);
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("prefix", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findQuery(String type, String query, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"q", (Object)query);
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findNestedQuery(String type, String field, String query, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"q", (Object)query);
        params.putSingle((Object)"field", (Object)field);
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("nested", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findSimilar(String type, String filterKey, String[] fields, String liketext, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.put((Object)"fields", fields == null ? null : Arrays.asList(fields));
        params.putSingle((Object)"filterid", (Object)filterKey);
        params.putSingle((Object)"like", (Object)liketext);
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("similar", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findTagged(String type, String[] tags, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.put((Object)"tags", tags == null ? null : Arrays.asList(tags));
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("tagged", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findTags(String keyword, Pager ... pager) {
        keyword = keyword == null ? "*" : keyword.concat("*");
        return this.findWildcard(Utils.type(Tag.class), "tag", keyword, pager);
    }

    public <P extends ParaObject> List<P> findTermInList(String type, String field, List<String> terms, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"field", (Object)field);
        params.put((Object)"terms", terms);
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("in", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findTerms(String type, Map<String, ?> terms, boolean matchAll, Pager ... pager) {
        if (terms == null) {
            return Collections.emptyList();
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"matchall", (Object)Boolean.toString(matchAll));
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, ?> term : terms.entrySet()) {
            String key = term.getKey();
            Object value = term.getValue();
            if (value == null) continue;
            list.add(key.concat(Para.getConfig().separator()).concat(value.toString()));
        }
        if (!terms.isEmpty()) {
            params.put((Object)"terms", list);
        }
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("terms", (MultivaluedMap<String, String>)params), pager);
    }

    public <P extends ParaObject> List<P> findWildcard(String type, String field, String wildcard, Pager ... pager) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"field", (Object)field);
        params.putSingle((Object)"q", (Object)wildcard);
        params.putSingle((Object)"type", (Object)type);
        params.putAll(this.pagerToParams(pager));
        return this.getItems(this.find("wildcard", (MultivaluedMap<String, String>)params), pager);
    }

    public Long getCount(String type) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"type", (Object)type);
        Pager pager = new Pager();
        this.getItems(this.find("count", (MultivaluedMap<String, String>)params), pager);
        return pager.getCount();
    }

    public Long getCount(String type, Map<String, ?> terms) {
        if (terms == null) {
            return 0L;
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, ?> term : terms.entrySet()) {
            String key = term.getKey();
            Object value = term.getValue();
            if (value == null) continue;
            list.add(key.concat(Para.getConfig().separator()).concat(value.toString()));
        }
        if (!terms.isEmpty()) {
            params.put((Object)"terms", list);
        }
        params.putSingle((Object)"type", (Object)type);
        params.putSingle((Object)"count", (Object)"true");
        Pager pager = new Pager();
        this.getItems(this.find("terms", (MultivaluedMap<String, String>)params), pager);
        return pager.getCount();
    }

    private Map<String, Object> find(String queryType, MultivaluedMap<String, String> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (params != null && !params.isEmpty()) {
            String qType;
            String string = qType = StringUtils.isBlank((CharSequence)queryType) ? "/default" : "/".concat(queryType);
            if (StringUtils.isBlank((CharSequence)((CharSequence)params.getFirst((Object)"type")))) {
                return (Map)this.invokeGet("search" + qType, params, Map.class);
            }
            return (Map)this.invokeGet((String)params.getFirst((Object)"type") + "/search" + qType, params, Map.class);
        }
        map.put("items", Collections.emptyList());
        map.put("totalHits", 0);
        return map;
    }

    public Long countLinks(ParaObject obj, String type2) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return 0L;
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"count", (Object)"true");
        Pager pager = new Pager();
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        this.getItems((Map)this.invokeGet(url, (MultivaluedMap<String, String>)params, Map.class), pager);
        return pager.getCount();
    }

    public <P extends ParaObject> List<P> getLinkedObjects(ParaObject obj, String type2, Pager ... pager) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return Collections.emptyList();
        }
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        return this.getItems((Map)this.invokeGet(url, this.pagerToParams(pager), Map.class), pager);
    }

    public <P extends ParaObject> List<P> findLinkedObjects(ParaObject obj, String type2, String field, String query, Pager ... pager) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return Collections.emptyList();
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"field", (Object)field);
        params.putSingle((Object)"q", (Object)(query == null ? "*" : query));
        params.putAll(this.pagerToParams(pager));
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        return this.getItems((Map)this.invokeGet(url, (MultivaluedMap<String, String>)params, Map.class), pager);
    }

    public boolean isLinked(ParaObject obj, String type2, String id2) {
        if (obj == null || obj.getId() == null || type2 == null || id2 == null) {
            return false;
        }
        String url = Utils.formatMessage((String)"{0}/links/{1}/{2}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2), Utils.urlEncode((String)id2)});
        Boolean result = (Boolean)this.invokeGet(url, null, Boolean.class);
        return result != null && result != false;
    }

    public boolean isLinked(ParaObject obj, ParaObject toObj) {
        if (obj == null || obj.getId() == null || toObj == null || toObj.getId() == null) {
            return false;
        }
        return this.isLinked(obj, toObj.getType(), toObj.getId());
    }

    public String link(ParaObject obj, String id2) {
        if (obj == null || obj.getId() == null || id2 == null) {
            return null;
        }
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)id2)});
        return (String)this.invokePost(url, null, String.class);
    }

    public void unlink(ParaObject obj, String type2, String id2) {
        if (obj == null || obj.getId() == null || type2 == null || id2 == null) {
            return;
        }
        String url = Utils.formatMessage((String)"{0}/links/{1}/{2}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2), Utils.urlEncode((String)id2)});
        this.invokeDelete(url, null, null);
    }

    public void unlinkAll(ParaObject obj) {
        if (obj == null || obj.getId() == null) {
            return;
        }
        String url = Utils.formatMessage((String)"{0}/links", (Object[])new Object[]{obj.getObjectURI()});
        this.invokeDelete(url, null, null);
    }

    public Long countChildren(ParaObject obj, String type2) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return 0L;
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"count", (Object)"true");
        params.putSingle((Object)"childrenonly", (Object)"true");
        Pager pager = new Pager();
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        this.getItems((Map)this.invokeGet(url, (MultivaluedMap<String, String>)params, Map.class), pager);
        return pager.getCount();
    }

    public <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, Pager ... pager) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return Collections.emptyList();
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"childrenonly", (Object)"true");
        params.putAll(this.pagerToParams(pager));
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        return this.getItems((Map)this.invokeGet(url, (MultivaluedMap<String, String>)params, Map.class), pager);
    }

    public <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, String field, String term, Pager ... pager) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return Collections.emptyList();
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"childrenonly", (Object)"true");
        params.putSingle((Object)"field", (Object)field);
        params.putSingle((Object)"term", (Object)term);
        params.putAll(this.pagerToParams(pager));
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        return this.getItems((Map)this.invokeGet(url, (MultivaluedMap<String, String>)params, Map.class), pager);
    }

    public <P extends ParaObject> List<P> findChildren(ParaObject obj, String type2, String query, Pager ... pager) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return Collections.emptyList();
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"childrenonly", (Object)"true");
        params.putSingle((Object)"q", (Object)(query == null ? "*" : query));
        params.putAll(this.pagerToParams(pager));
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        return this.getItems((Map)this.invokeGet(url, (MultivaluedMap<String, String>)params, Map.class), pager);
    }

    public void deleteChildren(ParaObject obj, String type2) {
        if (obj == null || obj.getId() == null || type2 == null) {
            return;
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"childrenonly", (Object)"true");
        String url = Utils.formatMessage((String)"{0}/links/{1}", (Object[])new Object[]{obj.getObjectURI(), Utils.urlEncode((String)type2)});
        this.invokeDelete(url, (MultivaluedMap<String, String>)params, null);
    }

    public String newId() {
        String res = (String)this.invokeGet("utils/newid", null, String.class);
        return res != null ? res : "";
    }

    public long getTimestamp() {
        Long res = (Long)this.invokeGet("utils/timestamp", null, Long.class);
        return res != null ? res : 0L;
    }

    public String formatDate(String format, Locale loc) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"format", (Object)format);
        params.putSingle((Object)"locale", (Object)(loc == null ? null : loc.toString()));
        return (String)this.invokeGet("utils/formatdate", (MultivaluedMap<String, String>)params, String.class);
    }

    public String noSpaces(String str, String replaceWith) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"string", (Object)str);
        params.putSingle((Object)"replacement", (Object)replaceWith);
        return (String)this.invokeGet("utils/nospaces", (MultivaluedMap<String, String>)params, String.class);
    }

    public String stripAndTrim(String str) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"string", (Object)str);
        return (String)this.invokeGet("utils/nosymbols", (MultivaluedMap<String, String>)params, String.class);
    }

    public String markdownToHtml(String markdownString) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"md", (Object)markdownString);
        return (String)this.invokeGet("utils/md2html", (MultivaluedMap<String, String>)params, String.class);
    }

    public String approximately(long delta) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"delta", (Object)Long.toString(delta));
        return (String)this.invokeGet("utils/timeago", (MultivaluedMap<String, String>)params, String.class);
    }

    public Map<String, String> newKeys() {
        Map keys = (Map)this.invokePost("_newkeys", null, Map.class);
        if (keys != null && keys.containsKey("secretKey")) {
            this.secretKey = (String)keys.get("secretKey");
        }
        return keys;
    }

    public Map<String, String> types() {
        return (Map)this.invokeGet("_types", null, Map.class);
    }

    public Map<String, Number> typesCount() {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"count", (Object)"true");
        return (Map)this.invokeGet("_types", (MultivaluedMap<String, String>)params, Map.class);
    }

    public <P extends ParaObject> P me() {
        Map data = (Map)this.invokeGet("_me", null, Map.class);
        return (P)ParaObjectUtils.setAnnotatedFields((Map)data);
    }

    public <P extends ParaObject> P me(String accessToken) {
        if (!StringUtils.isBlank((CharSequence)accessToken)) {
            Object auth = accessToken.startsWith("Bearer") ? accessToken : "Bearer " + accessToken;
            Map data = (Map)this.invokeSignedRequest(this.accessKey, (String)auth, App.AllowedMethods.GET.toString(), this.getEndpoint(), this.getFullPath("_me"), null, null, null, Map.class);
            return (P)ParaObjectUtils.setAnnotatedFields((Map)data);
        }
        return this.me();
    }

    public boolean voteUp(ParaObject obj, String voterid) {
        return this.voteUp(obj, voterid, null, null);
    }

    public boolean voteUp(ParaObject obj, String voterid, Integer expiresAfter, Integer lockedAfter) {
        if (obj == null || StringUtils.isBlank((CharSequence)voterid)) {
            return false;
        }
        if (expiresAfter == null && lockedAfter == null) {
            return (Boolean)this.invokePatch(obj.getObjectURI(), Collections.singletonMap("_voteup", voterid), Boolean.class);
        }
        HashMap<String, Object> vote = new HashMap<String, Object>();
        vote.put("_voteup", voterid);
        vote.put("_vote_locked_after", lockedAfter);
        vote.put("_vote_expires_after", expiresAfter);
        return (Boolean)this.invokePatch(obj.getObjectURI(), vote, Boolean.class);
    }

    public boolean voteDown(ParaObject obj, String voterid) {
        return this.voteDown(obj, voterid, null, null);
    }

    public boolean voteDown(ParaObject obj, String voterid, Integer expiresAfter, Integer lockedAfter) {
        if (obj == null || StringUtils.isBlank((CharSequence)voterid)) {
            return false;
        }
        if (expiresAfter == null && lockedAfter == null) {
            return (Boolean)this.invokePatch(obj.getObjectURI(), Collections.singletonMap("_votedown", voterid), Boolean.class);
        }
        HashMap<String, Object> vote = new HashMap<String, Object>();
        vote.put("_votedown", voterid);
        vote.put("_vote_locked_after", lockedAfter);
        vote.put("_vote_expires_after", expiresAfter);
        return (Boolean)this.invokePatch(obj.getObjectURI(), vote, Boolean.class);
    }

    public Map<String, Object> rebuildIndex() {
        return (Map)this.invokePost("_reindex", null, Map.class);
    }

    public Map<String, Object> rebuildIndex(String destinationIndex) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)"destinationIndex", (Object)destinationIndex);
        return (Map)this.invokeSignedRequest(this.accessKey, this.key(true), App.AllowedMethods.POST.toString(), this.getEndpoint(), this.getFullPath("_reindex"), null, (MultivaluedMap<String, String>)params, null, Map.class);
    }

    public Map<String, Map<String, Map<String, Map<String, ?>>>> validationConstraints() {
        return (Map)this.invokeGet("_constraints", null, Map.class);
    }

    public Map<String, Map<String, Map<String, Map<String, ?>>>> validationConstraints(String type) {
        return (Map)this.invokeGet(Utils.formatMessage((String)"_constraints/{0}", (Object[])new Object[]{Utils.urlEncode((String)type)}), null, Map.class);
    }

    public Map<String, Map<String, Map<String, Map<String, ?>>>> addValidationConstraint(String type, String field, Constraint c) {
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)field) || c == null) {
            return Collections.emptyMap();
        }
        return (Map)this.invokePut(Utils.formatMessage((String)"_constraints/{0}/{1}/{2}", (Object[])new Object[]{Utils.urlEncode((String)type), field, c.getName()}), c.getPayload(), Map.class);
    }

    public Map<String, Map<String, Map<String, Map<String, ?>>>> removeValidationConstraint(String type, String field, String constraintName) {
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)constraintName)) {
            return Collections.emptyMap();
        }
        return (Map)this.invokeDelete(Utils.formatMessage((String)"_constraints/{0}/{1}/{2}", (Object[])new Object[]{Utils.urlEncode((String)type), field, constraintName}), null, Map.class);
    }

    public Map<String, Map<String, List<String>>> resourcePermissions() {
        return (Map)this.invokeGet("_permissions", null, Map.class);
    }

    public Map<String, Map<String, List<String>>> resourcePermissions(String subjectid) {
        subjectid = Utils.urlEncode((String)subjectid);
        return (Map)this.invokeGet(Utils.formatMessage((String)"_permissions/{0}", (Object[])new Object[]{subjectid}), null, Map.class);
    }

    public Map<String, Map<String, List<String>>> grantResourcePermission(String subjectid, String resourcePath, EnumSet<App.AllowedMethods> permission) {
        return this.grantResourcePermission(subjectid, resourcePath, permission, false);
    }

    public Map<String, Map<String, List<String>>> grantResourcePermission(String subjectid, String resourcePath, EnumSet<App.AllowedMethods> permission, boolean allowGuestAccess) {
        if (StringUtils.isBlank((CharSequence)subjectid) || StringUtils.isBlank((CharSequence)resourcePath) || permission == null) {
            return Collections.emptyMap();
        }
        if (allowGuestAccess && "*".equals(subjectid)) {
            permission.add(App.AllowedMethods.GUEST);
        }
        subjectid = Utils.urlEncode((String)subjectid);
        resourcePath = Utils.urlEncode((String)resourcePath);
        return (Map)this.invokePut(Utils.formatMessage((String)"_permissions/{0}/{1}", (Object[])new Object[]{subjectid, resourcePath}), permission, Map.class);
    }

    public Map<String, Map<String, List<String>>> revokeResourcePermission(String subjectid, String resourcePath) {
        if (StringUtils.isBlank((CharSequence)subjectid) || StringUtils.isBlank((CharSequence)resourcePath)) {
            return Collections.emptyMap();
        }
        subjectid = Utils.urlEncode((String)subjectid);
        resourcePath = Utils.urlEncode((String)resourcePath);
        return (Map)this.invokeDelete(Utils.formatMessage((String)"_permissions/{0}/{1}", (Object[])new Object[]{subjectid, resourcePath}), null, Map.class);
    }

    public Map<String, Map<String, List<String>>> revokeAllResourcePermissions(String subjectid) {
        if (StringUtils.isBlank((CharSequence)subjectid)) {
            return Collections.emptyMap();
        }
        subjectid = Utils.urlEncode((String)subjectid);
        return (Map)this.invokeDelete(Utils.formatMessage((String)"_permissions/{0}", (Object[])new Object[]{subjectid}), null, Map.class);
    }

    public boolean isAllowedTo(String subjectid, String resourcePath, String httpMethod) {
        if (StringUtils.isBlank((CharSequence)subjectid) || StringUtils.isBlank((CharSequence)resourcePath) || StringUtils.isBlank((CharSequence)httpMethod)) {
            return false;
        }
        subjectid = Utils.urlEncode((String)subjectid);
        resourcePath = Utils.urlEncode((String)resourcePath);
        String url = Utils.formatMessage((String)"_permissions/{0}/{1}/{2}", (Object[])new Object[]{subjectid, resourcePath, httpMethod});
        Boolean result = (Boolean)this.invokeGet(url, null, Boolean.class);
        return result != null && result != false;
    }

    public Map<String, Object> appSettings() {
        return (Map)this.invokeGet("_settings", null, Map.class);
    }

    public Map<String, Object> appSettings(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this.appSettings();
        }
        return (Map)this.invokeGet(Utils.formatMessage((String)"_settings/{0}", (Object[])new Object[]{key}), null, Map.class);
    }

    public void addAppSetting(String key, Object value) {
        if (!StringUtils.isBlank((CharSequence)key) && value != null) {
            this.invokePut(Utils.formatMessage((String)"_settings/{0}", (Object[])new Object[]{key}), Collections.singletonMap("value", value), Map.class);
        }
    }

    public void setAppSettings(Map<?, ?> settings) {
        if (settings != null) {
            this.invokePut("_settings", settings, Map.class);
        }
    }

    public void removeAppSetting(String key) {
        if (!StringUtils.isBlank((CharSequence)key)) {
            this.invokeDelete(Utils.formatMessage((String)"_settings/{0}", (Object[])new Object[]{key}), null, null);
        }
    }

    public User signIn(String provider, String providerToken, boolean rememberJWT) {
        if (!StringUtils.isBlank((CharSequence)provider) && !StringUtils.isBlank((CharSequence)providerToken)) {
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("appid", this.accessKey);
            credentials.put("provider", provider);
            credentials.put("token", providerToken);
            Map result = (Map)this.invokePost(JWT_PATH, credentials, Map.class);
            if (result != null && result.containsKey("user") && result.containsKey("jwt")) {
                Map jwtData = (Map)result.get("jwt");
                if (rememberJWT) {
                    this.tokenKey = (String)jwtData.get("access_token");
                    this.tokenKeyExpires = (Long)jwtData.get("expires");
                    this.tokenKeyNextRefresh = (Long)jwtData.get("refresh");
                }
                User signedInUser = (User)ParaObjectUtils.setAnnotatedFields((Map)((Map)result.get("user")));
                signedInUser.setPassword((String)jwtData.get("access_token"));
                return signedInUser;
            }
            this.clearAccessToken();
        }
        return null;
    }

    public User signIn(String provider, String providerToken) {
        return this.signIn(provider, providerToken, true);
    }

    public void signOut() {
        this.clearAccessToken();
    }

    protected boolean refreshToken() {
        boolean canRefresh;
        long now = System.currentTimeMillis();
        boolean notExpired = this.tokenKeyExpires != null && this.tokenKeyExpires > now;
        boolean bl = canRefresh = this.tokenKeyNextRefresh != null && (this.tokenKeyNextRefresh < now || this.tokenKeyNextRefresh > this.tokenKeyExpires);
        if (this.tokenKey != null && notExpired && canRefresh) {
            Map result = (Map)this.invokeGet(JWT_PATH, null, Map.class);
            if (result != null && result.containsKey("user") && result.containsKey("jwt")) {
                Map jwtData = (Map)result.get("jwt");
                this.tokenKey = (String)jwtData.get("access_token");
                this.tokenKeyExpires = (Long)jwtData.get("expires");
                this.tokenKeyNextRefresh = (Long)jwtData.get("refresh");
                return true;
            }
            this.clearAccessToken();
        }
        return false;
    }

    public boolean revokeAllTokens() {
        return this.invokeDelete(JWT_PATH, null, Map.class) != null;
    }
}

