/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.cache;

import com.erudika.para.cache.Cache;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Utils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MockCache
implements Cache {
    private static final Logger logger = LoggerFactory.getLogger(MockCache.class);
    private Map<String, Map<String, Object>> maps = new HashMap<String, Map<String, Object>>();

    @Override
    public boolean contains(String appid, String id) {
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        if (this.isExpired((Long)this.getMap(appid).get(id + ":ttl"))) {
            this.remove(appid, id);
            return false;
        }
        return this.getMap(appid).containsKey(id);
    }

    @Override
    public <T> void put(String appid, String id, T object) {
        if (!StringUtils.isBlank((CharSequence)id) && object != null && !StringUtils.isBlank((CharSequence)appid)) {
            this.getMap(appid).put(id, object);
            logger.debug("Cache.put() {} {}", (Object)appid, (Object)id);
        }
    }

    @Override
    public <T> void put(String appid, String id, T object, Long ttlSeconds) {
        if (!StringUtils.isBlank((CharSequence)id) && object != null && !StringUtils.isBlank((CharSequence)appid)) {
            this.getMap(appid).put(id, object);
            this.getMap(appid).put(id + ":ttl", Utils.timestamp() + ttlSeconds * 1000L);
            logger.debug("Cache.put() {} {} ttl {}", new Object[]{appid, id, ttlSeconds});
        }
    }

    @Override
    public <T> void putAll(String appid, Map<String, T> objects) {
        if (objects != null && !objects.isEmpty() && !StringUtils.isBlank((CharSequence)appid)) {
            LinkedHashMap<String, T> cleanMap = new LinkedHashMap<String, T>(objects.size());
            for (Map.Entry<String, T> entry : objects.entrySet()) {
                if (StringUtils.isBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
                cleanMap.put(entry.getKey(), entry.getValue());
            }
            this.getMap(appid).putAll(cleanMap);
            logger.debug("Cache.putAll() {} {}", (Object)appid, (Object)objects.size());
        }
    }

    @Override
    public <T> T get(String appid, String id) {
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)appid)) {
            return null;
        }
        if (this.isExpired((Long)this.getMap(appid).get(id + ":ttl"))) {
            this.remove(appid, id);
            logger.debug("Cache.get() {} {}", (Object)appid, null);
            return null;
        }
        logger.debug("Cache.get() {} {}", (Object)appid, (Object)id);
        return (T)this.getMap(appid).get(id);
    }

    @Override
    public <T> Map<String, T> getAll(String appid, List<String> ids) {
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        if (ids == null || StringUtils.isBlank((CharSequence)appid)) {
            return map1;
        }
        ids.remove(null);
        for (String id : ids) {
            if (!this.isExpired((Long)this.getMap(appid).get(id + ":ttl"))) {
                Object t = this.getMap(appid).get(id);
                if (t == null) continue;
                map1.put(id, t);
                continue;
            }
            this.remove(appid, id);
        }
        logger.debug("Cache.getAll() {} {}", (Object)appid, (Object)ids.size());
        return map1;
    }

    @Override
    public void remove(String appid, String id) {
        if (!StringUtils.isBlank((CharSequence)id) && !StringUtils.isBlank((CharSequence)appid)) {
            logger.debug("Cache.remove() {} {}", (Object)appid, (Object)id);
            this.getMap(appid).remove(id);
        }
    }

    @Override
    public void removeAll(String appid) {
        if (!StringUtils.isBlank((CharSequence)appid)) {
            logger.debug("Cache.removeAll() {}", (Object)appid);
            this.getMap(appid).clear();
        }
    }

    @Override
    public void removeAll(String appid, List<String> ids) {
        if (ids != null && !StringUtils.isBlank((CharSequence)appid)) {
            for (String id : ids) {
                if (StringUtils.isBlank((CharSequence)id)) continue;
                this.remove(appid, id);
            }
            logger.debug("Cache.removeAll() {} {}", (Object)appid, (Object)ids.size());
        }
    }

    private boolean isExpired(Long ttl) {
        if (ttl == null) {
            return false;
        }
        return Utils.timestamp() > ttl;
    }

    private Map<String, Object> getMap(String appid) {
        if (!this.maps.containsKey(appid)) {
            this.maps.put(appid, new HashMap());
        }
        return this.maps.get(appid);
    }

    @Override
    public boolean contains(String id) {
        return this.contains(Config.APP_NAME_NS, id);
    }

    @Override
    public <T> void put(String id, T object) {
        this.put(Config.APP_NAME_NS, id, object);
    }

    @Override
    public <T> void putAll(Map<String, T> objects) {
        this.putAll(Config.APP_NAME_NS, objects);
    }

    @Override
    public <T> T get(String id) {
        return this.get(Config.APP_NAME_NS, id);
    }

    @Override
    public <T> Map<String, T> getAll(List<String> ids) {
        return this.getAll(Config.APP_NAME_NS, ids);
    }

    @Override
    public void remove(String id) {
        this.remove(Config.APP_NAME_NS, id);
    }

    @Override
    public void removeAll() {
        this.removeAll(Config.APP_NAME_NS);
    }

    @Override
    public void removeAll(List<String> ids) {
        this.removeAll(Config.APP_NAME_NS, ids);
    }
}

