/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.InitializeListener;
import com.erudika.para.cache.Cache;
import com.erudika.para.cache.MockCache;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.Vote;
import com.erudika.para.persistence.DAO;
import com.erudika.para.persistence.MockDAO;
import com.erudika.para.search.MockSearch;
import com.erudika.para.search.Search;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class CoreUtils
implements InitializeListener {
    private static final Logger logger = LoggerFactory.getLogger(CoreUtils.class);
    @Inject
    private DAO dao;
    @Inject
    private Search search;
    @Inject
    private Cache cache;
    private static CoreUtils instance;

    public CoreUtils(DAO dao, Search search, Cache cache) {
        this.dao = dao;
        this.search = search;
        this.cache = cache;
    }

    @Override
    public void onInitialize() {
        if (this.dao != null && this.search != null && this.cache != null) {
            logger.info("Loaded new DAO, Search and Cache implementations - {}, {} and {}.", new Object[]{this.dao.getClass().getSimpleName(), this.search.getClass().getSimpleName(), this.cache.getClass().getSimpleName()});
            instance = new CoreUtils(this.dao, this.search, this.cache);
        }
    }

    public static synchronized CoreUtils getInstance() {
        if (instance == null) {
            MockDAO defaultDAO = new MockDAO();
            MockSearch defaultSearch = new MockSearch();
            MockCache defaultCache = new MockCache();
            logger.info("Using default impementations - {}, {} and {}.", new Object[]{defaultDAO.getClass().getSimpleName(), defaultSearch.getClass().getSimpleName(), defaultCache.getClass().getSimpleName()});
            instance = new CoreUtils(defaultDAO, defaultSearch, defaultCache);
        }
        return instance;
    }

    public DAO getDao() {
        return this.dao;
    }

    public void setDao(DAO dao) {
        this.dao = dao;
    }

    public Search getSearch() {
        return this.search;
    }

    public void setSearch(Search search) {
        this.search = search;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public String getObjectURI(ParaObject obj) {
        String defurl = "/".concat(obj.getPlural());
        return obj.getId() != null ? defurl.concat("/").concat(obj.getId()) : defurl;
    }

    public String getName(String name, String id) {
        return name == null ? "ParaObject ".concat(id == null ? System.currentTimeMillis() + "" : id) : name;
    }

    public String overwrite(ParaObject obj) {
        return this.overwrite(Config.APP_NAME_NS, obj);
    }

    public String overwrite(String appid, ParaObject obj) {
        if (obj != null && obj.getId() != null) {
            if (obj.getUpdated() == null) {
                obj.setUpdated(System.currentTimeMillis());
            }
            return this.getDao().create(appid, obj);
        }
        return null;
    }

    public List<String> addTags(List<String> objectTags, String ... tag) {
        if (tag != null && tag.length > 0) {
            HashSet<Object> tagz = objectTags == null || objectTags.isEmpty() ? new HashSet() : new HashSet<String>(objectTags);
            for (String t : tag) {
                if (StringUtils.isBlank((CharSequence)t)) continue;
                tagz.add(Utils.noSpaces(Utils.stripAndTrim(t), "-"));
            }
            tagz.remove(null);
            tagz.remove("");
            return new ArrayList<Object>(tagz);
        }
        return objectTags;
    }

    public List<String> removeTags(List<String> objectTags, String ... tag) {
        if (objectTags != null && tag != null && tag.length > 0) {
            HashSet<String> tagz = new HashSet<String>(objectTags);
            tagz.removeAll(Arrays.asList(tag));
            return new ArrayList<String>(tagz);
        }
        return objectTags;
    }

    public String link(ParaObject obj, String id2) {
        Object second = this.getDao().read(obj.getAppid(), id2);
        if (second == null || obj.getId() == null) {
            return null;
        }
        return this.getDao().create(obj.getAppid(), new Linker(obj.getType(), second.getType(), obj.getId(), id2));
    }

    public void unlink(ParaObject obj, String type2, String id2) {
        this.getDao().delete(obj.getAppid(), new Linker(obj.getType(), type2, obj.getId(), id2));
    }

    public void unlinkAll(ParaObject obj) {
        HashMap<String, String> terms = new HashMap<String, String>();
        terms.put("id1", obj.getId());
        terms.put("id2", obj.getId());
        this.getDao().deleteAll(obj.getAppid(), this.getSearch().findTerms(obj.getAppid(), Utils.type(Linker.class), terms, false, new Pager[0]));
    }

    public List<Linker> getLinks(ParaObject obj, String type2, Pager ... pager) {
        if (type2 == null) {
            return Collections.emptyList();
        }
        Linker link = new Linker(obj.getType(), type2, null, null);
        String idField = link.getIdFieldNameFor(obj.getType());
        HashMap<String, String> terms = new HashMap<String, String>();
        terms.put("name", link.getName());
        terms.put(idField, obj.getId());
        return this.getSearch().findTerms(obj.getAppid(), link.getType(), terms, true, pager);
    }

    public boolean isLinked(ParaObject obj, String type2, String id2) {
        if (type2 == null) {
            return false;
        }
        return this.getDao().read(obj.getAppid(), new Linker(obj.getType(), type2, obj.getId(), id2).getId()) != null;
    }

    public boolean isLinked(ParaObject obj, ParaObject toObj) {
        if (toObj == null) {
            return false;
        }
        return this.isLinked(obj, toObj.getType(), toObj.getId());
    }

    public Long countLinks(ParaObject obj, String type2) {
        if (obj.getId() == null) {
            return 0L;
        }
        Linker link = new Linker(obj.getType(), type2, null, null);
        String idField = link.getIdFieldNameFor(obj.getType());
        HashMap<String, String> terms = new HashMap<String, String>();
        terms.put("name", link.getName());
        terms.put(idField, obj.getId());
        return this.getSearch().getCount(obj.getAppid(), link.getType(), terms);
    }

    public Long countChildren(ParaObject obj, String type2) {
        return this.getSearch().getCount(obj.getAppid(), type2);
    }

    public <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, Pager ... pager) {
        return this.getChildren(obj, type2, (String)null, (String)null, pager);
    }

    public <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, String field, String term, Pager ... pager) {
        HashMap<String, String> terms = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)field) && !StringUtils.isBlank((CharSequence)term)) {
            terms.put(field, term);
        }
        terms.put("parentid", obj.getId());
        return this.getSearch().findTerms(obj.getAppid(), type2, terms, true, pager);
    }

    public void deleteChildren(ParaObject obj, String type2) {
        if (!StringUtils.isBlank((CharSequence)obj.getId())) {
            this.getDao().deleteAll(obj.getAppid(), this.getSearch().findTerms(obj.getAppid(), type2, Collections.singletonMap("parentid", obj.getId()), true, new Pager[0]));
        }
    }

    public <P extends ParaObject> List<P> getLinkedObjects(ParaObject obj, String type2, Pager ... pager) {
        List<Linker> links = this.getLinks(obj, type2, pager);
        LinkedList<String> keys = new LinkedList<String>();
        for (Linker link : links) {
            if (link.isFirst(type2)) {
                keys.add(link.getId1());
                continue;
            }
            keys.add(link.getId2());
        }
        return new ArrayList(this.getDao().readAll(obj.getAppid(), keys, true).values());
    }

    public <P extends ParaObject> P getParent(ParaObject obj) {
        return this.getDao().read(obj.getAppid(), obj.getParentid());
    }

    public <P extends ParaObject> P getCreator(ParaObject obj) {
        return this.getDao().read(obj.getAppid(), obj.getCreatorid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vote(ParaObject votable, String userid, Votable.VoteValue upDown) {
        int vote;
        if (StringUtils.isBlank((CharSequence)userid) || votable == null || votable.getId() == null || upDown == null) {
            return false;
        }
        if (userid.equals(votable.getCreatorid()) || userid.equals(votable.getId())) {
            return false;
        }
        Vote v = new Vote(userid, votable.getId(), upDown.toString());
        Vote saved = (Vote)this.getDao().read(votable.getAppid(), v.getId());
        boolean done = false;
        int n = vote = upDown == Votable.VoteValue.UP ? 1 : -1;
        if (saved != null) {
            boolean isUpvote = upDown.equals((Object)Votable.VoteValue.UP);
            boolean wasUpvote = Votable.VoteValue.UP.toString().equals(saved.getValue());
            boolean voteHasChanged = isUpvote ^ wasUpvote;
            if (saved.isExpired()) {
                done = this.getDao().create(votable.getAppid(), v) != null;
            } else if (saved.isAmendable() && voteHasChanged) {
                this.getDao().delete(votable.getAppid(), saved);
                done = true;
            }
        } else {
            boolean bl = done = this.getDao().create(votable.getAppid(), v) != null;
        }
        if (done) {
            ParaObject paraObject = votable;
            synchronized (paraObject) {
                votable.setVotes(votable.getVotes() + vote);
            }
        }
        return done;
    }
}

