/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.i18n;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CurrencyUtils {
    private static final Logger logger = LoggerFactory.getLogger(CurrencyUtils.class);
    private static final Map<String, Locale> COUNTRY_TO_LOCALE_MAP = new HashMap<String, Locale>();
    private static final Map<String, Locale> CURRENCY_TO_LOCALE_MAP = new HashMap<String, Locale>();
    private static final Map<String, String> CURRENCIES_MAP = new TreeMap<String, String>();
    private static CurrencyUtils instance;

    private CurrencyUtils() {
        Locale[] locales = Locale.getAvailableLocales();
        try {
            for (Locale l : locales) {
                if (StringUtils.isBlank((CharSequence)l.getCountry())) continue;
                COUNTRY_TO_LOCALE_MAP.put(l.getCountry(), l);
                Currency c = Currency.getInstance(l);
                if (c == null) continue;
                CURRENCY_TO_LOCALE_MAP.put(c.getCurrencyCode(), l);
                CURRENCIES_MAP.put(c.getCurrencyCode(), this.getCurrencyName(c.getCurrencyCode(), Locale.US).concat(" ").concat(c.getSymbol(l)));
            }
            CURRENCY_TO_LOCALE_MAP.put("USD", Locale.US);
            CURRENCY_TO_LOCALE_MAP.put("EUR", Locale.FRANCE);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
    }

    public static CurrencyUtils getInstance() {
        if (instance == null) {
            instance = new CurrencyUtils();
        }
        return instance;
    }

    public String formatPrice(Double price, String cur) {
        String formatted = "";
        if (price != null) {
            Locale locale = CURRENCY_TO_LOCALE_MAP.get(cur);
            NumberFormat f = locale == null ? NumberFormat.getCurrencyInstance(Locale.US) : NumberFormat.getCurrencyInstance(locale);
            f.setMinimumFractionDigits(2);
            formatted = f.format(price);
        }
        return formatted;
    }

    public String getCurrencyName(String cur, Locale locale) {
        if (cur != null && CURRENCY_TO_LOCALE_MAP.containsKey(cur.toUpperCase())) {
            return Currency.getInstance(cur.toUpperCase()).getDisplayName(locale == null ? Locale.US : locale);
        }
        return "";
    }

    public Locale getLocaleForCountry(String countryCode) {
        if (countryCode == null) {
            return null;
        }
        return COUNTRY_TO_LOCALE_MAP.get(countryCode.toUpperCase());
    }

    public Currency getCurrency(String cur) {
        Currency currency = Currency.getInstance("EUR");
        if (StringUtils.isBlank((CharSequence)cur) || cur.length() != 3) {
            return currency;
        }
        try {
            currency = Currency.getInstance(cur.toUpperCase());
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        return currency;
    }

    public Map<String, String> getCurrenciesMap() {
        return CURRENCIES_MAP;
    }

    public boolean isValidCurrency(String cur) {
        return cur != null && CURRENCIES_MAP.containsKey(cur.toUpperCase());
    }
}

