/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.annotations.Stored;
import com.erudika.para.core.utils.Config;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;
import org.slf4j.LoggerFactory;

public class Webhook
extends Sysprop {
    private static final long serialVersionUID = 1L;
    @Stored
    @NotBlank
    @URL
    private String targetUrl;
    @Stored
    private String secret;
    @Stored
    private String typeFilter;
    @Stored
    private Boolean urlEncoded;
    @Stored
    private Boolean active;
    @Stored
    private Boolean tooManyFailures;
    @Stored
    private Boolean create;
    @Stored
    private Boolean update;
    @Stored
    private Boolean delete;
    @Stored
    private Boolean createAll;
    @Stored
    private Boolean updateAll;
    @Stored
    private Boolean deleteAll;
    @Stored
    private List<String> customEvents;
    @Stored
    private String triggeredEvent;
    @Stored
    private Object customPayload;

    public Webhook() {
        this(null);
    }

    public Webhook(String targetUrl) {
        this.targetUrl = targetUrl;
        this.urlEncoded = false;
        this.create = false;
        this.update = false;
        this.delete = false;
        this.createAll = false;
        this.updateAll = false;
        this.deleteAll = false;
        this.active = false;
        this.tooManyFailures = false;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(String typeFilter) {
        this.typeFilter = typeFilter;
    }

    public Boolean getUrlEncoded() {
        return this.urlEncoded;
    }

    public void setUrlEncoded(Boolean urlEncoded) {
        this.urlEncoded = urlEncoded;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getTooManyFailures() {
        return this.tooManyFailures;
    }

    public void setTooManyFailures(Boolean tooManyFailures) {
        this.tooManyFailures = tooManyFailures;
    }

    public Boolean getCreate() {
        return this.create;
    }

    public void setCreate(Boolean create) {
        this.create = create;
    }

    public Boolean getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean update) {
        this.update = update;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public Boolean getCreateAll() {
        return this.createAll;
    }

    public void setCreateAll(Boolean createAll) {
        this.createAll = createAll;
    }

    public Boolean getUpdateAll() {
        return this.updateAll;
    }

    public void setUpdateAll(Boolean updateAll) {
        this.updateAll = updateAll;
    }

    public Boolean getDeleteAll() {
        return this.deleteAll;
    }

    public void setDeleteAll(Boolean deleteAll) {
        this.deleteAll = deleteAll;
    }

    public List<String> getCustomEvents() {
        if (this.customEvents == null) {
            this.customEvents = new LinkedList<String>();
        }
        return this.customEvents;
    }

    public void setCustomEvents(List<String> customEvents) {
        this.customEvents = customEvents;
    }

    public String getTriggeredEvent() {
        return this.triggeredEvent;
    }

    public void setTriggeredEvent(String triggeredEvent) {
        this.triggeredEvent = triggeredEvent;
        if (!StringUtils.isBlank((CharSequence)triggeredEvent)) {
            this.setTargetUrl("https://para");
        }
    }

    public Object getCustomPayload() {
        return this.customPayload;
    }

    public void setCustomPayload(Object customPayload) {
        this.customPayload = customPayload;
    }

    public void resetSecret() {
        this.secret = Utils.generateSecurityToken();
    }

    @Override
    public void update() {
        if (this.active.booleanValue()) {
            this.tooManyFailures = false;
        }
        this.triggeredEvent = null;
        this.customPayload = null;
        super.update();
    }

    @Override
    public String create() {
        if (!StringUtils.isBlank((CharSequence)this.triggeredEvent) && this.customPayload != null) {
            Webhook.sendEventPayloadToQueue(this.getAppid(), "customEvents", this.triggeredEvent, this.customPayload);
            this.setId("triggered" + Config.SEPARATOR + this.triggeredEvent);
            this.setName("This webhook object is not persisted and should be discarded.");
            this.setStored(false);
            this.setIndexed(false);
            this.setCached(false);
            return this.getId();
        }
        if (StringUtils.isBlank((CharSequence)this.secret)) {
            this.resetSecret();
        }
        if (this.create.booleanValue() || this.update.booleanValue() || this.delete.booleanValue() || this.createAll.booleanValue() || this.updateAll.booleanValue() || this.deleteAll.booleanValue() || !this.getCustomEvents().isEmpty()) {
            this.active = true;
        }
        this.triggeredEvent = null;
        this.customPayload = null;
        return super.create();
    }

    public String buildPayloadAsJSON(String event, Object payload) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", this.getId());
        data.put("appid", this.getAppid());
        data.put("type", "webhookpayload");
        data.put("targetUrl", this.getTargetUrl());
        data.put("urlEncoded", this.getUrlEncoded());
        data.put("event", event);
        HashMap<String, Object> payloadObject = new HashMap<String, Object>();
        payloadObject.put("timestamp", System.currentTimeMillis());
        payloadObject.put("appid", this.getAppid());
        payloadObject.put("event", event);
        if (payload instanceof List) {
            payloadObject.put("items", payload);
        } else {
            payloadObject.put("items", Collections.singletonList(payload));
        }
        try {
            String payloadString = ParaObjectUtils.getJsonWriterNoIdent().writeValueAsString(payloadObject);
            data.put("payload", payloadString);
            data.put("signature", Utils.hmacSHA256(payloadString, this.getSecret()));
            return ParaObjectUtils.getJsonWriterNoIdent().writeValueAsString(data);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Webhook.class).error(null, (Throwable)e);
            return "";
        }
    }

    public static void sendEventPayloadToQueue(String appid, String eventName, Object eventValue, Object payload) {
        List webhooks;
        if (StringUtils.isBlank((CharSequence)appid)) {
            return;
        }
        Pager p = new Pager(10);
        p.setSortby("_docid");
        do {
            HashMap<String, Object> terms = new HashMap<String, Object>();
            terms.put(eventName, eventValue);
            terms.put("appid", appid);
            terms.put("active", true);
            webhooks = Para.getSearch().findTerms(appid, Utils.type(Webhook.class), terms, true, p);
            webhooks.stream().filter(webhook -> Webhook.typeFilterMatches(webhook, payload)).forEach(webhook -> Para.getQueue().push(webhook.buildPayloadAsJSON(eventValue instanceof String ? (String)eventValue : eventName, payload)));
        } while (!webhooks.isEmpty());
    }

    private static boolean typeFilterMatches(Webhook webhook, Object paraObjects) {
        List list;
        if (StringUtils.isBlank((CharSequence)webhook.getTypeFilter()) || "*".equals(webhook.getTypeFilter())) {
            return true;
        }
        if (paraObjects instanceof ParaObject) {
            return webhook.getTypeFilter().equalsIgnoreCase(((ParaObject)paraObjects).getType());
        }
        if (paraObjects instanceof List && !(list = (List)paraObjects).isEmpty() && list.get(0) instanceof ParaObject) {
            return webhook.getTypeFilter().equalsIgnoreCase(((ParaObject)list.get(0)).getType());
        }
        return false;
    }
}

