/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.validation;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.annotations.Email;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.core.validation.Constraint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.validator.constraints.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ValidationUtils.class);
    private static final Map<String, Map<String, Map<String, Map<String, ?>>>> CORE_CONSTRAINTS = new HashMap();
    private static Validator validator;

    private ValidationUtils() {
    }

    public static Validator getValidator() {
        if (validator == null) {
            validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return validator;
    }

    public static boolean isValidObject(ParaObject obj) {
        return ValidationUtils.validateObject(obj).length == 0;
    }

    public static boolean isValidObject(App app, ParaObject obj) {
        return ValidationUtils.validateObject(app, obj).length == 0;
    }

    public static String[] validateObject(ParaObject content) {
        if (content == null) {
            return new String[]{"Object cannot be null."};
        }
        LinkedList<String> list = new LinkedList<String>();
        try {
            for (ConstraintViolation constraintViolation : ValidationUtils.getValidator().validate((Object)content, new Class[0])) {
                String prop = "'".concat(constraintViolation.getPropertyPath().toString()).concat("'");
                list.add(prop.concat(" ").concat(constraintViolation.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        return list.toArray(new String[0]);
    }

    public static String[] validateObject(App app, ParaObject content) {
        if (content == null || app == null) {
            return new String[]{"Object cannot be null."};
        }
        try {
            Map<String, Map<String, Map<String, ?>>> fieldsMap;
            boolean isCustomType;
            String type = content.getType();
            boolean bl = isCustomType = content instanceof Sysprop && !type.equals(Utils.type(Sysprop.class));
            if (!app.getValidationConstraints().isEmpty() && isCustomType && (fieldsMap = app.getValidationConstraints().get(type)) != null && !fieldsMap.isEmpty()) {
                LinkedList<String> errors = new LinkedList<String>();
                for (Map.Entry<String, Map<String, Map<String, ?>>> e : fieldsMap.entrySet()) {
                    String field = e.getKey();
                    Object actualValue = ((Sysprop)content).getProperty(field);
                    if (actualValue == null && PropertyUtils.isReadable((Object)content, (String)field)) {
                        actualValue = PropertyUtils.getProperty((Object)content, (String)field);
                    }
                    Map<String, Map<String, ?>> consMap = e.getValue();
                    for (Map.Entry<String, Map<String, ?>> constraint : consMap.entrySet()) {
                        ValidationUtils.buildAndValidateConstraint(constraint, field, actualValue, errors);
                    }
                }
                if (!errors.isEmpty()) {
                    return errors.toArray(new String[0]);
                }
            }
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return ValidationUtils.validateObject(content);
    }

    private static void buildAndValidateConstraint(Map.Entry<String, Map<String, ?>> constraint, String field, Object actualValue, LinkedList<String> errors) {
        if (constraint == null) {
            return;
        }
        String consName = constraint.getKey();
        Map<String, Object> vals = constraint.getValue();
        if (vals == null) {
            vals = Collections.emptyMap();
        }
        Object val = vals.get("value");
        long min = NumberUtils.toLong((String)("" + vals.get("min")), (long)0L);
        long max = NumberUtils.toLong((String)("" + vals.get("max")), (long)10000L);
        if (ValidationUtils.isValidSimpleConstraint(consName, field, actualValue, errors)) {
            if (Constraint.matches(Min.class, consName) && !Constraint.min(NumberUtils.toLong((String)("" + val), (long)0L)).isValid(actualValue)) {
                errors.add(Utils.formatMessage("{0} must be a number larger than {1}.", field, val));
            } else if (Constraint.matches(Max.class, consName) && !Constraint.max(NumberUtils.toLong((String)("" + val), (long)10000L)).isValid(actualValue)) {
                errors.add(Utils.formatMessage("{0} must be a number smaller than {1}.", field, val));
            } else if (Constraint.matches(Size.class, consName) && !Constraint.size(min, max).isValid(actualValue)) {
                errors.add(Utils.formatMessage("{0} must be between {1} and {2}.", field, min, max));
            } else if (Constraint.matches(Digits.class, consName) && !Constraint.digits(NumberUtils.toLong((String)("" + vals.get("integer")), (long)0L), NumberUtils.toLong((String)("" + vals.get("fraction")), (long)0L)).isValid(actualValue)) {
                errors.add(Utils.formatMessage("{0} is not a valid number or within range.", field));
            } else if (Constraint.matches(Pattern.class, consName) && !Constraint.pattern(val).isValid(actualValue)) {
                errors.add(Utils.formatMessage("{0} doesn't match the pattern {1}.", field, val));
            }
        }
    }

    private static boolean isValidSimpleConstraint(String cName, String field, Object actual, LinkedList<String> err) {
        if ("required".equals(cName) && !Constraint.required().isValid(actual)) {
            err.add(Utils.formatMessage("{0} is required.", field));
            return false;
        }
        if (Constraint.matches(AssertFalse.class, cName) && !Constraint.falsy().isValid(actual)) {
            err.add(Utils.formatMessage("{0} must be false.", field));
            return false;
        }
        if (Constraint.matches(AssertTrue.class, cName) && !Constraint.truthy().isValid(actual)) {
            err.add(Utils.formatMessage("{0} must be true.", field));
            return false;
        }
        if (Constraint.matches(Future.class, cName) && !Constraint.future().isValid(actual)) {
            err.add(Utils.formatMessage("{0} must be in the future.", field));
            return false;
        }
        if (Constraint.matches(Past.class, cName) && !Constraint.past().isValid(actual)) {
            err.add(Utils.formatMessage("{0} must be in the past.", field));
            return false;
        }
        if (Constraint.matches(URL.class, cName) && !Constraint.url().isValid(actual)) {
            err.add(Utils.formatMessage("{0} is not a valid URL.", field));
            return false;
        }
        if (Constraint.matches(Email.class, cName) && !Constraint.email().isValid(actual)) {
            err.add(Utils.formatMessage("{0} is not a valid email.", field));
            return false;
        }
        return true;
    }

    public static Map<String, Map<String, Map<String, Map<String, ?>>>> getCoreValidationConstraints() {
        if (CORE_CONSTRAINTS.isEmpty()) {
            for (Map.Entry<String, Class<? extends ParaObject>> e : ParaObjectUtils.getCoreClassesMap().entrySet()) {
                String type = e.getKey();
                List<Field> fieldlist = Utils.getAllDeclaredFields(e.getValue());
                for (Field field : fieldlist) {
                    Annotation[] annos = field.getAnnotations();
                    if (annos.length <= 1) continue;
                    HashMap<String, Map<String, Object>> constrMap = new HashMap<String, Map<String, Object>>();
                    for (Annotation anno : annos) {
                        Constraint c;
                        if (!Constraint.isValidConstraintType(anno.annotationType()) || (c = Constraint.fromAnnotation(anno)) == null) continue;
                        constrMap.put(c.getName(), c.getPayload());
                    }
                    if (constrMap.isEmpty()) continue;
                    if (!CORE_CONSTRAINTS.containsKey(type)) {
                        CORE_CONSTRAINTS.put(type, new HashMap());
                    }
                    CORE_CONSTRAINTS.get(type).put(field.getName(), constrMap);
                }
            }
        }
        return Collections.unmodifiableMap(CORE_CONSTRAINTS);
    }
}

