/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.Votable;
import com.erudika.para.core.annotations.Email;
import com.erudika.para.core.annotations.Locked;
import com.erudika.para.core.annotations.Stored;
import com.erudika.para.core.i18n.CurrencyUtils;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.naming.LimitExceededException;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class User
implements ParaObject {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(User.class);
    public static final int MAX_PASSWORD_LENGTH = 5000;
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    private Long version;
    @Stored
    private Boolean stored;
    @Stored
    private Boolean indexed;
    @Stored
    private Boolean cached;
    @Stored
    @NotBlank
    private String identifier;
    @Stored
    @Locked
    @NotBlank
    private String groups;
    @Stored
    private Boolean active;
    @Stored
    private Boolean twoFA;
    @Stored
    private String twoFAkey;
    @Stored
    private String twoFAbackupKeyHash;
    @Stored
    @NotBlank
    @Email
    private String email;
    @Stored
    private String currency;
    @Stored
    private String picture;
    @Stored
    @Locked
    private String tokenSecret;
    @Stored
    private String idpIdToken;
    @Stored
    private String idpAccessToken;
    @Stored
    private String idpRefreshToken;
    private transient String password;

    public User() {
        this(null);
    }

    public User(String id) {
        this.setId(id);
        this.setName(this.getName());
        this.groups = Groups.USERS.toString();
    }

    @JsonIgnore
    public String getTokenSecret() {
        if (this.tokenSecret == null) {
            this.resetTokenSecret();
        }
        return this.tokenSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public String getPicture() {
        return StringUtils.isBlank((CharSequence)this.picture) ? "https://www.gravatar.com/avatar?d=mm&size=400" : this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public Boolean getActive() {
        if (this.active == null) {
            this.active = false;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getTwoFA() {
        if (this.twoFA == null) {
            this.twoFA = false;
        }
        return this.twoFA;
    }

    public void setTwoFA(Boolean twoFA) {
        this.twoFA = twoFA;
    }

    @JsonIgnore
    public String getTwoFAkey() {
        return this.twoFAkey;
    }

    public void setTwoFAkey(String twoFAkey) {
        this.twoFAkey = twoFAkey;
    }

    @JsonIgnore
    public String getTwoFAbackupKeyHash() {
        return this.twoFAbackupKeyHash;
    }

    public void setTwoFAbackupKeyHash(String twoFAbackupKeyHash) {
        this.twoFAbackupKeyHash = twoFAbackupKeyHash;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getEmail() {
        return StringUtils.lowerCase((String)this.email);
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        currency = StringUtils.upperCase((String)currency);
        if (!CurrencyUtils.getInstance().isValidCurrency(currency)) {
            currency = "EUR";
        }
        this.currency = currency;
    }

    public void resetTokenSecret() {
        this.tokenSecret = Utils.generateSecurityToken();
    }

    public boolean canModify(ParaObject obj) {
        if (obj == null || this.id == null) {
            return false;
        }
        boolean isCreatedByMe = obj.getCreatorid() != null && (obj.getCreatorid().startsWith(this.id + Para.getConfig().separator()) || this.id.equals(obj.getCreatorid()));
        boolean mine = isCreatedByMe || this.id.equals(obj.getId()) || this.id.equals(obj.getParentid());
        return mine || this.isAdmin();
    }

    @Override
    public String create() {
        if (StringUtils.isBlank((CharSequence)this.getIdentifier())) {
            logger.warn("Failed to create user - identifier not set.");
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)this.getPassword()) && this.getPassword().length() < Para.getConfig().minPasswordLength()) {
            logger.warn("Failed to create user - password too short.");
            return null;
        }
        if (User.readUserForIdentifier(this) != null) {
            logger.warn("Failed to create user - user with identifier '{}' already exists.", (Object)this.getIdentifier());
            return null;
        }
        if (!Para.getConfig().adminIdentifier().isEmpty() && Para.getConfig().adminIdentifier().equals(this.getIdentifier())) {
            logger.info("Creating new user '{}' ({}) with admin privileges.", (Object)this.getName(), (Object)this.getIdentifier());
            this.setGroups(Groups.ADMINS.toString());
        }
        if (StringUtils.isBlank((CharSequence)this.getGroups())) {
            this.setGroups(Groups.USERS.toString());
        }
        this.setGravatarPicture();
        if (StringUtils.isBlank((CharSequence)this.tokenSecret)) {
            this.resetTokenSecret();
        }
        if (CoreUtils.getInstance().getDao().create(this.getAppid(), this) != null) {
            this.createIdentifier(this.getIdentifier(), this.getPassword());
        } else {
            logger.warn("Failed to create user - dao.create() returned null.");
        }
        return this.getId();
    }

    @Override
    public void delete() {
        if (this.getId() != null) {
            CoreUtils.getInstance().getDao().deleteAll(this.getAppid(), this.getIdentifiers());
            CoreUtils.getInstance().getDao().delete(this.getAppid(), this);
        }
    }

    private List<Sysprop> getIdentifiers() {
        return CoreUtils.getInstance().getSearch().findTerms(this.getAppid(), Utils.type(Sysprop.class), Collections.singletonMap("creatorid", this.getId()), true, new Pager[0]);
    }

    public void attachIdentifier(String identifier) {
        if (this.exists()) {
            this.createIdentifier(identifier, Utils.generateSecurityToken());
        }
    }

    public void detachIdentifier(String identifier) {
        Sysprop s;
        if (!StringUtils.equals((CharSequence)identifier, (CharSequence)this.getIdentifier()) && (s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), identifier)) != null && StringUtils.equals((CharSequence)this.getId(), (CharSequence)s.getCreatorid())) {
            this.deleteIdentifier(identifier);
        }
    }

    @JsonIgnore
    public boolean isFacebookUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"fb:");
    }

    @JsonIgnore
    public boolean isGooglePlusUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"gp:");
    }

    @JsonIgnore
    public boolean isLinkedInUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"in:");
    }

    @JsonIgnore
    public boolean isTwitterUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"tw:");
    }

    @JsonIgnore
    public boolean isGitHubUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"gh:");
    }

    @JsonIgnore
    public boolean isMicrosoftUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"ms:");
    }

    @JsonIgnore
    public boolean isSlackUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"sl:");
    }

    @JsonIgnore
    public boolean isMattermostUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"mm:");
    }

    @JsonIgnore
    public boolean isAmazonUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"az:");
    }

    @JsonIgnore
    public boolean isLDAPUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"ldap:");
    }

    @JsonIgnore
    public boolean isSAMLUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"saml:");
    }

    @JsonIgnore
    public boolean isPasswordlessUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"custom:");
    }

    @JsonIgnore
    public boolean isOAuth2User() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"oa2:") || StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"oa2second:") || StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)"oa2third:");
    }

    @JsonIgnore
    public boolean isAdmin() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.groups, (CharSequence)Groups.ADMINS.toString());
    }

    @JsonIgnore
    public boolean isModerator() {
        return this.isAdmin() ? true : StringUtils.equalsIgnoreCase((CharSequence)this.groups, (CharSequence)Groups.MODS.toString());
    }

    public String getIdentityProvider() {
        if (this.isFacebookUser()) {
            return "facebook";
        }
        if (this.isGooglePlusUser()) {
            return "google";
        }
        if (this.isGitHubUser()) {
            return "github";
        }
        if (this.isTwitterUser()) {
            return "twitter";
        }
        if (this.isLinkedInUser()) {
            return "linkedin";
        }
        if (this.isMicrosoftUser()) {
            return "microsoft";
        }
        if (this.isSlackUser()) {
            return "slack";
        }
        if (this.isMattermostUser()) {
            return "mattermost";
        }
        if (this.isAmazonUser()) {
            return "amazon";
        }
        if (this.isLDAPUser()) {
            return "ldap";
        }
        if (this.isSAMLUser()) {
            return "saml";
        }
        if (this.isOAuth2User()) {
            return "oauth2";
        }
        if (this.isPasswordlessUser()) {
            return "custom";
        }
        if (Utils.isValidEmail(this.identifier)) {
            return "generic";
        }
        return "unknown";
    }

    public boolean hasValidIdentifier() {
        return !this.getIdentityProvider().equals("unknown");
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getIdpIdToken() {
        return this.idpIdToken;
    }

    public void setIdpIdToken(String idpIdToken) {
        this.idpIdToken = idpIdToken;
    }

    public String getIdpAccessToken() {
        return this.idpAccessToken;
    }

    public void setIdpAccessToken(String idpAccessToken) {
        this.idpAccessToken = idpAccessToken;
    }

    public String getIdpRefreshToken() {
        return this.idpRefreshToken;
    }

    public void setIdpRefreshToken(String idpRefreshToken) {
        this.idpRefreshToken = idpRefreshToken;
    }

    @JsonIgnore
    public String getIdpIdTokenPayload() {
        return StringUtils.substringBetween((String)this.idpIdToken, (String)".");
    }

    @JsonIgnore
    public String getIdpAccessTokenPayload() {
        return StringUtils.substringBetween((String)this.idpAccessToken, (String)".");
    }

    public static final User readUserForIdentifier(User u) {
        if (u == null || StringUtils.isBlank((CharSequence)u.getIdentifier())) {
            return null;
        }
        User user = null;
        String password = null;
        String identifier = u.getIdentifier();
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(u.getAppid(), identifier);
        if (s != null && s.getCreatorid() != null) {
            user = (User)CoreUtils.getInstance().getDao().read(u.getAppid(), s.getCreatorid());
            password = (String)s.getProperty("password");
        }
        if (user == null && !StringUtils.isBlank((CharSequence)u.getEmail())) {
            HashMap<String, String> terms = new HashMap<String, String>(2);
            terms.put("email", u.getEmail());
            terms.put("appid", u.getAppid());
            Pager p = new Pager(1);
            List users = CoreUtils.getInstance().getSearch().findTerms(u.getAppid(), u.getType(), terms, true, p);
            if (!users.isEmpty()) {
                user = (User)users.get(0);
                password = Utils.generateSecurityToken();
                user.createIdentifier(u.getIdentifier(), password);
                if (p.getCount() > 1L) {
                    logger.warn("{} user objects exist with the same email {}", (Object)p.getCount(), (Object)user.getEmail());
                }
            }
        }
        if (user != null) {
            if (password != null) {
                user.setPassword(password);
            }
            if (!identifier.equals(user.getIdentifier())) {
                logger.info("Identifier changed for user '{}', from {} to {}.", new Object[]{user.getId(), user.getIdentifier(), identifier});
                user.setIdentifier(identifier);
                CoreUtils.getInstance().getDao().update(user.getAppid(), user);
            }
            return user;
        }
        logger.debug("User not found for identifier {}/{}, {}.", new Object[]{u.getAppid(), identifier, u.getId()});
        return null;
    }

    public static final boolean passwordMatches(User u) throws LimitExceededException {
        if (u == null) {
            return false;
        }
        String password = u.getPassword();
        String identifier = u.getIdentifier();
        if (StringUtils.isBlank((CharSequence)password) || StringUtils.isBlank((CharSequence)identifier) || password.length() > 5000) {
            return false;
        }
        Object s = CoreUtils.getInstance().getDao().read(u.getAppid(), identifier);
        if (s != null) {
            if (s instanceof Sysprop) {
                String storedHash = (String)((Sysprop)s).getProperty("password");
                boolean matches = Utils.bcryptMatches(password, storedHash);
                if (matches) {
                    ((Sysprop)s).setVotes(0);
                    ((Sysprop)s).removeProperty("lockedUntil");
                    CoreUtils.getInstance().getDao().update(u.getAppid(), s);
                } else {
                    if (((Sysprop)s).hasProperty("lockedUntil") && (Long)((Sysprop)s).getProperty("lockedUntil") > System.currentTimeMillis()) {
                        logger.warn("Too many login attempts for user {} ({}/{}), account locked.", new Object[]{u.getId(), u.getAppid(), identifier});
                        throw new LimitExceededException("Too many login attempts!");
                    }
                    ((Sysprop)s).setVotes(((Sysprop)s).getVotes() + 1);
                    if (((Sysprop)s).getVotes() >= Para.getConfig().maxPasswordMatchingAttempts()) {
                        ((Sysprop)s).addProperty("lockedUntil", System.currentTimeMillis() + TimeUnit.HOURS.toNanos(Para.getConfig().passwordMatchingLockPeriodHours()));
                        CoreUtils.getInstance().getDao().update(u.getAppid(), s);
                    } else {
                        CoreUtils.getInstance().getDao().update(u.getAppid(), s);
                    }
                }
                return matches;
            }
            LoggerFactory.getLogger(User.class).warn(Utils.formatMessage("Failed to read auth object for user '{}' using identifier '{}'.", u.getId(), identifier));
        }
        return false;
    }

    public final String generatePasswordResetToken() {
        if (StringUtils.isBlank((CharSequence)this.identifier)) {
            return "";
        }
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (s != null) {
            String token = Utils.generateSecurityToken(42, true);
            s.addProperty("token", token);
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            return token;
        }
        return "";
    }

    public final boolean resetPassword(String token, String newpass) {
        if (StringUtils.isBlank((CharSequence)newpass) || StringUtils.isBlank((CharSequence)token) || newpass.length() < Para.getConfig().minPasswordLength()) {
            return false;
        }
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (this.isValidToken(s, "token", token)) {
            s.removeProperty("token");
            String hashed = Utils.bcrypt(newpass);
            s.addProperty("password", hashed);
            this.setPassword(hashed);
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            return true;
        }
        return false;
    }

    private boolean createIdentifier(String newIdent, String password) {
        if (StringUtils.isBlank((CharSequence)this.getId()) || StringUtils.isBlank((CharSequence)newIdent)) {
            return false;
        }
        Sysprop s = new Sysprop();
        s.setId(newIdent);
        s.setName("identifier");
        s.setCreatorid(this.getId());
        if (!StringUtils.isBlank((CharSequence)password)) {
            String hashed = Utils.bcrypt(password);
            s.addProperty("password", hashed);
            this.setPassword(hashed);
        }
        return CoreUtils.getInstance().getDao().create(this.getAppid(), s) != null;
    }

    private void deleteIdentifier(String ident) {
        if (!StringUtils.isBlank((CharSequence)ident)) {
            CoreUtils.getInstance().getDao().delete(this.getAppid(), new Sysprop(ident));
        }
    }

    public String generateEmailConfirmationToken() {
        if (StringUtils.isBlank((CharSequence)this.identifier)) {
            return "";
        }
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (s != null) {
            String token = Utils.base64encURL(Utils.generateSecurityToken().getBytes());
            s.addProperty("etoken", token);
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            return token;
        }
        return "";
    }

    public final boolean activateWithEmailToken(String token) {
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (this.isValidToken(s, "etoken", token)) {
            s.removeProperty("etoken");
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            this.setActive(true);
            this.update();
            return true;
        }
        return false;
    }

    public final boolean isValidPasswordResetToken(String token) {
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        return this.isValidToken(s, "token", token);
    }

    public final boolean isValidEmailConfirmationToken(String token) {
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        return this.isValidToken(s, "etoken", token);
    }

    private boolean isValidToken(Sysprop s, String key, String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        if (s != null && s.hasProperty(key)) {
            String storedToken = (String)s.getProperty(key);
            long timeout = (long)Para.getConfig().passwordResetTimeoutSec() * 1000L;
            if (StringUtils.equals((CharSequence)storedToken, (CharSequence)token) && s.getUpdated() + timeout > Utils.timestamp()) {
                return true;
            }
        }
        return false;
    }

    private void setGravatarPicture() {
        if (StringUtils.isBlank((CharSequence)this.picture)) {
            if (this.email != null) {
                String emailHash = Utils.md5(this.email.toLowerCase());
                this.setPicture("https://www.gravatar.com/avatar/" + emailHash + "?size=400&d=mm&r=pg");
            } else {
                this.setPicture("https://www.gravatar.com/avatar?d=mm&size=400");
            }
        }
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Para.getConfig().getRootAppIdentifier() : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getInstance().getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Boolean getStored() {
        if (this.stored == null) {
            this.stored = true;
        }
        return this.stored;
    }

    @Override
    public void setStored(Boolean stored) {
        this.stored = stored;
    }

    @Override
    public Boolean getIndexed() {
        if (this.indexed == null) {
            this.indexed = true;
        }
        return this.indexed;
    }

    @Override
    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public Boolean getCached() {
        if (this.cached == null) {
            this.cached = true;
        }
        return this.cached;
    }

    @Override
    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getInstance().getName(this.name, this.id).replaceAll("[\\p{S}\\p{P}\\p{C}&&[^'\\-,\\.]]", "").replaceAll("\\p{Z}+", " ").trim();
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public void update() {
        CoreUtils.getInstance().getDao().update(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId()) != null;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long getVersion() {
        return this.version == null ? 0L : this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.getInstance().countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getInstance().getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getInstance().getLinkedObjects(this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> findLinkedObjects(String type, String field, String query, Pager ... pager) {
        return CoreUtils.getInstance().findLinkedObjects(this, type, field, query, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.getInstance().isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.getInstance().isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.getInstance().link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.getInstance().unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.getInstance().unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.getInstance().countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public <P extends ParaObject> List<P> findChildren(String type, String query, Pager ... pager) {
        return CoreUtils.getInstance().findChildren(this, type, query, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.getInstance().deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }

    public static enum Groups {
        USERS,
        MODS,
        ADMINS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Roles {
        USER,
        MOD,
        ADMIN;


        public String toString() {
            return "ROLE_".concat(this.name());
        }
    }
}

