/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.core.annotations.Documented;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private com.typesafe.config.Config config;
    private Map<String, String> sortedConfigKeys;
    private List<Documented> annotatedMethods;
    private Map<String, Documented> annotatedMethodsMap;
    public static final String PARA = "para";
    public static final String _TYPE = "type";
    public static final String _APPID = "appid";
    public static final String _CREATORID = "creatorid";
    public static final String _ID = "id";
    public static final String _IDENTIFIER = "identifier";
    public static final String _KEY = "key";
    public static final String _NAME = "name";
    public static final String _PARENTID = "parentid";
    public static final String _PASSWORD = "password";
    public static final String _RESET_TOKEN = "token";
    public static final String _EMAIL_TOKEN = "etoken";
    public static final String _TIMESTAMP = "timestamp";
    public static final String _UPDATED = "updated";
    public static final String _TAGS = "tags";
    public static final String _EMAIL = "email";
    public static final String _GROUPS = "groups";
    public static final String _VERSION = "version";
    public static final String _PROPERTIES = "properties";
    public static final int DEFAULT_LIMIT = 10000;
    public static final String FB_PREFIX = "fb:";
    public static final String GPLUS_PREFIX = "gp:";
    public static final String LINKEDIN_PREFIX = "in:";
    public static final String TWITTER_PREFIX = "tw:";
    public static final String GITHUB_PREFIX = "gh:";
    public static final String MICROSOFT_PREFIX = "ms:";
    public static final String SLACK_PREFIX = "sl:";
    public static final String MATTERMOST_PREFIX = "mm:";
    public static final String AMAZON_PREFIX = "az:";
    public static final String OAUTH2_PREFIX = "oa2:";
    public static final String OAUTH2_SECOND_PREFIX = "oa2second:";
    public static final String OAUTH2_THIRD_PREFIX = "oa2third:";
    public static final String LDAP_PREFIX = "ldap:";
    public static final String SAML_PREFIX = "saml:";
    public static final String PASSWORDLESS_PREFIX = "custom:";

    public String getConfigFilePath() {
        return System.getProperty("config.file", this.getConfigRootPrefix() + "-application.conf");
    }

    public abstract String getConfigRootPrefix();

    protected com.typesafe.config.Config getFallbackConfig() {
        return ConfigFactory.empty();
    }

    protected Set<String> getKeysExcludedFromRendering() {
        return Collections.emptySet();
    }

    protected String getRenderedHeader() {
        return "";
    }

    protected String getRenderedFooter() {
        return "";
    }

    protected final void init(com.typesafe.config.Config conf) {
        try {
            Path localConfig = Paths.get(this.getConfigFilePath(), new String[0]).toAbsolutePath();
            if (StringUtils.isBlank((CharSequence)System.getProperty("config.resource")) && StringUtils.isBlank((CharSequence)System.getProperty("config.file")) && StringUtils.isBlank((CharSequence)System.getProperty("config.url")) && Files.exists(localConfig, new LinkOption[0])) {
                try {
                    conf = ConfigFactory.parseFile((File)localConfig.toFile()).getConfig(this.getConfigRootPrefix()).withFallback((ConfigMergeable)this.getFallbackConfig());
                }
                catch (Exception e) {
                    logger.debug("Failed to parse local config {}", (Object)e.getMessage());
                }
            }
            this.config = ConfigFactory.load().getConfig(this.getConfigRootPrefix()).withFallback((ConfigMergeable)this.getFallbackConfig());
            if (conf != null && !conf.isEmpty()) {
                this.config = conf.withFallback((ConfigMergeable)this.config);
            }
            this.getSortedConfigKeys();
        }
        catch (Exception ex) {
            logger.warn("Failed to load configuration file 'application.(conf|json|properties)' for namespace '{}' - {}", (Object)this.getConfigRootPrefix(), (Object)ex.getMessage());
            this.config = this.getFallbackConfig();
        }
    }

    protected boolean getConfigBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getConfigParam(key, Boolean.toString(defaultValue)));
    }

    protected int getConfigInt(String key, int defaultValue) {
        return NumberUtils.toInt((String)this.getConfigParam(key, Integer.toString(defaultValue)));
    }

    protected double getConfigDouble(String key, double defaultValue) {
        return NumberUtils.toDouble((String)this.getConfigParam(key, Double.toString(defaultValue)));
    }

    protected String getConfigParam(String key, String defaultValue) {
        if (this.config == null) {
            this.init(null);
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultValue;
        }
        String envKey = this.getConfigRootPrefix() + "_" + key.replaceAll("\\.", "_");
        String env = System.getenv().getOrDefault(envKey.toUpperCase(), System.getenv(envKey));
        String sys = System.getProperty(this.getConfigRootPrefix() + "." + key);
        if (!StringUtils.isBlank((CharSequence)sys)) {
            return sys;
        }
        if (!StringUtils.isBlank((CharSequence)env)) {
            return env;
        }
        return !StringUtils.isBlank((CharSequence)key) && this.config.hasPath(key) ? this.config.getAnyRef(key).toString() : defaultValue;
    }

    public Object getConfigValue(String key, String defaultValue) {
        String valString = this.getConfigParam(key, defaultValue);
        try {
            if (this.getConfig().hasPath(key) && this.getConfig().getValue(key).unwrapped() != null && StringUtils.equals((CharSequence)valString, (CharSequence)this.getConfig().getAnyRef(key).toString())) {
                return this.getConfig().getValue(key).unwrapped();
            }
            Documented doc = this.annotatedMethodsMap.get(key);
            if (doc != null && doc.type().equals(String.class)) {
                return valString;
            }
            Map v = (Map)ParaObjectUtils.getJsonReader(Map.class).readValue("{\"v\":" + valString + "}");
            return v.getOrDefault("v", defaultValue);
        }
        catch (Exception ex) {
            return valString;
        }
    }

    public com.typesafe.config.Config getConfig() {
        if (this.config == null) {
            this.init(null);
        }
        return this.config;
    }

    public Map<String, String> getSortedConfigKeys() {
        if (this.sortedConfigKeys == null || this.sortedConfigKeys.isEmpty()) {
            this.annotatedMethods = Arrays.stream(this.getClass().getMethods()).filter(m -> m.isAnnotationPresent(Documented.class)).map(m -> m.getAnnotation(Documented.class)).filter(m -> !StringUtils.isBlank((CharSequence)m.identifier())).sorted((a1, a2) -> Integer.compare(a1.position(), a2.position())).collect(Collectors.toList());
            this.sortedConfigKeys = this.annotatedMethods.stream().collect(Collectors.toMap(a -> a.identifier(), a -> a.category(), (u, v) -> u, LinkedHashMap::new));
            this.annotatedMethodsMap = this.annotatedMethods.stream().collect(Collectors.toMap(a -> a.identifier(), a -> a, (u, v) -> u, LinkedHashMap::new));
        }
        return this.sortedConfigKeys;
    }

    public void store() {
        if (!this.getConfigBoolean("store_config_locally", true)) {
            return;
        }
        String confFile = Paths.get(this.getConfigFilePath(), new String[0]).toAbsolutePath().toString();
        boolean isJsonFile = confFile.equalsIgnoreCase(".json");
        File conf = new File(confFile);
        if (!conf.exists() || conf.canWrite()) {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(conf));
                 ByteArrayInputStream data = new ByteArrayInputStream(this.render(isJsonFile, this.getRenderedHeader(), this.getRenderedFooter()).getBytes("utf-8"));){
                int read;
                byte[] bytes = new byte[1024];
                while ((read = data.read(bytes)) != -1) {
                    bos.write(bytes, 0, read);
                }
                logger.debug("Configuration stored successfully in {}", (Object)confFile);
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        } else {
            logger.warn("Failed to write configuration file {} to disk - check permissions.", (Object)confFile);
        }
    }

    public String render(boolean asJson) {
        return this.render(asJson, "", "");
    }

    public String render(boolean asJson, String hoconHeader, String hoconFooter) {
        if (asJson) {
            String conf = "{}";
            try {
                conf = ParaObjectUtils.getJsonWriter().writeValueAsString(this.getConfigMap());
            }
            catch (JsonProcessingException ex) {
                logger.error(null, (Throwable)ex);
            }
            return conf;
        }
        String category = "";
        StringBuilder sb = new StringBuilder(hoconHeader);
        if (!StringUtils.isBlank((CharSequence)hoconHeader) && !StringUtils.endsWith((CharSequence)hoconHeader, (CharSequence)"\n")) {
            sb.append("\n");
        }
        for (Map.Entry<String, Object> entry : this.getConfigMap().entrySet()) {
            String keyPrefixed = entry.getKey();
            String keyNoPrefix = StringUtils.removeStart((String)keyPrefixed, (String)(this.getConfigRootPrefix() + "."));
            Object val = entry.getValue();
            String valRendered = ConfigValueFactory.fromAnyRef((Object)val).render(ConfigRenderOptions.concise().setComments(false).setOriginComments(false));
            if (val == null) continue;
            String cat = this.getSortedConfigKeys().get(keyNoPrefix);
            if (!StringUtils.isBlank((CharSequence)cat) && !category.equalsIgnoreCase(cat)) {
                if (!category.isEmpty()) {
                    sb.append("\n");
                }
                category = this.getSortedConfigKeys().get(keyNoPrefix);
                sb.append("#############  ").append(category.toUpperCase()).append("  #############\n\n");
            }
            sb.append(keyPrefixed).append(" = ").append((Object)valRendered).append("\n");
        }
        sb.append("\n").append(hoconFooter).append("\n");
        return sb.toString();
    }

    public String renderConfigDocumentation(String format, boolean groupByCategory) {
        String category = "";
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Map<String, Map<String, String>>> jsonMapByCat = new LinkedHashMap<String, Map<String, Map<String, String>>>();
        LinkedHashMap<String, Map<String, String>> jsonMap = new LinkedHashMap<String, Map<String, String>>();
        if (!groupByCategory && "markdown".equalsIgnoreCase(format)) {
            sb.append("| Property key & Description | Default Value | Type |\n");
            sb.append("|  ---                       | ---           | ---  |\n");
        }
        for (Map.Entry<String, Documented> entry : this.annotatedMethodsMap.entrySet()) {
            if (this.getKeysExcludedFromRendering().contains(entry.getKey())) continue;
            if (groupByCategory) {
                category = this.renderCategoryHeader(format, category, entry, jsonMapByCat, sb);
            }
            this.renderConfigDescription(format, category, entry, jsonMapByCat, jsonMap, groupByCategory, sb);
        }
        if (StringUtils.isBlank((CharSequence)format) || "json".equalsIgnoreCase(format)) {
            try {
                return ParaObjectUtils.getJsonWriter().writeValueAsString(groupByCategory ? jsonMapByCat : jsonMap);
            }
            catch (JsonProcessingException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return sb.toString();
    }

    public Map<String, Object> getConfigMap() {
        LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>();
        for (String keyNoPrefix : this.getSortedConfigKeys().keySet()) {
            Object value = this.getConfigValue(keyNoPrefix, null);
            if (value == null) continue;
            configMap.put(this.getConfigRootPrefix() + "." + keyNoPrefix, value);
        }
        for (Map.Entry entry : this.getConfig().entrySet()) {
            String keyNoPrefix = (String)entry.getKey();
            String keyPrefixed = this.getConfigRootPrefix() + "." + (String)entry.getKey();
            Object value = this.getConfigValue(keyNoPrefix, "");
            Object valueUnwrapped = ConfigValueFactory.fromAnyRef((Object)value).unwrapped();
            if (this.getKeysExcludedFromRendering().contains(keyNoPrefix)) continue;
            configMap.put(keyPrefixed, valueUnwrapped);
        }
        return configMap;
    }

    private String renderCategoryHeader(String format, String category, Map.Entry<String, Documented> entry, Map<String, Map<String, Map<String, String>>> jsonMapByCat, StringBuilder sb) {
        String cat = this.getSortedConfigKeys().get(entry.getKey());
        if (!StringUtils.isBlank((CharSequence)cat) && !category.equalsIgnoreCase(cat)) {
            category = this.getSortedConfigKeys().getOrDefault(entry.getKey(), "");
            switch (StringUtils.trimToEmpty((String)format)) {
                case "markdown": {
                    if (!category.isEmpty()) {
                        sb.append("\n");
                    }
                    sb.append("## ").append(StringUtils.capitalize((String)category)).append("\n\n");
                    sb.append("| Property key & Description | Default Value | Type |\n");
                    sb.append("|  ---                       | ---           | ---  |\n");
                    break;
                }
                case "hocon": {
                    if (!category.isEmpty()) {
                        sb.append("\n");
                    }
                    sb.append("#############  ").append(category.toUpperCase()).append("  #############\n\n");
                    break;
                }
                default: {
                    jsonMapByCat.put(category, new LinkedHashMap());
                }
            }
        }
        return category;
    }

    private void renderConfigDescription(String format, String category, Map.Entry<String, Documented> entry, Map<String, Map<String, Map<String, String>>> jsonMapByCat, Map<String, Map<String, String>> jsonMap, boolean groupByCategory, StringBuilder sb) {
        switch (StringUtils.trimToEmpty((String)format)) {
            case "markdown": {
                String tags = Arrays.stream(entry.getValue().tags()).map(t -> " <kbd>" + t + "</kbd>").collect(Collectors.joining());
                sb.append("|`").append(this.getConfigRootPrefix()).append(".").append(entry.getKey()).append("`").append(tags).append("<br>").append(entry.getValue().description()).append(" | `").append(Optional.ofNullable(StringUtils.trimToNull((String)entry.getValue().value())).orElse(" ")).append("` | `").append(entry.getValue().type().getSimpleName()).append("`|\n");
                break;
            }
            case "hocon": {
                String tags = Arrays.stream(entry.getValue().tags()).map(t -> "[" + t + "] ").collect(Collectors.joining());
                sb.append("# ").append(entry.getValue().description());
                sb.append("[type: ").append(entry.getValue().type().getSimpleName()).append("] ").append(tags).append("\n");
                sb.append(this.getConfigRootPrefix()).append(".").append(entry.getKey()).append(" = ").append(entry.getValue().value()).append("\n");
                break;
            }
            default: {
                HashMap<String, String> description = new HashMap<String, String>();
                description.put("description", entry.getValue().description());
                description.put("defaultValue", entry.getValue().value());
                description.put(_TYPE, entry.getValue().type().getSimpleName());
                description.put(_TAGS, StringUtils.join((Object[])entry.getValue().tags(), (String)","));
                if (groupByCategory) {
                    jsonMapByCat.get(category).put(this.getConfigRootPrefix() + "." + entry.getKey(), description);
                    break;
                }
                jsonMap.put(this.getConfigRootPrefix() + "." + entry.getKey(), description);
            }
        }
    }
}

