/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class RateLimiter {
    private int rateLimitPerMin;
    private int rateLimitPerHour;
    private int rateLimitPerDay;
    private static final String LIMITS_PREFIX = "ratelimits:";
    private static final String LIMITS_H_PREFIX = "ratelimits_h:";
    private static final String LIMITS_D_PREFIX = "ratelimits_d:";

    RateLimiter() {
        this(60, 10);
    }

    RateLimiter(int rateLimitPerMin, int rateLimitPerHour) {
        this.rateLimitPerMin = rateLimitPerMin;
        this.rateLimitPerHour = rateLimitPerHour;
        this.rateLimitPerDay = 24 * rateLimitPerHour;
    }

    RateLimiter(int rateLimitPerMin, int rateLimitPerHour, int rateLimitPerDay) {
        this.rateLimitPerMin = rateLimitPerMin;
        this.rateLimitPerHour = rateLimitPerHour;
        this.rateLimitPerDay = rateLimitPerDay;
    }

    public boolean isAllowed(String appid, String userId) {
        return this.isAllowed(appid, userId, Utils.timestamp());
    }

    protected boolean isAllowed(String appid, String userId, Long reqT) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return false;
        }
        if (reqT == null || reqT <= 0L) {
            reqT = Utils.timestamp();
        }
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = Para.getConfig().getRootAppIdentifier();
        }
        ConcurrentSkipListMap times = (ConcurrentSkipListMap)Para.getCache().get(appid, this.limitsKey(userId));
        Long truncatedMin = this.truncate(reqT, ChronoUnit.MINUTES);
        if (times != null) {
            boolean endOfHour;
            Long lastTruncatedDay;
            Long truncatedDay = this.truncate(reqT, ChronoUnit.DAYS);
            boolean endOfDay = !Objects.equals(truncatedDay, lastTruncatedDay = this.truncate((Long)times.lastKey(), ChronoUnit.DAYS));
            boolean bl = endOfHour = !times.containsKey(truncatedMin);
            if (endOfDay || endOfHour) {
                this.refreshMinuteSlots(appid, userId, reqT);
                Para.getCache().put(appid, this.hourlyLimitsKey(userId), 0);
                if (endOfDay) {
                    Para.getCache().put(appid, this.dailyLimitsKey(userId), 0);
                }
            }
        } else {
            this.refreshMinuteSlots(appid, userId, reqT);
        }
        times = (ConcurrentSkipListMap)Para.getCache().get(appid, this.limitsKey(userId));
        int requestCounterHourly = Optional.ofNullable(Para.getCache().get(appid, this.hourlyLimitsKey(userId))).orElse(0);
        int requestCounterDaily = Optional.ofNullable(Para.getCache().get(appid, this.dailyLimitsKey(userId))).orElse(0);
        if (times.getOrDefault(truncatedMin, 0) >= this.rateLimitPerMin || requestCounterHourly >= this.rateLimitPerHour || requestCounterDaily >= this.rateLimitPerDay) {
            return false;
        }
        times.put(truncatedMin, times.getOrDefault(truncatedMin, 0) + 1);
        Para.getCache().put(appid, this.limitsKey(userId), times);
        Para.getCache().put(appid, this.hourlyLimitsKey(userId), requestCounterHourly + 1);
        Para.getCache().put(appid, this.dailyLimitsKey(userId), requestCounterDaily + 1);
        return true;
    }

    private Long truncate(Long time, ChronoUnit unit) {
        Instant instant = Instant.ofEpochMilli(time);
        Instant returnValue = instant.truncatedTo(unit);
        return returnValue.toEpochMilli();
    }

    private void refreshMinuteSlots(String appid, String userId, Long reqT) {
        Long minofDay = this.truncate(reqT, ChronoUnit.HOURS);
        ConcurrentSkipListMap<Long, Integer> times = new ConcurrentSkipListMap<Long, Integer>(IntStream.range(0, 60).boxed().collect(Collectors.toMap(k -> minofDay + (long)k.intValue() * TimeUnit.MINUTES.toMillis(1L), v -> 0)));
        Para.getCache().put(appid, this.limitsKey(userId), times);
    }

    private String limitsKey(String userId) {
        return StringUtils.startsWith((CharSequence)userId, (CharSequence)LIMITS_PREFIX) ? userId : LIMITS_PREFIX.concat(userId);
    }

    private String hourlyLimitsKey(String userId) {
        return StringUtils.startsWith((CharSequence)userId, (CharSequence)LIMITS_H_PREFIX) ? userId : LIMITS_H_PREFIX.concat(userId);
    }

    private String dailyLimitsKey(String userId) {
        return StringUtils.startsWith((CharSequence)userId, (CharSequence)LIMITS_D_PREFIX) ? userId : LIMITS_D_PREFIX.concat(userId);
    }
}

