/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.search;

import co.elastic.clients.elasticsearch._types.BulkIndexByScrollFailure;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.search.Search;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.search.es.ES;
import com.erudika.para.server.search.es.ESUtils;
import com.erudika.para.server.search.os.OS;
import com.erudika.para.server.search.os.OSUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opensearch.action.ActionListener;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ElasticSearch
implements Search {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearch.class);
    public static final boolean OPEN_SEARCH_FLAVOR = "opensearch".equalsIgnoreCase(Para.getConfig().elasticsearchFlavor());

    public ElasticSearch() {
        this(CoreUtils.getInstance().getDao());
    }

    @Inject
    public ElasticSearch(DAO dao) {
        ES.setDao(dao);
        OS.setDao(dao);
    }

    public boolean rebuildIndex(DAO dao, App app, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OSUtils.rebuildIndex(dao, app, null, pager);
        }
        return ESUtils.rebuildIndex(dao, app, null, pager);
    }

    public boolean rebuildIndex(DAO dao, App app, String destinationIndex, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OSUtils.rebuildIndex(dao, app, destinationIndex, pager);
        }
        return ESUtils.rebuildIndex(dao, app, destinationIndex, pager);
    }

    public boolean isValidQueryString(String queryString) {
        if (OPEN_SEARCH_FLAVOR) {
            return OSUtils.isValidQueryString(queryString);
        }
        return ESUtils.isValidQueryString(queryString);
    }

    public void createIndex(App app) {
        ElasticSearch.createIndexInternal(app);
    }

    private static void createIndexInternal(App app) {
        if (app != null) {
            String appid = app.getAppIdentifier();
            if (app.isSharingIndex()) {
                if (OPEN_SEARCH_FLAVOR) {
                    OSUtils.addIndexAliasWithRouting(Para.getConfig().getRootAppIdentifier(), appid);
                } else {
                    ESUtils.addIndexAliasWithRouting(Para.getConfig().getRootAppIdentifier(), appid);
                }
            } else {
                int replicas;
                int shards = app.isRootApp() ? Para.getConfig().elasticsearchRootIndexShards() : Para.getConfig().elasticsearchChildIndexShards();
                int n = replicas = app.isRootApp() ? Para.getConfig().elasticsearchRootIndexReplicas() : Para.getConfig().elasticsearchChildIndexReplicas();
                if (OPEN_SEARCH_FLAVOR) {
                    OSUtils.createIndex(appid, shards, replicas);
                } else {
                    ESUtils.createIndex(appid, shards, replicas);
                }
            }
        }
    }

    public void deleteIndex(App app) {
        ElasticSearch.deleteIndexInternal(app);
    }

    private static void deleteIndexInternal(App app) {
        if (app != null) {
            final String appid = app.getAppIdentifier();
            if (app.isSharingIndex()) {
                if (OPEN_SEARCH_FLAVOR) {
                    OSUtils.deleteByQuery(app.getAppIdentifier(), (QueryBuilder)QueryBuilders.matchAllQuery(), new ActionListener<BulkByScrollResponse>(){

                        public void onResponse(BulkByScrollResponse res) {
                        }

                        public void onFailure(Exception ex) {
                            logger.error("Failed to delete all objects in shared index for app '" + appid + "'", (Throwable)ex);
                        }
                    });
                    OSUtils.removeIndexAlias(Para.getConfig().getRootAppIdentifier(), appid);
                } else {
                    ESUtils.deleteByQuery(app.getAppIdentifier(), (QueryVariant)co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders.matchAll().build(), res -> {
                        if (!res.failures().isEmpty()) {
                            logger.error("Failed to delete all objects in shared index for app '" + appid + "' - {}", (Object)((BulkIndexByScrollFailure)res.failures().iterator().next()).cause().reason());
                        }
                    });
                    ESUtils.removeIndexAlias(Para.getConfig().getRootAppIdentifier(), appid);
                }
            } else if (OPEN_SEARCH_FLAVOR) {
                OSUtils.deleteIndex(appid);
            } else {
                ESUtils.deleteIndex(appid);
            }
        }
    }

    public void index(ParaObject object) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.indexAllInternal(Para.getConfig().getRootAppIdentifier(), Collections.singletonList(object));
        } else {
            ES.indexAllInternal(Para.getConfig().getRootAppIdentifier(), Collections.singletonList(object));
        }
    }

    public void index(String appid, ParaObject object) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.indexAllInternal(appid, Collections.singletonList(object));
        } else {
            ES.indexAllInternal(appid, Collections.singletonList(object));
        }
    }

    public void unindex(ParaObject object) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.unindexAllInternal(Para.getConfig().getRootAppIdentifier(), Collections.singletonList(object));
        } else {
            ES.unindexAllInternal(Para.getConfig().getRootAppIdentifier(), Collections.singletonList(object));
        }
    }

    public void unindex(String appid, ParaObject object) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.unindexAllInternal(appid, Collections.singletonList(object));
        } else {
            ES.unindexAllInternal(appid, Collections.singletonList(object));
        }
    }

    public <P extends ParaObject> void indexAll(List<P> objects) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.indexAllInternal(Para.getConfig().getRootAppIdentifier(), objects);
        } else {
            ES.indexAllInternal(Para.getConfig().getRootAppIdentifier(), objects);
        }
    }

    public <P extends ParaObject> void indexAll(String appid, List<P> objects) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.indexAllInternal(appid, objects);
        } else {
            ES.indexAllInternal(appid, objects);
        }
    }

    public <P extends ParaObject> void unindexAll(List<P> objects) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.unindexAllInternal(Para.getConfig().getRootAppIdentifier(), objects);
        } else {
            ES.unindexAllInternal(Para.getConfig().getRootAppIdentifier(), objects);
        }
    }

    public <P extends ParaObject> void unindexAll(String appid, List<P> objects) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.unindexAllInternal(appid, objects);
        } else {
            ES.unindexAllInternal(appid, objects);
        }
    }

    public void unindexAll(Map<String, ?> terms, boolean matchAll) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.unindexAllInternal(Para.getConfig().getRootAppIdentifier(), terms, matchAll);
        } else {
            ES.unindexAllInternal(Para.getConfig().getRootAppIdentifier(), terms, matchAll);
        }
    }

    public void unindexAll(String appid, Map<String, ?> terms, boolean matchAll) {
        if (OPEN_SEARCH_FLAVOR) {
            OS.unindexAllInternal(appid, terms, matchAll);
        } else {
            ES.unindexAllInternal(appid, terms, matchAll);
        }
    }

    public <P extends ParaObject> P findById(String id) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findByIdInternal(Para.getConfig().getRootAppIdentifier(), id);
        }
        return ES.findByIdInternal(Para.getConfig().getRootAppIdentifier(), id);
    }

    public <P extends ParaObject> P findById(String appid, String id) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findByIdInternal(appid, id);
        }
        return ES.findByIdInternal(appid, id);
    }

    public <P extends ParaObject> List<P> findByIds(List<String> ids) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findByIdsInternal(Para.getConfig().getRootAppIdentifier(), ids);
        }
        return ES.findByIdsInternal(Para.getConfig().getRootAppIdentifier(), ids);
    }

    public <P extends ParaObject> List<P> findByIds(String appid, List<String> ids) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findByIdsInternal(appid, ids);
        }
        return ES.findByIdsInternal(appid, ids);
    }

    public <P extends ParaObject> List<P> findNearby(String type, String query, int radius, double lat, double lng, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findNearbyInternal(Para.getConfig().getRootAppIdentifier(), type, query, radius, lat, lng, pager);
        }
        return ES.findNearbyInternal(Para.getConfig().getRootAppIdentifier(), type, query, radius, lat, lng, pager);
    }

    public <P extends ParaObject> List<P> findNearby(String appid, String type, String query, int radius, double lat, double lng, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findNearbyInternal(appid, type, query, radius, lat, lng, pager);
        }
        return ES.findNearbyInternal(appid, type, query, radius, lat, lng, pager);
    }

    public <P extends ParaObject> List<P> findPrefix(String type, String field, String prefix, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findPrefixInternal(Para.getConfig().getRootAppIdentifier(), type, field, prefix, pager);
        }
        return ES.findPrefixInternal(Para.getConfig().getRootAppIdentifier(), type, field, prefix, pager);
    }

    public <P extends ParaObject> List<P> findPrefix(String appid, String type, String field, String prefix, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findPrefixInternal(appid, type, field, prefix, pager);
        }
        return ES.findPrefixInternal(appid, type, field, prefix, pager);
    }

    public <P extends ParaObject> List<P> findQuery(String type, String query, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findQueryInternal(Para.getConfig().getRootAppIdentifier(), type, query, pager);
        }
        return ES.findQueryInternal(Para.getConfig().getRootAppIdentifier(), type, query, pager);
    }

    public <P extends ParaObject> List<P> findQuery(String appid, String type, String query, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findQueryInternal(appid, type, query, pager);
        }
        return ES.findQueryInternal(appid, type, query, pager);
    }

    public <P extends ParaObject> List<P> findNestedQuery(String type, String field, String query, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findNestedQueryInternal(Para.getConfig().getRootAppIdentifier(), type, field, query, pager);
        }
        return ES.findNestedQueryInternal(Para.getConfig().getRootAppIdentifier(), type, field, query, pager);
    }

    public <P extends ParaObject> List<P> findNestedQuery(String appid, String type, String field, String query, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findNestedQueryInternal(appid, type, field, query, pager);
        }
        return ES.findNestedQueryInternal(appid, type, field, query, pager);
    }

    public <P extends ParaObject> List<P> findSimilar(String type, String filterKey, String[] fields, String liketext, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findSimilarInternal(Para.getConfig().getRootAppIdentifier(), type, filterKey, fields, liketext, pager);
        }
        return ES.findSimilarInternal(Para.getConfig().getRootAppIdentifier(), type, filterKey, fields, liketext, pager);
    }

    public <P extends ParaObject> List<P> findSimilar(String appid, String type, String filterKey, String[] fields, String liketext, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findSimilarInternal(appid, type, filterKey, fields, liketext, pager);
        }
        return ES.findSimilarInternal(appid, type, filterKey, fields, liketext, pager);
    }

    public <P extends ParaObject> List<P> findTagged(String type, String[] tags, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTaggedInternal(Para.getConfig().getRootAppIdentifier(), type, tags, pager);
        }
        return ES.findTaggedInternal(Para.getConfig().getRootAppIdentifier(), type, tags, pager);
    }

    public <P extends ParaObject> List<P> findTagged(String appid, String type, String[] tags, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTaggedInternal(appid, type, tags, pager);
        }
        return ES.findTaggedInternal(appid, type, tags, pager);
    }

    public <P extends ParaObject> List<P> findTags(String keyword, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTagsInternal(Para.getConfig().getRootAppIdentifier(), keyword, pager);
        }
        return ES.findTagsInternal(Para.getConfig().getRootAppIdentifier(), keyword, pager);
    }

    public <P extends ParaObject> List<P> findTags(String appid, String keyword, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTagsInternal(appid, keyword, pager);
        }
        return ES.findTagsInternal(appid, keyword, pager);
    }

    public <P extends ParaObject> List<P> findTermInList(String type, String field, List<?> terms, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTermInListInternal(Para.getConfig().getRootAppIdentifier(), type, field, terms, pager);
        }
        return ES.findTermInListInternal(Para.getConfig().getRootAppIdentifier(), type, field, terms, pager);
    }

    public <P extends ParaObject> List<P> findTermInList(String appid, String type, String field, List<?> terms, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTermInListInternal(appid, type, field, terms, pager);
        }
        return ES.findTermInListInternal(appid, type, field, terms, pager);
    }

    public <P extends ParaObject> List<P> findTerms(String type, Map<String, ?> terms, boolean mustMatchBoth, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTermsInternal(Para.getConfig().getRootAppIdentifier(), type, terms, mustMatchBoth, pager);
        }
        return ES.findTermsInternal(Para.getConfig().getRootAppIdentifier(), type, terms, mustMatchBoth, pager);
    }

    public <P extends ParaObject> List<P> findTerms(String appid, String type, Map<String, ?> terms, boolean mustMatchBoth, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findTermsInternal(appid, type, terms, mustMatchBoth, pager);
        }
        return ES.findTermsInternal(appid, type, terms, mustMatchBoth, pager);
    }

    public <P extends ParaObject> List<P> findWildcard(String type, String field, String wildcard, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findWildcardInternal(Para.getConfig().getRootAppIdentifier(), type, field, wildcard, pager);
        }
        return ES.findWildcardInternal(Para.getConfig().getRootAppIdentifier(), type, field, wildcard, pager);
    }

    public <P extends ParaObject> List<P> findWildcard(String appid, String type, String field, String wildcard, Pager ... pager) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.findWildcardInternal(appid, type, field, wildcard, pager);
        }
        return ES.findWildcardInternal(appid, type, field, wildcard, pager);
    }

    public Long getCount(String type) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.getCountInternal(Para.getConfig().getRootAppIdentifier(), type);
        }
        return ES.getCountInternal(Para.getConfig().getRootAppIdentifier(), type);
    }

    public Long getCount(String appid, String type) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.getCountInternal(appid, type);
        }
        return ES.getCountInternal(appid, type);
    }

    public Long getCount(String type, Map<String, ?> terms) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.getCountInternal(Para.getConfig().getRootAppIdentifier(), type, terms);
        }
        return ES.getCountInternal(Para.getConfig().getRootAppIdentifier(), type, terms);
    }

    public Long getCount(String appid, String type, Map<String, ?> terms) {
        if (OPEN_SEARCH_FLAVOR) {
            return OS.getCountInternal(appid, type, terms);
        }
        return ES.getCountInternal(appid, type, terms);
    }

    static {
        if (Para.getConfig().isSearchEnabled() && Para.getConfig().searchPlugin().equalsIgnoreCase(ElasticSearch.class.getSimpleName())) {
            App.addAppCreatedListener(app -> ElasticSearch.createIndexInternal(app));
            App.addAppDeletedListener(app -> ElasticSearch.deleteIndexInternal(app));
        }
    }
}

