/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.search.es;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoDistanceQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Like;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MoreLikeThisQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WildcardQuery;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.elasticsearch.core.search.TotalHitsRelation;
import co.elastic.clients.util.ObjectBuilder;
import com.erudika.para.core.Address;
import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Tag;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.search.es.ESUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ES {
    private static final Logger logger = LoggerFactory.getLogger(ES.class);
    private static DAO dao;

    private ES() {
    }

    public static void setDao(DAO dao) {
        ES.dao = dao;
    }

    public static <P extends ParaObject> void indexAllInternal(String appid, List<P> objects) {
        if (StringUtils.isBlank((CharSequence)appid) || objects == null || objects.isEmpty()) {
            return;
        }
        try {
            ESUtils.executeRequests(objects.stream().filter(Objects::nonNull).map(obj -> BulkOperation.of(b -> b.update(d -> ((UpdateOperation.Builder)((UpdateOperation.Builder)d.index(ESUtils.getIndexName(appid))).id(obj.getId())).action(a -> a.doc(ESUtils.getSourceFromParaObject(obj)).docAsUpsert(Boolean.valueOf(true)))))).collect(Collectors.toList()));
            logger.debug("Search.indexAll() {}", (Object)objects.size());
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
        }
    }

    public static <P extends ParaObject> void unindexAllInternal(String appid, List<P> objects) {
        if (StringUtils.isBlank((CharSequence)appid) || objects == null || objects.isEmpty()) {
            return;
        }
        try {
            ESUtils.executeRequests(objects.stream().filter(Objects::nonNull).map(obj -> BulkOperation.of(b -> b.delete(d -> (ObjectBuilder)((DeleteOperation.Builder)d.index(ESUtils.getIndexName(appid))).id(obj.getId())))).collect(Collectors.toList()));
            logger.debug("Search.unindexAll() {}", (Object)objects.size());
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
        }
    }

    public static void unindexAllInternal(String appid, Map<String, ?> terms, boolean matchAll) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return;
        }
        try {
            long time = System.nanoTime();
            long unindexedCount = ESUtils.deleteByQuery(appid, (QueryVariant)(terms == null || terms.isEmpty() ? QueryBuilders.matchAll().build() : ESUtils.getTermsQuery(terms, matchAll)));
            time = System.nanoTime() - time;
            logger.info("Unindexed {} documents without failures, took {}s.", (Object)unindexedCount, (Object)TimeUnit.NANOSECONDS.toSeconds(time));
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
        }
    }

    public static <P extends ParaObject> P findByIdInternal(String appid, String id) {
        try {
            return ESUtils.getParaObjectFromSource(ES.getSource(appid, id));
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return null;
        }
    }

    public static <P extends ParaObject> List<P> findByIdsInternal(String appid, List<String> ids) {
        LinkedList list = new LinkedList();
        if (ids == null || ids.isEmpty()) {
            return list;
        }
        try {
            List values = ids.stream().filter(Objects::nonNull).map(v -> FieldValue.of(fv -> fv.stringValue(v))).collect(Collectors.toList());
            TermsQuery qb = QueryBuilders.terms().field("id").terms(t -> t.value(values)).build();
            return ES.searchQuery(appid, null, (QueryVariant)qb, new Pager[0]);
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return list;
        }
    }

    public static <P extends ParaObject> List<P> findTermInListInternal(String appid, String type, String field, List<?> terms, Pager ... pager) {
        TermsQuery qb;
        if (StringUtils.isBlank((CharSequence)field) || terms == null) {
            return Collections.emptyList();
        }
        if (ESUtils.nestedMode() && field.startsWith("properties.")) {
            BoolQuery bfb = null;
            BoolQuery.Builder fb = QueryBuilders.bool();
            for (Object term : terms) {
                bfb = ESUtils.keyValueBoolQuery(field, String.valueOf(term));
                fb.should(bfb._toQuery(), new Query[0]);
            }
            qb = (QueryVariant)ESUtils.nestedPropsQuery((QueryVariant)(terms.size() > 1 ? fb.build() : bfb)).build();
        } else {
            List values = terms.stream().filter(Objects::nonNull).map(v -> FieldValue.of(fv -> fv.stringValue(v.toString()))).collect(Collectors.toList());
            qb = QueryBuilders.terms().field(field).terms(t -> t.value(values)).build();
        }
        return ES.searchQuery(appid, type, (QueryVariant)qb, pager);
    }

    public static <P extends ParaObject> List<P> findPrefixInternal(String appid, String type, String field, String prefix, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)prefix)) {
            return Collections.emptyList();
        }
        Object qb = ESUtils.nestedMode() && field.startsWith("properties.") ? (QueryVariant)ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(field, (QueryVariant)QueryBuilders.prefix().field(ESUtils.getValueFieldName(prefix)).value(prefix).build())).build() : QueryBuilders.prefix().field(field).value(prefix).build();
        return ES.searchQuery(appid, type, (QueryVariant)qb, pager);
    }

    public static <P extends ParaObject> List<P> findQueryInternal(String appid, String type, String query, Pager ... pager) {
        Object qb;
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyList();
        }
        if (ESUtils.nestedMode()) {
            qb = ESUtils.convertQueryStringToNestedQuery(query);
            if (qb == null) {
                return Collections.emptyList();
            }
        } else {
            String qs = ESUtils.qs(query);
            qb = "*".equals(qs) ? QueryBuilders.matchAll().build() : QueryBuilders.queryString().query(qs).allowLeadingWildcard(Boolean.valueOf(false)).build();
        }
        return ES.searchQuery(appid, type, qb, pager);
    }

    public static <P extends ParaObject> List<P> findNestedQueryInternal(String appid, String type, String field, String query, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)query) || StringUtils.isBlank((CharSequence)field)) {
            return Collections.emptyList();
        }
        String queryString = "nstd." + field + ":" + query;
        NestedQuery qb = QueryBuilders.nested().path("nstd").query(QueryBuilders.queryString().query(ESUtils.qs(queryString)).build()._toQuery()).scoreMode(ChildScoreMode.Avg).build();
        return ES.searchQuery(appid, type, (QueryVariant)qb, pager);
    }

    public static <P extends ParaObject> List<P> findWildcardInternal(String appid, String type, String field, String wildcard, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)wildcard)) {
            return Collections.emptyList();
        }
        Object qb = ESUtils.nestedMode() && field.startsWith("properties.") ? (QueryVariant)ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(field, (QueryVariant)QueryBuilders.wildcard().field(ESUtils.getValueFieldName(wildcard)).value(wildcard).build())).build() : QueryBuilders.wildcard().field(field).value(wildcard).build();
        return ES.searchQuery(appid, type, (QueryVariant)qb, pager);
    }

    public static <P extends ParaObject> List<P> findTaggedInternal(String appid, String type, String[] tags, Pager ... pager) {
        if (tags == null || tags.length == 0 || StringUtils.isBlank((CharSequence)appid)) {
            return Collections.emptyList();
        }
        BoolQuery.Builder tagFilter = QueryBuilders.bool();
        for (String tag : tags) {
            tagFilter.must(QueryBuilders.term().field("tags").value(v -> v.stringValue(tag)).build()._toQuery(), new Query[0]);
        }
        return ES.searchQuery(appid, type, (QueryVariant)tagFilter.build(), pager);
    }

    public static <P extends ParaObject> List<P> findTermsInternal(String appid, String type, Map<String, ?> terms, boolean mustMatchAll, Pager ... pager) {
        if (terms == null || terms.isEmpty()) {
            return Collections.emptyList();
        }
        QueryVariant fb = ESUtils.getTermsQuery(terms, mustMatchAll);
        if (fb == null) {
            return Collections.emptyList();
        }
        return ES.searchQuery(appid, type, fb, pager);
    }

    public static <P extends ParaObject> List<P> findSimilarInternal(String appid, String type, String filterKey, String[] fields, String liketext, Pager ... pager) {
        MoreLikeThisQuery qb;
        if (StringUtils.isBlank((CharSequence)liketext)) {
            return Collections.emptyList();
        }
        String matchPercent = "70%";
        if (fields == null || fields.length == 0) {
            qb = QueryBuilders.moreLikeThis().like(l -> l.text(liketext)).minDocFreq(Integer.valueOf(1)).minTermFreq(Integer.valueOf(1)).minimumShouldMatch(matchPercent).build();
        } else {
            boolean containsNestedProps = Arrays.stream(fields).anyMatch(f -> StringUtils.startsWith((CharSequence)f, (CharSequence)"properties."));
            if (ESUtils.nestedMode() && containsNestedProps) {
                BoolQuery.Builder bqb = QueryBuilders.bool();
                for (String field : fields) {
                    MatchQuery kQuery = QueryBuilders.match().field("properties.k").query(v -> v.stringValue(ESUtils.getNestedKey(field))).build();
                    MoreLikeThisQuery vQuery = QueryBuilders.moreLikeThis().fields("properties.v", new String[0]).like(Like.of(l -> l.text(liketext)), new Like[0]).minDocFreq(Integer.valueOf(1)).minTermFreq(Integer.valueOf(1)).minimumShouldMatch(matchPercent).build();
                    QueryVariant nested = (QueryVariant)ESUtils.nestedPropsQuery((QueryVariant)QueryBuilders.bool().must(kQuery._toQuery(), new Query[]{vQuery._toQuery()}).build()).build();
                    bqb.should(nested._toQuery(), new Query[0]);
                }
                qb = bqb.build();
            } else {
                qb = QueryBuilders.moreLikeThis().fields(Arrays.asList(fields)).like(l -> l.text(liketext)).minDocFreq(Integer.valueOf(1)).minTermFreq(Integer.valueOf(1)).minimumShouldMatch(matchPercent).build();
            }
        }
        if (!StringUtils.isBlank((CharSequence)filterKey)) {
            qb = QueryBuilders.bool().mustNot(QueryBuilders.term().field("id").value(v -> v.stringValue(filterKey)).build()._toQuery(), new Query[0]).filter(qb._toQuery(), new Query[0]).build();
        }
        return ES.searchQuery(appid, ES.searchQueryRaw(appid, type, (QueryVariant)qb, pager));
    }

    public static <P extends ParaObject> List<P> findTagsInternal(String appid, String keyword, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return Collections.emptyList();
        }
        WildcardQuery qb = QueryBuilders.wildcard().field("tag").value(keyword.concat("*")).build();
        return ES.searchQuery(appid, Utils.type(Tag.class), (QueryVariant)qb, pager);
    }

    public static <P extends ParaObject> List<P> findNearbyInternal(String appid, String type, String query, int radius, double lat, double lng, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)appid)) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            query = "*";
        }
        Pager page = ESUtils.getPager(pager);
        GeoDistanceQuery qb1 = QueryBuilders.geoDistance().field("latlng").location(l -> l.latlon(ll -> ll.lat(lat).lon(lng))).distance(Integer.toString(radius) + " km").build();
        SearchResponse<Map> hits1 = ES.searchQueryRaw(appid, Utils.type(Address.class), (QueryVariant)qb1, page);
        page.setLastKey(null);
        if (hits1 == null) {
            return Collections.emptyList();
        }
        if (type.equals(Utils.type(Address.class))) {
            return ES.searchQuery(appid, hits1);
        }
        List parentIds = hits1.hits().hits().stream().filter(Objects::nonNull).map(h -> (String)((Map)h.source()).get("parentid")).collect(Collectors.toList());
        BoolQuery qb2 = QueryBuilders.bool().must(QueryBuilders.queryString().query(ESUtils.qs(query)).build()._toQuery(), new Query[0]).filter(QueryBuilders.ids().values(parentIds).build()._toQuery(), new Query[0]).build();
        SearchResponse<Map> hits2 = ES.searchQueryRaw(appid, type, (QueryVariant)qb2, page);
        return ES.searchQuery(appid, hits2);
    }

    private static <P extends ParaObject> List<P> searchQuery(String appid, String type, QueryVariant query, Pager ... pager) {
        return ES.searchQuery(appid, ES.searchQueryRaw(appid, type, query, pager));
    }

    protected static <P extends ParaObject> List<P> searchQuery(String appid, SearchResponse<Map> hits) {
        if (hits == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>(hits.hits().hits().size());
        LinkedList<String> keys = new LinkedList<String>();
        boolean readFromIndex = Para.getConfig().readFromIndexEnabled();
        boolean cleanupIndex = Para.getConfig().syncIndexWithDatabaseEnabled();
        try {
            for (Hit hit : hits.hits().hits()) {
                if (readFromIndex) {
                    Object pobj = ESUtils.getParaObjectFromSource((Map)hit.source());
                    results.add(pobj);
                } else {
                    keys.add(hit.id());
                }
                logger.debug("Search result: appid={}, {}->{}", new Object[]{appid, ((Map)hit.source()).get("appid"), hit.id()});
            }
            if (!readFromIndex && !keys.isEmpty()) {
                ArrayList<ParaObject> objectsMissingFromDB = new ArrayList<ParaObject>(results.size());
                Map fromDB = dao.readAll(appid, keys, true);
                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String)keys.get(i);
                    Object pobj = (ParaObject)fromDB.get(key);
                    if (pobj == null && (pobj = ESUtils.getParaObjectFromSource((Map)((Hit)hits.hits().hits().get(i)).source())) != null && appid.equals(pobj.getAppid()) && pobj.getStored().booleanValue()) {
                        objectsMissingFromDB.add((ParaObject)pobj);
                    }
                    if (pobj == null) continue;
                    results.add(pobj);
                }
                if (!objectsMissingFromDB.isEmpty()) {
                    ES.handleMissingObjects(appid, objectsMissingFromDB, cleanupIndex);
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.warn("Search query failed for app '{}': {}", (Object)appid, (Object)msg);
        }
        return results;
    }

    private static <P extends ParaObject> void handleMissingObjects(String appid, List<P> objectsMissingFromDB, boolean cleanupIndex) {
        if (cleanupIndex) {
            ES.unindexAllInternal(appid, objectsMissingFromDB);
            logger.debug("Removed {} objects from index in app '{}' that were not found in database: {}.", new Object[]{objectsMissingFromDB.size(), appid, objectsMissingFromDB.stream().map(o -> o.getId()).collect(Collectors.toList())});
        } else {
            logger.warn("Found {} objects in app '{}' that are still indexed but deleted from the database: {}. Sometimes this happens if you do a search right after a delete operation.", new Object[]{objectsMissingFromDB.size(), appid, objectsMissingFromDB});
        }
    }

    protected static SearchResponse<Map> searchQueryRaw(String appid, String type, QueryVariant query, Pager ... pager) {
        int start;
        if (StringUtils.isBlank((CharSequence)appid)) {
            return null;
        }
        Pager page = ESUtils.getPager(pager);
        SortOrder order = page.isDesc() ? SortOrder.Desc : SortOrder.Asc;
        int max = page.getLimit();
        int pageNum = (int)page.getPage();
        int n = start = pageNum < 1 || pageNum > Para.getConfig().maxPages() ? 0 : (pageNum - 1) * max;
        if (query == null) {
            query = QueryBuilders.matchAll().build();
        }
        if (!StringUtils.isBlank((CharSequence)type)) {
            query = QueryBuilders.bool().must(query._toQuery(), new Query[]{QueryBuilders.term().field("type").value(v -> v.stringValue(type)).build()._toQuery()}).build();
        }
        SearchResponse hits = null;
        String debugQuery = "";
        try {
            Object id;
            SearchRequest.Builder search = new SearchRequest.Builder();
            search.index(ESUtils.getIndexName(appid), new String[0]).searchType(SearchType.DfsQueryThenFetch).query(query._toQuery()).size(Integer.valueOf(max)).trackTotalHits(ESUtils.getTrackTotalHits());
            if (pageNum <= 1 && !StringUtils.isBlank((CharSequence)page.getLastKey())) {
                search.searchAfter(page.getLastKey(), new String[0]);
                search.from(Integer.valueOf(0));
                search.sort(SortOptions.of(b -> b.field(f -> f.field("_docid").order(order))), new SortOptions[0]);
            } else {
                search.from(Integer.valueOf(start));
                for (SortOptions sortField : ESUtils.getSortFieldsFromPager(page)) {
                    search.sort(sortField, new SortOptions[0]);
                }
            }
            debugQuery = search.toString();
            logger.debug("Elasticsearch query: {}", (Object)debugQuery);
            hits = ESUtils.getRESTClient().search(search.build(), Map.class);
            page.setCount(Optional.ofNullable(hits.hits().total()).orElse(TotalHits.of(t -> t.relation(TotalHitsRelation.Eq).value(page.getCount()))).value());
            if (hits.hits().hits().size() > 0 && (id = ((Map)((Hit)hits.hits().hits().get(hits.hits().hits().size() - 1)).source()).get("_docid")) != null) {
                page.setLastKey(id.toString());
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.debug("No search results for type '{}' in app '{}': {}.\nQuery: {}", new Object[]{type, appid, msg, debugQuery});
        }
        return hits;
    }

    protected static Map<String, Object> getSource(String appid, String key) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)appid)) {
            return map;
        }
        try {
            GetResponse gres = ESUtils.getRESTClient().get(b -> b.index(ESUtils.getIndexName(appid)).id(key), Map.class);
            if (gres.found()) {
                map = (Map)gres.source();
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.warn("Could not get any data from index '{}': {}", (Object)appid, (Object)msg);
        }
        return map;
    }

    public static Long getCountInternal(String appid, String type) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return 0L;
        }
        Object query = !StringUtils.isBlank((CharSequence)type) ? QueryBuilders.bool().must(QueryBuilders.term().field("type").value(v -> v.stringValue(type)).build()._toQuery(), new Query[0]).build() : QueryBuilders.matchAll().build();
        Long count = 0L;
        try {
            count = ESUtils.getRESTClient().count(arg_0 -> ES.lambda$getCountInternal$30(appid, (QueryVariant)query, arg_0)).count();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.warn("Could not count results in index '{}': {}", (Object)appid, (Object)msg);
        }
        return count;
    }

    public static Long getCountInternal(String appid, String type, Map<String, ?> terms) {
        if (StringUtils.isBlank((CharSequence)appid) || terms == null || terms.isEmpty()) {
            return 0L;
        }
        Long count = 0L;
        QueryVariant query = ESUtils.getTermsQuery(terms, true);
        if (query != null) {
            if (!StringUtils.isBlank((CharSequence)type)) {
                query = QueryBuilders.bool().must(query._toQuery(), new Query[]{QueryBuilders.term().field("type").value(v -> v.stringValue(type)).build()._toQuery()}).build();
            }
            try {
                Query q = query._toQuery();
                count = ESUtils.getRESTClient().count(b -> b.index(ESUtils.getIndexName(appid), new String[0]).query(q)).count();
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                String msg = cause != null ? cause.getMessage() : e.getMessage();
                logger.warn("Could not count results in index '{}': {}", (Object)appid, (Object)msg);
            }
        }
        return count;
    }

    public boolean rebuildIndex(DAO dao, App app, Pager ... pager) {
        return ESUtils.rebuildIndex(dao, app, null, pager);
    }

    public boolean rebuildIndex(DAO dao, App app, String destinationIndex, Pager ... pager) {
        return ESUtils.rebuildIndex(dao, app, destinationIndex, pager);
    }

    private static /* synthetic */ ObjectBuilder lambda$getCountInternal$30(String appid, QueryVariant query, CountRequest.Builder b) {
        return b.index(ESUtils.getIndexName(appid), new String[0]).query(query._toQuery());
    }
}

