/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.search.es;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.BulkIndexByScrollFailure;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchAllQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MultiMatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.elasticsearch.indices.update_aliases.AddAction;
import co.elastic.clients.elasticsearch.indices.update_aliases.RemoveAction;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.listeners.DestroyListener;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public final class ESUtils {
    private static final Logger logger = LoggerFactory.getLogger(ESUtils.class);
    private static ElasticsearchClient restClient;
    private static ElasticsearchAsyncClient restClientAsync;
    private static final int MAX_QUERY_DEPTH = 10;
    private static final String DATE_FORMAT = "epoch_millis||epoch_second||yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||yyyy/MM/dd||yyyyMMdd||yyyy";
    static final String PROPS_FIELD = "properties";
    static final String PROPS_PREFIX = "properties.";
    static final String PROPS_JSON = "_properties";
    static final String PROPS_REGEX = "(^|.*\\W)properties[\\.\\:].+";
    private static final String[] IGNORED_FIELDS;

    static boolean nestedMode() {
        return Para.getConfig().elasticsearchNestedModeEnabled();
    }

    static boolean asyncEnabled() {
        return Para.getConfig().elasticsearchAsyncModeEnabled();
    }

    static boolean flushImmediately() {
        return Para.getConfig().elasticsearchBulkFlushEnabled();
    }

    public static Map<String, Property> getDefaultMapping() {
        HashMap<String, Property> props = new HashMap<String, Property>();
        props.put("nstd", Property.of(p -> p.nested(n -> n.enabled(Boolean.valueOf(true)))));
        props.put(PROPS_FIELD, Property.of(p -> {
            if (ESUtils.nestedMode()) {
                p.nested(n -> n.enabled(Boolean.valueOf(true)));
            } else {
                p.object(n -> n.enabled(Boolean.valueOf(true)));
            }
            return p;
        }));
        props.put("latlng", Property.of(p -> p.geoPoint(n -> n.nullValue(v -> v.text("0,0")))));
        props.put("_docid", Property.of(p -> p.long_(n -> (ObjectBuilder)n.index(Boolean.valueOf(false)))));
        props.put("updated", Property.of(p -> p.date(n -> n.format(DATE_FORMAT))));
        props.put("timestamp", Property.of(p -> p.date(n -> n.format(DATE_FORMAT))));
        props.put("tag", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("id", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("key", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("name", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("type", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("tags", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("token", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("email", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("appid", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("groups", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("password", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("parentid", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("creatorid", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        props.put("identifier", Property.of(p -> p.keyword(n -> n.index(Boolean.valueOf(true)))));
        return props;
    }

    private ESUtils() {
    }

    public static ElasticsearchClient getRESTClient() {
        if (restClient != null) {
            return restClient;
        }
        String esScheme = Para.getConfig().elasticsearchRestClientScheme();
        String esHost = Para.getConfig().elasticsearchRestClientHost();
        int esPort = Para.getConfig().elasticsearchRestClientPort();
        boolean signRequests = Para.getConfig().elasticsearchSignRequestsForAwsEnabled();
        HttpHost host = new HttpHost(esHost, esPort, esScheme);
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{host});
        String esPrefix = Para.getConfig().elasticsearchRestClientContextPath();
        if (StringUtils.isNotEmpty((CharSequence)esPrefix)) {
            clientBuilder.setPathPrefix(esPrefix);
        }
        ArrayList<RestClientBuilder.HttpClientConfigCallback> configurationCallbacks = new ArrayList<RestClientBuilder.HttpClientConfigCallback>();
        if (signRequests) {
            configurationCallbacks.add(ESUtils.getAWSRequestSigningInterceptor(host.getSchemeName() + "://" + host.getHostName()));
        }
        configurationCallbacks.add(ESUtils.getAuthenticationCallback());
        clientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            configurationCallbacks.forEach(c -> c.customizeHttpClient(httpClientBuilder));
            if (esHost.startsWith("localhost") || !Para.getConfig().inProduction()) {
                httpClientBuilder.setSSLHostnameVerifier((hostname, session) -> true);
            }
            return httpClientBuilder;
        });
        RestClientTransport transport = new RestClientTransport(clientBuilder.build(), (JsonpMapper)new JacksonJsonpMapper());
        restClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        restClientAsync = new ElasticsearchAsyncClient((ElasticsearchTransport)transport);
        Para.addDestroyListener((DestroyListener)new DestroyListener(){

            public void onDestroy() {
                ESUtils.shutdownClient();
            }
        });
        if (!ESUtils.existsIndex(Para.getConfig().getRootAppIdentifier())) {
            ESUtils.createIndex(Para.getConfig().getRootAppIdentifier());
        }
        return restClient;
    }

    protected static void shutdownClient() {
        if (restClient != null) {
            try {
                ((ElasticsearchTransport)restClient._transport()).close();
                ((ElasticsearchTransport)restClientAsync._transport()).close();
            }
            catch (IOException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
    }

    private static ElasticsearchAsyncClient getAsyncRESTClient() {
        if (restClientAsync == null) {
            ESUtils.getRESTClient();
        }
        return restClientAsync;
    }

    private static boolean createIndexWithoutAlias(String name, int shards, int replicas) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.containsWhitespace((CharSequence)name) || ESUtils.existsIndex(name)) {
            return false;
        }
        try {
            if (shards <= 0) {
                shards = Para.getConfig().elasticsearchRootIndexShards();
            }
            if (replicas < 0) {
                replicas = Para.getConfig().elasticsearchRootIndexReplicas();
            }
            int numShards = shards;
            int numReplicas = replicas;
            IndexSettings settings = IndexSettings.of(b -> {
                b.numberOfShards(Integer.toString(numShards));
                b.numberOfReplicas(Integer.toString(numReplicas));
                b.autoExpandReplicas(Para.getConfig().elasticsearchAutoExpandReplicas());
                return b;
            });
            ESUtils.getRESTClient().indices().create(b -> b.index(name).settings(settings).mappings(TypeMapping.of(t -> t.properties(ESUtils.getDefaultMapping()))));
            logger.info("Created a new index '{}' with {} shards, {} replicas.", new Object[]{name, shards, replicas});
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean createIndex(String appid) {
        return ESUtils.createIndex(appid, Para.getConfig().elasticsearchRootIndexShards(), Para.getConfig().elasticsearchRootIndexReplicas());
    }

    public static boolean createIndex(String appid, int shards, int replicas) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        String indexName = appid.trim() + "_1";
        boolean created = ESUtils.createIndexWithoutAlias(indexName, shards, replicas);
        if (created) {
            boolean withAliasRouting = App.isRoot((String)appid) && Para.getConfig().elasticsearchRootIndexSharingEnabled();
            boolean aliased = ESUtils.addIndexAlias(indexName, appid, withAliasRouting);
            if (!aliased) {
                logger.info("Created ES index '{}' without an alias '{}'.", (Object)indexName, (Object)appid);
            } else {
                logger.info("Created ES index '{}' with alias '{}'.", (Object)indexName, (Object)appid);
            }
        }
        return created;
    }

    public static boolean deleteIndex(String appid) {
        if (StringUtils.isBlank((CharSequence)appid) || !ESUtils.existsIndex(appid)) {
            return false;
        }
        try {
            String indexName = ESUtils.getIndexNameForAlias(appid.trim());
            ESUtils.getRESTClient().indices().delete(b -> b.index(indexName, new String[0]));
            logger.info("Deleted ES index '{}'.", (Object)indexName);
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean existsIndex(String appid) {
        boolean exists;
        if (StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        try {
            String indexName = appid.trim();
            exists = ESUtils.getRESTClient().indices().exists(b -> b.index(indexName, new String[0])).value();
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            exists = false;
        }
        return exists;
    }

    public static boolean rebuildIndex(DAO dao, App app, String destinationIndex, Pager ... pager) {
        Objects.requireNonNull(dao, "DAO object cannot be null!");
        Objects.requireNonNull(app, "App object cannot be null!");
        if (StringUtils.isBlank((CharSequence)app.getAppIdentifier())) {
            return false;
        }
        try {
            List list;
            String indexName = app.getAppIdentifier().trim();
            if (!ESUtils.existsIndex(indexName)) {
                if (app.isSharingIndex()) {
                    ESUtils.addIndexAliasWithRouting(ESUtils.getIndexName(Para.getConfig().getRootAppIdentifier()), app.getAppIdentifier());
                } else {
                    logger.info("Creating '{}' index because it doesn't exist.", (Object)indexName);
                    ESUtils.createIndex(indexName);
                }
            }
            String oldName = ESUtils.getIndexNameForAlias(indexName);
            String newName = indexName;
            if (!app.isSharingIndex()) {
                if (StringUtils.isBlank((CharSequence)destinationIndex)) {
                    newName = ESUtils.getNewIndexName(indexName, oldName);
                    ESUtils.createIndexWithoutAlias(newName, -1, -1);
                } else {
                    newName = destinationIndex;
                }
            }
            LinkedList<BulkOperation> batch = new LinkedList<BulkOperation>();
            Pager p = ESUtils.getPager(pager);
            int batchSize = Para.getConfig().reindexBatchSize(p.getLimit());
            long reindexedCount = 0L;
            String newIndex = newName;
            do {
                list = dao.readPage(app.getAppIdentifier(), p);
                logger.debug("rebuildIndex(): Read {} objects from table {}.", (Object)list.size(), (Object)indexName);
                for (ParaObject obj : list) {
                    if (obj == null) continue;
                    batch.add(BulkOperation.of(b -> b.index(i -> ((IndexOperation.Builder)((IndexOperation.Builder)i.index(newIndex)).id(obj.getId())).document(ESUtils.getSourceFromParaObject(obj)))));
                    if (batch.size() < batchSize) continue;
                    reindexedCount += (long)batch.size();
                    ESUtils.executeRequests(batch);
                    logger.debug("rebuildIndex(): indexed {}", (Object)batch.size());
                    batch.clear();
                }
            } while (!list.isEmpty());
            if (batch.size() > 0) {
                reindexedCount += (long)batch.size();
                ESUtils.executeRequests(batch);
                logger.debug("rebuildIndex(): indexed {}", (Object)batch.size());
            }
            if (!app.isSharingIndex()) {
                ESUtils.switchIndexToAlias(oldName, newName, indexName, true);
            }
            logger.info("rebuildIndex(): {} objects reindexed in '{}' [shared: {}].", new Object[]{reindexedCount, indexName, app.isSharingIndex()});
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static void refreshIndex(String appid) throws IOException {
        if (!StringUtils.isBlank((CharSequence)appid)) {
            ESUtils.getRESTClient().indices().refresh(b -> b.index(ESUtils.getIndexName(appid), new String[0]));
        }
    }

    public static long deleteByQuery(String appid, QueryVariant fb) {
        return ESUtils.deleteByQuery(appid, fb, ESUtils.asyncEnabled() ? res -> {
            logger.debug("Unindexed {}", (Object)res.total());
            if (!res.failures().isEmpty()) {
                logger.error("Delete by query reqest failed for app '" + appid + "' - {}", (Object)((BulkIndexByScrollFailure)res.failures().iterator().next()).cause().reason());
            }
        } : null);
    }

    public static long deleteByQuery(String appid, QueryVariant fb, Consumer<DeleteByQueryResponse> cb) {
        int batchSize = 1000;
        boolean isSharingIndex = !App.isRoot((String)appid) && StringUtils.startsWith((CharSequence)appid, (CharSequence)" ");
        String indexName = ESUtils.getIndexName(appid);
        DeleteByQueryRequest.Builder deleteByQueryReq = new DeleteByQueryRequest.Builder();
        deleteByQueryReq.index(indexName, new String[0]);
        deleteByQueryReq.conflicts(Conflicts.Proceed);
        deleteByQueryReq.query(fb._toQuery());
        deleteByQueryReq.slices(Long.valueOf(1L));
        deleteByQueryReq.scroll(Time.of(t -> t.time("10m")));
        deleteByQueryReq.refresh(Boolean.valueOf(true));
        if (isSharingIndex) {
            deleteByQueryReq.routing(indexName);
        }
        if (cb != null) {
            ESUtils.getAsyncRESTClient().deleteByQuery(deleteByQueryReq.build()).thenAccept(cb);
        } else {
            try {
                DeleteByQueryResponse res = ESUtils.getRESTClient().deleteByQuery(deleteByQueryReq.build());
                if (!res.failures().isEmpty()) {
                    logger.warn("Failures in deleteByQuery() - {}", (Object)((BulkIndexByScrollFailure)res.failures().iterator().next()).cause().reason());
                }
                return res.total();
            }
            catch (IOException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return 0L;
    }

    protected static Pager getPager(Pager[] pager) {
        return pager != null && pager.length > 0 ? pager[0] : new Pager();
    }

    protected static List<SortOptions> getSortFieldsFromPager(Pager pager) {
        SortOrder defaultOrder;
        if (pager == null) {
            pager = new Pager();
        }
        SortOrder sortOrder = defaultOrder = pager.isDesc() ? SortOrder.Desc : SortOrder.Asc;
        if (pager.getSortby().contains(",")) {
            String[] fields = pager.getSortby().split(",");
            ArrayList<SortOptions> sortFields = new ArrayList<SortOptions>(fields.length);
            for (String field : fields) {
                String fieldName;
                SortOrder order;
                if (field.endsWith(":asc")) {
                    order = SortOrder.Asc;
                    fieldName = field.substring(0, field.indexOf(":asc")).trim();
                } else if (field.endsWith(":desc")) {
                    order = SortOrder.Desc;
                    fieldName = field.substring(0, field.indexOf(":desc")).trim();
                } else {
                    order = defaultOrder;
                    fieldName = field.trim();
                }
                if (ESUtils.nestedMode() && fieldName.startsWith(PROPS_PREFIX)) {
                    sortFields.add(ESUtils.getNestedFieldSort(fieldName, order));
                    continue;
                }
                sortFields.add(SortOptions.of(b -> b.field(f -> f.field(fieldName).order(order))));
            }
            return sortFields;
        }
        if (StringUtils.isBlank((CharSequence)pager.getSortby())) {
            return Collections.singletonList(SortOptions.of(b -> b.score(s -> s.order(defaultOrder))));
        }
        String fieldName = pager.getSortby();
        if (ESUtils.nestedMode() && fieldName.startsWith(PROPS_PREFIX)) {
            return Collections.singletonList(ESUtils.getNestedFieldSort(fieldName, defaultOrder));
        }
        return Collections.singletonList(SortOptions.of(b -> b.field(f -> f.field(fieldName).order(defaultOrder))));
    }

    private static SortOptions getNestedFieldSort(String fieldName, SortOrder order) {
        return SortOptions.of(b -> b.field(f -> f.field("properties.vn").order(order).nested(n -> n.path(PROPS_FIELD).filter(nf -> nf.term((T t) -> t.field("properties.k").value(fv -> fv.stringValue(StringUtils.removeStart((String)fieldName, (String)PROPS_PREFIX))))))));
    }

    public static boolean addIndexAliasWithRouting(String indexName, String aliasName) {
        return ESUtils.addIndexAlias(indexName, aliasName, true);
    }

    public static boolean addIndexAlias(String indexName, String aliasName, boolean withAliasRouting) {
        if (StringUtils.isBlank((CharSequence)aliasName) || !ESUtils.existsIndex(indexName)) {
            return false;
        }
        try {
            String alias = aliasName.trim();
            String index = ESUtils.getIndexNameWithWildcard(indexName.trim());
            return ESUtils.getRESTClient().indices().updateAliases(b -> b.actions(a -> {
                if (withAliasRouting) {
                    return a.add(aa -> aa.index(index).alias(alias).searchRouting(alias).indexRouting(alias).filter(QueryBuilders.term().field("appid").value(FieldValue.of((String)aliasName)).build()._toQuery()));
                }
                return a.add(aa -> aa.index(index).alias(alias));
            })).acknowledged();
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
    }

    public static boolean removeIndexAlias(String indexName, String aliasName) {
        if (StringUtils.isBlank((CharSequence)aliasName) || !ESUtils.existsIndex(indexName)) {
            return false;
        }
        String alias = aliasName.trim();
        try {
            String index = ESUtils.getIndexNameWithWildcard(indexName.trim());
            return ESUtils.getRESTClient().indices().updateAliases(b -> b.actions(a -> a.remove(r -> r.index(index).alias(alias)))).acknowledged();
        }
        catch (Exception e) {
            logger.warn("Failed to remove index alias '" + alias + "' for index " + indexName + ": {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean existsIndexAlias(String indexName, String aliasName) {
        if (StringUtils.isBlank((CharSequence)indexName) || StringUtils.isBlank((CharSequence)aliasName)) {
            return false;
        }
        try {
            String alias = aliasName.trim();
            String index = ESUtils.getIndexNameWithWildcard(indexName.trim());
            return ESUtils.getRESTClient().indices().existsAlias(b -> b.index(index, new String[0]).name(alias, new String[0])).value();
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
    }

    public static void switchIndexToAlias(String oldIndex, String newIndex, String alias, boolean deleteOld) {
        if (StringUtils.isBlank((CharSequence)oldIndex) || StringUtils.isBlank((CharSequence)newIndex) || StringUtils.isBlank((CharSequence)alias)) {
            return;
        }
        try {
            String aliaz = alias.trim();
            String oldName = oldIndex.trim();
            String newName = newIndex.trim();
            logger.info("Switching index aliases {}->{}, deleting '{}': {}", new Object[]{aliaz, newIndex, oldIndex, deleteOld});
            Action removeAction = RemoveAction.of(b -> b.index(oldName).alias(aliaz))._toAction();
            Action addAction = AddAction.of(b -> b.index(newName).alias(aliaz))._toAction();
            ESUtils.getRESTClient().indices().updateAliases(b -> b.actions(removeAction, new Action[]{addAction}));
            if (deleteOld) {
                ESUtils.deleteIndex(oldName);
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
    }

    public static String getIndexNameForAlias(String appid) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return appid;
        }
        try {
            Map aliases = ESUtils.getRESTClient().indices().getAlias(b -> b.index(appid, new String[0])).result();
            if (!aliases.isEmpty()) {
                return (String)aliases.keySet().iterator().next();
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        return appid;
    }

    static String getNewIndexName(String appid, String oldName) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return appid;
        }
        return (oldName.contains("_") ? oldName.substring(0, oldName.indexOf(95)) : appid) + "_" + Utils.timestamp();
    }

    public static void executeRequests(List<BulkOperation> requests) {
        if (requests == null || requests.isEmpty()) {
            return;
        }
        try {
            if (ESUtils.asyncEnabled()) {
                ESUtils.getAsyncRESTClient().bulk(b -> b.operations(requests).refresh(ESUtils.flushImmediately() ? Refresh.True : Refresh.False)).thenAccept(b -> {
                    if (b.errors()) {
                        b.items().stream().filter(i -> i.status() != 200).forEach(item -> logger.error("Failed to execute async {} operation for index '{}', document id '{}': {}", new Object[]{item.operationType(), item.index(), item.id(), item.error().reason()}));
                    }
                });
            } else {
                BulkResponse res = ESUtils.getRESTClient().bulk(b -> b.operations(requests).refresh(ESUtils.flushImmediately() ? Refresh.True : Refresh.False));
                if (res.errors()) {
                    res.items().stream().filter(i -> i.status() != 200).forEach(item -> logger.error("Failed to execute sync {} operation for index '{}', document id '{}': {}", new Object[]{item.operationType(), item.index(), item.id(), item.error().reason()}));
                    ESUtils.handleFailedRequests();
                }
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
    }

    private static void handleFailedRequests() {
        if (Para.getConfig().exceptionOnWriteErrorsEnabled()) {
            throw new RuntimeException("Synchronous indexing operation failed!");
        }
    }

    public static boolean isClusterOK() {
        try {
            HealthStatus status = ESUtils.getRESTClient().cluster().health().status();
            return !HealthStatus.Red.equals((Object)status);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
    }

    static QueryVariant getTermsQuery(Map<String, ?> terms, boolean mustMatchAll) {
        BoolQuery.Builder fb = QueryBuilders.bool();
        int addedTerms = 0;
        boolean noop = true;
        Object bfb = null;
        for (Map.Entry<String, ?> term : terms.entrySet()) {
            String stringValue;
            Object val = term.getValue();
            if (StringUtils.isBlank((CharSequence)term.getKey()) || val == null || !Utils.isBasicType(val.getClass()) || StringUtils.isBlank((CharSequence)(stringValue = val.toString()))) continue;
            Matcher matcher = Pattern.compile(".*(<|>|<=|>=)$").matcher(term.getKey().trim());
            bfb = matcher.matches() ? ESUtils.range(matcher.group(1), term.getKey(), stringValue) : (ESUtils.nestedMode() ? (QueryVariant)ESUtils.term((Query)new TermQuery(new Term(term.getKey(), stringValue))).build() : QueryBuilders.term().field(term.getKey()).value(v -> v.stringValue(stringValue)).build());
            if (mustMatchAll) {
                fb.must(bfb._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[0]);
            } else {
                fb.should(bfb._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[0]);
            }
            ++addedTerms;
            noop = false;
        }
        if (addedTerms == 1 && bfb != null) {
            return bfb;
        }
        return noop ? null : fb.build();
    }

    static String qs(String query) {
        if (StringUtils.isBlank((CharSequence)query) || "*".equals(query.trim())) {
            return "*";
        }
        if ((query = query.trim()).length() > 1 && query.startsWith("*")) {
            query = query.substring(1);
        }
        try {
            StandardQueryParser parser = new StandardQueryParser();
            parser.setAllowLeadingWildcard(false);
            parser.parse(query, "");
        }
        catch (Exception ex) {
            logger.warn("Failed to parse query string '{}'.", (Object)query);
            query = "*";
        }
        return query.trim();
    }

    static Query qsParsed(String query) {
        if (StringUtils.isBlank((CharSequence)query) || "*".equals(query.trim())) {
            return null;
        }
        try {
            StandardQueryParser parser = new StandardQueryParser();
            parser.setAllowLeadingWildcard(false);
            return parser.parse(query, "");
        }
        catch (Exception ex) {
            logger.warn("Failed to parse query string '{}'.", (Object)query);
            return null;
        }
    }

    public static boolean isValidQueryString(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return false;
        }
        if ("*".equals(query.trim())) {
            return true;
        }
        try {
            StandardQueryParser parser = new StandardQueryParser();
            parser.setAllowLeadingWildcard(false);
            parser.parse(query, "");
            return true;
        }
        catch (QueryNodeException ex) {
            return false;
        }
    }

    public static Map<String, Object> getSourceFromParaObject(ParaObject po) {
        if (po == null) {
            return Collections.emptyMap();
        }
        Map data = ParaObjectUtils.getAnnotatedFields((ParaObject)po, null, (boolean)false);
        HashMap<String, Object> source = new HashMap<String, Object>(data.size() + 1);
        source.putAll(data);
        if (ESUtils.nestedMode() && po instanceof Sysprop) {
            try {
                Map props = (Map)data.get(PROPS_FIELD);
                List<Map<String, Object>> keysAndValues = ESUtils.getNestedProperties(props);
                source.put(PROPS_FIELD, keysAndValues);
                source.put(PROPS_JSON, ParaObjectUtils.getJsonWriterNoIdent().writeValueAsString((Object)props));
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
        for (String field : IGNORED_FIELDS) {
            source.remove(field);
        }
        source.put("_docid", NumberUtils.toLong((String)Utils.getNewId()));
        return source;
    }

    static TrackHits getTrackTotalHits() {
        String trackTotalHits = Para.getConfig().elasticsearchTrackTotalHits();
        return TrackHits.of(t -> {
            if (NumberUtils.isDigits((String)trackTotalHits)) {
                return t.count(Integer.valueOf(NumberUtils.toInt((String)trackTotalHits, (int)10000)));
            }
            if (!Boolean.valueOf(trackTotalHits).booleanValue()) {
                return t.enabled(Boolean.valueOf(false));
            }
            return t.enabled(Boolean.valueOf(true));
        });
    }

    private static List<Map<String, Object>> getNestedProperties(Map<String, Object> objectData) {
        if (objectData == null || objectData.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Map<String, Object>> keysAndValues = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> stack = new LinkedList<Map<String, Object>>();
        stack.add(Collections.singletonMap("", objectData));
        while (!stack.isEmpty()) {
            String prefix;
            Map singletonMap = (Map)stack.pop();
            Object value = singletonMap.get(prefix = (String)singletonMap.keySet().iterator().next());
            if (value == null) continue;
            if (value instanceof Map) {
                Object pre = StringUtils.isBlank((CharSequence)prefix) ? "" : prefix + "-";
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    ESUtils.addFieldToStack((String)pre + (String)entry.getKey(), entry.getValue(), stack, keysAndValues);
                }
                continue;
            }
            ESUtils.addFieldToStack(prefix, value, stack, keysAndValues);
        }
        return keysAndValues;
    }

    private static void addFieldToStack(String prefix, Object val, LinkedList<Map<String, Object>> stack, List<Map<String, Object>> keysAndValues) {
        if (val instanceof Map) {
            stack.push(Collections.singletonMap(prefix, val));
        } else if (val instanceof List) {
            for (int i = 0; i < ((List)val).size(); ++i) {
                stack.push(Collections.singletonMap(prefix + "-" + String.valueOf(i), ((List)val).get(i)));
            }
        } else {
            keysAndValues.add(ESUtils.getKeyValueField(prefix, val));
        }
    }

    private static Map<String, Object> getKeyValueField(String field, Object value) {
        HashMap<String, Object> propMap = new HashMap<String, Object>(2);
        propMap.put("k", field);
        if (value instanceof Number) {
            propMap.put("vn", value);
        } else {
            propMap.put("v", String.valueOf(value));
        }
        return propMap;
    }

    static <P extends ParaObject> P getParaObjectFromSource(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(source.size());
        data.putAll(source);
        if (ESUtils.nestedMode() && data.containsKey(PROPS_JSON)) {
            try {
                Map props = (Map)ParaObjectUtils.getJsonReader(Map.class).readValue((String)data.get(PROPS_JSON));
                data.put(PROPS_FIELD, props);
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
            data.remove(PROPS_JSON);
        }
        data.remove("_docid");
        return (P)ParaObjectUtils.setAnnotatedFields(data);
    }

    static QueryVariant range(String operator, String field, String stringValue) {
        Objects.requireNonNull(field);
        String key = field.replaceAll("[<>=\\s]+$", "");
        boolean nestedMode = ESUtils.nestedMode() && field.startsWith(PROPS_PREFIX);
        RangeQuery.Builder rfb = QueryBuilders.range().field(nestedMode ? ESUtils.getValueFieldName(stringValue) : key);
        if (">".equals(operator)) {
            rfb.gt(ESUtils.getNumericValue(stringValue));
        } else if ("<".equals(operator)) {
            rfb.lt(ESUtils.getNumericValue(stringValue));
        } else if (">=".equals(operator)) {
            rfb.gte(ESUtils.getNumericValue(stringValue));
        } else if ("<=".equals(operator)) {
            rfb.lte(ESUtils.getNumericValue(stringValue));
        }
        if (nestedMode) {
            return (QueryVariant)ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(key, (QueryVariant)rfb.build())).build();
        }
        return rfb.build();
    }

    static QueryVariant convertQueryStringToNestedQuery(String query) {
        String queryStr = StringUtils.trimToEmpty((String)query).replaceAll("\\[(\\d+)\\]", "-$1");
        Query q = ESUtils.qsParsed(queryStr);
        if (q == null) {
            return QueryBuilders.matchAll().build();
        }
        try {
            return ESUtils.rewriteQuery(q, 0);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return null;
        }
    }

    private static QueryVariant rewriteQuery(Query q, int depth) throws IllegalAccessException {
        if (depth > 10) {
            throw new IllegalArgumentException("Query depth exceeded! Max depth: 10 - " + q.toString());
        }
        ObjectBuilder qb = null;
        if (q instanceof BooleanQuery) {
            qb = QueryBuilders.bool();
            block5: for (BooleanClause clause : ((BooleanQuery)q).clauses()) {
                switch (clause.getOccur()) {
                    case MUST: {
                        ((BoolQuery.Builder)qb).must(ESUtils.rewriteQuery(clause.getQuery(), depth++)._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[0]);
                        continue block5;
                    }
                    case MUST_NOT: {
                        ((BoolQuery.Builder)qb).mustNot(ESUtils.rewriteQuery(clause.getQuery(), depth++)._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[0]);
                        continue block5;
                    }
                    case FILTER: {
                        ((BoolQuery.Builder)qb).filter(ESUtils.rewriteQuery(clause.getQuery(), depth++)._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[0]);
                        continue block5;
                    }
                }
                ((BoolQuery.Builder)qb).should(ESUtils.rewriteQuery(clause.getQuery(), depth++)._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[0]);
            }
        } else if (q instanceof TermRangeQuery) {
            qb = ESUtils.termRange(q);
        } else if (q instanceof BoostQuery) {
            qb = (ObjectBuilder)QueryBuilders.boosting().positive(ESUtils.rewriteQuery(((BoostQuery)q).getQuery(), depth++)._toQuery()).boost(Float.valueOf(((BoostQuery)q).getBoost()));
        } else if (q instanceof TermQuery) {
            qb = ESUtils.term(q);
        } else if (q instanceof FuzzyQuery) {
            qb = ESUtils.fuzzy(q);
        } else if (q instanceof PrefixQuery) {
            qb = ESUtils.prefix(q);
        } else if (q instanceof WildcardQuery) {
            qb = ESUtils.wildcard(q);
        } else {
            logger.warn("Unknown query type in nested mode query syntax: {}", (Object)q);
        }
        return qb == null ? QueryBuilders.matchAll().build() : (QueryVariant)qb.build();
    }

    private static ObjectBuilder<?> termRange(Query q) {
        ObjectBuilder<?> qb = null;
        TermRangeQuery trq = (TermRangeQuery)q;
        if (!StringUtils.isBlank((CharSequence)trq.getField())) {
            String from = trq.getLowerTerm() != null ? Term.toString((BytesRef)trq.getLowerTerm()) : "*";
            String to = trq.getUpperTerm() != null ? Term.toString((BytesRef)trq.getUpperTerm()) : "*";
            boolean isNestedField = trq.getField().matches(PROPS_REGEX);
            qb = QueryBuilders.range().field(isNestedField ? ESUtils.getValueFieldNameFromRange(from, to) : trq.getField());
            if ("*".equals(from) && "*".equals(to)) {
                qb = QueryBuilders.matchAll();
            }
            if (!"*".equals(from)) {
                if (trq.includesLower()) {
                    qb.gte(ESUtils.getNumericValue(from));
                } else {
                    qb.gt(ESUtils.getNumericValue(from));
                }
            }
            if (!"*".equals(to)) {
                if (trq.includesUpper()) {
                    qb.lte(ESUtils.getNumericValue(to));
                } else {
                    qb.lt(ESUtils.getNumericValue(to));
                }
            }
            if (isNestedField) {
                qb = ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(trq.getField(), (QueryVariant)qb.build()));
            }
        }
        return qb;
    }

    private static ObjectBuilder<?> term(Query q) {
        TermQuery.Builder qb;
        String field = ((TermQuery)q).getTerm().field();
        String value = ((TermQuery)q).getTerm().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQuery kQuery = QueryBuilders.matchAll().build();
            MultiMatchQuery vQuery = QueryBuilders.multiMatch().query(value).build();
            QueryVariant nested = (QueryVariant)ESUtils.nestedPropsQuery((QueryVariant)QueryBuilders.bool().must(kQuery._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{vQuery._toQuery()}).build()).build();
            qb = QueryBuilders.bool().should(nested._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{QueryBuilders.multiMatch().query(value).build()._toQuery()});
        } else {
            qb = field.matches(PROPS_REGEX) ? ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(field, value)) : QueryBuilders.term().field(field).value(v -> v.stringValue(value));
        }
        return qb;
    }

    private static ObjectBuilder<?> fuzzy(Query q) {
        BoolQuery.Builder qb;
        String field = ((FuzzyQuery)q).getTerm().field();
        String value = ((FuzzyQuery)q).getTerm().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQuery kQuery = QueryBuilders.matchAll().build();
            co.elastic.clients.elasticsearch._types.query_dsl.FuzzyQuery vQuery = QueryBuilders.fuzzy().field(ESUtils.getValueFieldName(value)).value(v -> v.stringValue(value)).build();
            QueryVariant nested = (QueryVariant)ESUtils.nestedPropsQuery((QueryVariant)QueryBuilders.bool().must(kQuery._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{vQuery._toQuery()}).build());
            qb = QueryBuilders.bool().should(nested._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{QueryBuilders.multiMatch().query(value).build()._toQuery()});
        } else {
            qb = field.matches(PROPS_REGEX) ? ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(field, (QueryVariant)QueryBuilders.fuzzy().field(ESUtils.getValueFieldName(value)).value(v -> v.stringValue(value)).build())) : QueryBuilders.fuzzy().field(field).value(v -> v.stringValue(value));
        }
        return qb;
    }

    private static ObjectBuilder<?> prefix(Query q) {
        BoolQuery.Builder qb;
        String field = ((PrefixQuery)q).getPrefix().field();
        String value = ((PrefixQuery)q).getPrefix().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQuery kQuery = QueryBuilders.matchAll().build();
            co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery vQuery = QueryBuilders.prefix().field(ESUtils.getValueFieldName(value)).value(value).build();
            QueryVariant nested = (QueryVariant)ESUtils.nestedPropsQuery((QueryVariant)QueryBuilders.bool().must(kQuery._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{vQuery._toQuery()}).build());
            qb = QueryBuilders.bool().should(nested._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{QueryBuilders.multiMatch().query(value).build()._toQuery()});
        } else {
            qb = field.matches(PROPS_REGEX) ? ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(field, (QueryVariant)QueryBuilders.prefix().field(ESUtils.getValueFieldName(value)).value(value).build())) : QueryBuilders.prefix().field(field).value(value);
        }
        return qb;
    }

    private static ObjectBuilder<?> wildcard(Query q) {
        BoolQuery.Builder qb;
        String field = ((WildcardQuery)q).getTerm().field();
        String value = ((WildcardQuery)q).getTerm().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQuery kQuery = QueryBuilders.matchAll().build();
            co.elastic.clients.elasticsearch._types.query_dsl.WildcardQuery vQuery = QueryBuilders.wildcard().field(ESUtils.getValueFieldName(value)).value(value).build();
            QueryVariant nested = (QueryVariant)ESUtils.nestedPropsQuery((QueryVariant)QueryBuilders.bool().must(kQuery._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{vQuery._toQuery()}).build());
            qb = QueryBuilders.bool().should(nested._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{QueryBuilders.multiMatch().query(value).build()._toQuery()});
        } else {
            qb = field.matches(PROPS_REGEX) ? ESUtils.nestedPropsQuery(ESUtils.keyValueBoolQuery(field, (QueryVariant)QueryBuilders.wildcard().field(ESUtils.getValueFieldName(value)).value(value).build())) : QueryBuilders.wildcard().field(field).value(value);
        }
        return qb;
    }

    static QueryVariant keyValueBoolQuery(String k, QueryVariant query) {
        return ESUtils.keyValueBoolQuery(k, null, query);
    }

    static QueryVariant keyValueBoolQuery(String k, String v) {
        return ESUtils.keyValueBoolQuery(k, v, null);
    }

    static QueryVariant keyValueBoolQuery(String k, String v, QueryVariant query) {
        QueryVariant vQuery;
        if (StringUtils.isBlank((CharSequence)k) || query == null && StringUtils.isBlank((CharSequence)v)) {
            return QueryBuilders.matchAll().build();
        }
        MatchQuery kQuery = QueryBuilders.match().field("properties.k").query(b -> b.stringValue(ESUtils.getNestedKey(k))).operator(Operator.And).build();
        Object object = vQuery = query == null ? QueryBuilders.match().field(ESUtils.getValueFieldName(v)).query(b -> b.stringValue(v)).operator(Operator.And).build() : query;
        if ("*".equals(v) || query instanceof MatchAllQuery) {
            return QueryBuilders.bool().must(kQuery._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[0]).build();
        }
        return QueryBuilders.bool().must(kQuery._toQuery(), new co.elastic.clients.elasticsearch._types.query_dsl.Query[]{vQuery._toQuery()}).build();
    }

    static ObjectBuilder<?> nestedPropsQuery(QueryVariant query) {
        return QueryBuilders.nested().path(PROPS_FIELD).query(query._toQuery()).scoreMode(ChildScoreMode.Avg);
    }

    static String getNestedKey(String key) {
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)PROPS_PREFIX)) {
            return StringUtils.removeStart((String)key, (String)PROPS_PREFIX).replaceAll("\\[(\\d+)\\]", "-$1").replaceAll("\\.", "-");
        }
        return key;
    }

    static String getValueFieldName(String v) {
        return PROPS_PREFIX + (NumberUtils.isDigits((String)v) ? "vn" : "v");
    }

    static String getValueFieldNameFromRange(String from, String to) {
        if ("*".equals(from) && "*".equals(to) || NumberUtils.isDigits((String)from) || NumberUtils.isDigits((String)to)) {
            return "properties.vn";
        }
        return "properties.v";
    }

    static JsonData getNumericValue(String v) {
        return JsonData.of((Object)(NumberUtils.isDigits((String)v) ? Long.valueOf(NumberUtils.toLong((String)v, (long)0L)) : v));
    }

    static String getIndexName(String appid) {
        return appid.trim();
    }

    static String getIndexNameWithWildcard(String indexName) {
        return StringUtils.contains((CharSequence)indexName, (CharSequence)"_") ? indexName : indexName + "_*";
    }

    static RestClientBuilder.HttpClientConfigCallback getAWSRequestSigningInterceptor(String endpoint) {
        return httpClientBuilder -> {
            httpClientBuilder.addInterceptorLast((request, context) -> {
                Aws4Signer signer = Aws4Signer.create();
                AwsCredentials creds = DefaultCredentialsProvider.create().resolveCredentials();
                Aws4SignerParams.Builder signerParams = Aws4SignerParams.builder().awsCredentials(creds).doubleUrlEncode(Boolean.valueOf(true)).signingName("es").signingRegion(Region.of((String)Para.getConfig().elasticsearchAwsRegion()));
                String httpMethod = request.getRequestLine().getMethod();
                HashMap params = new HashMap();
                try {
                    Header[] body;
                    URIBuilder uriBuilder;
                    String resourcePath;
                    SdkHttpFullRequest.Builder r = SdkHttpFullRequest.builder();
                    if (!StringUtils.isBlank((CharSequence)httpMethod)) {
                        r.method(SdkHttpMethod.valueOf((String)httpMethod));
                    }
                    if (!StringUtils.isBlank((CharSequence)endpoint)) {
                        if (endpoint.startsWith("https://")) {
                            r.protocol("HTTPS");
                            r.host(StringUtils.removeStart((String)endpoint, (String)"https://"));
                        } else if (endpoint.startsWith("http://")) {
                            r.protocol("HTTP");
                            r.host(StringUtils.removeStart((String)endpoint, (String)"http://"));
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)(resourcePath = (uriBuilder = new URIBuilder(request.getRequestLine().getUri())).getPath()))) {
                        r.encodedPath(resourcePath);
                    }
                    for (NameValuePair param : uriBuilder.getQueryParams()) {
                        r.appendRawQueryParameter(param.getName(), param.getValue());
                    }
                    if (request instanceof HttpEntityEnclosingRequest && (body = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
                        InputStream is = body.getContent();
                        r.contentStreamProvider(() -> is);
                    }
                    if (r.contentStreamProvider() == null) {
                        request.removeHeaders("Content-Length");
                    }
                    for (Header header : request.getAllHeaders()) {
                        r.putHeader(header.getName(), header.getValue());
                    }
                    SdkHttpFullRequest signedReq = signer.sign(r.build(), signerParams.build());
                    for (String header : signedReq.headers().keySet()) {
                        request.setHeader(header, signedReq.firstMatchingHeader(header).orElse(""));
                    }
                }
                catch (Exception ex) {
                    logger.error("Failed to sign request to AWS Elasticsearch:", (Throwable)ex);
                }
            });
            return httpClientBuilder;
        };
    }

    static RestClientBuilder.HttpClientConfigCallback getAuthenticationCallback() {
        String basicAuthLogin = Para.getConfig().elasticsearchAuthUser();
        String basicAuthPassword = Para.getConfig().elasticsearchAuthPassword();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{basicAuthLogin, basicAuthPassword})) {
            return httpClientBuilder -> httpClientBuilder;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthLogin, basicAuthPassword));
        return arg_0 -> ESUtils.lambda$getAuthenticationCallback$98((CredentialsProvider)credentialsProvider, arg_0);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getAuthenticationCallback$98(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    static {
        IGNORED_FIELDS = new String[]{"settings", "datatypes", "deviceState", "deviceMetadata", "resourcePermissions", "validationConstraints"};
    }
}

