/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.search.os;

import com.erudika.para.core.Address;
import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Tag;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.search.os.OSUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchType;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.core.CountRequest;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.GeoDistanceQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.MoreLikeThisQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OS {
    private static final Logger logger = LoggerFactory.getLogger(OS.class);
    private static DAO dao;

    private OS() {
    }

    public static void setDao(DAO dao) {
        OS.dao = dao;
    }

    public static <P extends ParaObject> void indexAllInternal(String appid, List<P> objects) {
        if (StringUtils.isBlank((CharSequence)appid) || objects == null || objects.isEmpty()) {
            return;
        }
        try {
            OSUtils.executeRequests(objects.stream().filter(Objects::nonNull).map(obj -> new IndexRequest(OSUtils.getIndexName(appid)).id(obj.getId()).source(OSUtils.getSourceFromParaObject(obj))).collect(Collectors.toList()));
            logger.debug("Search.indexAll() {}", (Object)objects.size());
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
        }
    }

    public static <P extends ParaObject> void unindexAllInternal(String appid, List<P> objects) {
        if (StringUtils.isBlank((CharSequence)appid) || objects == null || objects.isEmpty()) {
            return;
        }
        try {
            OSUtils.executeRequests(objects.stream().filter(Objects::nonNull).map(obj -> new DeleteRequest(OSUtils.getIndexName(appid)).id(obj.getId())).collect(Collectors.toList()));
            logger.debug("Search.unindexAll() {}", (Object)objects.size());
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
        }
    }

    public static void unindexAllInternal(String appid, Map<String, ?> terms, boolean matchAll) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return;
        }
        try {
            long time = System.nanoTime();
            long unindexedCount = OSUtils.deleteByQuery(appid, (QueryBuilder)(terms == null || terms.isEmpty() ? QueryBuilders.matchAllQuery() : OSUtils.getTermsQuery(terms, matchAll)));
            time = System.nanoTime() - time;
            logger.info("Unindexed {} documents without failures, took {}s.", (Object)unindexedCount, (Object)TimeUnit.NANOSECONDS.toSeconds(time));
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
        }
    }

    public static <P extends ParaObject> P findByIdInternal(String appid, String id) {
        try {
            return OSUtils.getParaObjectFromSource(OS.getSource(appid, id));
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return null;
        }
    }

    public static <P extends ParaObject> List<P> findByIdsInternal(String appid, List<String> ids) {
        LinkedList list = new LinkedList();
        if (ids == null || ids.isEmpty()) {
            return list;
        }
        try {
            TermsQueryBuilder qb = QueryBuilders.termsQuery((String)"id", ids);
            return OS.searchQuery(appid, null, (QueryBuilder)qb, new Pager[0]);
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return list;
        }
    }

    public static <P extends ParaObject> List<P> findTermInListInternal(String appid, String type, String field, List<?> terms, Pager ... pager) {
        TermsQueryBuilder qb;
        if (StringUtils.isBlank((CharSequence)field) || terms == null) {
            return Collections.emptyList();
        }
        if (OSUtils.nestedMode() && field.startsWith("properties.")) {
            QueryBuilder bfb = null;
            BoolQueryBuilder fb = QueryBuilders.boolQuery();
            for (Object term : terms) {
                bfb = OSUtils.keyValueBoolQuery(field, String.valueOf(term));
                fb.should(bfb);
            }
            qb = OSUtils.nestedPropsQuery((QueryBuilder)(terms.size() > 1 ? fb : bfb));
        } else {
            qb = QueryBuilders.termsQuery((String)field, terms);
        }
        return OS.searchQuery(appid, type, (QueryBuilder)qb, pager);
    }

    public static <P extends ParaObject> List<P> findPrefixInternal(String appid, String type, String field, String prefix, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)prefix)) {
            return Collections.emptyList();
        }
        Object qb = OSUtils.nestedMode() && field.startsWith("properties.") ? OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(field, (QueryBuilder)QueryBuilders.prefixQuery((String)OSUtils.getValueFieldName(prefix), (String)prefix))) : QueryBuilders.prefixQuery((String)field, (String)prefix);
        return OS.searchQuery(appid, type, (QueryBuilder)qb, pager);
    }

    public static <P extends ParaObject> List<P> findQueryInternal(String appid, String type, String query, Pager ... pager) {
        QueryBuilder qb;
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyList();
        }
        if (OSUtils.nestedMode()) {
            qb = OSUtils.convertQueryStringToNestedQuery(query);
            if (qb == null) {
                return Collections.emptyList();
            }
        } else {
            qb = QueryBuilders.queryStringQuery((String)OSUtils.qs(query)).allowLeadingWildcard(Boolean.valueOf(false));
        }
        return OS.searchQuery(appid, type, qb, pager);
    }

    public static <P extends ParaObject> List<P> findNestedQueryInternal(String appid, String type, String field, String query, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)query) || StringUtils.isBlank((CharSequence)field)) {
            return Collections.emptyList();
        }
        String queryString = "nstd." + field + ":" + query;
        NestedQueryBuilder qb = QueryBuilders.nestedQuery((String)"nstd", (QueryBuilder)QueryBuilders.queryStringQuery((String)OSUtils.qs(queryString)), (ScoreMode)ScoreMode.Avg);
        return OS.searchQuery(appid, type, (QueryBuilder)qb, pager);
    }

    public static <P extends ParaObject> List<P> findWildcardInternal(String appid, String type, String field, String wildcard, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)wildcard)) {
            return Collections.emptyList();
        }
        Object qb = OSUtils.nestedMode() && field.startsWith("properties.") ? OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(field, (QueryBuilder)QueryBuilders.wildcardQuery((String)OSUtils.getValueFieldName(wildcard), (String)wildcard))) : QueryBuilders.wildcardQuery((String)field, (String)wildcard);
        return OS.searchQuery(appid, type, (QueryBuilder)qb, pager);
    }

    public static <P extends ParaObject> List<P> findTaggedInternal(String appid, String type, String[] tags, Pager ... pager) {
        if (tags == null || tags.length == 0 || StringUtils.isBlank((CharSequence)appid)) {
            return Collections.emptyList();
        }
        BoolQueryBuilder tagFilter = QueryBuilders.boolQuery();
        for (String tag : tags) {
            tagFilter.must((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)tag));
        }
        return OS.searchQuery(appid, type, (QueryBuilder)tagFilter, pager);
    }

    public static <P extends ParaObject> List<P> findTermsInternal(String appid, String type, Map<String, ?> terms, boolean mustMatchAll, Pager ... pager) {
        if (terms == null || terms.isEmpty()) {
            return Collections.emptyList();
        }
        QueryBuilder fb = OSUtils.getTermsQuery(terms, mustMatchAll);
        if (fb == null) {
            return Collections.emptyList();
        }
        return OS.searchQuery(appid, type, fb, pager);
    }

    public static <P extends ParaObject> List<P> findSimilarInternal(String appid, String type, String filterKey, String[] fields, String liketext, Pager ... pager) {
        MoreLikeThisQueryBuilder qb;
        if (StringUtils.isBlank((CharSequence)liketext)) {
            return Collections.emptyList();
        }
        String matchPercent = "70%";
        if (fields == null || fields.length == 0) {
            qb = QueryBuilders.moreLikeThisQuery((String[])new String[]{liketext}).minDocFreq(1).minTermFreq(1).minimumShouldMatch(matchPercent);
        } else {
            boolean containsNestedProps = Arrays.stream(fields).anyMatch(f -> StringUtils.startsWith((CharSequence)f, (CharSequence)"properties."));
            if (OSUtils.nestedMode() && containsNestedProps) {
                BoolQueryBuilder bqb = QueryBuilders.boolQuery();
                for (String field : fields) {
                    MatchQueryBuilder kQuery = QueryBuilders.matchQuery((String)"properties.k", (Object)OSUtils.getNestedKey(field));
                    MoreLikeThisQueryBuilder vQuery = QueryBuilders.moreLikeThisQuery((String[])new String[]{"properties.v"}, (String[])new String[]{liketext}, (MoreLikeThisQueryBuilder.Item[])MoreLikeThisQueryBuilder.Item.EMPTY_ARRAY).minDocFreq(1).minTermFreq(1).minimumShouldMatch(matchPercent);
                    bqb.should((QueryBuilder)OSUtils.nestedPropsQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)kQuery).must((QueryBuilder)vQuery)));
                }
                qb = bqb;
            } else {
                qb = QueryBuilders.moreLikeThisQuery((String[])fields, (String[])new String[]{liketext}, (MoreLikeThisQueryBuilder.Item[])MoreLikeThisQueryBuilder.Item.EMPTY_ARRAY).minDocFreq(1).minTermFreq(1).minimumShouldMatch(matchPercent);
            }
        }
        if (!StringUtils.isBlank((CharSequence)filterKey)) {
            qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)filterKey)).filter((QueryBuilder)qb);
        }
        return OS.searchQuery(appid, OS.searchQueryRaw(appid, type, (QueryBuilder)qb, pager));
    }

    public static <P extends ParaObject> List<P> findTagsInternal(String appid, String keyword, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return Collections.emptyList();
        }
        WildcardQueryBuilder qb = QueryBuilders.wildcardQuery((String)"tag", (String)keyword.concat("*"));
        return OS.searchQuery(appid, Utils.type(Tag.class), (QueryBuilder)qb, pager);
    }

    public static <P extends ParaObject> List<P> findNearbyInternal(String appid, String type, String query, int radius, double lat, double lng, Pager ... pager) {
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)appid)) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            query = "*";
        }
        Pager page = OSUtils.getPager(pager);
        GeoDistanceQueryBuilder qb1 = QueryBuilders.geoDistanceQuery((String)"latlng").point(lat, lng).distance((double)radius, DistanceUnit.KILOMETERS);
        SearchHits hits1 = OS.searchQueryRaw(appid, Utils.type(Address.class), (QueryBuilder)qb1, page);
        page.setLastKey(null);
        if (hits1 == null) {
            return Collections.emptyList();
        }
        if (type.equals(Utils.type(Address.class))) {
            return OS.searchQuery(appid, hits1);
        }
        String[] parentids = new String[hits1.getHits().length];
        for (int i = 0; i < hits1.getHits().length; ++i) {
            Object pid = hits1.getAt(i).getSourceAsMap().get("parentid");
            if (pid == null) continue;
            parentids[i] = (String)pid;
        }
        BoolQueryBuilder qb2 = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.queryStringQuery((String)OSUtils.qs(query))).filter((QueryBuilder)QueryBuilders.idsQuery().addIds(parentids));
        SearchHits hits2 = OS.searchQueryRaw(appid, type, (QueryBuilder)qb2, page);
        return OS.searchQuery(appid, hits2);
    }

    private static <P extends ParaObject> List<P> searchQuery(String appid, String type, QueryBuilder query, Pager ... pager) {
        return OS.searchQuery(appid, OS.searchQueryRaw(appid, type, query, pager));
    }

    protected static <P extends ParaObject> List<P> searchQuery(String appid, SearchHits hits) {
        if (hits == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>(hits.getHits().length);
        LinkedList<String> keys = new LinkedList<String>();
        boolean readFromIndex = Para.getConfig().readFromIndexEnabled();
        boolean cleanupIndex = Para.getConfig().syncIndexWithDatabaseEnabled();
        try {
            for (SearchHit hit : hits) {
                if (readFromIndex) {
                    Object pobj = OSUtils.getParaObjectFromSource(hit.getSourceAsMap());
                    results.add(pobj);
                } else {
                    keys.add(hit.getId());
                }
                logger.debug("Search result: appid={}, {}->{}", new Object[]{appid, hit.getSourceAsMap().get("appid"), hit.getId()});
            }
            if (!readFromIndex && !keys.isEmpty()) {
                ArrayList<ParaObject> objectsMissingFromDB = new ArrayList<ParaObject>(results.size());
                Map fromDB = dao.readAll(appid, keys, true);
                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String)keys.get(i);
                    Object pobj = (ParaObject)fromDB.get(key);
                    if (pobj == null && (pobj = OSUtils.getParaObjectFromSource(hits.getAt(i).getSourceAsMap())) != null && appid.equals(pobj.getAppid()) && pobj.getStored().booleanValue()) {
                        objectsMissingFromDB.add((ParaObject)pobj);
                    }
                    if (pobj == null) continue;
                    results.add(pobj);
                }
                if (!objectsMissingFromDB.isEmpty()) {
                    OS.handleMissingObjects(appid, objectsMissingFromDB, cleanupIndex);
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.warn("Search query failed for app '{}': {}", (Object)appid, (Object)msg);
        }
        return results;
    }

    private static <P extends ParaObject> void handleMissingObjects(String appid, List<P> objectsMissingFromDB, boolean cleanupIndex) {
        if (cleanupIndex) {
            OS.unindexAllInternal(appid, objectsMissingFromDB);
            logger.debug("Removed {} objects from index in app '{}' that were not found in database: {}.", new Object[]{objectsMissingFromDB.size(), appid, objectsMissingFromDB.stream().map(o -> o.getId()).collect(Collectors.toList())});
        } else {
            logger.warn("Found {} objects in app '{}' that are still indexed but deleted from the database: {}. Sometimes this happens if you do a search right after a delete operation.", new Object[]{objectsMissingFromDB.size(), appid, objectsMissingFromDB});
        }
    }

    protected static SearchHits searchQueryRaw(String appid, String type, QueryBuilder query, Pager ... pager) {
        int start;
        if (StringUtils.isBlank((CharSequence)appid)) {
            return null;
        }
        Pager page = OSUtils.getPager(pager);
        SortOrder order = page.isDesc() ? SortOrder.DESC : SortOrder.ASC;
        int max = page.getLimit();
        int pageNum = (int)page.getPage();
        int n = start = pageNum < 1 || pageNum > Para.getConfig().maxPages() ? 0 : (pageNum - 1) * max;
        if (query == null) {
            query = QueryBuilders.matchAllQuery();
        }
        if (!StringUtils.isBlank((CharSequence)type)) {
            query = QueryBuilders.boolQuery().must(query).must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)type));
        }
        SearchHits hits = null;
        String debugQuery = "";
        try {
            Object id;
            SearchRequest search = new SearchRequest(new String[]{OSUtils.getIndexName(appid)}).searchType(SearchType.DFS_QUERY_THEN_FETCH).source(OSUtils.getSourceBuilder(query, max));
            if (pageNum <= 1 && !StringUtils.isBlank((CharSequence)page.getLastKey())) {
                search.source().searchAfter(new Object[]{NumberUtils.toLong((String)page.getLastKey())});
                search.source().from(0);
                search.source().sort(SortBuilders.fieldSort((String)"_docid").order(order));
            } else {
                search.source().from(start);
                for (SortBuilder<?> sortField : OSUtils.getSortFieldsFromPager(page)) {
                    search.source().sort(sortField);
                }
            }
            debugQuery = search.toString();
            logger.debug("Elasticsearch query: {}", (Object)debugQuery);
            hits = OSUtils.getRESTClient().search(search, RequestOptions.DEFAULT).getHits();
            page.setCount(hits.getTotalHits().value);
            if (hits.getHits().length > 0 && (id = hits.getAt(hits.getHits().length - 1).getSourceAsMap().get("_docid")) != null) {
                page.setLastKey(id.toString());
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.debug("No search results for type '{}' in app '{}': {}.\nQuery: {}", new Object[]{type, appid, msg, debugQuery});
        }
        return hits;
    }

    protected static Map<String, Object> getSource(String appid, String key) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)appid)) {
            return map;
        }
        try {
            GetRequest get = ((GetRequest)new GetRequest().index(OSUtils.getIndexName(appid))).id(key);
            GetResponse gres = OSUtils.getRESTClient().get(get, RequestOptions.DEFAULT);
            if (gres.isExists()) {
                map = gres.getSource();
            }
        }
        catch (IndexNotFoundException ex) {
            logger.warn("Index not created yet. Call '_setup' first.");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.warn("Could not get any data from index '{}': {}", (Object)appid, (Object)msg);
        }
        return map;
    }

    public static Long getCountInternal(String appid, String type) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return 0L;
        }
        Object query = !StringUtils.isBlank((CharSequence)type) ? QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)type)) : QueryBuilders.matchAllQuery();
        Long count = 0L;
        try {
            CountRequest cr = new CountRequest(new String[]{OSUtils.getIndexName(appid)}).query((QueryBuilder)query);
            count = OSUtils.getRESTClient().count(cr, RequestOptions.DEFAULT).getCount();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause != null ? cause.getMessage() : e.getMessage();
            logger.warn("Could not count results in index '{}': {}", (Object)appid, (Object)msg);
        }
        return count;
    }

    public static Long getCountInternal(String appid, String type, Map<String, ?> terms) {
        if (StringUtils.isBlank((CharSequence)appid) || terms == null || terms.isEmpty()) {
            return 0L;
        }
        Long count = 0L;
        QueryBuilder query = OSUtils.getTermsQuery(terms, true);
        if (query != null) {
            if (!StringUtils.isBlank((CharSequence)type)) {
                query = QueryBuilders.boolQuery().must(query).must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)type));
            }
            try {
                CountRequest cr = new CountRequest(new String[]{OSUtils.getIndexName(appid)}).query(query);
                count = OSUtils.getRESTClient().count(cr, RequestOptions.DEFAULT).getCount();
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                String msg = cause != null ? cause.getMessage() : e.getMessage();
                logger.warn("Could not count results in index '{}': {}", (Object)appid, (Object)msg);
            }
        }
        return count;
    }

    public boolean rebuildIndex(DAO dao, App app, Pager ... pager) {
        return OSUtils.rebuildIndex(dao, app, null, pager);
    }

    public boolean rebuildIndex(DAO dao, App app, String destinationIndex, Pager ... pager) {
        return OSUtils.rebuildIndex(dao, app, destinationIndex, pager);
    }
}

