/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.search.os;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.listeners.DestroyListener;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeUnit;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.FuzzyQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.PrefixQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public final class OSUtils {
    private static final Logger logger = LoggerFactory.getLogger(OSUtils.class);
    private static RestHighLevelClient restClient;
    private static BulkProcessor bulkProcessor;
    private static ActionListener<BulkResponse> syncListener;
    private static final int MAX_QUERY_DEPTH = 10;
    private static final String DATE_FORMAT = "epoch_millis||epoch_second||yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||yyyy/MM/dd||yyyyMMdd||yyyy";
    static final String PROPS_FIELD = "properties";
    static final String PROPS_PREFIX = "properties.";
    static final String PROPS_JSON = "_properties";
    static final String PROPS_REGEX = "(^|.*\\W)properties[\\.\\:].+";
    private static final String[] IGNORED_FIELDS;

    static boolean nestedMode() {
        return Para.getConfig().elasticsearchNestedModeEnabled();
    }

    static boolean asyncEnabled() {
        return Para.getConfig().elasticsearchAsyncModeEnabled();
    }

    static boolean flushImmediately() {
        return Para.getConfig().elasticsearchBulkFlushEnabled();
    }

    public static String getDefaultMapping() {
        return "{\n  \"properties\": {\n    \"nstd\": {\"type\": \"nested\"},\n    \"properties\": {\"type\": \"" + (OSUtils.nestedMode() ? "nested" : "object") + "\"},\n    \"latlng\": {\"type\": \"geo_point\"},\n    \"_docid\": {\"type\": \"long\", \"index\": false},\n    \"updated\": {\"type\": \"date\", \"format\" : \"epoch_millis||epoch_second||yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||yyyy/MM/dd||yyyyMMdd||yyyy\"},\n    \"timestamp\": {\"type\": \"date\", \"format\" : \"epoch_millis||epoch_second||yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||yyyy/MM/dd||yyyyMMdd||yyyy\"},\n    \"tag\": {\"type\": \"keyword\"},\n    \"id\": {\"type\": \"keyword\"},\n    \"key\": {\"type\": \"keyword\"},\n    \"name\": {\"type\": \"keyword\"},\n    \"type\": {\"type\": \"keyword\"},\n    \"tags\": {\"type\": \"keyword\"},\n    \"token\": {\"type\": \"keyword\"},\n    \"email\": {\"type\": \"keyword\"},\n    \"appid\": {\"type\": \"keyword\"},\n    \"groups\": {\"type\": \"keyword\"},\n    \"password\": {\"type\": \"keyword\"},\n    \"parentid\": {\"type\": \"keyword\"},\n    \"creatorid\": {\"type\": \"keyword\"},\n    \"identifier\": {\"type\": \"keyword\"}\n  }\n}";
    }

    private OSUtils() {
    }

    static void initClient() {
        OSUtils.getRESTClient();
    }

    public static RestHighLevelClient getRESTClient() {
        if (restClient != null) {
            return restClient;
        }
        String esScheme = Para.getConfig().elasticsearchRestClientScheme();
        String esHost = Para.getConfig().elasticsearchRestClientHost();
        int esPort = Para.getConfig().elasticsearchRestClientPort();
        boolean signRequests = Para.getConfig().elasticsearchSignRequestsForAwsEnabled();
        HttpHost host = new HttpHost(esHost, esPort, esScheme);
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{host});
        String esPrefix = Para.getConfig().elasticsearchRestClientContextPath();
        if (StringUtils.isNotEmpty((CharSequence)esPrefix)) {
            clientBuilder.setPathPrefix(esPrefix);
        }
        ArrayList<RestClientBuilder.HttpClientConfigCallback> configurationCallbacks = new ArrayList<RestClientBuilder.HttpClientConfigCallback>();
        if (signRequests) {
            configurationCallbacks.add(OSUtils.getAWSRequestSigningInterceptor(host.getSchemeName() + "://" + host.getHostName()));
        }
        configurationCallbacks.add(OSUtils.getAuthenticationCallback());
        clientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            configurationCallbacks.forEach(c -> c.customizeHttpClient(httpClientBuilder));
            return httpClientBuilder;
        });
        restClient = new RestHighLevelClient(clientBuilder);
        Para.addDestroyListener((DestroyListener)new DestroyListener(){

            public void onDestroy() {
                OSUtils.shutdownClient();
            }
        });
        if (!OSUtils.existsIndex(Para.getConfig().getRootAppIdentifier())) {
            OSUtils.createIndex(Para.getConfig().getRootAppIdentifier());
        }
        return restClient;
    }

    protected static void shutdownClient() {
        if (restClient != null) {
            try {
                restClient.close();
            }
            catch (IOException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        if (bulkProcessor != null) {
            boolean closed = false;
            try {
                closed = bulkProcessor.awaitClose(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ex) {
                logger.warn("Interrupted waiting for BulkProcessor to close.", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
            finally {
                if (!closed) {
                    bulkProcessor.close();
                }
                bulkProcessor = null;
            }
        }
    }

    private static boolean createIndexWithoutAlias(String name, int shards, int replicas) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.containsWhitespace((CharSequence)name) || OSUtils.existsIndex(name)) {
            return false;
        }
        if (shards <= 0) {
            shards = Para.getConfig().elasticsearchRootIndexShards();
        }
        if (replicas < 0) {
            replicas = Para.getConfig().elasticsearchRootIndexReplicas();
        }
        try {
            Settings.Builder settings = Settings.builder();
            settings.put("number_of_shards", Integer.toString(shards));
            settings.put("number_of_replicas", Integer.toString(replicas));
            settings.put("auto_expand_replicas", Para.getConfig().elasticsearchAutoExpandReplicas());
            settings.put("analysis.analyzer.default.type", "standard");
            settings.putList("analysis.analyzer.default.stopwords", new String[]{"arabic", "armenian", "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "english", "finnish", "french", "galician", "german", "greek", "hindi", "hungarian", "indonesian", "italian", "norwegian", "persian", "portuguese", "romanian", "russian", "spanish", "swedish", "turkish"});
            CreateIndexRequest create = new CreateIndexRequest(name).settings(settings.build()).mapping(OSUtils.getDefaultMapping(), XContentType.JSON);
            OSUtils.getRESTClient().indices().create(create, RequestOptions.DEFAULT);
            logger.info("Created a new index '{}' with {} shards, {} replicas.", new Object[]{name, shards, replicas});
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean createIndex(String appid) {
        return OSUtils.createIndex(appid, Para.getConfig().elasticsearchRootIndexShards(), Para.getConfig().elasticsearchRootIndexReplicas());
    }

    public static boolean createIndex(String appid, int shards, int replicas) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        String indexName = appid.trim() + "_1";
        boolean created = OSUtils.createIndexWithoutAlias(indexName, shards, replicas);
        if (created) {
            boolean withAliasRouting = App.isRoot((String)appid) && Para.getConfig().elasticsearchRootIndexSharingEnabled();
            boolean aliased = OSUtils.addIndexAlias(indexName, appid, withAliasRouting);
            if (!aliased) {
                logger.info("Created ES index '{}' without an alias '{}'.", (Object)indexName, (Object)appid);
            } else {
                logger.info("Created ES index '{}' with alias '{}'.", (Object)indexName, (Object)appid);
            }
        }
        return created;
    }

    public static boolean deleteIndex(String appid) {
        if (StringUtils.isBlank((CharSequence)appid) || !OSUtils.existsIndex(appid)) {
            return false;
        }
        try {
            String indexName = OSUtils.getIndexNameForAlias(appid.trim());
            DeleteIndexRequest delete = new DeleteIndexRequest(indexName);
            OSUtils.getRESTClient().indices().delete(delete, RequestOptions.DEFAULT);
            logger.info("Deleted ES index '{}'.", (Object)indexName);
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean existsIndex(String appid) {
        boolean exists;
        if (StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        try {
            String indexName = appid.trim();
            GetIndexRequest get = new GetIndexRequest(new String[]{indexName});
            exists = OSUtils.getRESTClient().indices().exists(get, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            exists = false;
        }
        return exists;
    }

    public static boolean rebuildIndex(DAO dao, App app, String destinationIndex, Pager ... pager) {
        Objects.requireNonNull(dao, "DAO object cannot be null!");
        Objects.requireNonNull(app, "App object cannot be null!");
        if (StringUtils.isBlank((CharSequence)app.getAppIdentifier())) {
            return false;
        }
        try {
            List list;
            String indexName = app.getAppIdentifier().trim();
            if (!OSUtils.existsIndex(indexName)) {
                if (app.isSharingIndex()) {
                    OSUtils.addIndexAliasWithRouting(OSUtils.getIndexName(Para.getConfig().getRootAppIdentifier()), app.getAppIdentifier());
                } else {
                    logger.info("Creating '{}' index because it doesn't exist.", (Object)indexName);
                    OSUtils.createIndex(indexName);
                }
            }
            String oldName = OSUtils.getIndexNameForAlias(indexName);
            String newName = indexName;
            if (!app.isSharingIndex()) {
                if (StringUtils.isBlank((CharSequence)destinationIndex)) {
                    newName = OSUtils.getNewIndexName(indexName, oldName);
                    OSUtils.createIndexWithoutAlias(newName, -1, -1);
                } else {
                    newName = destinationIndex;
                }
            }
            LinkedList batch = new LinkedList();
            Pager p = OSUtils.getPager(pager);
            int batchSize = Para.getConfig().reindexBatchSize(p.getLimit());
            long reindexedCount = 0L;
            do {
                list = dao.readPage(app.getAppIdentifier(), p);
                logger.debug("rebuildIndex(): Read {} objects from table {}.", (Object)list.size(), (Object)indexName);
                for (ParaObject obj : list) {
                    if (obj == null) continue;
                    batch.add((DocWriteRequest<?>)new IndexRequest(newName).id(obj.getId()).source(OSUtils.getSourceFromParaObject(obj)));
                    if (batch.size() < batchSize) continue;
                    reindexedCount += (long)batch.size();
                    OSUtils.executeRequests(batch);
                    logger.debug("rebuildIndex(): indexed {}", (Object)batch.size());
                    batch.clear();
                }
            } while (!list.isEmpty());
            if (batch.size() > 0) {
                reindexedCount += (long)batch.size();
                OSUtils.executeRequests(batch);
                logger.debug("rebuildIndex(): indexed {}", (Object)batch.size());
            }
            if (!app.isSharingIndex()) {
                OSUtils.switchIndexToAlias(oldName, newName, indexName, true);
            }
            logger.info("rebuildIndex(): {} objects reindexed in '{}' [shared: {}].", new Object[]{reindexedCount, indexName, app.isSharingIndex()});
        }
        catch (Exception e) {
            logger.warn(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static void refreshIndex(String appid) throws IOException {
        if (!StringUtils.isBlank((CharSequence)appid)) {
            if (OSUtils.asyncEnabled()) {
                OSUtils.bulkProcessor(OSUtils.getRESTClient()).flush();
            }
            OSUtils.getRESTClient().indices().refresh(new RefreshRequest(new String[]{OSUtils.getIndexName(appid)}), RequestOptions.DEFAULT);
        }
    }

    public static long deleteByQuery(final String appid, QueryBuilder fb) {
        return OSUtils.deleteByQuery(appid, fb, OSUtils.asyncEnabled() ? new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse res) {
                logger.debug(res.getStatus().toString());
            }

            public void onFailure(Exception ex) {
                logger.error("Delete by query reqest failed for app '" + appid + "'", (Throwable)ex);
            }
        } : null);
    }

    public static long deleteByQuery(String appid, QueryBuilder fb, ActionListener<BulkByScrollResponse> cb) {
        int batchSize = 1000;
        boolean isSharingIndex = !App.isRoot((String)appid) && StringUtils.startsWith((CharSequence)appid, (CharSequence)" ");
        String indexName = OSUtils.getIndexName(appid);
        DeleteByQueryRequest deleteByQueryReq = new DeleteByQueryRequest(new String[]{indexName});
        deleteByQueryReq.setConflicts("proceed");
        deleteByQueryReq.setQuery(fb);
        deleteByQueryReq.setBatchSize(batchSize);
        deleteByQueryReq.setSlices(1);
        deleteByQueryReq.setScroll(TimeValue.timeValueMinutes((long)10L));
        deleteByQueryReq.setRefresh(true);
        if (isSharingIndex) {
            deleteByQueryReq.setRouting(indexName);
        }
        if (cb != null) {
            OSUtils.getRESTClient().deleteByQueryAsync(deleteByQueryReq, RequestOptions.DEFAULT, cb);
        } else {
            try {
                BulkByScrollResponse res = OSUtils.getRESTClient().deleteByQuery(deleteByQueryReq, RequestOptions.DEFAULT);
                if (!res.getBulkFailures().isEmpty()) {
                    logger.warn("Bulk failure in deleteByQuery()!", (Throwable)((BulkItemResponse.Failure)res.getBulkFailures().iterator().next()).getCause());
                }
                if (!res.getSearchFailures().isEmpty()) {
                    logger.warn("Search failure in deleteByQuery()!", ((ScrollableHitSource.SearchFailure)res.getSearchFailures().iterator().next()).getReason());
                }
                return res.getTotal();
            }
            catch (IOException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return 0L;
    }

    protected static Pager getPager(Pager[] pager) {
        return pager != null && pager.length > 0 ? pager[0] : new Pager();
    }

    protected static List<SortBuilder<?>> getSortFieldsFromPager(Pager pager) {
        SortOrder defaultOrder;
        if (pager == null) {
            pager = new Pager();
        }
        SortOrder sortOrder = defaultOrder = pager.isDesc() ? SortOrder.DESC : SortOrder.ASC;
        if (pager.getSortby().contains(",")) {
            String[] fields = pager.getSortby().split(",");
            ArrayList sortFields = new ArrayList(fields.length);
            for (String field : fields) {
                String fieldName;
                SortOrder order;
                if (field.endsWith(":asc")) {
                    order = SortOrder.ASC;
                    fieldName = field.substring(0, field.indexOf(":asc")).trim();
                } else if (field.endsWith(":desc")) {
                    order = SortOrder.DESC;
                    fieldName = field.substring(0, field.indexOf(":desc")).trim();
                } else {
                    order = defaultOrder;
                    fieldName = field.trim();
                }
                if (OSUtils.nestedMode() && fieldName.startsWith(PROPS_PREFIX)) {
                    sortFields.add((SortBuilder<?>)OSUtils.getNestedFieldSort(fieldName, order));
                    continue;
                }
                sortFields.add(SortBuilders.fieldSort((String)fieldName).order(order));
            }
            return sortFields;
        }
        if (StringUtils.isBlank((CharSequence)pager.getSortby())) {
            return Collections.singletonList(SortBuilders.scoreSort());
        }
        String fieldName = pager.getSortby();
        if (OSUtils.nestedMode() && fieldName.startsWith(PROPS_PREFIX)) {
            return Collections.singletonList(OSUtils.getNestedFieldSort(fieldName, defaultOrder));
        }
        return Collections.singletonList(SortBuilders.fieldSort((String)fieldName).order(defaultOrder));
    }

    private static FieldSortBuilder getNestedFieldSort(String fieldName, SortOrder order) {
        return ((FieldSortBuilder)SortBuilders.fieldSort((String)"properties.vn").order(order)).setNestedSort(new NestedSortBuilder(PROPS_FIELD).setFilter((QueryBuilder)QueryBuilders.termQuery((String)"properties.k", (String)StringUtils.removeStart((String)fieldName, (String)PROPS_PREFIX))));
    }

    public static boolean addIndexAliasWithRouting(String indexName, String aliasName) {
        return OSUtils.addIndexAlias(indexName, aliasName, true);
    }

    public static boolean addIndexAlias(String indexName, String aliasName, boolean withAliasRouting) {
        if (StringUtils.isBlank((CharSequence)aliasName) || !OSUtils.existsIndex(indexName)) {
            return false;
        }
        try {
            String alias = aliasName.trim();
            String index = OSUtils.getIndexNameWithWildcard(indexName.trim());
            IndicesAliasesRequest.AliasActions addAction = withAliasRouting ? IndicesAliasesRequest.AliasActions.add().index(index).alias(alias).searchRouting(alias).indexRouting(alias).filter((QueryBuilder)QueryBuilders.termQuery((String)"appid", (String)aliasName)) : IndicesAliasesRequest.AliasActions.add().index(index).alias(alias);
            IndicesAliasesRequest actions = new IndicesAliasesRequest().addAliasAction(addAction);
            return OSUtils.getRESTClient().indices().updateAliases(actions, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
    }

    public static boolean removeIndexAlias(String indexName, String aliasName) {
        if (StringUtils.isBlank((CharSequence)aliasName) || !OSUtils.existsIndex(indexName)) {
            return false;
        }
        String alias = aliasName.trim();
        try {
            String index = OSUtils.getIndexNameWithWildcard(indexName.trim());
            IndicesAliasesRequest.AliasActions removeAction = IndicesAliasesRequest.AliasActions.remove().index(index).alias(alias);
            IndicesAliasesRequest actions = new IndicesAliasesRequest().addAliasAction(removeAction);
            return OSUtils.getRESTClient().indices().updateAliases(actions, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (Exception e) {
            logger.warn("Failed to remove index alias '" + alias + "' for index " + indexName + ": {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean existsIndexAlias(String indexName, String aliasName) {
        if (StringUtils.isBlank((CharSequence)indexName) || StringUtils.isBlank((CharSequence)aliasName)) {
            return false;
        }
        try {
            String alias = aliasName.trim();
            String index = OSUtils.getIndexNameWithWildcard(indexName.trim());
            GetAliasesRequest getAlias = new GetAliasesRequest().indices(new String[]{index}).aliases(new String[]{alias});
            return OSUtils.getRESTClient().indices().existsAlias(getAlias, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
    }

    public static void switchIndexToAlias(String oldIndex, String newIndex, String alias, boolean deleteOld) {
        if (StringUtils.isBlank((CharSequence)oldIndex) || StringUtils.isBlank((CharSequence)newIndex) || StringUtils.isBlank((CharSequence)alias)) {
            return;
        }
        try {
            String aliaz = alias.trim();
            String oldName = oldIndex.trim();
            String newName = newIndex.trim();
            logger.info("Switching index aliases {}->{}, deleting '{}': {}", new Object[]{aliaz, newIndex, oldIndex, deleteOld});
            IndicesAliasesRequest.AliasActions removeAction = IndicesAliasesRequest.AliasActions.remove().index(oldName).alias(aliaz);
            IndicesAliasesRequest.AliasActions addAction = IndicesAliasesRequest.AliasActions.add().index(newName).alias(aliaz);
            IndicesAliasesRequest actions = new IndicesAliasesRequest().addAliasAction(removeAction).addAliasAction(addAction);
            OSUtils.getRESTClient().indices().updateAliases(actions, RequestOptions.DEFAULT);
            if (deleteOld) {
                OSUtils.deleteIndex(oldName);
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
    }

    public static String getIndexNameForAlias(String appid) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return appid;
        }
        try {
            Map aliases = OSUtils.getRESTClient().indices().getAlias(new GetAliasesRequest().indices(new String[]{appid}), RequestOptions.DEFAULT).getAliases();
            if (!aliases.isEmpty()) {
                return (String)aliases.keySet().iterator().next();
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        return appid;
    }

    static String getNewIndexName(String appid, String oldName) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return appid;
        }
        return (oldName.contains("_") ? oldName.substring(0, oldName.indexOf(95)) : appid) + "_" + Utils.timestamp();
    }

    public static void executeRequests(List<DocWriteRequest<?>> requests) {
        if (requests == null || requests.isEmpty()) {
            return;
        }
        ActionListener<BulkResponse> listener = OSUtils.getSyncRequestListener();
        try {
            if (OSUtils.asyncEnabled()) {
                BulkProcessor bp = OSUtils.bulkProcessor(OSUtils.getRESTClient());
                requests.forEach(arg_0 -> ((BulkProcessor)bp).add(arg_0));
                if (OSUtils.flushImmediately()) {
                    bp.flush();
                }
            } else {
                BulkRequest bulk = new BulkRequest();
                requests.forEach(arg_0 -> ((BulkRequest)bulk).add(arg_0));
                listener.onResponse((Object)OSUtils.getRESTClient().bulk(bulk, RequestOptions.DEFAULT));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static BulkProcessor bulkProcessor(RestHighLevelClient client) {
        if (bulkProcessor == null) {
            bulkProcessor = OSUtils.configureBulkProcessor(BulkProcessor.builder((request, bulkListener) -> client.bulkAsync(request, RequestOptions.DEFAULT, bulkListener), (BulkProcessor.Listener)OSUtils.getAsyncRequestListener()));
        }
        return bulkProcessor;
    }

    private static BulkProcessor configureBulkProcessor(BulkProcessor.Builder builder) {
        int sizeLimit = Para.getConfig().elasticsearchBulkSizeLimitMb();
        int actionLimit = Para.getConfig().elasticsearchBulkActionLimit();
        int concurrentRequests = Para.getConfig().elasticsearchBulkConcurrentRequests();
        int flushInterval = Para.getConfig().elasticsearchBulkFlushIntervalSec();
        int backoffInitialDelayMs = Para.getConfig().elasticsearchBulkBackoffDelayMs();
        int backoffNumRetries = Para.getConfig().elasticsearchBulkBackoffRetries();
        builder.setBulkSize(new ByteSizeValue((long)sizeLimit, ByteSizeUnit.MB));
        builder.setBulkActions(actionLimit);
        builder.setConcurrentRequests(concurrentRequests);
        if (flushInterval > 0) {
            builder.setFlushInterval(TimeValue.timeValueMillis((long)flushInterval));
        }
        if (backoffNumRetries > 0) {
            builder.setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)backoffInitialDelayMs), (int)backoffNumRetries));
        } else {
            builder.setBackoffPolicy(BackoffPolicy.noBackoff());
        }
        return builder.build();
    }

    private static BulkProcessor.Listener getAsyncRequestListener() {
        return new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response != null && response.hasFailures()) {
                    Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).forEach(item -> logger.error("Failed to execute async {} operation for index '{}', document id '{}': {}", new Object[]{item.getOpType(), item.getIndex(), item.getId(), item.getFailure().getMessage()}));
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable throwable) {
                logger.error("Asynchronous indexing operation failed.", throwable);
            }
        };
    }

    private static ActionListener<BulkResponse> getSyncRequestListener() {
        if (syncListener != null) {
            return syncListener;
        }
        syncListener = new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse response) {
                if (response != null && response.hasFailures()) {
                    Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).forEach(item -> logger.error("Failed to execute {} operation for index '{}', document id '{}': {}", new Object[]{item.getOpType(), item.getIndex(), item.getId(), item.getFailure().getMessage()}));
                    OSUtils.handleFailedRequests(Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).map(BulkItemResponse::getFailure).map(BulkItemResponse.Failure::getCause).filter(Objects::nonNull).findFirst().orElse(null));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Synchronous indexing operation failed!", (Throwable)e);
                OSUtils.handleFailedRequests(e);
            }
        };
        return syncListener;
    }

    private static void handleFailedRequests(Throwable t) {
        if (t != null && Para.getConfig().exceptionOnWriteErrorsEnabled()) {
            throw new RuntimeException("Synchronous indexing operation failed!", t);
        }
    }

    public static boolean isClusterOK() {
        try {
            ClusterHealthStatus status = OSUtils.getRESTClient().cluster().health(new ClusterHealthRequest(), RequestOptions.DEFAULT).getStatus();
            return !ClusterHealthStatus.RED.equals((Object)status);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
    }

    static QueryBuilder getTermsQuery(Map<String, ?> terms, boolean mustMatchAll) {
        BoolQueryBuilder fb = QueryBuilders.boolQuery();
        int addedTerms = 0;
        boolean noop = true;
        Object bfb = null;
        for (Map.Entry<String, ?> term : terms.entrySet()) {
            String stringValue;
            Object val = term.getValue();
            if (StringUtils.isBlank((CharSequence)term.getKey()) || val == null || !Utils.isBasicType(val.getClass()) || StringUtils.isBlank((CharSequence)(stringValue = val.toString()))) continue;
            Matcher matcher = Pattern.compile(".*(<|>|<=|>=)$").matcher(term.getKey().trim());
            bfb = matcher.matches() ? OSUtils.range(matcher.group(1), term.getKey(), stringValue) : (OSUtils.nestedMode() ? OSUtils.term((Query)new TermQuery(new Term(term.getKey(), stringValue))) : QueryBuilders.termQuery((String)term.getKey(), (String)stringValue));
            if (mustMatchAll) {
                fb.must((QueryBuilder)bfb);
            } else {
                fb.should((QueryBuilder)bfb);
            }
            ++addedTerms;
            noop = false;
        }
        if (addedTerms == 1 && bfb != null) {
            return bfb;
        }
        return noop ? null : fb;
    }

    static String qs(String query) {
        if (StringUtils.isBlank((CharSequence)query) || "*".equals(query.trim())) {
            return "*";
        }
        if ((query = query.trim()).length() > 1 && query.startsWith("*")) {
            query = query.substring(1);
        }
        try {
            StandardQueryParser parser = new StandardQueryParser();
            parser.setAllowLeadingWildcard(false);
            parser.parse(query, "");
        }
        catch (Exception ex) {
            logger.warn("Failed to parse query string '{}'.", (Object)query);
            query = "*";
        }
        return query.trim();
    }

    static Query qsParsed(String query) {
        if (StringUtils.isBlank((CharSequence)query) || "*".equals(query.trim())) {
            return null;
        }
        try {
            StandardQueryParser parser = new StandardQueryParser();
            parser.setAllowLeadingWildcard(false);
            return parser.parse(query, "");
        }
        catch (Exception ex) {
            logger.warn("Failed to parse query string '{}'.", (Object)query);
            return null;
        }
    }

    public static boolean isValidQueryString(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return false;
        }
        if ("*".equals(query.trim())) {
            return true;
        }
        try {
            StandardQueryParser parser = new StandardQueryParser();
            parser.setAllowLeadingWildcard(false);
            parser.parse(query, "");
            return true;
        }
        catch (QueryNodeException ex) {
            return false;
        }
    }

    public static Map<String, Object> getSourceFromParaObject(ParaObject po) {
        if (po == null) {
            return Collections.emptyMap();
        }
        Map data = ParaObjectUtils.getAnnotatedFields((ParaObject)po, null, (boolean)false);
        HashMap<String, Object> source = new HashMap<String, Object>(data.size() + 1);
        source.putAll(data);
        if (OSUtils.nestedMode() && po instanceof Sysprop) {
            try {
                Map props = (Map)data.get(PROPS_FIELD);
                List<Map<String, Object>> keysAndValues = OSUtils.getNestedProperties(props);
                source.put(PROPS_FIELD, keysAndValues);
                source.put(PROPS_JSON, ParaObjectUtils.getJsonWriterNoIdent().writeValueAsString((Object)props));
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
        for (String field : IGNORED_FIELDS) {
            source.remove(field);
        }
        source.put("_docid", NumberUtils.toLong((String)Utils.getNewId()));
        return source;
    }

    static SearchSourceBuilder getSourceBuilder(QueryBuilder query, int max) {
        String trackTotalHits = Para.getConfig().elasticsearchTrackTotalHits();
        SearchSourceBuilder source = new SearchSourceBuilder().query(query).size(max);
        if (NumberUtils.isDigits((String)trackTotalHits)) {
            source.trackTotalHitsUpTo(NumberUtils.toInt((String)trackTotalHits, (int)10000));
        } else if (Boolean.valueOf(trackTotalHits).booleanValue()) {
            source.trackTotalHits(true);
        }
        return source;
    }

    private static List<Map<String, Object>> getNestedProperties(Map<String, Object> objectData) {
        if (objectData == null || objectData.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Map<String, Object>> keysAndValues = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> stack = new LinkedList<Map<String, Object>>();
        stack.add(Collections.singletonMap("", objectData));
        while (!stack.isEmpty()) {
            String prefix;
            Map singletonMap = (Map)stack.pop();
            Object value = singletonMap.get(prefix = (String)singletonMap.keySet().iterator().next());
            if (value == null) continue;
            if (value instanceof Map) {
                Object pre = StringUtils.isBlank((CharSequence)prefix) ? "" : prefix + "-";
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    OSUtils.addFieldToStack((String)pre + (String)entry.getKey(), entry.getValue(), stack, keysAndValues);
                }
                continue;
            }
            OSUtils.addFieldToStack(prefix, value, stack, keysAndValues);
        }
        return keysAndValues;
    }

    private static void addFieldToStack(String prefix, Object val, LinkedList<Map<String, Object>> stack, List<Map<String, Object>> keysAndValues) {
        if (val instanceof Map) {
            stack.push(Collections.singletonMap(prefix, val));
        } else if (val instanceof List) {
            for (int i = 0; i < ((List)val).size(); ++i) {
                stack.push(Collections.singletonMap(prefix + "-" + String.valueOf(i), ((List)val).get(i)));
            }
        } else {
            keysAndValues.add(OSUtils.getKeyValueField(prefix, val));
        }
    }

    private static Map<String, Object> getKeyValueField(String field, Object value) {
        HashMap<String, Object> propMap = new HashMap<String, Object>(2);
        propMap.put("k", field);
        if (value instanceof Number) {
            propMap.put("vn", value);
        } else {
            propMap.put("v", String.valueOf(value));
        }
        return propMap;
    }

    static <P extends ParaObject> P getParaObjectFromSource(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(source.size());
        data.putAll(source);
        if (OSUtils.nestedMode() && data.containsKey(PROPS_JSON)) {
            try {
                Map props = (Map)ParaObjectUtils.getJsonReader(Map.class).readValue((String)data.get(PROPS_JSON));
                data.put(PROPS_FIELD, props);
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
            data.remove(PROPS_JSON);
        }
        data.remove("_docid");
        return (P)ParaObjectUtils.setAnnotatedFields(data);
    }

    static QueryBuilder range(String operator, String field, String stringValue) {
        Objects.requireNonNull(field);
        String key = field.replaceAll("[<>=\\s]+$", "");
        boolean nestedMode = OSUtils.nestedMode() && field.startsWith(PROPS_PREFIX);
        RangeQueryBuilder rfb = QueryBuilders.rangeQuery((String)(nestedMode ? OSUtils.getValueFieldName(stringValue) : key));
        if (">".equals(operator)) {
            rfb.gt(OSUtils.getNumericValue(stringValue));
        } else if ("<".equals(operator)) {
            rfb.lt(OSUtils.getNumericValue(stringValue));
        } else if (">=".equals(operator)) {
            rfb.gte(OSUtils.getNumericValue(stringValue));
        } else if ("<=".equals(operator)) {
            rfb.lte(OSUtils.getNumericValue(stringValue));
        }
        if (nestedMode) {
            return OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(key, (QueryBuilder)rfb));
        }
        return rfb;
    }

    static QueryBuilder convertQueryStringToNestedQuery(String query) {
        String queryStr = StringUtils.trimToEmpty((String)query).replaceAll("\\[(\\d+)\\]", "-$1");
        Query q = OSUtils.qsParsed(queryStr);
        if (q == null) {
            return QueryBuilders.matchAllQuery();
        }
        try {
            return OSUtils.rewriteQuery(q, 0);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return null;
        }
    }

    private static QueryBuilder rewriteQuery(Query q, int depth) throws IllegalAccessException {
        if (depth > 10) {
            throw new IllegalArgumentException("Query depth exceeded! Max depth: 10 - " + q.toString());
        }
        BoolQueryBuilder qb = null;
        if (q instanceof BooleanQuery) {
            qb = QueryBuilders.boolQuery();
            block5: for (BooleanClause clause : ((BooleanQuery)q).clauses()) {
                switch (clause.getOccur()) {
                    case MUST: {
                        qb.must(OSUtils.rewriteQuery(clause.getQuery(), depth++));
                        continue block5;
                    }
                    case MUST_NOT: {
                        qb.mustNot(OSUtils.rewriteQuery(clause.getQuery(), depth++));
                        continue block5;
                    }
                    case FILTER: {
                        qb.filter(OSUtils.rewriteQuery(clause.getQuery(), depth++));
                        continue block5;
                    }
                }
                qb.should(OSUtils.rewriteQuery(clause.getQuery(), depth++));
            }
        } else if (q instanceof TermRangeQuery) {
            qb = OSUtils.termRange(q);
        } else if (q instanceof BoostQuery) {
            qb = OSUtils.rewriteQuery(((BoostQuery)q).getQuery(), depth++).boost(((BoostQuery)q).getBoost());
        } else if (q instanceof TermQuery) {
            qb = OSUtils.term(q);
        } else if (q instanceof FuzzyQuery) {
            qb = OSUtils.fuzzy(q);
        } else if (q instanceof PrefixQuery) {
            qb = OSUtils.prefix(q);
        } else if (q instanceof WildcardQuery) {
            qb = OSUtils.wildcard(q);
        } else {
            logger.warn("Unknown query type in nested mode query syntax: {}", (Object)q);
        }
        return qb == null ? QueryBuilders.matchAllQuery() : qb;
    }

    private static QueryBuilder termRange(Query q) {
        RangeQueryBuilder qb = null;
        TermRangeQuery trq = (TermRangeQuery)q;
        if (!StringUtils.isBlank((CharSequence)trq.getField())) {
            String from = trq.getLowerTerm() != null ? Term.toString((BytesRef)trq.getLowerTerm()) : "*";
            String to = trq.getUpperTerm() != null ? Term.toString((BytesRef)trq.getUpperTerm()) : "*";
            boolean isNestedField = trq.getField().matches(PROPS_REGEX);
            qb = QueryBuilders.rangeQuery((String)(isNestedField ? OSUtils.getValueFieldNameFromRange(from, to) : trq.getField()));
            if ("*".equals(from) && "*".equals(to)) {
                qb = QueryBuilders.matchAllQuery();
            }
            if (!"*".equals(from)) {
                qb.from(OSUtils.getNumericValue(from)).includeLower(trq.includesLower());
            }
            if (!"*".equals(to)) {
                qb.to(OSUtils.getNumericValue(to)).includeUpper(trq.includesUpper());
            }
            if (isNestedField) {
                qb = OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(trq.getField(), (QueryBuilder)qb));
            }
        }
        return qb;
    }

    private static QueryBuilder term(Query q) {
        Object qb;
        String field = ((TermQuery)q).getTerm().field();
        String value = ((TermQuery)q).getTerm().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQueryBuilder kQuery = QueryBuilders.matchAllQuery();
            MultiMatchQueryBuilder vQuery = QueryBuilders.multiMatchQuery((Object)value, (String[])new String[0]);
            qb = QueryBuilders.boolQuery().should((QueryBuilder)OSUtils.nestedPropsQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)kQuery).must((QueryBuilder)vQuery))).should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])new String[0]));
        } else {
            qb = field.matches(PROPS_REGEX) ? OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(field, value)) : QueryBuilders.termQuery((String)field, (String)value);
        }
        return qb;
    }

    private static QueryBuilder fuzzy(Query q) {
        Object qb;
        String field = ((FuzzyQuery)q).getTerm().field();
        String value = ((FuzzyQuery)q).getTerm().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQueryBuilder kQuery = QueryBuilders.matchAllQuery();
            FuzzyQueryBuilder vQuery = QueryBuilders.fuzzyQuery((String)OSUtils.getValueFieldName(value), (String)value);
            qb = QueryBuilders.boolQuery().should((QueryBuilder)OSUtils.nestedPropsQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)kQuery).must((QueryBuilder)vQuery))).should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])new String[0]));
        } else {
            qb = field.matches(PROPS_REGEX) ? OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(field, (QueryBuilder)QueryBuilders.fuzzyQuery((String)OSUtils.getValueFieldName(value), (String)value))) : QueryBuilders.fuzzyQuery((String)field, (String)value);
        }
        return qb;
    }

    private static QueryBuilder prefix(Query q) {
        Object qb;
        String field = ((PrefixQuery)q).getPrefix().field();
        String value = ((PrefixQuery)q).getPrefix().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQueryBuilder kQuery = QueryBuilders.matchAllQuery();
            PrefixQueryBuilder vQuery = QueryBuilders.prefixQuery((String)OSUtils.getValueFieldName(value), (String)value);
            qb = QueryBuilders.boolQuery().should((QueryBuilder)OSUtils.nestedPropsQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)kQuery).must((QueryBuilder)vQuery))).should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])new String[0]));
        } else {
            qb = field.matches(PROPS_REGEX) ? OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(field, (QueryBuilder)QueryBuilders.prefixQuery((String)OSUtils.getValueFieldName(value), (String)value))) : QueryBuilders.prefixQuery((String)field, (String)value);
        }
        return qb;
    }

    private static QueryBuilder wildcard(Query q) {
        Object qb;
        String field = ((WildcardQuery)q).getTerm().field();
        String value = ((WildcardQuery)q).getTerm().text();
        if (StringUtils.isBlank((CharSequence)field)) {
            MatchAllQueryBuilder kQuery = QueryBuilders.matchAllQuery();
            WildcardQueryBuilder vQuery = QueryBuilders.wildcardQuery((String)OSUtils.getValueFieldName(value), (String)value);
            qb = QueryBuilders.boolQuery().should((QueryBuilder)OSUtils.nestedPropsQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)kQuery).must((QueryBuilder)vQuery))).should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])new String[0]));
        } else {
            qb = field.matches(PROPS_REGEX) ? OSUtils.nestedPropsQuery(OSUtils.keyValueBoolQuery(field, (QueryBuilder)QueryBuilders.wildcardQuery((String)OSUtils.getValueFieldName(value), (String)value))) : QueryBuilders.wildcardQuery((String)field, (String)value);
        }
        return qb;
    }

    static QueryBuilder keyValueBoolQuery(String k, QueryBuilder query) {
        return OSUtils.keyValueBoolQuery(k, null, query);
    }

    static QueryBuilder keyValueBoolQuery(String k, String v) {
        return OSUtils.keyValueBoolQuery(k, v, null);
    }

    static QueryBuilder keyValueBoolQuery(String k, String v, QueryBuilder query) {
        QueryBuilder vQuery;
        if (StringUtils.isBlank((CharSequence)k) || query == null && StringUtils.isBlank((CharSequence)v)) {
            return QueryBuilders.matchAllQuery();
        }
        MatchQueryBuilder kQuery = QueryBuilders.matchQuery((String)"properties.k", (Object)OSUtils.getNestedKey(k)).operator(Operator.AND);
        Object object = vQuery = query == null ? QueryBuilders.matchQuery((String)OSUtils.getValueFieldName(v), (Object)v).operator(Operator.AND) : query;
        if ("*".equals(v) || QueryBuilders.matchAllQuery().equals((Object)query)) {
            return QueryBuilders.boolQuery().must((QueryBuilder)kQuery);
        }
        return QueryBuilders.boolQuery().must((QueryBuilder)kQuery).must(vQuery);
    }

    static NestedQueryBuilder nestedPropsQuery(QueryBuilder query) {
        return QueryBuilders.nestedQuery((String)PROPS_FIELD, (QueryBuilder)query, (ScoreMode)ScoreMode.Avg);
    }

    static String getNestedKey(String key) {
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)PROPS_PREFIX)) {
            return StringUtils.removeStart((String)key, (String)PROPS_PREFIX).replaceAll("\\[(\\d+)\\]", "-$1").replaceAll("\\.", "-");
        }
        return key;
    }

    static String getValueFieldName(String v) {
        return PROPS_PREFIX + (NumberUtils.isDigits((String)v) ? "vn" : "v");
    }

    static String getValueFieldNameFromRange(String from, String to) {
        if ("*".equals(from) && "*".equals(to) || NumberUtils.isDigits((String)from) || NumberUtils.isDigits((String)to)) {
            return "properties.vn";
        }
        return "properties.v";
    }

    static Object getNumericValue(String v) {
        return NumberUtils.isDigits((String)v) ? Long.valueOf(NumberUtils.toLong((String)v, (long)0L)) : v;
    }

    static String getIndexName(String appid) {
        return appid.trim();
    }

    static String getIndexNameWithWildcard(String indexName) {
        return StringUtils.contains((CharSequence)indexName, (CharSequence)"_") ? indexName : indexName + "_*";
    }

    static RestClientBuilder.HttpClientConfigCallback getAWSRequestSigningInterceptor(String endpoint) {
        return httpClientBuilder -> {
            httpClientBuilder.addInterceptorLast((request, context) -> {
                Aws4Signer signer = Aws4Signer.create();
                AwsCredentials creds = DefaultCredentialsProvider.create().resolveCredentials();
                Aws4SignerParams.Builder signerParams = Aws4SignerParams.builder().awsCredentials(creds).doubleUrlEncode(Boolean.valueOf(true)).signingName("es").signingRegion(Region.of((String)Para.getConfig().elasticsearchAwsRegion()));
                String httpMethod = request.getRequestLine().getMethod();
                HashMap params = new HashMap();
                try {
                    Header[] body;
                    URIBuilder uriBuilder;
                    String resourcePath;
                    SdkHttpFullRequest.Builder r = SdkHttpFullRequest.builder();
                    if (!StringUtils.isBlank((CharSequence)httpMethod)) {
                        r.method(SdkHttpMethod.valueOf((String)httpMethod));
                    }
                    if (!StringUtils.isBlank((CharSequence)endpoint)) {
                        if (endpoint.startsWith("https://")) {
                            r.protocol("HTTPS");
                            r.host(StringUtils.removeStart((String)endpoint, (String)"https://"));
                        } else if (endpoint.startsWith("http://")) {
                            r.protocol("HTTP");
                            r.host(StringUtils.removeStart((String)endpoint, (String)"http://"));
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)(resourcePath = (uriBuilder = new URIBuilder(request.getRequestLine().getUri())).getPath()))) {
                        r.encodedPath(resourcePath);
                    }
                    for (NameValuePair param : uriBuilder.getQueryParams()) {
                        r.appendRawQueryParameter(param.getName(), param.getValue());
                    }
                    if (request instanceof HttpEntityEnclosingRequest && (body = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
                        InputStream is = body.getContent();
                        r.contentStreamProvider(() -> is);
                    }
                    if (r.contentStreamProvider() == null) {
                        request.removeHeaders("Content-Length");
                    }
                    for (Header header : request.getAllHeaders()) {
                        r.putHeader(header.getName(), header.getValue());
                    }
                    SdkHttpFullRequest signedReq = signer.sign(r.build(), signerParams.build());
                    for (String header : signedReq.headers().keySet()) {
                        request.setHeader(header, signedReq.firstMatchingHeader(header).orElse(""));
                    }
                }
                catch (Exception ex) {
                    logger.error("Failed to sign request to AWS Elasticsearch:", (Throwable)ex);
                }
            });
            return httpClientBuilder;
        };
    }

    static RestClientBuilder.HttpClientConfigCallback getAuthenticationCallback() {
        String basicAuthLogin = Para.getConfig().elasticsearchAuthUser();
        String basicAuthPassword = Para.getConfig().elasticsearchAuthPassword();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{basicAuthLogin, basicAuthPassword})) {
            return httpClientBuilder -> httpClientBuilder;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthLogin, basicAuthPassword));
        return arg_0 -> OSUtils.lambda$getAuthenticationCallback$7((CredentialsProvider)credentialsProvider, arg_0);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getAuthenticationCallback$7(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    static {
        IGNORED_FIELDS = new String[]{"settings", "datatypes", "deviceState", "deviceMetadata", "resourcePermissions", "validationConstraints"};
    }
}

