/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.search.rest;

import com.erudika.para.core.App;
import com.erudika.para.core.listeners.DestroyListener;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.rest.CustomResourceHandler;
import com.erudika.para.core.search.Search;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHeader;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyResourceHandler
implements CustomResourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProxyResourceHandler.class);
    private RestClient lowLevelClient;
    public static final String PATH = Para.getConfig().elasticsearchProxyPath();

    public String getRelativePath() {
        return PATH;
    }

    public Response handleGet(ContainerRequestContext ctx) {
        return this.proxyRequest("GET", ctx);
    }

    public Response handlePost(ContainerRequestContext ctx) {
        return this.proxyRequest("POST", ctx);
    }

    public Response handlePatch(ContainerRequestContext ctx) {
        return this.proxyRequest("PATCH", ctx);
    }

    public Response handlePut(ContainerRequestContext ctx) {
        return this.proxyRequest("PUT", ctx);
    }

    public Response handleDelete(ContainerRequestContext ctx) {
        return this.proxyRequest("DELETE", ctx);
    }

    Response proxyRequest(String method, ContainerRequestContext ctx) {
        if (!Para.getConfig().elasticsearchProxyEnabled()) {
            return Response.status((int)Response.Status.FORBIDDEN.getStatusCode(), (String)"This feature is disabled.").build();
        }
        String appid = ParaObjectUtils.getAppidFromAuthHeader((String)((String)ctx.getHeaders().getFirst((Object)"Authorization")));
        if (StringUtils.isBlank((CharSequence)appid)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String path = this.getCleanPath(appid, this.getPath(ctx));
        try {
            if (path.endsWith("/reindex") && "POST".equals(method)) {
                return this.handleReindexTask(appid, (String)ctx.getUriInfo().getQueryParameters().getFirst((Object)"destinationIndex"));
            }
            Header[] headers = this.getHeaders((MultivaluedMap<String, String>)ctx.getHeaders());
            RestClient client = this.getClient();
            if (client != null) {
                HttpEntity resp;
                Request esRequest = new Request(method, path);
                RequestOptions.Builder opts = RequestOptions.DEFAULT.toBuilder();
                for (Header header : headers) {
                    opts.addHeader(header.getName(), header.getValue());
                }
                esRequest.setOptions(opts);
                if (ctx.getEntityStream() != null && ctx.getEntityStream().available() > 0) {
                    InputStreamEntity body = new InputStreamEntity(ctx.getEntityStream(), ContentType.APPLICATION_JSON);
                    esRequest.setEntity((HttpEntity)body);
                    resp = client.performRequest(esRequest).getEntity();
                } else {
                    resp = client.performRequest(esRequest).getEntity();
                }
                if (resp != null && resp.getContent() != null) {
                    Header type = resp.getContentType();
                    Object response = this.getTransformedResponse(appid, resp.getContent(), ctx);
                    return Response.ok((Object)response).header(type.getName(), (Object)type.getValue()).build();
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to proxy '{} {}' to Elasticsearch: {}", new Object[]{method, path, ex.getMessage()});
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private RestClient getClient() {
        if (this.lowLevelClient != null) {
            return this.lowLevelClient;
        }
        try {
            String esScheme = Para.getConfig().elasticsearchRestClientScheme();
            String esHost = Para.getConfig().elasticsearchRestClientHost();
            int esPort = Para.getConfig().elasticsearchRestClientPort();
            this.lowLevelClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esHost, esPort, esScheme)}).build();
            Para.addDestroyListener((DestroyListener)new DestroyListener(){

                public void onDestroy() {
                    if (ProxyResourceHandler.this.lowLevelClient != null) {
                        try {
                            ProxyResourceHandler.this.lowLevelClient.close();
                        }
                        catch (IOException ex) {
                            logger.error(null, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Failed to initialize Elasticsearch low-level client: {}", (Object)e.getMessage());
        }
        return this.lowLevelClient;
    }

    private Header[] getHeaders(MultivaluedMap<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return new Header[0];
        }
        int i = 0;
        headers.remove((Object)"Content-Length");
        Header[] headerz = new Header[headers.size()];
        for (String key : headers.keySet()) {
            headerz[i] = new BasicHeader(key, (String)headers.getFirst((Object)key));
            ++i;
        }
        return headerz;
    }

    private String getPath(ContainerRequestContext ctx) {
        String path = (String)ctx.getUriInfo().getPathParameters(true).getFirst((Object)"path");
        return StringUtils.isBlank((CharSequence)path) ? "_search" : path;
    }

    public String getCleanPath(String appid, String path) {
        if (StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"getRawResponse")) {
            try {
                URIBuilder uri = new URIBuilder(path);
                List params = uri.getQueryParams();
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    NameValuePair next = (NameValuePair)iterator.next();
                    if (!next.getName().equalsIgnoreCase("getRawResponse")) continue;
                    iterator.remove();
                    break;
                }
                path = uri.setParameters(params).toString();
            }
            catch (URISyntaxException ex) {
                logger.warn(null, (Throwable)ex);
            }
        }
        if (path.startsWith("/")) {
            path = StringUtils.stripStart((String)path, (String)"/");
        }
        if (StringUtils.isBlank((CharSequence)path) || "/".equals(path)) {
            path = "_search";
        }
        return "/".concat(appid).concat("/").concat(path);
    }

    private Response handleReindexTask(String appid, String destinationIndex) {
        if (!Para.getConfig().elasticsearchProxyReindexingEnabled() || appid == null) {
            return Response.status((int)Response.Status.FORBIDDEN.getStatusCode(), (String)"This feature is disabled.").build();
        }
        Pager pager = new Pager();
        DAO dao = CoreUtils.getInstance().getDao();
        Search search = CoreUtils.getInstance().getSearch();
        App app = (App)dao.read(App.id((String)appid));
        if (app != null) {
            long startTime = System.nanoTime();
            search.rebuildIndex(dao, app, destinationIndex, new Pager[]{pager});
            long tookMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            HashMap<String, Long> response = new HashMap<String, Long>();
            response.put("reindexed", pager.getCount());
            response.put("tookMillis", tookMillis);
            return Response.ok(response, (String)"application/json").build();
        }
        return Response.status((int)404, (String)"App not found.").build();
    }

    private Object getTransformedResponse(String appid, InputStream content, ContainerRequestContext ctx) {
        if (ctx.getUriInfo().getQueryParameters().containsKey((Object)"getRawResponse") || StringUtils.containsIgnoreCase((CharSequence)this.getPath(ctx), (CharSequence)"getRawResponse=")) {
            return content;
        }
        try {
            JsonNode tree = ParaObjectUtils.getJsonMapper().readTree(content);
            JsonNode hits = tree.at("/hits/hits");
            if (hits.isMissingNode()) {
                return tree;
            }
            LinkedList<String> keys = new LinkedList<String>();
            long count = tree.at("/hits/total").asLong();
            for (JsonNode hit : hits) {
                String id = hit.get("_id").asText();
                keys.add(id);
            }
            DAO dao = CoreUtils.getInstance().getDao();
            Map fromDB = dao.readAll(appid, keys, true);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("items", fromDB);
            result.put("totalHits", count);
            return result;
        }
        catch (IOException ex) {
            logger.error(null, (Throwable)ex);
            return Collections.emptyMap();
        }
    }
}

