/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TypeFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.IntUnaryOperator;

public final class TupleType
extends ABIType<Tuple>
implements Iterable<ABIType<?>> {
    static final String EMPTY_TUPLE_STRING = "()";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final TupleType EMPTY = new TupleType("()", false, EMPTY_ARRAY, null, null, 0);
    final ABIType<?>[] elementTypes;
    final String[] elementNames;
    final String[] elementInternalTypes;
    private final int[] elementHeadOffsets;
    private final int headLength;
    private final int firstOffset;

    TupleType(String canonicalType, boolean dynamic, ABIType<?>[] elementTypes, String[] elementNames, String[] elementInternalTypes, int flags) {
        super(canonicalType, Tuple.class, dynamic, flags);
        this.elementTypes = elementTypes;
        this.elementNames = elementNames;
        this.elementInternalTypes = elementInternalTypes;
        this.elementHeadOffsets = new int[elementTypes.length];
        if (dynamic) {
            this.headLength = 32;
            int sum = 0;
            for (int i = 0; i < elementTypes.length; ++i) {
                this.elementHeadOffsets[i] = sum;
                sum += elementTypes[i].headLength();
            }
            this.firstOffset = sum;
        } else {
            this.headLength = this.staticTupleHeadLength();
            this.firstOffset = -1;
        }
    }

    public int size() {
        return this.elementTypes.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String getElementName(int index) {
        return this.elementNames == null ? null : this.elementNames[index];
    }

    public String getElementInternalType(int index) {
        return this.elementInternalTypes == null ? null : this.elementInternalTypes[index];
    }

    public <T extends ABIType<?>> T get(int index) {
        return (T)this.elementTypes[index];
    }

    public ABIType<Object> getNonCapturing(int index) {
        return this.get(index);
    }

    @Override
    Class<?> arrayClass() {
        return Tuple[].class;
    }

    @Override
    public int typeCode() {
        return 7;
    }

    @Override
    int headLength() {
        return this.headLength;
    }

    @Override
    int dynamicByteLength(Tuple value) {
        return this.countBytes(i -> TupleType.measureObject(this.getNonCapturing(i), value.elements[i]));
    }

    @Override
    int byteLength(Tuple value) {
        if (!this.dynamic) {
            return this.headLength;
        }
        return this.dynamicByteLength(value);
    }

    private static int measureObject(ABIType<Object> type, Object value) {
        return TupleType.totalLen(type.byteLength(value), type.dynamic);
    }

    @Override
    public int byteLengthPacked(Tuple value) {
        Object[] elements = value != null ? value.elements : new Object[this.size()];
        return this.countBytes(i -> this.getNonCapturing(i).byteLengthPacked(elements[i]));
    }

    private int countBytes(IntUnaryOperator counter) {
        return TupleType.countBytes(false, this.elementTypes.length, counter);
    }

    static int countBytes(boolean array, int len, IntUnaryOperator counter) {
        int i;
        try {
            int count = 0;
            for (i = 0; i < len; ++i) {
                count += counter.applyAsInt(i);
            }
            return count;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException((array ? "array" : "tuple") + " index " + i + ": " + iae.getMessage(), iae);
        }
    }

    @Override
    public int validate(Tuple value) {
        if (value.size() == this.size()) {
            return this.countBytes(i -> TupleType.validateObject(this.getNonCapturing(i), value.elements[i]));
        }
        throw new IllegalArgumentException("tuple length mismatch: expected length " + this.size() + " but found " + value.size());
    }

    private static int validateObject(ABIType<Object> type, Object value) {
        try {
            type.validateClass(value);
            return TupleType.totalLen(type.validate(value), type.dynamic);
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("null", npe);
        }
    }

    static int totalLen(int byteLen, boolean addUnit) {
        return addUnit ? 32 + byteLen : byteLen;
    }

    @Override
    void encodeTail(Tuple value, ByteBuffer dest) {
        if (this.dynamic) {
            this.encodeDynamic(value.elements, dest);
        } else {
            this.encodeStatic(value.elements, dest);
        }
    }

    @Override
    void encodePackedUnchecked(Tuple value, ByteBuffer dest) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.getNonCapturing(i).encodePackedUnchecked(value.elements[i], dest);
        }
    }

    private void encodeStatic(Object[] values, ByteBuffer dest) {
        for (int i = 0; i < values.length; ++i) {
            this.getNonCapturing(i).encodeTail(values[i], dest);
        }
    }

    private void encodeDynamic(Object[] values, ByteBuffer dest) {
        ABIType<Object> t;
        if (values.length == 0) {
            return;
        }
        int i = 0;
        int last = values.length - 1;
        int offset = this.firstOffset;
        while (true) {
            t = this.getNonCapturing(i);
            if (!t.dynamic) {
                t.encodeTail(values[i], dest);
                if (i >= last) {
                    break;
                }
            } else {
                Encoding.insertIntUnsigned(offset, dest);
                if (i >= last) break;
                offset += t.dynamicByteLength(values[i]);
            }
            ++i;
        }
        for (i = 0; i < values.length; ++i) {
            t = this.getNonCapturing(i);
            if (!t.dynamic) continue;
            t.encodeTail(values[i], dest);
        }
    }

    @Override
    Tuple decode(ByteBuffer bb, byte[] unitBuffer) {
        int i;
        Object[] elements = new Object[this.size()];
        try {
            int start = bb.position();
            int[] offsets = new int[elements.length];
            for (i = 0; i < elements.length; ++i) {
                ABIType<?> t = this.elementTypes[i];
                if (!t.dynamic) {
                    elements[i] = t.decode(bb, unitBuffer);
                    continue;
                }
                int offset = Encoding.UINT31.decode(bb, unitBuffer);
                offsets[i] = offset == 0 ? -1 : offset;
            }
            for (i = 0; i < elements.length; ++i) {
                int offset = offsets[i];
                if (offset == 0) continue;
                int jump = start + offset;
                if (jump != bb.position()) {
                    bb.position(offset == -1 ? start : jump);
                }
                elements[i] = this.elementTypes[i].decode(bb, unitBuffer);
            }
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.decodeException(true, i, cause);
        }
        return new Tuple(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T decode(ByteBuffer bb, int ... indices) {
        bb.mark();
        try {
            if (indices.length == 1) {
                Object object = this.decodeIndex(bb, indices[0]);
                return (T)object;
            }
            Tuple tuple = this.decodeIndices(bb, indices);
            return (T)tuple;
        }
        finally {
            bb.reset();
        }
    }

    private Object decodeIndex(ByteBuffer bb, int index) {
        ABIType<?> type = this.elementTypes[index];
        int start = bb.position();
        bb.position(start + this.elementHeadOffsets[index]);
        return TupleType.decodeObject(type, bb, start, TupleType.newUnitBuffer(), index);
    }

    private Tuple decodeIndices(ByteBuffer bb, int ... indices) {
        Object[] results = new Object[this.elementTypes.length];
        int start = bb.position();
        byte[] unitBuffer = TupleType.newUnitBuffer();
        int prev = -1;
        for (int index : indices) {
            ABIType<?> resultType = this.elementTypes[index];
            if (index <= prev) {
                throw new IllegalArgumentException("index out of order: " + index);
            }
            bb.position(start + this.elementHeadOffsets[index]);
            results[index] = TupleType.decodeObject(resultType, bb, start, unitBuffer, index);
            prev = index;
        }
        return new Tuple(results);
    }

    private static Object decodeObject(ABIType<?> type, ByteBuffer bb, int start, byte[] unitBuffer, int index) {
        try {
            if (type.dynamic) {
                bb.position(start + Encoding.UINT31.decode(bb, unitBuffer));
            }
            return type.decode(bb, unitBuffer);
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.decodeException(true, index, cause);
        }
    }

    int staticTupleHeadLength() {
        int len = 0;
        int sum = 0;
        block4: for (int i = 0; i < this.elementTypes.length; ++i) {
            this.elementHeadOffsets[i] = sum;
            ABIType<?> e = this.elementTypes[i];
            sum += e.headLength();
            switch (e.typeCode()) {
                case 6: {
                    len += ((ArrayType)e).staticArrayHeadLength();
                    continue block4;
                }
                case 7: {
                    len += ((TupleType)e).staticTupleHeadLength();
                    continue block4;
                }
                default: {
                    len += 32;
                }
            }
        }
        return len;
    }

    static IllegalArgumentException decodeException(boolean tuple, int i, IllegalArgumentException cause) {
        return new IllegalArgumentException((tuple ? "tuple index " : "array index ") + i + ": " + cause.getMessage(), cause);
    }

    @Override
    public Iterator<ABIType<?>> iterator() {
        return Arrays.asList(this.elementTypes).iterator();
    }

    public TupleType select(boolean ... manifest) {
        return this.selectElements(manifest, false);
    }

    public TupleType exclude(boolean ... manifest) {
        return this.selectElements(manifest, true);
    }

    private TupleType selectElements(boolean[] manifest, boolean negate) {
        int size = this.size();
        if (manifest.length == size) {
            StringBuilder canonicalBuilder = new StringBuilder("(");
            boolean dynamic = false;
            ArrayList selected = new ArrayList(size);
            ArrayList<String> selectedNames = this.elementNames == null ? null : new ArrayList<String>(size);
            ArrayList<String> selectedInternalTypes = this.elementInternalTypes == null ? null : new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                if (!(negate ^ manifest[i])) continue;
                Object e = this.get(i);
                canonicalBuilder.append(((ABIType)e).canonicalType).append(',');
                dynamic |= ((ABIType)e).dynamic;
                selected.add(e);
                if (selectedNames != null) {
                    selectedNames.add(this.elementNames[i]);
                }
                if (selectedInternalTypes == null) continue;
                selectedInternalTypes.add(this.elementInternalTypes[i]);
            }
            return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, selected.toArray(EMPTY_ARRAY), selectedNames == null ? null : selectedNames.toArray(EMPTY_STRING_ARRAY), selectedInternalTypes == null ? null : selectedInternalTypes.toArray(EMPTY_STRING_ARRAY), this.flags);
        }
        throw new IllegalArgumentException("manifest.length != size(): " + manifest.length + " != " + size);
    }

    private static String completeTupleTypeString(StringBuilder sb) {
        int len = sb.length();
        return len != 1 ? sb.deleteCharAt(len - 1).append(')').toString() : EMPTY_TUPLE_STRING;
    }

    public static TupleType parse(String rawTupleTypeString) {
        return (TupleType)TypeFactory.create(rawTupleTypeString);
    }

    public static TupleType parse(int flags, String rawTupleTypeString) {
        return (TupleType)TypeFactory.create(flags, rawTupleTypeString);
    }

    public static TupleType of(String ... typeStrings) {
        StringBuilder sb = new StringBuilder("(");
        for (String str : typeStrings) {
            sb.append(str).append(',');
        }
        return TupleType.parse(TupleType.completeTupleTypeString(sb));
    }

    static TupleType empty(int flags) {
        return flags == 0 ? EMPTY : new TupleType(EMPTY_TUPLE_STRING, false, EMPTY_ARRAY, null, null, flags);
    }
}

