/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

public enum TypeEnum {
    FUNCTION("function", true),
    RECEIVE("receive", true),
    FALLBACK("fallback", true),
    CONSTRUCTOR("constructor", true),
    EVENT("event", false),
    ERROR("error", false);

    static final int ORDINAL_FUNCTION = 0;
    static final int ORDINAL_RECEIVE = 1;
    static final int ORDINAL_FALLBACK = 2;
    static final int ORDINAL_CONSTRUCTOR = 3;
    static final int ORDINAL_EVENT = 4;
    static final int ORDINAL_ERROR = 5;
    private final String name;
    public final boolean isFunction;

    private TypeEnum(String name, boolean isFunction) {
        this.name = name;
        this.isFunction = isFunction;
    }

    public String toString() {
        return this.name;
    }

    public static TypeEnum parse(String typeString) {
        if (typeString == null) {
            return FUNCTION;
        }
        switch (typeString) {
            case "function": {
                return FUNCTION;
            }
            case "receive": {
                return RECEIVE;
            }
            case "fallback": {
                return FALLBACK;
            }
            case "constructor": {
                return CONSTRUCTOR;
            }
            case "event": {
                return EVENT;
            }
            case "error": {
                return ERROR;
            }
        }
        throw TypeEnum.unexpectedType(typeString);
    }

    static IllegalArgumentException unexpectedType(String t) {
        return new IllegalArgumentException("unexpected type: " + (t == null ? null : "\"" + t + '\"'));
    }
}

