/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static JsonElement parseElement(String json) {
        return Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(json)));
    }

    public static JsonObject parseObject(String json) {
        return JsonUtils.parseElement(json).getAsJsonObject();
    }

    public static JsonArray parseArray(String json) {
        return JsonUtils.parseElement(json).getAsJsonArray();
    }

    public static String getString(JsonObject object, String key) {
        return JsonUtils.getString(object, key, null);
    }

    public static Boolean getBoolean(JsonObject object, String key) {
        return JsonUtils.getBoolean(object, key, null);
    }

    public static JsonArray getArray(JsonObject object, String key) {
        JsonElement element = object.get(key);
        if (JsonUtils.isNull(element)) {
            return null;
        }
        return element.getAsJsonArray();
    }

    public static String getString(JsonObject object, String key, String defaultVal) {
        JsonElement element = object.get(key);
        if (JsonUtils.isNull(element)) {
            return defaultVal;
        }
        if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
            return element.getAsString();
        }
        throw new IllegalArgumentException(key + " is not a string");
    }

    public static Boolean getBoolean(JsonObject object, String key, Boolean defaultVal) {
        JsonElement element = object.get(key);
        if (JsonUtils.isNull(element)) {
            return defaultVal;
        }
        if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
            return element.getAsBoolean();
        }
        throw new IllegalArgumentException(key + " is not a boolean");
    }

    private static boolean isNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }
}

