/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.util.Integers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class RLPList
extends RLPItem
implements Iterable<RLPItem> {
    RLPList(byte[] buffer, int index, int dataIndex, int dataLength, int endIndex) {
        super(buffer, index, dataIndex, dataLength, endIndex);
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public RLPList asRLPList() {
        return this;
    }

    @Override
    public RLPList duplicate() {
        byte[] enc = this.encoding();
        return new RLPList(enc, 0, enc.length - this.dataLength, this.dataLength, enc.length);
    }

    public static RLPList wrap(RLPItem ... elements) {
        return RLPList.wrap(Arrays.asList(elements));
    }

    public static RLPList wrap(Iterable<RLPItem> elements) {
        int dataLen = 0;
        for (RLPItem e : elements) {
            dataLen += e.encodingLength();
        }
        return RLPDecoder.RLP_STRICT.wrapList(dataLen < 56 ? RLPList.encodeListShort(dataLen, elements) : RLPList.encodeListLong(dataLen, elements));
    }

    private static byte[] encodeListShort(int dataLen, Iterable<RLPItem> elements) {
        byte[] dest = new byte[1 + dataLen];
        dest[0] = (byte)(-64 + dataLen);
        RLPList.copyElements(elements, dest, 1);
        return dest;
    }

    private static byte[] encodeListLong(int dataLen, Iterable<RLPItem> elements) {
        int lengthOfLength = Integers.len(dataLen);
        int prefixLen = 1 + lengthOfLength;
        byte[] dest = new byte[prefixLen + dataLen];
        dest[0] = (byte)(-9 + lengthOfLength);
        Integers.putLong(dataLen, dest, 1);
        RLPList.copyElements(elements, dest, prefixLen);
        return dest;
    }

    private static void copyElements(Iterable<RLPItem> elements, byte[] dest, int destIndex) {
        for (RLPItem e : elements) {
            destIndex = e.copy(dest, destIndex);
        }
    }

    public List<RLPItem> elements() {
        return this.elements(RLPDecoder.RLP_STRICT);
    }

    public List<RLPItem> elements(RLPDecoder decoder) {
        ArrayList<RLPItem> arrayList = new ArrayList<RLPItem>();
        this.elements(decoder, arrayList);
        return arrayList;
    }

    public void elements(RLPDecoder decoder, Collection<? super RLPItem> collection) {
        Iterator<RLPItem> iter = this.iterator(decoder);
        while (iter.hasNext()) {
            collection.add(iter.next());
        }
    }

    public Iterator<RLPItem> iterator(final RLPDecoder decoder) {
        return new Iterator<RLPItem>(){
            int idx;
            {
                this.idx = RLPList.this.dataIndex;
            }

            @Override
            public boolean hasNext() {
                return this.idx < RLPList.this.endIndex;
            }

            @Override
            public RLPItem next() {
                if (this.hasNext()) {
                    Object next = decoder.wrap(RLPList.this.buffer, this.idx, RLPList.this.endIndex);
                    this.idx = ((RLPItem)next).endIndex;
                    return next;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Iterator<RLPItem> iterator() {
        return this.iterator(RLPDecoder.RLP_STRICT);
    }
}

