/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Strings;

public final class FastBase64 {
    public static final int NO_FLAGS = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_LINE_SEP = 2;
    public static final int URL_SAFE_CHARS = 4;
    private static final int LINE_LEN = 76;
    private static final int LINE_SEP_LEN = 2;
    private static final byte PADDING_BYTE = 61;
    private static final short[] URL_SAFE = FastBase64.table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");

    private FastBase64() {
    }

    static short[] table(String alphabet) {
        byte[] bytes = Strings.decode(alphabet, 3);
        short[] table = new short[4096];
        int i = 0;
        int offset = 0;
        while (i < bytes.length) {
            int leftBits = bytes[i] << 8;
            for (int j = 0; j < bytes.length; ++j) {
                table[offset + j] = (short)(leftBits | bytes[j] & 0xFF);
            }
            ++i;
            offset += bytes.length;
        }
        return table;
    }

    public static String encodeToString(byte[] buffer, int offset, int len, int flags) {
        byte[] out = new byte[FastBase64.encodedSize(len, flags)];
        FastBase64.encodeToBytes(buffer, offset, len, out, 0, flags);
        return new String(out, 0, 0, out.length);
    }

    public static int encodedSize(int inputLen, int flags) {
        int chunks = inputLen / 3;
        return FastBase64.size(chunks, inputLen - chunks * 3, (flags & 1) != 0, (flags & 2) != 0);
    }

    private static int size(int chunks, int remainder, boolean noPadding, boolean noLineSep) {
        int chars = chunks * 4 + (remainder != 0 ? (noPadding ? remainder + 1 : 4) : 0);
        return noLineSep ? chars : chars + (chars - 1) / 76 * 2;
    }

    public static byte[] encodeToBytes(byte[] buffer, int offset, int len, int flags) {
        byte[] out = new byte[FastBase64.encodedSize(len, flags)];
        FastBase64.encodeToBytes(buffer, offset, len, out, 0, flags);
        return out;
    }

    public static void encodeToBytes(byte[] buffer, int offset, int len, byte[] dest, int destOff, int flags) {
        short[] table;
        int chunks = len / 3;
        int evenBytes = chunks * 3;
        int remainder = len - evenBytes;
        int charsLeft = 0;
        if (remainder > 0) {
            charsLeft = (flags & 1) != 0 ? remainder + 1 : 4;
        }
        int endEvenBytes = offset + evenBytes;
        int endEvenChars = destOff + chunks * 4;
        short[] sArray = table = (flags & 4) != 0 ? URL_SAFE : Standard.TABLE;
        if ((flags & 2) != 0) {
            FastBase64.encodeMain(buffer, offset, table, endEvenBytes, dest, destOff);
            FastBase64.insertRemainder(buffer, endEvenBytes, remainder, endEvenChars, charsLeft, table, dest);
        } else {
            int endChars = destOff + FastBase64.size(chunks, remainder, (flags & 1) != 0, false);
            int o = FastBase64.encodeMainLineSep(buffer, offset, table, endEvenBytes, dest, destOff, endChars);
            FastBase64.insertRemainder(buffer, endEvenBytes, remainder, o, charsLeft, table, dest);
        }
    }

    private static void encodeMain(byte[] buffer, int i, short[] table, int end, byte[] dest, int o) {
        while (i < end) {
            int _24bits = (buffer[i++] & 0xFF) << 16 | (buffer[i++] & 0xFF) << 8 | buffer[i++] & 0xFF;
            short ab = table[_24bits >>> 12];
            short cd = table[_24bits & 0xFFF];
            dest[o++] = (byte)(ab >>> 8);
            dest[o++] = (byte)ab;
            dest[o++] = (byte)(cd >>> 8);
            dest[o++] = (byte)cd;
        }
    }

    private static int encodeMainLineSep(byte[] buffer, int i, short[] table, int end, byte[] dest, int o, int endChars) {
        int lineSepLimit = endChars - 2;
        int quadruples = 0;
        while (i < end) {
            int _24bits = (buffer[i++] & 0xFF) << 16 | (buffer[i++] & 0xFF) << 8 | buffer[i++] & 0xFF;
            short ab = table[_24bits >>> 12];
            short cd = table[_24bits & 0xFFF];
            dest[o++] = (byte)(ab >>> 8);
            dest[o++] = (byte)ab;
            dest[o++] = (byte)(cd >>> 8);
            dest[o++] = (byte)cd;
            if (++quadruples < 19 || o >= lineSepLimit) continue;
            dest[o++] = 13;
            dest[o++] = 10;
            quadruples = 0;
        }
        return o;
    }

    private static void insertRemainder(byte[] buffer, int offset, int remainder, int o, int charsLeft, short[] table, byte[] dest) {
        int bits = 0;
        int thirdChar = 61;
        switch (remainder) {
            case 2: {
                bits = (buffer[offset + 1] & 0xFF) << 2;
                thirdChar = table[bits & 0x3F];
            }
            case 1: {
                bits |= (buffer[offset] & 0xFF) << 10;
                switch (charsLeft) {
                    case 4: {
                        dest[o + 3] = 61;
                    }
                    case 3: {
                        dest[o + 2] = (byte)thirdChar;
                    }
                    case 2: {
                        dest[o + 1] = (byte)table[bits >> 6 & 0x3F];
                    }
                }
                dest[o] = (byte)table[bits >> 12];
            }
        }
    }

    private static final class Standard {
        static final short[] TABLE = FastBase64.table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");

        private Standard() {
        }
    }
}

