/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.Event;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.util.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public final class ABIJSON {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    static final String FUNCTION = "function";
    static final String RECEIVE = "receive";
    static final String FALLBACK = "fallback";
    static final String CONSTRUCTOR = "constructor";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String TUPLE = "tuple";
    private static final String COMPONENTS = "components";
    private static final String EVENT = "event";
    private static final String ANONYMOUS = "anonymous";
    private static final String INDEXED = "indexed";
    private static final String STATE_MUTABILITY = "stateMutability";
    private static final String PURE = "pure";
    private static final String VIEW = "view";
    static final String PAYABLE = "payable";
    private static final String CONSTANT = "constant";
    private static final Gson GSON;
    private static final Gson GSON_PRETTY;

    public static ABIObject parseABIObject(String objectJson) {
        return ABIJSON.parseABIObject(JsonUtils.parseObject(objectJson));
    }

    public static ABIObject parseABIObject(JsonObject object) {
        return EVENT.equals(JsonUtils.getString(object, TYPE)) ? ABIJSON.parseEvent(object) : ABIJSON.parseFunction(object, Function.newDefaultDigest());
    }

    public static List<Function> parseFunctions(String arrayJson) {
        return ABIJSON.parseFunctions(arrayJson, Function.newDefaultDigest());
    }

    public static List<Function> parseFunctions(String arrayJson, MessageDigest digest) {
        return ABIJSON.parseObjects(arrayJson, true, false, digest, Function.class);
    }

    public static List<Event> parseEvents(String arrayJson) {
        return ABIJSON.parseObjects(arrayJson, false, true, null, Event.class);
    }

    public static <T extends ABIObject> List<T> parseObjects(String arrayJson, boolean functions, boolean events, MessageDigest digest, Class<T> classOfT) {
        ArrayList<ABIObject> abiObjects = new ArrayList<ABIObject>();
        for (JsonElement e : JsonUtils.parseArray(arrayJson)) {
            if (!e.isJsonObject()) continue;
            JsonObject jsonObj = (JsonObject)e;
            switch (JsonUtils.getString(jsonObj, TYPE, FUNCTION)) {
                case "function": 
                case "receive": 
                case "fallback": 
                case "constructor": {
                    if (!functions) break;
                    abiObjects.add((ABIObject)classOfT.cast(ABIJSON.parseFunction(jsonObj, digest)));
                    break;
                }
                case "event": {
                    if (!events) break;
                    abiObjects.add((ABIObject)classOfT.cast(ABIJSON.parseEvent(jsonObj)));
                    break;
                }
            }
        }
        return abiObjects;
    }

    public static Function parseFunction(JsonObject function, MessageDigest messageDigest) {
        return new Function(ABIJSON.parseFunctionType(JsonUtils.getString(function, TYPE)), JsonUtils.getString(function, NAME), ABIJSON.parseTypes(JsonUtils.getArray(function, INPUTS)), ABIJSON.parseTypes(JsonUtils.getArray(function, OUTPUTS)), JsonUtils.getString(function, STATE_MUTABILITY), messageDigest);
    }

    private static Function.Type parseFunctionType(String type) {
        if (type != null) {
            switch (type) {
                case "function": {
                    return Function.Type.FUNCTION;
                }
                case "receive": {
                    return Function.Type.RECEIVE;
                }
                case "fallback": {
                    return Function.Type.FALLBACK;
                }
                case "constructor": {
                    return Function.Type.CONSTRUCTOR;
                }
            }
            throw new IllegalArgumentException("unexpected type: \"" + type + "\"");
        }
        return Function.Type.FUNCTION;
    }

    private static TupleType parseTypes(JsonArray array) {
        if (array != null) {
            ABIType[] elementsArray = new ABIType[array.size()];
            for (int i = 0; i < elementsArray.length; ++i) {
                elementsArray[i] = ABIJSON.parseType(array.get(i).getAsJsonObject());
            }
            return TupleType.wrap((ABIType[])elementsArray);
        }
        return TupleType.EMPTY;
    }

    static Event parseEvent(JsonObject event) {
        String type = JsonUtils.getString(event, TYPE);
        if (EVENT.equals(type)) {
            JsonArray inputs = JsonUtils.getArray(event, INPUTS);
            if (inputs != null) {
                int inputsLen = inputs.size();
                ABIType[] inputsArray = new ABIType[inputsLen];
                boolean[] indexed = new boolean[inputsLen];
                for (int i = 0; i < inputsLen; ++i) {
                    JsonObject inputObj = inputs.get(i).getAsJsonObject();
                    inputsArray[i] = ABIJSON.parseType(inputObj);
                    indexed[i] = JsonUtils.getBoolean(inputObj, INDEXED);
                }
                return new Event(JsonUtils.getString(event, NAME), TupleType.wrap((ABIType[])inputsArray), indexed, JsonUtils.getBoolean(event, ANONYMOUS, false));
            }
            throw new IllegalArgumentException("array \"inputs\" null or not found");
        }
        throw new IllegalArgumentException("unexpected type: " + (type == null ? null : "\"" + type + "\""));
    }

    private static ABIType<?> parseType(JsonObject object) {
        String typeStr = JsonUtils.getString(object, TYPE);
        if (typeStr.startsWith(TUPLE)) {
            return TypeFactory.createFromBase(ABIJSON.parseTypes(JsonUtils.getArray(object, COMPONENTS)), typeStr.substring(TUPLE.length()), JsonUtils.getString(object, NAME));
        }
        return TypeFactory.create(typeStr, JsonUtils.getString(object, NAME));
    }

    public static String toJson(Object abiObj, boolean pretty) {
        return (pretty ? GSON_PRETTY : GSON).toJson(abiObj);
    }

    private static void writeJsonArray(JsonWriter out, String name, TupleType tupleType, boolean[] indexedManifest) throws IOException {
        out.name(name).beginArray();
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            ABIType<?> e = tupleType.elementTypes[i];
            out.beginObject();
            ABIJSON.addIfValueNotNull(out, NAME, e.getName());
            out.name(TYPE);
            String type = e.canonicalType;
            if (type.startsWith("(")) {
                out.value(type.replace(type.substring(0, type.lastIndexOf(41) + 1), TUPLE));
                ABIType<Object> base = e;
                while (base instanceof ArrayType) {
                    base = ((ArrayType)base).elementType;
                }
                ABIJSON.writeJsonArray(out, COMPONENTS, (TupleType)base, null);
            } else {
                out.value(type);
            }
            if (indexedManifest != null) {
                out.name(INDEXED).value(indexedManifest[i]);
            }
            out.endObject();
        }
        out.endArray();
    }

    private static void addIfValueNotNull(JsonWriter out, String key, String value) throws IOException {
        if (value != null) {
            out.name(key).value(value);
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        GSON = builder.registerTypeAdapter(Function.class, (Object)new FunctionAdapter()).registerTypeAdapter(Event.class, (Object)new EventAdapter()).create();
        GSON_PRETTY = builder.setPrettyPrinting().create();
    }

    private static class FunctionAdapter
    extends TypeAdapter<Function> {
        private FunctionAdapter() {
        }

        public void write(JsonWriter out, Function f) throws IOException {
            out.beginObject();
            Function.Type type = f.getType();
            out.name(ABIJSON.TYPE).value(type.toString());
            if (type != Function.Type.FALLBACK) {
                ABIJSON.addIfValueNotNull(out, ABIJSON.NAME, f.getName());
                if (type != Function.Type.RECEIVE) {
                    ABIJSON.writeJsonArray(out, ABIJSON.INPUTS, f.getParamTypes(), null);
                    if (type != Function.Type.CONSTRUCTOR) {
                        ABIJSON.writeJsonArray(out, ABIJSON.OUTPUTS, f.getOutputTypes(), null);
                    }
                }
            }
            String stateMutability = f.getStateMutability();
            ABIJSON.addIfValueNotNull(out, ABIJSON.STATE_MUTABILITY, stateMutability);
            out.name(ABIJSON.CONSTANT).value(ABIJSON.VIEW.equals(stateMutability) || ABIJSON.PURE.equals(stateMutability));
            out.endObject();
        }

        public Function read(JsonReader in) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EventAdapter
    extends TypeAdapter<Event> {
        private EventAdapter() {
        }

        public void write(JsonWriter out, Event e) throws IOException {
            out.beginObject();
            out.name(ABIJSON.TYPE).value(ABIJSON.EVENT);
            ABIJSON.addIfValueNotNull(out, ABIJSON.NAME, e.getName());
            ABIJSON.writeJsonArray(out, ABIJSON.INPUTS, e.getParams(), e.getIndexManifest());
            out.endObject();
        }

        public Event read(JsonReader in) {
            throw new UnsupportedOperationException();
        }
    }
}

