/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.Utils;
import java.nio.ByteBuffer;

public abstract class ABIType<J> {
    public static final int TYPE_CODE_BOOLEAN = 0;
    public static final int TYPE_CODE_BYTE = 1;
    public static final int TYPE_CODE_INT = 2;
    public static final int TYPE_CODE_LONG = 3;
    public static final int TYPE_CODE_BIG_INTEGER = 4;
    public static final int TYPE_CODE_BIG_DECIMAL = 5;
    public static final int TYPE_CODE_ARRAY = 6;
    public static final int TYPE_CODE_TUPLE = 7;
    public static final ABIType<?>[] EMPTY_TYPE_ARRAY = new ABIType[0];
    final String canonicalType;
    final Class<J> clazz;
    final boolean dynamic;
    private String name = null;

    ABIType(String canonicalType, Class<J> clazz, boolean dynamic) {
        this.canonicalType = canonicalType;
        this.clazz = clazz;
        this.dynamic = dynamic;
    }

    public final String getCanonicalType() {
        return this.canonicalType;
    }

    public final Class<J> clazz() {
        return this.clazz;
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    public final String getName() {
        return this.name;
    }

    final ABIType<J> setName(String name) {
        this.name = name;
        return this;
    }

    abstract String arrayClassName();

    public abstract int typeCode();

    abstract int byteLength(Object var1);

    abstract int byteLengthPacked(Object var1);

    public abstract int validate(Object var1);

    int encodeHead(Object value, ByteBuffer dest, int nextOffset) {
        if (!this.dynamic) {
            this.encodeTail(value, dest);
            return nextOffset;
        }
        return Encoding.insertOffset(nextOffset, dest, this.byteLength(value));
    }

    void encodeTail(Object value, ByteBuffer dest) {
        throw new UnsupportedOperationException();
    }

    abstract J decode(ByteBuffer var1, byte[] var2);

    public abstract J parseArgument(String var1);

    void validateClass(Object value) {
        if (!this.clazz.isInstance(value)) {
            if (value == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException("class mismatch: " + value.getClass().getName() + " not assignable to " + this.clazz.getName() + " (" + Utils.friendlyClassName(value.getClass()) + " not instanceof " + Utils.friendlyClassName(this.clazz) + "/" + this.canonicalType + ")");
        }
    }

    static byte[] newUnitBuffer() {
        return new byte[32];
    }

    public final int hashCode() {
        return this.canonicalType.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.canonicalType.equals(((ABIType)o).canonicalType);
    }

    public final String toString() {
        return this.canonicalType;
    }
}

