/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.abi.Utils;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public final class ArrayType<E extends ABIType<?>, J>
extends ABIType<J> {
    static final Class<byte[]> BYTE_ARRAY_CLASS = byte[].class;
    static final String BYTE_ARRAY_ARRAY_CLASS_NAME = byte[][].class.getName();
    static final Class<String> STRING_CLASS = String.class;
    static final String STRING_ARRAY_CLASS_NAME = String[].class.getName();
    private static final IntType ARRAY_LENGTH_TYPE = new IntType("int32", 32, false);
    private static final int ARRAY_LENGTH_BYTE_LEN = 32;
    static final int DYNAMIC_LENGTH = -1;
    final E elementType;
    final int length;
    private final boolean isString;
    private final String arrayClassName;

    ArrayType(String canonicalType, Class<J> clazz, boolean dynamic, E elementType, int length, String arrayClassName) {
        super(canonicalType, clazz, dynamic);
        this.elementType = elementType;
        this.length = length;
        this.arrayClassName = arrayClassName;
        this.isString = clazz == STRING_CLASS;
    }

    public E getElementType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isString() {
        return this.isString;
    }

    @Override
    String arrayClassName() {
        return this.arrayClassName;
    }

    @Override
    public int typeCode() {
        return 6;
    }

    @Override
    int byteLength(Object value) {
        int len;
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                len = ((boolean[])value).length * 32;
                break;
            }
            case 1: {
                len = Integers.roundLengthUp(this.byteCount(value), 32);
                break;
            }
            case 2: {
                len = ((int[])value).length * 32;
                break;
            }
            case 3: {
                len = ((long[])value).length * 32;
                break;
            }
            case 4: 
            case 5: {
                len = ((Number[])value).length * 32;
                break;
            }
            case 6: 
            case 7: {
                len = this.calcObjArrByteLen((Object[])value);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return this.length == -1 ? 32 + len : len;
    }

    private int calcObjArrByteLen(Object[] elements) {
        int len = 0;
        for (Object element : elements) {
            len += ((ABIType)this.elementType).byteLength(element);
        }
        return !((ABIType)this.elementType).dynamic ? len : len + elements.length * 32;
    }

    private int staticByteLengthPacked() {
        if (this.length != -1) {
            return this.length * ((ABIType)this.elementType).byteLengthPacked(null);
        }
        throw new IllegalArgumentException("array of dynamic elements");
    }

    @Override
    int byteLengthPacked(Object value) {
        if (value == null) {
            return this.staticByteLengthPacked();
        }
        E elementType = this.elementType;
        switch (((ABIType)elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length;
            }
            case 1: {
                return this.byteCount(value);
            }
            case 2: {
                return ((int[])value).length * ((ABIType)elementType).byteLengthPacked(null);
            }
            case 3: {
                return ((long[])value).length * ((ABIType)elementType).byteLengthPacked(null);
            }
            case 4: 
            case 5: {
                return ((Number[])value).length * ((ABIType)elementType).byteLengthPacked(null);
            }
            case 6: 
            case 7: {
                return this.calcObjArrPackedByteLen((Object[])value);
            }
        }
        throw new Error();
    }

    private int calcObjArrPackedByteLen(Object[] elements) {
        int packedLen = 0;
        for (Object element : elements) {
            packedLen += ((ABIType)this.elementType).byteLengthPacked(element);
        }
        return packedLen;
    }

    private int byteCount(Object value) {
        return ((byte[])this.decodeIfString(value)).length;
    }

    Object decodeIfString(Object value) {
        return !this.isString ? value : (Object)Strings.decode((String)value, 1);
    }

    Object encodeIfString(byte[] bytes) {
        return !this.isString ? bytes : (byte[])Strings.encode(bytes, 1);
    }

    @Override
    public int validate(Object value) {
        int staticLen;
        this.validateClass(value);
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                staticLen = this.checkLength(((boolean[])value).length, value) * 32;
                break;
            }
            case 1: {
                staticLen = Integers.roundLengthUp(this.checkLength(this.byteCount(value), value), 32);
                break;
            }
            case 2: {
                staticLen = this.validateIntArray((int[])value);
                break;
            }
            case 3: {
                staticLen = this.validateLongArray((long[])value);
                break;
            }
            case 4: {
                staticLen = this.validateBigIntegerArray((BigInteger[])value);
                break;
            }
            case 5: {
                staticLen = this.validateBigDecimalArray((BigDecimal[])value);
                break;
            }
            case 6: 
            case 7: {
                staticLen = this.validateObjectArray((Object[])value);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return this.length == -1 ? 32 + staticLen : staticLen;
    }

    private int validateIntArray(int[] arr) {
        int i;
        IntType intType = (IntType)this.elementType;
        int len = arr.length;
        this.checkLength(len, arr);
        try {
            for (i = 0; i < len; ++i) {
                intType.validatePrimitive(arr[i]);
            }
        }
        catch (IllegalArgumentException iae) {
            throw ArrayType.abiException(iae, i);
        }
        return len * 32;
    }

    private int validateLongArray(long[] arr) {
        int i;
        LongType longType = (LongType)this.elementType;
        int len = arr.length;
        this.checkLength(len, arr);
        try {
            for (i = 0; i < len; ++i) {
                longType.validatePrimitive(arr[i]);
            }
        }
        catch (IllegalArgumentException iae) {
            throw ArrayType.abiException(iae, i);
        }
        return len * 32;
    }

    private int validateBigIntegerArray(BigInteger[] arr) {
        int i;
        int len = arr.length;
        this.checkLength(len, arr);
        BigIntegerType bigIntegerType = (BigIntegerType)this.elementType;
        try {
            for (i = 0; i < len; ++i) {
                bigIntegerType.validateBigInt(arr[i]);
            }
        }
        catch (IllegalArgumentException iae) {
            throw ArrayType.abiException(iae, i);
        }
        return len * 32;
    }

    private int validateBigDecimalArray(BigDecimal[] arr) {
        int i;
        int len = arr.length;
        this.checkLength(len, arr);
        BigDecimalType bigDecimalType = (BigDecimalType)this.elementType;
        try {
            for (i = 0; i < len; ++i) {
                BigDecimal element = arr[i];
                bigDecimalType.validateBigInt(element.unscaledValue());
                if (element.scale() == bigDecimalType.scale) continue;
                throw new IllegalArgumentException(String.format("big decimal scale mismatch: actual != expected: %d != %d", element.scale(), bigDecimalType.scale));
            }
        }
        catch (IllegalArgumentException iae) {
            throw ArrayType.abiException(iae, i);
        }
        return len * 32;
    }

    private static IllegalArgumentException abiException(IllegalArgumentException iae, int i) {
        return new IllegalArgumentException("array index " + i + ": " + iae.getMessage());
    }

    private int validateObjectArray(Object[] arr) {
        int len = arr.length;
        this.checkLength(len, arr);
        int byteLength = !((ABIType)this.elementType).dynamic ? 0 : len * 32;
        for (int i = 0; i < len; ++i) {
            byteLength += ((ABIType)this.elementType).validate(arr[i]);
        }
        return byteLength;
    }

    private int checkLength(int valueLength, Object value) {
        if (this.length == -1 || this.length == valueLength) {
            return valueLength;
        }
        throw new IllegalArgumentException(Utils.friendlyClassName(value.getClass(), valueLength) + " not instanceof " + Utils.friendlyClassName(this.clazz, this.length) + ", " + valueLength + " != " + this.length);
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        this.encodeArrayTail(this.decodeIfString(value), dest);
    }

    private void insert(Supplier<Integer> supplyLength, Runnable insert, ByteBuffer dest) {
        if (this.length == -1) {
            Encoding.insertInt(supplyLength.get().intValue(), dest);
        }
        insert.run();
    }

    private void encodeArrayTail(Object v, ByteBuffer dest) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                boolean[] z = (boolean[])v;
                this.insert(() -> z.length, () -> ArrayType.insertBooleans(z, dest), dest);
                return;
            }
            case 1: {
                byte[] b = (byte[])v;
                this.insert(() -> b.length, () -> Encoding.insertBytesPadded(b, dest), dest);
                return;
            }
            case 2: {
                int[] i = (int[])v;
                this.insert(() -> i.length, () -> ArrayType.insertInts(i, dest), dest);
                return;
            }
            case 3: {
                long[] j = (long[])v;
                this.insert(() -> j.length, () -> ArrayType.insertLongs(j, dest), dest);
                return;
            }
            case 4: {
                BigInteger[] bi = (BigInteger[])v;
                this.insert(() -> bi.length, () -> Encoding.insertBigIntegers(bi, 32, dest), dest);
                return;
            }
            case 5: {
                BigDecimal[] bd = (BigDecimal[])v;
                this.insert(() -> bd.length, () -> Encoding.insertBigDecimals(bd, 32, dest), dest);
                return;
            }
            case 6: 
            case 7: {
                Object[] objects = (Object[])v;
                if (this.dynamic) {
                    this.insert(() -> objects.length, () -> this.insertOffsets(objects, dest), dest);
                }
                for (Object object : objects) {
                    ((ABIType)this.elementType).encodeTail(object, dest);
                }
                return;
            }
        }
        throw new Error();
    }

    private void insertOffsets(Object[] objects, ByteBuffer dest) {
        if (((ABIType)this.elementType).dynamic) {
            int nextOffset = objects.length * 32;
            for (Object object : objects) {
                nextOffset = Encoding.insertOffset(nextOffset, dest, ((ABIType)this.elementType).byteLength(object));
            }
        }
    }

    private static void insertBooleans(boolean[] bools, ByteBuffer dest) {
        for (boolean e : bools) {
            dest.put(e ? BooleanType.BOOLEAN_TRUE : BooleanType.BOOLEAN_FALSE);
        }
    }

    private static void insertInts(int[] ints, ByteBuffer dest) {
        for (int e : ints) {
            Encoding.insertInt(e, dest);
        }
    }

    private static void insertLongs(long[] longs, ByteBuffer dest) {
        for (long e : longs) {
            Encoding.insertInt(e, dest);
        }
    }

    @Override
    J decode(ByteBuffer bb, byte[] unitBuffer) {
        int arrayLen = this.length == -1 ? ARRAY_LENGTH_TYPE.decode(bb, unitBuffer) : this.length;
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return (J)ArrayType.decodeBooleanArray(bb, arrayLen, unitBuffer);
            }
            case 1: {
                return (J)this.decodeByteArray(bb, arrayLen);
            }
            case 2: {
                return (J)ArrayType.decodeIntArray((IntType)this.elementType, bb, arrayLen, unitBuffer);
            }
            case 3: {
                return (J)ArrayType.decodeLongArray((LongType)this.elementType, bb, arrayLen, unitBuffer);
            }
            case 4: {
                return (J)ArrayType.decodeBigIntegerArray((BigIntegerType)this.elementType, bb, arrayLen, unitBuffer);
            }
            case 5: {
                return (J)ArrayType.decodeBigDecimalArray((BigDecimalType)this.elementType, bb, arrayLen, unitBuffer);
            }
            case 6: 
            case 7: {
                return (J)this.decodeObjectArray(arrayLen, bb, unitBuffer);
            }
        }
        throw new Error();
    }

    private static boolean[] decodeBooleanArray(ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        boolean[] booleans = new boolean[arrayLen];
        int booleanOffset = 31;
        for (int i = 0; i < arrayLen; ++i) {
            bb.get(unitBuffer);
            for (int j = 0; j < 31; ++j) {
                if (unitBuffer[j] == 0) continue;
                throw new IllegalArgumentException("illegal boolean value @ " + (bb.position() - j));
            }
            byte last = unitBuffer[31];
            if (last == 1) {
                booleans[i] = true;
                continue;
            }
            if (last == 0) continue;
            throw new IllegalArgumentException("illegal boolean value @ " + (bb.position() - 32));
        }
        return booleans;
    }

    private Object decodeByteArray(ByteBuffer bb, int arrayLen) {
        int mark = bb.position();
        byte[] out = new byte[arrayLen];
        bb.get(out);
        bb.position(mark + Integers.roundLengthUp(arrayLen, 32));
        return this.encodeIfString(out);
    }

    private static int[] decodeIntArray(IntType intType, ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        int[] ints = new int[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            ints[i] = ArrayType.decodeBigIntElement(intType, bb, unitBuffer).intValue();
        }
        return ints;
    }

    private static long[] decodeLongArray(LongType longType, ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        long[] longs = new long[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            longs[i] = ArrayType.decodeBigIntElement(longType, bb, unitBuffer).longValue();
        }
        return longs;
    }

    private static BigInteger[] decodeBigIntegerArray(BigIntegerType bigIntegerType, ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        BigInteger[] bigInts = new BigInteger[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            bigInts[i] = ArrayType.decodeBigIntElement(bigIntegerType, bb, unitBuffer);
        }
        return bigInts;
    }

    private static BigDecimal[] decodeBigDecimalArray(BigDecimalType bigDecimalType, ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        BigDecimal[] bigDecs = new BigDecimal[arrayLen];
        int scale = bigDecimalType.scale;
        for (int i = 0; i < arrayLen; ++i) {
            bigDecs[i] = new BigDecimal(ArrayType.decodeBigIntElement(bigDecimalType, bb, unitBuffer), scale);
        }
        return bigDecs;
    }

    private static BigInteger decodeBigIntElement(UnitType<?> type, ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer);
        BigInteger bi = new BigInteger(unitBuffer);
        type.validateBigInt(bi);
        return bi;
    }

    private Object[] decodeObjectArray(int len, ByteBuffer bb, byte[] unitBuffer) {
        Object[] dest = (Object[])Array.newInstance(((ABIType)this.elementType).clazz, len);
        if (!this.dynamic || !((ABIType)this.elementType).dynamic) {
            for (int i = 0; i < len; ++i) {
                dest[i] = ((ABIType)this.elementType).decode(bb, unitBuffer);
            }
        } else {
            int i;
            int[] offsets = new int[len];
            for (i = 0; i < len; ++i) {
                offsets[i] = Encoding.OFFSET_TYPE.decode(bb, unitBuffer);
            }
            for (i = 0; i < len; ++i) {
                if (offsets[i] <= 0) continue;
                dest[i] = ((ABIType)this.elementType).decode(bb, unitBuffer);
            }
        }
        return dest;
    }

    @Override
    public J parseArgument(String s) {
        throw new UnsupportedOperationException();
    }
}

