/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class BaseTypeInfo {
    private static final int ADDRESS_BIT_LEN = 160;
    static final int DECIMAL_BIT_LEN = 128;
    static final int DECIMAL_SCALE = 10;
    static final int FIXED_BIT_LEN = 128;
    static final int FIXED_SCALE = 18;
    private static final int FUNCTION_BYTE_LEN = 24;
    private static final int N_A = -1;
    private static final Map<String, BaseTypeInfo> TYPE_INFO_MAP;
    final int bitLen;
    final int arrayLen;

    private BaseTypeInfo(int bitLen) {
        this(bitLen, -1);
    }

    private BaseTypeInfo(int bitLen, int arrayLen) {
        this.bitLen = bitLen;
        this.arrayLen = arrayLen;
    }

    static BaseTypeInfo get(String canonical) {
        return TYPE_INFO_MAP.get(canonical);
    }

    static Map<String, BaseTypeInfo> getBaseTypeInfoMap() {
        return TYPE_INFO_MAP;
    }

    public int hashCode() {
        return Objects.hash(this.bitLen, this.arrayLen);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTypeInfo that = (BaseTypeInfo)o;
        return this.bitLen == that.bitLen && this.arrayLen == that.arrayLen;
    }

    static {
        int n;
        HashMap<String, BaseTypeInfo> map = new HashMap<String, BaseTypeInfo>(256);
        for (n = 8; n <= 256; n += 8) {
            BaseTypeInfo info = new BaseTypeInfo(n);
            map.put("int" + n, info);
            map.put("uint" + n, info);
        }
        map.put("int", (BaseTypeInfo)map.get("int256"));
        map.put("uint", (BaseTypeInfo)map.get("uint256"));
        for (n = 1; n <= 32; ++n) {
            map.put("bytes" + n, new BaseTypeInfo(-1, n));
        }
        map.put("function", (BaseTypeInfo)map.get("bytes24"));
        BaseTypeInfo present = new BaseTypeInfo(-1, -1);
        map.put("bytes", present);
        map.put("string", present);
        map.put("address", new BaseTypeInfo(160));
        map.put("decimal", new BaseTypeInfo(128));
        map.put("bool", present);
        BaseTypeInfo fixedType = new BaseTypeInfo(128);
        map.put("fixed", fixedType);
        map.put("ufixed", fixedType);
        map.put("fixed128x18", fixedType);
        map.put("ufixed128x18", fixedType);
        TYPE_INFO_MAP = Collections.unmodifiableMap(map);
    }
}

