/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class BooleanType
extends UnitType<Boolean> {
    private static final String ARRAY_CLASS_NAME = boolean[].class.getName();
    static final byte[] BOOLEAN_FALSE = new byte[32];
    static final byte[] BOOLEAN_TRUE = new byte[32];

    BooleanType() {
        super("bool", Boolean.class, 1, true);
    }

    @Override
    String arrayClassName() {
        return ARRAY_CLASS_NAME;
    }

    @Override
    public int typeCode() {
        return 0;
    }

    @Override
    int byteLengthPacked(Object value) {
        return 1;
    }

    @Override
    public int validate(Object value) {
        this.validateClass(value);
        return 32;
    }

    @Override
    int encodeHead(Object value, ByteBuffer dest, int offset) {
        dest.put((Boolean)value != false ? BOOLEAN_TRUE : BOOLEAN_FALSE);
        return offset;
    }

    @Override
    Boolean decode(ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer);
        BigInteger bi = new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return BooleanType.decodeBoolean(bi.byteValue());
    }

    static Boolean decodeBoolean(byte b) {
        return b == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public Boolean parseArgument(String s) {
        Boolean bool = Boolean.parseBoolean(s);
        this.validate(bool);
        return bool;
    }

    static {
        BooleanType.BOOLEAN_TRUE[BooleanType.BOOLEAN_TRUE.length - 1] = 1;
    }
}

