/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class ByteType
extends UnitType<Byte> {
    private static final String ARRAY_CLASS_NAME = byte[].class.getName();
    static final ByteType UNSIGNED = new ByteType("uint8", true);

    private ByteType(String canonicalType, boolean unsigned) {
        super(canonicalType, Byte.class, 8, unsigned);
    }

    @Override
    String arrayClassName() {
        return ARRAY_CLASS_NAME;
    }

    @Override
    public int typeCode() {
        return 1;
    }

    @Override
    int byteLengthPacked(Object value) {
        return 1;
    }

    @Override
    public int validate(Object value) {
        this.validateClass(value);
        return 32;
    }

    @Override
    Byte decode(ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer);
        BigInteger bi = new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return bi.byteValue();
    }

    @Override
    public Byte parseArgument(String s) {
        Byte b = Byte.parseByte(s);
        this.validate(b);
        return b;
    }
}

