/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class Encoding {
    static final int OFFSET_LENGTH_BYTES = 32;
    static final IntType OFFSET_TYPE = new IntType("int32", 32, false);
    private static final byte NEGATIVE_ONE_BYTE = -1;
    static final byte ZERO_BYTE = 0;
    static final byte ONE_BYTE = 1;
    private static final byte[] CACHED_ZERO_PADDING = new byte[32];
    private static final byte[] CACHED_NEG1_PADDING = new byte[32];
    private static final byte[] NON_NEGATIVE_INT_PADDING;
    private static final byte[] NEGATIVE_INT_PADDING;

    Encoding() {
    }

    static int insertOffset(int offset, ByteBuffer dest, int tailByteLen) {
        Encoding.insertInt(offset, dest);
        return offset + tailByteLen;
    }

    static void insertInt(long val, ByteBuffer dest) {
        dest.put(val >= 0L ? NON_NEGATIVE_INT_PADDING : NEGATIVE_INT_PADDING);
        dest.putLong(val);
    }

    static void insertInt(BigInteger signed, int paddedLen, ByteBuffer dest) {
        byte[] arr = signed.toByteArray();
        int arrLen = arr.length;
        if (arrLen <= 32) {
            Encoding.insertPadding(paddedLen - arrLen, signed.signum() < 0, dest);
            dest.put(arr);
        } else {
            dest.put(arr, 1, 32);
        }
    }

    static void insertBytesPadded(byte[] bytes, ByteBuffer dest) {
        dest.put(bytes);
        int rem = Integers.mod(bytes.length, 32);
        Encoding.insertPadding(rem != 0 ? 32 - rem : 0, false, dest);
    }

    static void insertPadding(int n, boolean negativeOnes, ByteBuffer dest) {
        dest.put(!negativeOnes ? CACHED_ZERO_PADDING : CACHED_NEG1_PADDING, 0, n);
    }

    static void insertBigIntegers(BigInteger[] arr, int byteLen, ByteBuffer dest) {
        for (BigInteger e : arr) {
            Encoding.insertInt(e, byteLen, dest);
        }
    }

    static void insertBigDecimals(BigDecimal[] arr, int byteLen, ByteBuffer dest) {
        for (BigDecimal e : arr) {
            Encoding.insertInt(e.unscaledValue(), byteLen, dest);
        }
    }

    static {
        Arrays.fill(CACHED_NEG1_PADDING, (byte)-1);
        NON_NEGATIVE_INT_PADDING = new byte[24];
        NEGATIVE_INT_PADDING = Arrays.copyOfRange(CACHED_NEG1_PADDING, 0, 24);
    }
}

