/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.JsonUtils;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;

public final class Event
implements ABIObject {
    private final String name;
    private final TupleType inputs;
    private final boolean[] indexManifest;
    private final boolean anonymous;

    public Event(String name, String paramsString, boolean[] indexed) {
        this(name, paramsString, indexed, false);
    }

    public Event(String name, String paramsString, boolean[] indexed, boolean anonymous) {
        this(name, TupleType.parse(paramsString), indexed, anonymous);
    }

    public Event(String name, TupleType params, boolean[] indexed, boolean anonymous) {
        this.name = Objects.requireNonNull(name);
        this.inputs = Objects.requireNonNull(params);
        if (indexed.length != this.inputs.elementTypes.length) {
            throw new IllegalArgumentException("indexed.length doesn't match number of inputs");
        }
        this.indexManifest = Arrays.copyOf(indexed, indexed.length);
        this.anonymous = anonymous;
    }

    public String getName() {
        return this.name;
    }

    public TupleType getParams() {
        return this.inputs;
    }

    public boolean[] getIndexManifest() {
        return Arrays.copyOf(this.indexManifest, this.indexManifest.length);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String signature() {
        return this.name + this.inputs.canonicalType;
    }

    public TupleType getIndexedParams() {
        return this.inputs.subTupleType(this.indexManifest);
    }

    public TupleType getNonIndexedParams() {
        return this.inputs.subTupleType(this.indexManifest, true);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.inputs.hashCode();
        result = 31 * result + Arrays.hashCode(this.indexManifest);
        result = 31 * result + (this.anonymous ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.anonymous != event.anonymous) {
            return false;
        }
        if (!this.name.equals(event.name)) {
            return false;
        }
        if (!this.inputs.equals(event.inputs)) {
            return false;
        }
        return Arrays.equals(this.indexManifest, event.indexManifest);
    }

    public static Event fromJson(String eventJson) {
        return Event.fromJsonObject(JsonUtils.parseObject(eventJson));
    }

    public static Event fromJsonObject(JsonObject event) {
        return ABIJSON.parseEvent(event);
    }

    @Override
    public String toJson(boolean pretty) {
        return ABIJSON.toJson(this, pretty);
    }

    public String toString() {
        return this.toJson(true);
    }
}

