/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.abi.Utils;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.JsonUtils;
import com.esaulpaugh.headlong.util.Strings;
import com.google.gson.JsonObject;
import com.joemelsha.crypto.hash.Keccak;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Function
implements ABIObject {
    private static final Pattern ALL_ASCII_NO_OPEN_PAREN = Pattern.compile("^[[^(]&&\\p{ASCII}]*$");
    private static final Pattern OPEN_PAREN_OR_NON_ASCII = Pattern.compile("[([^\\p{ASCII}]]");
    public static final int SELECTOR_LEN = 4;
    private final Type type;
    private final String name;
    private final TupleType inputTypes;
    private final TupleType outputTypes;
    private final String stateMutability;
    private final byte[] selector = new byte[4];
    private final String hashAlgorithm;

    public Function(String signature) {
        this(signature, null);
    }

    public Function(String signature, String outputs) {
        this(Type.FUNCTION, signature, outputs, Function.newDefaultDigest());
    }

    public Function(String signature, String outputs, MessageDigest messageDigest) {
        this(Type.FUNCTION, signature, outputs, messageDigest);
    }

    public Function(Type type, String signature, String outputs, MessageDigest messageDigest) {
        int split = signature.indexOf(40);
        if (split >= 0) {
            try {
                this.inputTypes = (TupleType)TypeFactory.create(signature.substring(split), null);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("illegal signature termination", cce);
            }
        } else {
            throw new IllegalArgumentException("params start not found");
        }
        this.type = Objects.requireNonNull(type);
        String name = Utils.regexValidate(ALL_ASCII_NO_OPEN_PAREN, OPEN_PAREN_OR_NON_ASCII, signature.substring(0, split));
        this.name = name.isEmpty() && (type == Type.FALLBACK || type == Type.CONSTRUCTOR) ? null : name;
        this.outputTypes = outputs != null ? TupleType.parse(outputs) : TupleType.EMPTY;
        this.stateMutability = null;
        this.hashAlgorithm = messageDigest.getAlgorithm();
        this.validateFunction();
        this.generateSelector(messageDigest);
    }

    public Function(Type type, String name, TupleType inputTypes, TupleType outputTypes, String stateMutability, MessageDigest messageDigest) {
        this.type = Objects.requireNonNull(type);
        this.name = name != null ? Utils.regexValidate(ALL_ASCII_NO_OPEN_PAREN, OPEN_PAREN_OR_NON_ASCII, name) : null;
        this.inputTypes = Objects.requireNonNull(inputTypes);
        this.outputTypes = Objects.requireNonNull(outputTypes);
        this.stateMutability = stateMutability;
        this.hashAlgorithm = messageDigest.getAlgorithm();
        this.validateFunction();
        this.generateSelector(messageDigest);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public TupleType getParamTypes() {
        return this.inputTypes;
    }

    public TupleType getOutputTypes() {
        return this.outputTypes;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public byte[] selector() {
        return Arrays.copyOf(this.selector, this.selector.length);
    }

    public String selectorHex() {
        return Strings.encode(this.selector);
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getCanonicalSignature() {
        return this.name != null ? this.name + this.inputTypes.canonicalType : this.inputTypes.canonicalType;
    }

    private void validateFunction() {
        switch (this.type) {
            case FUNCTION: {
                if (this.name != null) break;
                throw Function.nameNullabilityException(false);
            }
            case RECEIVE: {
                if (!"receive".equals(this.name)) {
                    throw new IllegalArgumentException("functions of this type must be named \"receive\"");
                }
                if (!"payable".equals(this.stateMutability)) {
                    throw new IllegalArgumentException("functions of this type must be payable");
                }
            }
            case FALLBACK: {
                Function.assertNoElements(this.inputTypes, "inputs");
            }
            case CONSTRUCTOR: {
                Function.assertNoElements(this.outputTypes, "outputs");
                if (this.type == Type.RECEIVE || this.name == null) break;
                throw Function.nameNullabilityException(true);
            }
        }
    }

    private static IllegalArgumentException nameNullabilityException(boolean mustBeNull) {
        return new IllegalArgumentException("functions of this type must be " + (mustBeNull ? "un" : "") + "named");
    }

    private static void assertNoElements(TupleType tupleType, String description) {
        if (tupleType.elementTypes.length > 0) {
            throw new IllegalArgumentException("functions of this type cannot have " + description);
        }
    }

    private void generateSelector(MessageDigest messageDigest) {
        messageDigest.reset();
        messageDigest.update(Strings.decode(this.getCanonicalSignature(), 1));
        try {
            messageDigest.digest(this.selector, 0, 4);
        }
        catch (DigestException de) {
            throw new RuntimeException(de);
        }
    }

    public int measureCallLength(Tuple args) {
        return 4 + this.inputTypes.measureEncodedLength(args);
    }

    public ByteBuffer encodeCallWithArgs(Object ... args) {
        return this.encodeCall(new Tuple(args));
    }

    public ByteBuffer encodeCall(Tuple args) {
        ByteBuffer dest = ByteBuffer.wrap(new byte[this.measureCallLength(args)]);
        this.encodeCall(args, dest);
        return dest;
    }

    public Function encodeCall(Tuple args, ByteBuffer dest) {
        this.inputTypes.validate(args);
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
        return this;
    }

    public Tuple decodeCall(byte[] array) {
        return this.decodeCall(ByteBuffer.wrap(array));
    }

    public Tuple decodeCall(ByteBuffer abiBuffer) {
        byte[] unitBuffer = ABIType.newUnitBuffer();
        abiBuffer.get(unitBuffer, 0, 4);
        for (int i = 0; i < 4; ++i) {
            if (unitBuffer[i] == this.selector[i]) continue;
            throw new IllegalArgumentException("given selector does not match: expected: " + this.selectorHex() + ", found: " + Strings.encode(unitBuffer, 0, 4, 0));
        }
        return this.inputTypes.decode(abiBuffer, unitBuffer);
    }

    public Tuple decodeReturn(byte[] returnVals) {
        return this.outputTypes.decode(returnVals);
    }

    public Tuple decodeReturn(ByteBuffer returnVals) {
        return this.outputTypes.decode(returnVals);
    }

    public int hashCode() {
        return 31 * Objects.hash(new Object[]{this.type, this.name, this.inputTypes, this.outputTypes, this.hashAlgorithm, this.stateMutability}) + Arrays.hashCode(this.selector);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Function function = (Function)o;
        return this.type == function.type && Objects.equals(this.name, function.name) && this.inputTypes.equals(function.inputTypes) && this.outputTypes.equals(function.outputTypes) && Arrays.equals(this.selector, function.selector) && this.hashAlgorithm.equals(function.hashAlgorithm) && Objects.equals(this.stateMutability, function.stateMutability);
    }

    public String toString() {
        return this.toJson(true);
    }

    @Override
    public String toJson(boolean pretty) {
        return ABIJSON.toJson(this, pretty);
    }

    public static Function parse(String signature) {
        return new Function(signature);
    }

    public static Function parse(String signature, MessageDigest messageDigest) {
        return new Function(signature, null, messageDigest);
    }

    public static Function fromJson(String objectJson) {
        return Function.fromJsonObject(JsonUtils.parseObject(objectJson));
    }

    public static Function fromJson(String objectJson, MessageDigest messageDigest) {
        return Function.fromJsonObject(JsonUtils.parseObject(objectJson), messageDigest);
    }

    public static Function fromJsonObject(JsonObject function) {
        return Function.fromJsonObject(function, Function.newDefaultDigest());
    }

    public static Function fromJsonObject(JsonObject function, MessageDigest messageDigest) {
        return ABIJSON.parseFunction(function, messageDigest);
    }

    public static MessageDigest newDefaultDigest() {
        return new Keccak(256);
    }

    public static String formatCall(byte[] abiCall) {
        return Function.formatCall(abiCall, 0, abiCall.length);
    }

    public static String formatCall(byte[] buffer, int offset, int length) {
        return Function.formatCall(buffer, offset, length, new TupleType.LabelMaker());
    }

    public static String formatCall(byte[] buffer, int offset, int length, TupleType.LabelMaker labelMaker) {
        Integers.checkIsMultiple(length - 4, 32);
        StringBuilder sb = new StringBuilder();
        sb.append("ID");
        int n = 9 - "ID".length();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        sb.append(Strings.encode(buffer, offset, 4, 0));
        for (int idx = offset + 4; idx < length; idx += 32) {
            sb.append('\n');
            sb.append(labelMaker.make(idx));
            sb.append(Strings.encode(buffer, idx, 32, 0));
        }
        return sb.toString();
    }

    public static enum Type {
        FUNCTION,
        RECEIVE,
        FALLBACK,
        CONSTRUCTOR;


        public String toString() {
            return Type.toString(this);
        }

        public static String toString(Type type) {
            switch (type) {
                case FUNCTION: {
                    return "function";
                }
                case RECEIVE: {
                    return "receive";
                }
                case FALLBACK: {
                    return "fallback";
                }
                case CONSTRUCTOR: {
                    return "constructor";
                }
            }
            throw new Error();
        }
    }
}

