/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class IntType
extends UnitType<Integer> {
    private static final String ARRAY_CLASS_NAME = int[].class.getName();

    IntType(String canonicalType, int bitLength, boolean unsigned) {
        super(canonicalType, Integer.class, bitLength, unsigned);
    }

    @Override
    String arrayClassName() {
        return ARRAY_CLASS_NAME;
    }

    @Override
    public int typeCode() {
        return 2;
    }

    @Override
    Integer decode(ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer);
        BigInteger bi = new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return bi.intValue();
    }

    @Override
    public Integer parseArgument(String s) {
        Integer in = Integer.parseInt(s);
        this.validate(in);
        return in;
    }
}

