/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class LongType
extends UnitType<Long> {
    private static final String ARRAY_CLASS_NAME = long[].class.getName();

    LongType(String canonicalType, int bitLength, boolean unsigned) {
        super(canonicalType, Long.class, bitLength, unsigned);
    }

    @Override
    String arrayClassName() {
        return ARRAY_CLASS_NAME;
    }

    @Override
    public int typeCode() {
        return 3;
    }

    @Override
    Long decode(ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer);
        BigInteger bi = new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return bi.longValue();
    }

    @Override
    public Long parseArgument(String s) {
        Long lo = Long.parseLong(s);
        this.validate(lo);
        return lo;
    }
}

