/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.util.Uint;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public final class PackedDecoder {
    public static Tuple decode(TupleType types, byte[] buffer) {
        return PackedDecoder.decode(types, buffer, 0, buffer.length);
    }

    public static Tuple decode(TupleType tupleType, byte[] buffer, int from, int to) {
        if (PackedDecoder.countDynamicsTupleType(tupleType) <= 1) {
            Object[] elements = new Tuple[1];
            PackedDecoder.decodeTuple(tupleType, buffer, from, to, elements, 0);
            Object tuple = elements[0];
            tupleType.validate(tuple);
            return tuple;
        }
        throw new IllegalArgumentException("multiple dynamic elements");
    }

    private static int countDynamicsTupleType(TupleType tupleType) {
        int numDynamic = 0;
        for (ABIType<?> e : tupleType) {
            numDynamic += !e.dynamic ? 0 : (7 == e.typeCode() ? PackedDecoder.countDynamicsTupleType((TupleType)e) : PackedDecoder.countDynamicsArrayType(e));
        }
        return numDynamic;
    }

    private static int countDynamicsArrayType(ABIType<?> type) {
        ArrayType arrayType;
        int numDynamic = 0;
        do {
            arrayType = (ArrayType)type;
            if (-1 != arrayType.length) continue;
            ++numDynamic;
        } while (6 == (type = arrayType.elementType).typeCode());
        if (7 == type.typeCode()) {
            numDynamic += PackedDecoder.countDynamicsTupleType((TupleType)type);
        }
        return numDynamic;
    }

    private static int decodeTuple(TupleType tupleType, byte[] buffer, int start, int end, Object[] parentElements, int pei) {
        int i;
        ABIType<?>[] elementTypes = tupleType.elementTypes;
        int len = elementTypes.length;
        Object[] elements = new Object[len];
        int mark = -1;
        for (i = len - 1; i >= 0; --i) {
            ABIType<?> type = elementTypes[i];
            if (type.dynamic) {
                mark = i;
                break;
            }
            int typeCode = type.typeCode();
            if (6 == typeCode) {
                ArrayType arrayType = (ArrayType)type;
                PackedDecoder.decodeArray(arrayType, buffer, end -= ((ABIType)arrayType.elementType).byteLengthPacked(null) * arrayType.length, end, elements, i);
                continue;
            }
            if (7 == typeCode) {
                TupleType inner = (TupleType)type;
                int innerLen = inner.byteLengthPacked(null);
                end -= PackedDecoder.decodeTupleStatic(inner, buffer, end - innerLen, end, elements, i);
                continue;
            }
            end -= PackedDecoder.decode(elementTypes[i], buffer, end - type.byteLengthPacked(null), end, elements, i);
        }
        if (mark > -1) {
            for (i = 0; i <= mark; ++i) {
                start += PackedDecoder.decode(elementTypes[i], buffer, start, end, elements, i);
            }
        }
        parentElements[pei] = new Tuple(elements);
        return tupleType.byteLengthPacked(parentElements[pei]);
    }

    private static int decode(ABIType<?> type, byte[] buffer, int idx, int end, Object[] elements, int i) {
        switch (type.typeCode()) {
            case 0: {
                elements[i] = BooleanType.decodeBoolean(buffer[idx]);
                return type.byteLengthPacked(null);
            }
            case 1: {
                elements[i] = buffer[idx];
                return type.byteLengthPacked(null);
            }
            case 2: {
                return PackedDecoder.decodeInt(type.byteLengthPacked(null), (IntType)type, buffer, idx, elements, i);
            }
            case 3: {
                return PackedDecoder.decodeLong(type.byteLengthPacked(null), (LongType)type, buffer, idx, elements, i);
            }
            case 4: {
                return PackedDecoder.decodeBigInteger(type.byteLengthPacked(null), buffer, idx, elements, i);
            }
            case 5: {
                return PackedDecoder.decodeBigDecimal(type.byteLengthPacked(null), ((BigDecimalType)type).scale, buffer, idx, elements, i);
            }
            case 6: {
                return PackedDecoder.decodeArray((ArrayType)type, buffer, idx, end, elements, i);
            }
            case 7: {
                return type.dynamic ? PackedDecoder.decodeTuple((TupleType)type, buffer, idx, end, elements, i) : PackedDecoder.decodeTupleStatic((TupleType)type, buffer, idx, end, elements, i);
            }
        }
        throw new Error();
    }

    private static int decodeTupleStatic(TupleType tupleType, byte[] buffer, int idx, int end, Object[] parentElements, int pei) {
        ABIType<?>[] elementTypes = tupleType.elementTypes;
        int len = elementTypes.length;
        Object[] elements = new Object[len];
        for (int i = 0; i < len; ++i) {
            idx += PackedDecoder.decode(elementTypes[i], buffer, idx, end, elements, i);
        }
        parentElements[pei] = new Tuple(elements);
        return tupleType.byteLengthPacked(parentElements[pei]);
    }

    private static int decodeInt(int elementLen, IntType intType, byte[] buffer, int idx, Object[] dest, int destIdx) {
        int signed = PackedDecoder.getPackedInt(buffer, idx, elementLen);
        dest[destIdx] = intType.unsigned ? (int)new Uint(intType.getBitLength()).toUnsignedLong(signed) : signed;
        return elementLen;
    }

    private static int decodeLong(int elementLen, LongType longType, byte[] buffer, int idx, Object[] dest, int destIdx) {
        long signed = PackedDecoder.getPackedLong(buffer, idx, elementLen);
        dest[destIdx] = longType.unsigned ? new Uint(longType.getBitLength()).toUnsignedLong(signed) : signed;
        return elementLen;
    }

    private static int decodeBigInteger(int elementLen, byte[] buffer, int idx, Object[] dest, int destIdx) {
        BigInteger val = new BigInteger(Arrays.copyOfRange(buffer, idx, idx + elementLen));
        dest[destIdx] = val;
        return elementLen;
    }

    private static int decodeBigDecimal(int elementLen, int scale, byte[] buffer, int idx, Object[] dest, int destIdx) {
        BigInteger unscaled = new BigInteger(Arrays.copyOfRange(buffer, idx, idx + elementLen));
        dest[destIdx] = new BigDecimal(unscaled, scale);
        return elementLen;
    }

    private static int decodeArray(ArrayType<? extends ABIType<?>, ?> arrayType, byte[] buffer, int idx, int end, Object[] dest, int destIdx) {
        Object array;
        int arrayLen;
        Object elementType = arrayType.elementType;
        int elementByteLen = ((ABIType)elementType).byteLengthPacked(null);
        if (arrayType.length == -1) {
            if (elementByteLen == 0) {
                throw new IllegalArgumentException("can't decode dynamic number of zero-length elements");
            }
            arrayLen = (end - idx) / elementByteLen;
        } else {
            arrayLen = arrayType.length;
        }
        switch (((ABIType)elementType).typeCode()) {
            case 0: {
                array = PackedDecoder.decodeBooleanArray(arrayLen, buffer, idx);
                break;
            }
            case 1: {
                array = arrayType.encodeIfString(PackedDecoder.decodeByteArray(arrayLen, buffer, idx));
                break;
            }
            case 2: {
                array = PackedDecoder.decodeIntArray((IntType)elementType, elementByteLen, arrayLen, buffer, idx);
                break;
            }
            case 3: {
                array = PackedDecoder.decodeLongArray((LongType)elementType, elementByteLen, arrayLen, buffer, idx);
                break;
            }
            case 4: {
                array = PackedDecoder.decodeBigIntegerArray(elementByteLen, arrayLen, buffer, idx);
                break;
            }
            case 5: {
                array = PackedDecoder.decodeBigDecimalArray(elementByteLen, ((BigDecimalType)elementType).scale, arrayLen, buffer, idx);
                break;
            }
            case 6: 
            case 7: {
                array = PackedDecoder.decodeObjectArray(arrayLen, elementType, buffer, idx, end);
                break;
            }
            default: {
                throw new Error();
            }
        }
        dest[destIdx] = array;
        return arrayLen * elementByteLen;
    }

    private static boolean[] decodeBooleanArray(int arrayLen, byte[] buffer, int idx) {
        boolean[] booleans = new boolean[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            booleans[i] = BooleanType.decodeBoolean(buffer[idx + i]);
        }
        return booleans;
    }

    private static byte[] decodeByteArray(int arrayLen, byte[] buffer, int idx) {
        byte[] bytes = new byte[arrayLen];
        System.arraycopy(buffer, idx, bytes, 0, arrayLen);
        return bytes;
    }

    private static int[] decodeIntArray(IntType intType, int elementLen, int arrayLen, byte[] buffer, int idx) {
        int[] ints = new int[arrayLen];
        Uint uint = new Uint(intType.bitLength);
        for (int i = 0; i < arrayLen; ++i) {
            int signed = PackedDecoder.getPackedInt(buffer, idx, elementLen);
            ints[i] = intType.unsigned ? (int)uint.toUnsignedLong(signed) : signed;
            idx += elementLen;
        }
        return ints;
    }

    private static long[] decodeLongArray(LongType longType, int elementLen, int arrayLen, byte[] buffer, int idx) {
        long[] longs = new long[arrayLen];
        Uint uint = new Uint(longType.bitLength);
        for (int i = 0; i < arrayLen; ++i) {
            long signed = PackedDecoder.getPackedLong(buffer, idx, elementLen);
            longs[i] = longType.unsigned ? uint.toUnsignedLong(signed) : signed;
            idx += elementLen;
        }
        return longs;
    }

    private static BigInteger[] decodeBigIntegerArray(int elementLen, int arrayLen, byte[] buffer, int idx) {
        BigInteger[] bigInts = new BigInteger[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            bigInts[i] = new BigInteger(Arrays.copyOfRange(buffer, idx, idx + elementLen));
            idx += elementLen;
        }
        return bigInts;
    }

    private static BigDecimal[] decodeBigDecimalArray(int elementLen, int scale, int arrayLen, byte[] buffer, int idx) {
        BigDecimal[] bigDecimals = new BigDecimal[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            bigDecimals[i] = new BigDecimal(new BigInteger(Arrays.copyOfRange(buffer, idx, idx + elementLen)), scale);
            idx += elementLen;
        }
        return bigDecimals;
    }

    private static Object[] decodeObjectArray(int arrayLen, ABIType<?> elementType, byte[] buffer, int idx, int end) {
        Object[] objects = (Object[])Array.newInstance(elementType.clazz, arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            int len = PackedDecoder.decode(elementType, buffer, idx, end, objects, i);
            idx += len;
            end -= len;
        }
        return objects;
    }

    static int getPackedInt(byte[] buffer, int i, int len) {
        byte leftmost;
        int shiftAmount = 0;
        int val = 0;
        switch (len) {
            case 4: {
                val = buffer[i + 3] & 0xFF;
                shiftAmount = 8;
            }
            case 3: {
                val |= (buffer[i + 2] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= (buffer[i + 1] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                leftmost = buffer[i];
                val |= (leftmost & 0xFF) << shiftAmount;
                break;
            }
            default: {
                throw new IllegalArgumentException("len out of range: " + len);
            }
        }
        if (leftmost < 0) {
            switch (len) {
                case 1: {
                    return val | 0xFFFFFF00;
                }
                case 2: {
                    return val | 0xFFFF0000;
                }
                case 3: {
                    return val | 0xFF000000;
                }
            }
        }
        return val;
    }

    static long getPackedLong(byte[] buffer, int i, int len) {
        byte leftmost;
        int shiftAmount = 0;
        long val = 0L;
        switch (len) {
            case 8: {
                val = (long)buffer[i + 7] & 0xFFL;
                shiftAmount = 8;
            }
            case 7: {
                val |= ((long)buffer[i + 6] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 6: {
                val |= ((long)buffer[i + 5] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 5: {
                val |= ((long)buffer[i + 4] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 4: {
                val |= ((long)buffer[i + 3] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 3: {
                val |= ((long)buffer[i + 2] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= ((long)buffer[i + 1] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                leftmost = buffer[i];
                val |= ((long)leftmost & 0xFFL) << shiftAmount;
                break;
            }
            default: {
                throw new IllegalArgumentException("len out of range: " + len);
            }
        }
        if (leftmost < 0) {
            switch (len) {
                case 1: {
                    return val | 0xFFFFFFFFFFFFFF00L;
                }
                case 2: {
                    return val | 0xFFFFFFFFFFFF0000L;
                }
                case 3: {
                    return val | 0xFFFFFFFFFF000000L;
                }
                case 4: {
                    return val | 0xFFFFFFFF00000000L;
                }
                case 5: {
                    return val | 0xFFFFFF0000000000L;
                }
                case 6: {
                    return val | 0xFFFF000000000000L;
                }
                case 7: {
                    return val | 0xFF00000000000000L;
                }
            }
        }
        return val;
    }
}

