/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.util.BizarroIntegers;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

final class PackedEncoder {
    PackedEncoder() {
    }

    static void encodeTuple(TupleType tupleType, Tuple tuple, ByteBuffer dest) {
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            PackedEncoder.encode(tupleType.elementTypes[i], tuple.elements[i], dest);
        }
    }

    private static void encode(ABIType<?> type, Object value, ByteBuffer dest) {
        switch (type.typeCode()) {
            case 0: {
                PackedEncoder.encodeBoolean((Boolean)value, dest);
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                PackedEncoder.encodeInt(((Number)value).longValue(), type.byteLengthPacked(null), dest);
                return;
            }
            case 4: {
                Encoding.insertInt((BigInteger)value, type.byteLengthPacked(null), dest);
                return;
            }
            case 5: {
                Encoding.insertInt(((BigDecimal)value).unscaledValue(), type.byteLengthPacked(null), dest);
                return;
            }
            case 6: {
                PackedEncoder.encodeArray((ArrayType)type, value, dest);
                return;
            }
            case 7: {
                PackedEncoder.encodeTuple((TupleType)type, (Tuple)value, dest);
                return;
            }
        }
        throw new Error();
    }

    private static void encodeArray(ArrayType<? extends ABIType<?>, ?> arrayType, Object value, ByteBuffer dest) {
        Object elementType = arrayType.elementType;
        switch (((ABIType)elementType).typeCode()) {
            case 0: {
                PackedEncoder.encodeBooleans((boolean[])value, dest);
                return;
            }
            case 1: {
                dest.put((byte[])arrayType.decodeIfString(value));
                return;
            }
            case 2: {
                PackedEncoder.encodeInts((int[])value, ((ABIType)elementType).byteLengthPacked(null), dest);
                return;
            }
            case 3: {
                PackedEncoder.encodeLongs((long[])value, ((ABIType)elementType).byteLengthPacked(null), dest);
                return;
            }
            case 4: {
                Encoding.insertBigIntegers((BigInteger[])value, ((ABIType)elementType).byteLengthPacked(null), dest);
                return;
            }
            case 5: {
                Encoding.insertBigDecimals((BigDecimal[])value, ((ABIType)elementType).byteLengthPacked(null), dest);
                return;
            }
            case 6: 
            case 7: {
                for (Object e : (Object[])value) {
                    PackedEncoder.encode(elementType, e, dest);
                }
                return;
            }
        }
        throw new Error();
    }

    private static void encodeBooleans(boolean[] arr, ByteBuffer dest) {
        for (boolean bool : arr) {
            PackedEncoder.encodeBoolean(bool, dest);
        }
    }

    private static void encodeInts(int[] arr, int byteLen, ByteBuffer dest) {
        for (int e : arr) {
            PackedEncoder.encodeInt(e, byteLen, dest);
        }
    }

    private static void encodeLongs(long[] arr, int byteLen, ByteBuffer dest) {
        for (long e : arr) {
            PackedEncoder.encodeInt(e, byteLen, dest);
        }
    }

    private static void encodeBoolean(boolean value, ByteBuffer dest) {
        dest.put(value ? (byte)1 : 0);
    }

    private static void encodeInt(long value, int byteLen, ByteBuffer dest) {
        if (value >= 0L) {
            Encoding.insertPadding(byteLen - Integers.len(value), false, dest);
            Integers.putLong(value, dest);
        } else {
            Encoding.insertPadding(byteLen - BizarroIntegers.len(value), true, dest);
            BizarroIntegers.putLong(value, dest);
        }
    }
}

