/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.PackedEncoder;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TupleType
extends ABIType<Tuple>
implements Iterable<ABIType<?>> {
    private static final String ARRAY_CLASS_NAME = Tuple[].class.getName();
    private static final String EMPTY_TUPLE_STRING = "()";
    public static final TupleType EMPTY = new TupleType("()", false, EMPTY_TYPE_ARRAY);
    final ABIType<?>[] elementTypes;

    private TupleType(String canonicalType, boolean dynamic, ABIType<?>[] elementTypes) {
        super(canonicalType, Tuple.class, dynamic);
        this.elementTypes = elementTypes;
    }

    static <E extends ABIType<?>> TupleType wrap(E[] elements) {
        StringBuilder canonicalBuilder = new StringBuilder("(");
        boolean dynamic = false;
        for (E e : elements) {
            canonicalBuilder.append(((ABIType)e).canonicalType).append(',');
            dynamic |= ((ABIType)e).dynamic;
        }
        return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, (ABIType<?>[])elements);
    }

    public int size() {
        return this.elementTypes.length;
    }

    public ABIType<?> get(int index) {
        return this.elementTypes[index];
    }

    public ABIType<?>[] elements() {
        return Arrays.copyOf(this.elementTypes, this.elementTypes.length);
    }

    @Override
    String arrayClassName() {
        return ARRAY_CLASS_NAME;
    }

    @Override
    public int typeCode() {
        return 7;
    }

    @Override
    int byteLength(Object value) {
        Object[] elements = ((Tuple)value).elements;
        int len = 0;
        for (int i = 0; i < this.elementTypes.length; ++i) {
            ABIType<?> type = this.elementTypes[i];
            int byteLen = type.byteLength(elements[i]);
            len += !type.dynamic ? byteLen : 32 + byteLen;
        }
        return len;
    }

    private int staticByteLengthPacked() {
        int len = 0;
        for (ABIType<?> elementType : this.elementTypes) {
            len += elementType.byteLengthPacked(null);
        }
        return len;
    }

    @Override
    public int byteLengthPacked(Object value) {
        if (value == null) {
            return this.staticByteLengthPacked();
        }
        Object[] elements = ((Tuple)value).elements;
        int len = 0;
        for (int i = 0; i < this.elementTypes.length; ++i) {
            len += this.elementTypes[i].byteLengthPacked(elements[i]);
        }
        return len;
    }

    @Override
    public int validate(Object value) {
        this.validateClass(value);
        Object[] elements = ((Tuple)value).elements;
        if (elements.length == this.elementTypes.length) {
            int i;
            try {
                int len = 0;
                for (i = 0; i < this.elementTypes.length; ++i) {
                    ABIType<?> type = this.elementTypes[i];
                    int byteLen = type.validate(elements[i]);
                    len += !type.dynamic ? byteLen : 32 + byteLen;
                }
                return len;
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IllegalArgumentException("tuple index " + i + ": " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("tuple length mismatch: actual != expected: " + elements.length + " != " + this.elementTypes.length);
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        Object[] values = ((Tuple)value).elements;
        if (!this.dynamic) {
            TupleType.encodeHeads(this.elementTypes, values, dest, -1);
            return;
        }
        ABIType<?>[] types = this.elementTypes;
        TupleType.encodeHeads(types, values, dest, TupleType.headLengthSum(types, values));
        for (int i = 0; i < types.length; ++i) {
            ABIType<?> t = types[i];
            if (!t.dynamic) continue;
            t.encodeTail(values[i], dest);
        }
    }

    private static void encodeHeads(ABIType<?>[] types, Object[] values, ByteBuffer dest, int nextOffset) {
        for (int i = 0; i < types.length; ++i) {
            nextOffset = types[i].encodeHead(values[i], dest, nextOffset);
        }
    }

    private static int headLengthSum(ABIType<?>[] types, Object[] elements) {
        int sum = 0;
        for (int i = 0; i < types.length; ++i) {
            ABIType<?> type = types[i];
            sum += !type.dynamic ? type.byteLength(elements[i]) : 32;
        }
        return sum;
    }

    public Tuple decode(byte[] array) {
        ByteBuffer bb = ByteBuffer.wrap(array);
        Tuple decoded = this.decode(bb);
        int remaining = bb.remaining();
        if (remaining == 0) {
            return decoded;
        }
        throw new IllegalArgumentException("unconsumed bytes: " + remaining + " remaining");
    }

    public Tuple decode(ByteBuffer bb) {
        return this.decode(bb, TupleType.newUnitBuffer());
    }

    @Override
    Tuple decode(ByteBuffer bb, byte[] unitBuffer) {
        int len = this.elementTypes.length;
        Object[] elements = new Object[len];
        if (!this.dynamic) {
            for (int i = 0; i < len; ++i) {
                elements[i] = this.elementTypes[i].decode(bb, unitBuffer);
            }
        } else {
            int i;
            int[] offsets = new int[len];
            for (i = 0; i < len; ++i) {
                ABIType<?> elementType = this.elementTypes[i];
                if (!elementType.dynamic) {
                    elements[i] = elementType.decode(bb, unitBuffer);
                    continue;
                }
                offsets[i] = Encoding.OFFSET_TYPE.decode(bb, unitBuffer);
            }
            for (i = 0; i < len; ++i) {
                if (offsets[i] <= 0) continue;
                elements[i] = this.elementTypes[i].decode(bb, unitBuffer);
            }
        }
        return new Tuple(elements);
    }

    @Override
    public Tuple parseArgument(String s) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer encodeElements(Object ... elements) {
        return this.encode(new Tuple(elements));
    }

    public ByteBuffer encode(Tuple values) {
        ByteBuffer dest = ByteBuffer.allocate(this.validate(values));
        this.encodeTail(values, dest);
        return dest;
    }

    public TupleType encode(Tuple values, ByteBuffer dest) {
        this.validate(values);
        this.encodeTail(values, dest);
        return this;
    }

    public int measureEncodedLength(Tuple values) {
        return this.validate(values);
    }

    public ByteBuffer encodePacked(Tuple values) {
        this.validate(values);
        ByteBuffer dest = ByteBuffer.allocate(this.byteLengthPacked(values));
        PackedEncoder.encodeTuple(this, values, dest);
        return dest;
    }

    public void encodePacked(Tuple values, ByteBuffer dest) {
        this.validate(values);
        PackedEncoder.encodeTuple(this, values, dest);
    }

    @Override
    public Iterator<ABIType<?>> iterator() {
        return new Iterator<ABIType<?>>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < TupleType.this.elementTypes.length;
            }

            @Override
            public ABIType<?> next() {
                try {
                    return TupleType.this.elementTypes[this.index++];
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    throw new NoSuchElementException(aioobe.getMessage());
                }
            }
        };
    }

    public TupleType subTupleType(boolean[] manifest) {
        return this.subTupleType(manifest, false);
    }

    public TupleType subTupleType(boolean[] manifest, boolean negate) {
        int len = TupleType.checkLength(this.elementTypes, manifest);
        StringBuilder canonicalBuilder = new StringBuilder("(");
        boolean dynamic = false;
        ABIType[] selected = new ABIType[TupleType.getSelectionSize(manifest, negate)];
        int s = 0;
        for (int i = 0; i < len; ++i) {
            if (!(negate ^ manifest[i])) continue;
            ABIType<?> e = this.elementTypes[i];
            canonicalBuilder.append(e.canonicalType).append(',');
            dynamic |= e.dynamic;
            selected[s++] = e;
        }
        return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, selected);
    }

    private static int checkLength(ABIType<?>[] elements, boolean[] manifest) {
        int len = manifest.length;
        if (len == elements.length) {
            return len;
        }
        throw new IllegalArgumentException("manifest.length != elements.length: " + manifest.length + " != " + elements.length);
    }

    private static int getSelectionSize(boolean[] manifest, boolean negate) {
        int count = 0;
        for (boolean b : manifest) {
            if (!b) continue;
            ++count;
        }
        return negate ? manifest.length - count : count;
    }

    private static String completeTupleTypeString(StringBuilder sb) {
        int len = sb.length();
        return len != 1 ? sb.replace(len - 1, len, ")").toString() : EMPTY_TUPLE_STRING;
    }

    public static TupleType parse(String rawTupleTypeString) {
        return (TupleType)TypeFactory.create(rawTupleTypeString, null);
    }

    public static TupleType of(String ... typeStrings) {
        StringBuilder sb = new StringBuilder("(");
        for (String str : typeStrings) {
            sb.append(str).append(',');
        }
        return TupleType.parse(TupleType.completeTupleTypeString(sb));
    }

    public static TupleType parseElements(String rawElementsString) {
        return TupleType.parse('(' + rawElementsString + ')');
    }

    public static String format(byte[] abi) {
        return TupleType.format(abi, new LabelMaker(){

            @Override
            public String make(int offset) {
                StringBuilder sb = new StringBuilder();
                String labelStr = Long.toHexString(offset);
                int zeroes = 6 - labelStr.length();
                for (int i = 0; i < zeroes; ++i) {
                    sb.append(' ');
                }
                sb.append(labelStr);
                this.pad(sb, ' ');
                return sb.toString();
            }
        });
    }

    public static String format(byte[] abi, LabelMaker labelMaker) {
        Integers.checkIsMultiple(abi.length, 32);
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < abi.length; idx += 32) {
            if (idx > 0) {
                sb.append('\n');
            }
            sb.append(labelMaker.make(idx));
            sb.append(Strings.encode(abi, idx, 32, 0));
        }
        return sb.toString();
    }

    public static class LabelMaker {
        public String make(int offset) {
            StringBuilder sb = new StringBuilder();
            sb.append(offset / 32);
            this.pad(sb, ' ');
            return sb.toString();
        }

        public void pad(StringBuilder sb, char ch) {
            int n = 9 - sb.length();
            for (int i = 0; i < n; ++i) {
                sb.append(ch);
            }
        }
    }
}

