/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BaseTypeInfo;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.TupleType;
import java.math.BigInteger;
import java.util.ArrayList;

final class TypeFactory {
    private static final ABIType<BigInteger> CACHED_UINT_TYPE = new BigIntegerType("uint256", 256, true);
    private static final ClassLoader CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    static final String EMPTY_PARAMETER = "empty parameter";

    TypeFactory() {
    }

    static ABIType<?> create(String rawType, String name) {
        return TypeFactory.buildType(rawType, null, name == null).setName(name);
    }

    static ABIType<?> createFromBase(TupleType baseType, String typeSuffix, String name) {
        return TypeFactory.buildType(baseType.canonicalType + typeSuffix, baseType, name == null).setName(name);
    }

    private static ABIType<?> buildType(String rawType, ABIType<?> baseType, boolean nameless) {
        try {
            int lastCharIndex = rawType.length() - 1;
            if (rawType.charAt(lastCharIndex) == ']') {
                int secondToLastCharIndex = lastCharIndex - 1;
                int arrayOpenIndex = rawType.lastIndexOf(91, secondToLastCharIndex);
                ABIType<?> elementType = TypeFactory.buildType(rawType.substring(0, arrayOpenIndex), baseType, nameless);
                String type = elementType.canonicalType + rawType.substring(arrayOpenIndex);
                int length = arrayOpenIndex == secondToLastCharIndex ? -1 : TypeFactory.parseLen(rawType, arrayOpenIndex + 1, lastCharIndex);
                boolean dynamic = length == -1 || elementType.dynamic;
                String arrayClassName = elementType.arrayClassName();
                Class<?> arrayClass = Class.forName(arrayClassName, false, CLASS_LOADER);
                return new ArrayType(type, arrayClass, dynamic, elementType, length, '[' + arrayClassName);
            }
            if (baseType != null || (baseType = TypeFactory.resolveBaseType(rawType, nameless)) != null) {
                return baseType;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalArgumentException("unrecognized type: " + rawType);
    }

    private static int parseLen(String rawType, int startLen, int lastCharIndex) {
        try {
            String lengthStr = rawType.substring(startLen, lastCharIndex);
            int length = Integer.parseInt(lengthStr);
            if (length >= 0) {
                if (lengthStr.length() > 1 && rawType.charAt(startLen) == '0') {
                    throw new IllegalArgumentException("leading zero in array length");
                }
                return length;
            }
            throw new IllegalArgumentException("negative array length");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("illegal number format", nfe);
        }
    }

    private static ABIType<?> resolveBaseType(String baseTypeStr, boolean nameless) {
        if (baseTypeStr.charAt(0) == '(') {
            return TypeFactory.parseTupleType(baseTypeStr);
        }
        BaseTypeInfo info = BaseTypeInfo.get(baseTypeStr);
        if (info != null) {
            switch (baseTypeStr) {
                case "int8": 
                case "int16": 
                case "int24": 
                case "int32": {
                    return new IntType(baseTypeStr, info.bitLen, false);
                }
                case "int40": 
                case "int48": 
                case "int56": 
                case "int64": {
                    return new LongType(baseTypeStr, info.bitLen, false);
                }
                case "int72": 
                case "int80": 
                case "int88": 
                case "int96": 
                case "int104": 
                case "int112": 
                case "int120": 
                case "int128": 
                case "int136": 
                case "int144": 
                case "int152": 
                case "int160": 
                case "int168": 
                case "int176": 
                case "int184": 
                case "int192": 
                case "int200": 
                case "int208": 
                case "int216": 
                case "int224": 
                case "int232": 
                case "int240": 
                case "int248": {
                    return new BigIntegerType(baseTypeStr, info.bitLen, false);
                }
                case "int256": 
                case "int": {
                    return new BigIntegerType("int256", 256, false);
                }
                case "uint8": 
                case "uint16": 
                case "uint24": {
                    return new IntType(baseTypeStr, info.bitLen, true);
                }
                case "uint32": 
                case "uint40": 
                case "uint48": 
                case "uint56": {
                    return new LongType(baseTypeStr, info.bitLen, true);
                }
                case "uint64": 
                case "uint72": 
                case "uint80": 
                case "uint88": 
                case "uint96": 
                case "uint104": 
                case "uint112": 
                case "uint120": 
                case "uint128": 
                case "uint136": 
                case "uint144": 
                case "uint152": 
                case "uint160": 
                case "address": 
                case "uint168": 
                case "uint176": 
                case "uint184": 
                case "uint192": 
                case "uint200": 
                case "uint208": 
                case "uint216": 
                case "uint224": 
                case "uint232": 
                case "uint240": 
                case "uint248": {
                    return new BigIntegerType(baseTypeStr, info.bitLen, true);
                }
                case "uint256": 
                case "uint": {
                    return nameless ? CACHED_UINT_TYPE : new BigIntegerType("uint256", 256, true);
                }
                case "bytes1": 
                case "bytes2": 
                case "bytes3": 
                case "bytes4": 
                case "bytes5": 
                case "bytes6": 
                case "bytes7": 
                case "bytes8": 
                case "bytes9": 
                case "bytes10": 
                case "bytes11": 
                case "bytes12": 
                case "bytes13": 
                case "bytes14": 
                case "bytes15": 
                case "bytes16": 
                case "bytes17": 
                case "bytes18": 
                case "bytes19": 
                case "bytes20": 
                case "bytes21": 
                case "bytes22": 
                case "bytes23": 
                case "bytes24": 
                case "function": 
                case "bytes25": 
                case "bytes26": 
                case "bytes27": 
                case "bytes28": 
                case "bytes29": 
                case "bytes30": 
                case "bytes31": 
                case "bytes32": {
                    return new ArrayType<ByteType, byte[]>(baseTypeStr, ArrayType.BYTE_ARRAY_CLASS, false, ByteType.UNSIGNED, info.arrayLen, ArrayType.BYTE_ARRAY_ARRAY_CLASS_NAME);
                }
                case "bool": {
                    return new BooleanType();
                }
                case "bytes": {
                    return new ArrayType<ByteType, byte[]>(baseTypeStr, ArrayType.BYTE_ARRAY_CLASS, true, ByteType.UNSIGNED, -1, ArrayType.BYTE_ARRAY_ARRAY_CLASS_NAME);
                }
                case "string": {
                    return new ArrayType<ByteType, String>(baseTypeStr, ArrayType.STRING_CLASS, true, ByteType.UNSIGNED, -1, ArrayType.STRING_ARRAY_CLASS_NAME);
                }
                case "decimal": {
                    return new BigDecimalType(baseTypeStr, 128, 10, false);
                }
                case "fixed": 
                case "fixed128x18": {
                    return new BigDecimalType("fixed128x18", 128, 18, false);
                }
                case "ufixed": 
                case "ufixed128x18": {
                    return new BigDecimalType("ufixed128x18", 128, 18, true);
                }
            }
            return null;
        }
        return TypeFactory.tryParseFixed(baseTypeStr);
    }

    private static BigDecimalType tryParseFixed(String type) {
        int idx = type.indexOf("fixed");
        boolean unsigned = false;
        if (idx == 0 || (unsigned = idx == 1 && type.charAt(0) == 'u')) {
            int indexOfX = type.lastIndexOf(120);
            try {
                int M = Integer.parseInt(type.substring(idx + "fixed".length(), indexOfX));
                int N = Integer.parseInt(type.substring(indexOfX + 1));
                if ((M & 7) == 0 && M >= 8 && M <= 256 && N > 0 && N <= 80) {
                    return new BigDecimalType(type, M, N, unsigned);
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static TupleType parseTupleType(String rawTypeStr) {
        ArrayList elements = new ArrayList();
        try {
            int argStart = 1;
            int argEnd = 1;
            int prevEndChar = 41;
            int end = rawTypeStr.length();
            block7: while (argStart < end) {
                switch (rawTypeStr.charAt(argStart)) {
                    case '(': {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, TypeFactory.findSubtupleEnd(rawTypeStr, argStart + 1));
                        break;
                    }
                    case ')': {
                        if (prevEndChar != 44) break block7;
                        throw new IllegalArgumentException(EMPTY_PARAMETER);
                    }
                    case ',': {
                        if (rawTypeStr.charAt(argEnd) == ')') break block7;
                        throw new IllegalArgumentException(EMPTY_PARAMETER);
                    }
                    default: {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, argStart + 1);
                    }
                }
                elements.add(TypeFactory.buildType(rawTypeStr.substring(argStart, argEnd), null, true));
                char c = rawTypeStr.charAt(argEnd);
                prevEndChar = c;
                if (c != ',') break;
                argStart = argEnd + 1;
            }
            if (argEnd == end - 1 && prevEndChar == 41) {
                return TupleType.wrap((ABIType[])elements.toArray(ABIType.EMPTY_TYPE_ARRAY));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("@ index " + elements.size() + ", " + iae.getMessage(), iae);
        }
        throw new IllegalArgumentException("unrecognized type: " + rawTypeStr);
    }

    private static int findSubtupleEnd(String parentTypeString, int i) {
        int depth = 1;
        do {
            char x;
            if ((x = parentTypeString.charAt(i++)) > ')') continue;
            if (x == ')') {
                --depth;
                continue;
            }
            if (x != '(') continue;
            ++depth;
        } while (depth > 0);
        return i;
    }

    private static int nextTerminator(String signature, int i) {
        int comma = signature.indexOf(44, i);
        int close = signature.indexOf(41, i);
        return comma == -1 ? close : (close == -1 ? comma : Math.min(comma, close));
    }
}

