/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.util.BizarroIntegers;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class UnitType<V>
extends ABIType<V> {
    public static final int UNIT_LENGTH_BYTES = 32;
    final int bitLength;
    final boolean unsigned;

    UnitType(String canonicalType, Class<V> clazz, int bitLength, boolean unsigned) {
        super(canonicalType, clazz, false);
        this.bitLength = bitLength;
        this.unsigned = unsigned;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    final int byteLength(Object value) {
        return 32;
    }

    @Override
    int byteLengthPacked(Object value) {
        return this.bitLength >> 3;
    }

    @Override
    public int validate(Object value) {
        this.validateClass(value);
        this.validatePrimitive(((Number)value).longValue());
        return 32;
    }

    @Override
    int encodeHead(Object value, ByteBuffer dest, int nextOffset) {
        Encoding.insertInt(((Number)value).longValue(), dest);
        return nextOffset;
    }

    final void validatePrimitive(long longVal) {
        this.checkBitLen(longVal >= 0L ? Integers.bitLen(longVal) : BizarroIntegers.bitLen(longVal));
        if (this.unsigned && longVal < 0L) {
            throw new IllegalArgumentException("signed value given for unsigned type");
        }
    }

    final void validateBigInt(BigInteger bigIntVal) {
        this.checkBitLen(bigIntVal.bitLength());
        if (this.unsigned && bigIntVal.signum() < 0) {
            throw new IllegalArgumentException("signed value given for unsigned type");
        }
    }

    final void checkBitLen(int actual) {
        if (actual > this.bitLength) {
            throw new IllegalArgumentException("exceeds bit limit: " + actual + " > " + this.bitLength);
        }
    }
}

