/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Utils {
    Utils() {
    }

    static String regexValidate(Pattern validString, Pattern illegalChar, String input) {
        if (validString.matcher(input).matches()) {
            return input;
        }
        Matcher badChar = illegalChar.matcher(input);
        if (badChar.find()) {
            int idx = badChar.start();
            char c = input.charAt(idx);
            throw new IllegalArgumentException("illegal char 0x" + Integer.toHexString(c) + " '" + c + "' @ index " + idx);
        }
        throw new Error("regex mismatch");
    }

    static String friendlyClassName(Class<?> clazz) {
        return Utils.friendlyClassName(clazz, null);
    }

    static String friendlyClassName(Class<?> clazz, Integer arrayLength) {
        String className = clazz.getName();
        int split = className.lastIndexOf(91) + 1;
        boolean hasArraySuffix = split > 0;
        String base = hasArraySuffix ? className.substring(split) : className;
        StringBuilder sb = new StringBuilder();
        switch (base) {
            case "B": {
                sb.append("byte");
                break;
            }
            case "S": {
                sb.append("short");
                break;
            }
            case "I": {
                sb.append("int");
                break;
            }
            case "J": {
                sb.append("long");
                break;
            }
            case "F": {
                sb.append("float");
                break;
            }
            case "D": {
                sb.append("double");
                break;
            }
            case "C": {
                sb.append("char");
                break;
            }
            case "Z": {
                sb.append("boolean");
                break;
            }
            default: {
                int lastDotIndex = base.lastIndexOf(46);
                if (lastDotIndex == -1) break;
                sb.append(base, lastDotIndex + 1, base.length() - (base.charAt(0) == 'L' ? 1 : 0));
            }
        }
        if (hasArraySuffix) {
            int i = 0;
            if (arrayLength != null && arrayLength >= 0) {
                sb.append('[').append(arrayLength).append(']');
                ++i;
            }
            while (i < split) {
                sb.append("[]");
                ++i;
            }
        }
        return sb.toString();
    }
}

