/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi.util;

import com.esaulpaugh.headlong.abi.util.BizarroIntegers;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;

public final class Uint {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final long ZERO = 0L;
    public final int numBits;
    public final BigInteger range;
    public final long rangeLong;
    public final BigInteger halfRange;
    public final long halfRangeLong;
    public final long maskLong;

    public Uint(int numBits) {
        long maskLong;
        long halfRangeLong;
        long rangeLong;
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        this.numBits = numBits;
        this.range = TWO.shiftLeft(numBits - 1);
        try {
            rangeLong = this.range.longValueExact();
            halfRangeLong = rangeLong >> 1;
            maskLong = this.range.subtract(BigInteger.ONE).longValueExact();
        }
        catch (ArithmeticException ae) {
            maskLong = 0L;
            halfRangeLong = 0L;
            rangeLong = 0L;
        }
        this.rangeLong = rangeLong;
        this.halfRange = this.range.shiftRight(1);
        this.halfRangeLong = halfRangeLong;
        this.maskLong = maskLong;
    }

    public long toSignedLong(long unsigned) {
        if (this.rangeLong != 0L) {
            if (unsigned < 0L) {
                throw new IllegalArgumentException("unsigned value is negative: " + unsigned);
            }
            int bitLen = Integers.bitLen(unsigned);
            if (bitLen <= this.numBits) {
                return unsigned >= this.halfRangeLong ? unsigned - this.rangeLong : unsigned;
            }
            throw Uint.tooManyBitsException(bitLen, this.numBits, false);
        }
        return this.toSigned(BigInteger.valueOf(unsigned)).longValueExact();
    }

    public BigInteger toSigned(BigInteger unsigned) {
        if (unsigned.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("unsigned value is negative: " + unsigned);
        }
        int bitLen = unsigned.bitLength();
        if (bitLen <= this.numBits) {
            return unsigned.compareTo(this.halfRange) >= 0 ? unsigned.subtract(this.range) : unsigned;
        }
        throw Uint.tooManyBitsException(bitLen, this.numBits, false);
    }

    public long toUnsignedLong(long signed) {
        if (this.maskLong != 0L) {
            int bitLen;
            int n = bitLen = signed < 0L ? BizarroIntegers.bitLen(signed) : Integers.bitLen(signed);
            if (bitLen < this.numBits) {
                return signed & this.maskLong;
            }
            throw Uint.tooManyBitsException(bitLen, this.numBits, true);
        }
        return this.toUnsigned(signed).longValueExact();
    }

    public BigInteger toUnsigned(long signed) {
        return this.toUnsigned(BigInteger.valueOf(signed));
    }

    public BigInteger toUnsigned(BigInteger signed) {
        int bitLen = signed.bitLength();
        if (bitLen < this.numBits) {
            return signed.compareTo(BigInteger.ZERO) >= 0 ? signed : signed.add(this.range);
        }
        throw Uint.tooManyBitsException(bitLen, this.numBits, true);
    }

    public long[] toUnsignedLongAll(int ... signeds) {
        long[] out = new long[signeds.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.toUnsignedLong(signeds[i]);
        }
        return out;
    }

    public BigInteger[] toUnsignedAll(long ... signeds) {
        BigInteger[] out = new BigInteger[signeds.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.toUnsigned(signeds[i]);
        }
        return out;
    }

    public BigInteger[] toUnsignedAll(BigInteger ... signeds) {
        BigInteger[] out = new BigInteger[signeds.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.toUnsigned(signeds[i]);
        }
        return out;
    }

    private static IllegalArgumentException tooManyBitsException(int bitLen, int rangeNumBits, boolean signed) {
        return signed ? new IllegalArgumentException("signed has too many bits: " + bitLen + " is not less than " + rangeNumBits) : new IllegalArgumentException("unsigned has too many bits: " + bitLen + " > " + rangeNumBits);
    }
}

