/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.KeyValuePair;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.util.Integers;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public final class RLPEncoder {
    static int dataLen(List<KeyValuePair> pairs) {
        long sum = 0L;
        for (KeyValuePair pair : pairs) {
            sum += (long)(RLPEncoder.stringEncodedLen(pair.getKey()) + RLPEncoder.stringEncodedLen(pair.getValue()));
        }
        return RLPEncoder.requireNoOverflow(sum);
    }

    static int prefixLength(int dataLen) {
        return RLPEncoder.isShort(dataLen) ? 1 : 1 + Integers.len(dataLen);
    }

    static void insertListPrefix(int dataLen, ByteBuffer bb) {
        if (RLPEncoder.isShort(dataLen)) {
            bb.put((byte)(-64 + dataLen));
        } else {
            bb.put((byte)(-9 + Integers.len(dataLen)));
            Integers.putLong(dataLen, bb);
        }
    }

    static void insertRecordContentList(int dataLen, long seq, List<KeyValuePair> pairs, ByteBuffer bb) {
        if (seq >= 0L) {
            pairs.sort(KeyValuePair.PAIR_COMPARATOR);
            RLPEncoder.insertListPrefix(dataLen, bb);
            RLPEncoder.encodeString(seq, bb);
            for (KeyValuePair pair : pairs) {
                RLPEncoder.encodeKeyValuePair(pair, bb);
            }
        } else {
            throw new IllegalArgumentException("negative seq");
        }
    }

    private static void encodeString(long val, ByteBuffer bb) {
        int dataLen = Integers.len(val);
        if (dataLen == 1) {
            RLPEncoder.encodeLen1String((byte)val, bb);
            return;
        }
        bb.put((byte)(-128 + dataLen));
        Integers.putLong(val, bb);
    }

    private static void encodeKeyValuePair(KeyValuePair pair, ByteBuffer bb) {
        RLPEncoder.encodeString(pair.getKey(), bb);
        RLPEncoder.encodeString(pair.getValue(), bb);
    }

    private static int requireNoOverflow(long val) {
        if (val <= Integer.MAX_VALUE) {
            return (int)val;
        }
        throw new IllegalArgumentException("integer overflow");
    }

    private static boolean isShort(int dataLen) {
        return dataLen < 56;
    }

    private static int sumEncodedLen(Iterable<?> rawItems) {
        long sum = 0L;
        for (Object raw : rawItems) {
            sum += (long)RLPEncoder.encodedLen(raw);
        }
        return RLPEncoder.requireNoOverflow(sum);
    }

    private static int encodedLen(Object raw) {
        if (raw instanceof byte[]) {
            return RLPEncoder.stringEncodedLen((byte[])raw);
        }
        if (raw instanceof Iterable) {
            return RLPEncoder.listEncodedLen((Iterable)raw);
        }
        if (raw instanceof Object[]) {
            return RLPEncoder.listEncodedLen(Arrays.asList((Object[])raw));
        }
        if (raw == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("unsupported object type: " + raw.getClass().getName());
    }

    private static int stringEncodedLen(byte[] byteString) {
        int dataLen = byteString.length;
        return 1 + (RLPEncoder.isShort(dataLen) ? (dataLen == 1 && byteString[0] >= 0 ? 0 : dataLen) : Integers.len(dataLen) + dataLen);
    }

    private static int listEncodedLen(Iterable<?> items) {
        int dataLen = RLPEncoder.sumEncodedLen(items);
        return 1 + (RLPEncoder.isShort(dataLen) ? dataLen : Integers.len(dataLen) + dataLen);
    }

    static void encodeItem(Object raw, ByteBuffer bb) {
        if (raw instanceof byte[]) {
            RLPEncoder.encodeString((byte[])raw, bb);
        } else if (raw instanceof Iterable) {
            Iterable elements = (Iterable)raw;
            RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, bb);
        } else if (raw instanceof Object[]) {
            List<Object> elements = Arrays.asList((Object[])raw);
            RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, bb);
        } else {
            if (raw == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException("unsupported object type: " + raw.getClass().getName());
        }
    }

    private static void encodeString(byte[] data, ByteBuffer bb) {
        int dataLen = data.length;
        if (dataLen == 1) {
            RLPEncoder.encodeLen1String(data[0], bb);
            return;
        }
        if (RLPEncoder.isShort(dataLen)) {
            bb.put((byte)(-128 + dataLen));
        } else {
            bb.put((byte)(-73 + Integers.len(dataLen)));
            Integers.putLong(dataLen, bb);
        }
        bb.put(data);
    }

    private static void encodeLen1String(byte first, ByteBuffer bb) {
        if (first < 0) {
            bb.put((byte)-127);
        }
        bb.put(first);
    }

    private static void encodeList(int dataLen, Iterable<?> elements, ByteBuffer bb) {
        RLPEncoder.insertListPrefix(dataLen, bb);
        RLPEncoder.encodeSequentially(elements, bb);
    }

    public static byte[] encodeString(byte b) {
        return RLPEncoder.encodeString(new byte[]{b});
    }

    public static byte[] encodeString(byte[] byteString) {
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.stringEncodedLen(byteString));
        RLPEncoder.encodeString(byteString, bb);
        return bb.array();
    }

    public static byte[] encodeSequentially(Object ... objects) {
        return RLPEncoder.encodeSequentially(Arrays.asList(objects));
    }

    public static int encodeSequentially(Object[] objects, byte[] dest, int destIndex) {
        return RLPEncoder.encodeSequentially(Arrays.asList(objects), dest, destIndex);
    }

    public static void encodeSequentially(Object[] objects, ByteBuffer dest) {
        RLPEncoder.encodeSequentially(Arrays.asList(objects), dest);
    }

    public static byte[] encodeSequentially(Iterable<?> objects) {
        byte[] dest = new byte[RLPEncoder.sumEncodedLen(objects)];
        RLPEncoder.encodeSequentially(objects, dest, 0);
        return dest;
    }

    public static int encodeSequentially(Iterable<?> objects, byte[] dest, int destIndex) {
        ByteBuffer bb = ByteBuffer.wrap(dest, destIndex, dest.length - destIndex);
        RLPEncoder.encodeSequentially(objects, bb);
        return bb.position();
    }

    public static void encodeSequentially(Iterable<?> objects, ByteBuffer dest) {
        for (Object raw : objects) {
            RLPEncoder.encodeItem(raw, dest);
        }
    }

    public static byte[] encodeAsList(Object ... elements) {
        return RLPEncoder.encodeAsList(Arrays.asList(elements));
    }

    public static int encodeAsList(Object[] elements, byte[] dest, int destIndex) {
        return RLPEncoder.encodeAsList(Arrays.asList(elements), dest, destIndex);
    }

    public static void encodeAsList(Object[] elements, ByteBuffer dest) {
        RLPEncoder.encodeAsList(Arrays.asList(elements), dest);
    }

    public static byte[] encodeAsList(Iterable<?> elements) {
        int dataLen = RLPEncoder.sumEncodedLen(elements);
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.prefixLength(dataLen) + dataLen);
        RLPEncoder.encodeList(dataLen, elements, bb);
        return bb.array();
    }

    public static int encodeAsList(Iterable<?> elements, byte[] dest, int destIndex) {
        ByteBuffer bb = ByteBuffer.wrap(dest, destIndex, dest.length - destIndex);
        RLPEncoder.encodeAsList(elements, bb);
        return bb.position();
    }

    public static void encodeAsList(Iterable<?> elements, ByteBuffer dest) {
        RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, dest);
    }

    public static RLPList toList(RLPItem ... encodings) {
        return RLPEncoder.toList(Arrays.asList(encodings));
    }

    public static RLPList toList(Iterable<RLPItem> encodings) {
        return RLPList.withElements(encodings);
    }
}

