/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;

public class RLPOutputStream
extends OutputStream {
    private final OutputStream out;

    public RLPOutputStream() {
        this.out = new Baos();
    }

    public RLPOutputStream(OutputStream out) {
        this.out = Objects.requireNonNull(out);
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return (ByteArrayOutputStream)this.out;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeOut(RLPEncoder.encodeString((byte)b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeOut(RLPEncoder.encodeString(b));
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        this.writeOut(RLPEncoder.encodeString(Arrays.copyOfRange(buffer, off, off + len)));
    }

    public void writeAll(Object ... rawObjects) throws IOException {
        this.writeOut(RLPEncoder.encodeSequentially(rawObjects));
    }

    public void writeAll(Iterable<?> rawObjects) throws IOException {
        this.writeOut(RLPEncoder.encodeSequentially(rawObjects));
    }

    public void writeList(Object ... rawElements) throws IOException {
        this.writeOut(RLPEncoder.encodeAsList(rawElements));
    }

    public void writeList(Iterable<?> rawElements) throws IOException {
        this.writeOut(RLPEncoder.encodeAsList(rawElements));
    }

    private void writeOut(byte[] rlp) throws IOException {
        this.out.write(rlp, 0, rlp.length);
    }

    public String toString() {
        return this.out.toString();
    }

    private static class Baos
    extends ByteArrayOutputStream {
        private Baos() {
        }

        @Override
        public String toString() {
            return Strings.encode(this.buf, 0, this.count, 0);
        }
    }
}

