/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.ShortInputException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

class RLPStreamIterator
implements Iterator<RLPItem> {
    protected final InputStream is;
    protected final RLPDecoder decoder;
    protected byte[] buffer;
    protected int index;
    protected RLPItem next;

    RLPStreamIterator(InputStream is, RLPDecoder decoder) {
        this(is, decoder, new byte[0], 0);
    }

    RLPStreamIterator(InputStream is, RLPDecoder decoder, byte[] buffer, int index) {
        this.is = is;
        this.decoder = decoder;
        this.buffer = buffer;
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            int available = this.is.available();
            if (available > 0) {
                int keptBytes = this.buffer.length - this.index;
                byte[] newBuffer = new byte[keptBytes + available];
                System.arraycopy(this.buffer, this.index, newBuffer, 0, keptBytes);
                this.buffer = newBuffer;
                this.index = 0;
                int read = this.is.read(this.buffer, keptBytes, available);
                if (read != available) {
                    throw new IOException("read failed: " + read + " != " + available);
                }
            } else if (this.index >= this.buffer.length) {
                return false;
            }
            this.next = this.decoder.wrap(this.buffer, this.index);
            return true;
        }
        catch (ShortInputException e) {
            return false;
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    @Override
    public RLPItem next() {
        if (this.hasNext()) {
            RLPItem item = this.next;
            this.next = null;
            this.index = item.endIndex;
            return item;
        }
        throw new NoSuchElementException();
    }
}

