/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.KeyValuePair;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;
import java.security.SignatureException;
import java.util.Iterator;
import java.util.List;

public final class Record {
    private static final long MAX_RECORD_LEN = 300L;
    private static final String ENR_PREFIX = "enr:";
    private final RLPList rlp;

    public Record(long seq, List<KeyValuePair> pairs, Signer signer) {
        int signatureLen = signer.signatureLength();
        int payloadLen = Record.rlpEncodedLen(seq) + RLPEncoder.dataLen(pairs);
        int recordListDataLen = RLPEncoder.prefixLength(signatureLen) + signatureLen + payloadLen;
        int recordListPrefixLen = RLPEncoder.prefixLength(recordListDataLen);
        int recordLen = recordListPrefixLen + recordListDataLen;
        if ((long)recordLen > 300L) {
            throw new IllegalArgumentException("record length exceeds maximum: " + recordLen + " > " + 300L);
        }
        ByteBuffer bb = ByteBuffer.allocate(recordLen);
        RLPEncoder.insertListPrefix(recordListDataLen, bb);
        int contentListLen = RLPEncoder.prefixLength(payloadLen) + payloadLen;
        int contentListOffset = recordLen - contentListLen;
        bb.position(contentListOffset);
        RLPEncoder.insertRecordContentList(payloadLen, seq, pairs, bb);
        byte[] signature = signer.sign(bb.array(), contentListOffset, contentListLen);
        bb.position(recordListPrefixLen);
        RLPEncoder.encodeItem(signature, bb);
        this.rlp = RLPDecoder.RLP_STRICT.wrapList(bb.array());
    }

    private Record(RLPList recordRLP) {
        this.rlp = recordRLP;
    }

    public static Record parse(String enrString) {
        if (enrString.startsWith(ENR_PREFIX)) {
            return Record.decode(Strings.decode(enrString.substring(ENR_PREFIX.length()), 2));
        }
        throw new IllegalArgumentException("prefix \"enr:\" not found");
    }

    public static Record decode(byte[] record) {
        return new Record(RLPDecoder.RLP_STRICT.wrapList(record));
    }

    public RLPList getRLP() {
        return this.rlp;
    }

    public RLPItem getSignature() {
        return this.getRLP().iterator(RLPDecoder.RLP_STRICT).next();
    }

    public RLPList getContent() {
        return RLPDecoder.RLP_STRICT.wrapList(this.getContentBytes(this.getSignature().endIndex));
    }

    public long getSeq() {
        Iterator<RLPItem> iter = this.getRLP().iterator();
        iter.next();
        return iter.next().asLong();
    }

    private byte[] getContentBytes(int index) {
        int contentDataLen = this.rlp.encodingLength() - index;
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.prefixLength(contentDataLen) + contentDataLen);
        RLPEncoder.insertListPrefix(contentDataLen, bb);
        this.rlp.exportRange(index, index + contentDataLen, bb.array(), bb.position());
        return bb.array();
    }

    public RLPList decode(Verifier verifier) throws SignatureException {
        RLPItem signatureItem = this.getSignature();
        byte[] content = this.getContentBytes(signatureItem.endIndex);
        verifier.verify(signatureItem.asBytes(), content);
        return RLPDecoder.RLP_STRICT.wrapList(content);
    }

    public int hashCode() {
        return this.rlp.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.rlp.equals(((Record)o).rlp);
    }

    public String toString() {
        return ENR_PREFIX + this.rlp.toString(2);
    }

    private static int rlpEncodedLen(long val) {
        int dataLen = Integers.len(val);
        if (dataLen == 1) {
            return (byte)val >= 0 ? 1 : 2;
        }
        return 1 + dataLen;
    }

    public static interface Signer {
        public int signatureLength();

        public byte[] sign(byte[] var1, int var2, int var3);
    }

    public static interface Verifier {
        public void verify(byte[] var1, byte[] var2) throws SignatureException;
    }
}

