/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp.util;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.util.NotationParser;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Notation {
    private static final boolean LENIENT = true;
    private static final String BEGIN_NOTATION = "(";
    private static final String END_NOTATION = "\n)";
    static final String BEGIN_LIST = "[";
    static final String END_LIST = "]";
    static final String BEGIN_STRING = "'";
    static final String END_STRING = "'";
    private static final String BEGIN_LIST_SHORT = "[ ";
    private static final String DELIMITER = ", ";
    private static final String LIST_LONG_END_PLUS_DELIMITER = "], ";
    private static final String LIST_SHORT_END_PLUS_DELIMITER = " ], ";
    private static final String STRING_END_PLUS_DELIMITER = "', ";
    private static final String[] INDENTATION_CACHE;
    private static final String ELEMENT_INDENTATION;
    private final String value;

    private Notation(String value) {
        this.value = Objects.requireNonNull(value);
    }

    public List<Object> parse() {
        return NotationParser.parse(this.value);
    }

    public static Notation forEncoding(byte[] encoding) {
        return Notation.forEncoding(encoding, 0, encoding.length);
    }

    public static Notation forEncoding(byte[] buffer, int index, int end) {
        if (index >= 0) {
            if (index <= (end = Math.min(buffer.length, end))) {
                StringBuilder sb = new StringBuilder(BEGIN_NOTATION);
                Notation.buildList(sb, buffer, index, end, 0, true);
                return new Notation(sb.append(END_NOTATION).toString());
            }
            throw new IllegalArgumentException("index > end: " + index + " > " + end);
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public static Notation forObjects(Object ... objects) {
        return Notation.forEncoding(RLPEncoder.encodeSequentially(objects));
    }

    public static Notation forObjects(Iterable<Object> objects) {
        return Notation.forEncoding(RLPEncoder.encodeSequentially(objects));
    }

    private static RuntimeException exceedsContainer(int index, long end, int containerEnd) {
        return new IllegalArgumentException("element @ index " + index + " exceeds its container: " + end + " > " + containerEnd);
    }

    private static int getShortElementEnd(int elementDataIndex, int elementDataLen, int containerEnd) {
        int end = elementDataIndex + elementDataLen;
        if (end <= containerEnd) {
            return end;
        }
        throw Notation.exceedsContainer(elementDataIndex - 1, end, containerEnd);
    }

    private static int getLongElementEnd(byte[] data, int leadByteIndex, int dataIndex, int containerEnd) {
        if (dataIndex <= containerEnd) {
            int lengthIndex = leadByteIndex + 1;
            int lengthLen = dataIndex - lengthIndex;
            long dataLenLong = Integers.getLong(data, leadByteIndex + 1, lengthLen, true);
            long end = (long)(lengthIndex + lengthLen) + dataLenLong;
            if (end > (long)containerEnd) {
                throw Notation.exceedsContainer(leadByteIndex, end, containerEnd);
            }
            int dataLen = (int)dataLenLong;
            if (dataLen >= 56) {
                return (int)end;
            }
            throw new IllegalArgumentException("long element data length must be 56 or greater; found: " + dataLen + " for element @ " + leadByteIndex);
        }
        throw Notation.exceedsContainer(leadByteIndex, dataIndex, containerEnd);
    }

    private static int buildString(StringBuilder sb, byte[] data, int from, int to) {
        int len = to - from;
        sb.append("'").append(Strings.encode(data, from, len, 0)).append(STRING_END_PLUS_DELIMITER);
        return to;
    }

    private static int buildList(StringBuilder sb, byte[] data, int dataIndex, int end, int depth, boolean longList) {
        if (!longList) {
            sb.append(BEGIN_LIST_SHORT);
        } else if (depth != 0) {
            sb.append(BEGIN_LIST);
        }
        String baseIndentation = longList ? Notation.getIndentation(depth) : null;
        int i = dataIndex;
        while (i < end) {
            byte lead;
            DataType type;
            if (longList) {
                sb.append('\n').append(baseIndentation).append(ELEMENT_INDENTATION);
            }
            if ((type = DataType.type(lead = data[i])) != DataType.SINGLE_BYTE) {
                int elementDataIdx = i + 1;
                if (type.isLong) {
                    if (longList) {
                        i = type.isString ? Notation.buildString(sb, data, elementDataIdx, Notation.getLongElementEnd(data, i, elementDataIdx, end)) : Notation.buildList(sb, data, elementDataIdx += lead - type.offset, Notation.getLongElementEnd(data, i, elementDataIdx, end), depth + 1, true);
                        continue;
                    }
                    throw new IllegalArgumentException("long element found in short list");
                }
                i = type.isString ? Notation.buildString(sb, data, elementDataIdx, Notation.getShortElementEnd(elementDataIdx, lead - type.offset, end)) : Notation.buildList(sb, data, elementDataIdx, Notation.getShortElementEnd(elementDataIdx, lead - type.offset, end), depth + 1, false);
                continue;
            }
            i = Notation.buildString(sb, data, i, i + 1);
        }
        if (dataIndex != end) {
            Notation.stripFinalDelimiter(sb);
        }
        if (!longList) {
            sb.append(LIST_SHORT_END_PLUS_DELIMITER);
        } else if (depth != 0) {
            sb.append('\n').append(baseIndentation).append(LIST_LONG_END_PLUS_DELIMITER);
        }
        return end;
    }

    private static String newIndentation(int n) {
        char[] spaces = new char[n << 1];
        Arrays.fill(spaces, ' ');
        return String.valueOf(spaces);
    }

    private static String getIndentation(int n) {
        return n < INDENTATION_CACHE.length ? INDENTATION_CACHE[n] : Notation.newIndentation(n);
    }

    private static void stripFinalDelimiter(StringBuilder sb) {
        int n = sb.length();
        sb.replace(n - DELIMITER.length(), n, "");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Notation && this.value.equals(((Notation)other).value);
    }

    public String toString() {
        return this.value;
    }

    static {
        ELEMENT_INDENTATION = Notation.newIndentation(1);
        INDENTATION_CACHE = new String[8];
        for (int i = 0; i < INDENTATION_CACHE.length; ++i) {
            Notation.INDENTATION_CACHE[i] = Notation.newIndentation(i);
        }
    }
}

