/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Strings;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class Integers {
    public static byte[] toBytes(byte val) {
        byte[] byArray;
        if (val != 0) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = val;
        } else {
            byArray = Strings.EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public static byte[] toBytes(short val) {
        byte[] bytes = new byte[Integers.len(val)];
        Integers.putShort(val, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(int val) {
        byte[] bytes = new byte[Integers.len(val)];
        Integers.putInt(val, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(long val) {
        byte[] bytes = new byte[Integers.len(val)];
        Integers.putLong(val, bytes, 0);
        return bytes;
    }

    public static byte[] toBytesUnsigned(BigInteger val) {
        byte[] bytes = new byte[Integers.len(val)];
        Integers.putBigInt(val, bytes, 0);
        return bytes;
    }

    public static int putByte(byte val, byte[] o, int i) {
        if (val != 0) {
            o[i] = val;
            return 1;
        }
        return 0;
    }

    public static int putShort(short val, byte[] o, int i) {
        if (val != 0) {
            byte b = (byte)val;
            if ((val = (short)(val >> 8)) != 0) {
                o[i] = (byte)val;
                o[i + 1] = b;
                return 2;
            }
            o[i] = b;
            return 1;
        }
        return 0;
    }

    public static int putInt(int val, byte[] o, int i) {
        if (val != 0) {
            byte d = (byte)val;
            if ((val >>>= 8) != 0) {
                byte c = (byte)val;
                if ((val >>>= 8) != 0) {
                    byte b = (byte)val;
                    if ((val >>>= 8) != 0) {
                        o[i] = (byte)val;
                        o[i + 1] = b;
                        o[i + 2] = c;
                        o[i + 3] = d;
                        return 4;
                    }
                    o[i] = b;
                    o[i + 1] = c;
                    o[i + 2] = d;
                    return 3;
                }
                o[i] = c;
                o[i + 1] = d;
                return 2;
            }
            o[i] = d;
            return 1;
        }
        return 0;
    }

    public static int putLong(long val, byte[] o, int i) {
        if (val != 0L) {
            byte h = (byte)val;
            if ((val >>>= 8) != 0L) {
                byte g = (byte)val;
                if ((val >>>= 8) != 0L) {
                    byte f = (byte)val;
                    if ((val >>>= 8) != 0L) {
                        byte e = (byte)val;
                        if ((val >>>= 8) != 0L) {
                            byte d = (byte)val;
                            if ((val >>>= 8) != 0L) {
                                byte c = (byte)val;
                                if ((val >>>= 8) != 0L) {
                                    byte b = (byte)val;
                                    if ((val >>>= 8) != 0L) {
                                        o[i] = (byte)val;
                                        o[i + 1] = b;
                                        o[i + 2] = c;
                                        o[i + 3] = d;
                                        o[i + 4] = e;
                                        o[i + 5] = f;
                                        o[i + 6] = g;
                                        o[i + 7] = h;
                                        return 8;
                                    }
                                    o[i] = b;
                                    o[i + 1] = c;
                                    o[i + 2] = d;
                                    o[i + 3] = e;
                                    o[i + 4] = f;
                                    o[i + 5] = g;
                                    o[i + 6] = h;
                                    return 7;
                                }
                                o[i] = c;
                                o[i + 1] = d;
                                o[i + 2] = e;
                                o[i + 3] = f;
                                o[i + 4] = g;
                                o[i + 5] = h;
                                return 6;
                            }
                            o[i] = d;
                            o[i + 1] = e;
                            o[i + 2] = f;
                            o[i + 3] = g;
                            o[i + 4] = h;
                            return 5;
                        }
                        o[i] = e;
                        o[i + 1] = f;
                        o[i + 2] = g;
                        o[i + 3] = h;
                        return 4;
                    }
                    o[i] = f;
                    o[i + 1] = g;
                    o[i + 2] = h;
                    return 3;
                }
                o[i] = g;
                o[i + 1] = h;
                return 2;
            }
            o[i] = h;
            return 1;
        }
        return 0;
    }

    public static int putLong(long val, ByteBuffer o) {
        if (val != 0L) {
            byte h = (byte)val;
            if ((val >>>= 8) != 0L) {
                byte g = (byte)val;
                if ((val >>>= 8) != 0L) {
                    byte f = (byte)val;
                    if ((val >>>= 8) != 0L) {
                        byte e = (byte)val;
                        if ((val >>>= 8) != 0L) {
                            byte d = (byte)val;
                            if ((val >>>= 8) != 0L) {
                                byte c = (byte)val;
                                if ((val >>>= 8) != 0L) {
                                    byte b = (byte)val;
                                    if ((val >>>= 8) != 0L) {
                                        o.put((byte)val).put(b).put(c).put(d).put(e).put(f).put(g).put(h);
                                        return 8;
                                    }
                                    o.put(b).put(c).put(d).put(e).put(f).put(g).put(h);
                                    return 7;
                                }
                                o.put(c).put(d).put(e).put(f).put(g).put(h);
                                return 6;
                            }
                            o.put(d).put(e).put(f).put(g).put(h);
                            return 5;
                        }
                        o.put(e).put(f).put(g).put(h);
                        return 4;
                    }
                    o.put(f).put(g).put(h);
                    return 3;
                }
                o.put(g).put(h);
                return 2;
            }
            o.put(h);
            return 1;
        }
        return 0;
    }

    public static byte getByte(byte[] buffer, int offset, int len, boolean lenient) {
        switch (len) {
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                return lead;
            }
            case 0: {
                return 0;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static short getShort(byte[] buffer, int offset, int len, boolean lenient) {
        int shiftAmount = 0;
        int val = 0;
        switch (len) {
            case 2: {
                val = buffer[offset + 1] & 0xFF;
                shiftAmount = 8;
            }
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                val |= (lead & 0xFF) << shiftAmount;
            }
            case 0: {
                return (short)val;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static int getInt(byte[] buffer, int offset, int len, boolean lenient) {
        int shiftAmount = 0;
        int val = 0;
        switch (len) {
            case 4: {
                val = buffer[offset + 3] & 0xFF;
                shiftAmount = 8;
            }
            case 3: {
                val |= (buffer[offset + 2] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= (buffer[offset + 1] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                val |= (lead & 0xFF) << shiftAmount;
            }
            case 0: {
                return val;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static long getLong(byte[] buffer, int offset, int len, boolean lenient) {
        int shiftAmount = 0;
        long val = 0L;
        switch (len) {
            case 8: {
                val = (long)buffer[offset + 7] & 0xFFL;
                shiftAmount = 8;
            }
            case 7: {
                val |= ((long)buffer[offset + 6] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 6: {
                val |= ((long)buffer[offset + 5] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 5: {
                val |= ((long)buffer[offset + 4] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 4: {
                val |= ((long)buffer[offset + 3] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 3: {
                val |= ((long)buffer[offset + 2] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= ((long)buffer[offset + 1] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                val |= ((long)lead & 0xFFL) << shiftAmount;
            }
            case 0: {
                return val;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    private static IllegalArgumentException leadingZeroException(int idx, int len) {
        return new IllegalArgumentException("deserialized integers with leading zeroes are invalid; index: " + idx + ", len: " + len);
    }

    private static IllegalArgumentException outOfRangeException(int len) {
        return new IllegalArgumentException("len is out of range: " + len);
    }

    public static int len(byte val) {
        return val != 0 ? 1 : 0;
    }

    public static int len(short val) {
        if (val != 0) {
            if (val >> 8 != 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int len(int val) {
        if (val != 0) {
            if ((val >>>= 8) != 0) {
                if ((val >>>= 8) != 0) {
                    if (val >>> 8 != 0) {
                        return 4;
                    }
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int len(long val) {
        if (val != 0L) {
            if ((val >>>= 8) != 0L) {
                if ((val >>>= 8) != 0L) {
                    if ((val >>>= 8) != 0L) {
                        if ((val >>>= 8) != 0L) {
                            if ((val >>>= 8) != 0L) {
                                if ((val >>>= 8) != 0L) {
                                    if (val >>> 8 != 0L) {
                                        return 8;
                                    }
                                    return 7;
                                }
                                return 6;
                            }
                            return 5;
                        }
                        return 4;
                    }
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int len(BigInteger val) {
        return Integers.roundLengthUp(val.bitLength(), 8) >> 3;
    }

    public static int bitLen(long val) {
        return 64 - Long.numberOfLeadingZeros(val);
    }

    public static BigInteger getBigInt(byte[] buffer, int offset, int len, boolean lenient) {
        if (len != 0) {
            if (!lenient && buffer[offset] == 0) {
                throw Integers.leadingZeroException(offset, len);
            }
            byte[] arr = new byte[1 + len];
            System.arraycopy(buffer, offset, arr, 1, len);
            return new BigInteger(arr);
        }
        return BigInteger.ZERO;
    }

    public static int putBigInt(BigInteger val, byte[] dest, int destIdx) {
        byte[] bytes = val.toByteArray();
        int srcPos = 0;
        int len = bytes.length;
        if (bytes[0] == 0) {
            ++srcPos;
            --len;
        }
        System.arraycopy(bytes, srcPos, dest, destIdx, len);
        return len;
    }

    public static int mod(int val, int powerOfTwo) {
        return val & powerOfTwo - 1;
    }

    public static int roundLengthUp(int len, int powerOfTwo) {
        int mod = Integers.mod(len, powerOfTwo);
        return mod != 0 ? len + (powerOfTwo - mod) : len;
    }

    public static void checkIsMultiple(int len, int powerOfTwo) {
        if (Integers.mod(len, powerOfTwo) != 0) {
            throw new IllegalArgumentException("expected length mod " + powerOfTwo + " == 0, found: " + len % powerOfTwo);
        }
    }
}

