/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;

public final class JsonUtils {
    public static JsonElement parse(String json) {
        return JsonParser.parseString((String)json);
    }

    public static JsonObject parseObject(String json) {
        return JsonUtils.parse(json).getAsJsonObject();
    }

    public static JsonArray parseArray(String json) {
        return JsonUtils.parse(json).getAsJsonArray();
    }

    public static String getString(JsonObject object, String key) {
        return JsonUtils.getString(object, key, null);
    }

    public static boolean getBoolean(JsonObject object, String key) {
        return JsonUtils.getBoolean(object, key, null);
    }

    public static JsonArray getArray(JsonObject object, String key) {
        return JsonUtils.getArray(object, key, null);
    }

    public static String getString(JsonObject object, String key, String defaultVal) {
        JsonElement element = object.get(key);
        if (element == null || element.isJsonNull()) {
            return defaultVal;
        }
        if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isString()) {
            throw new IllegalArgumentException(key + " is not a string");
        }
        return element.getAsString();
    }

    public static boolean getBoolean(JsonObject object, String key, Boolean defaultVal) {
        JsonElement element = object.get(key);
        if (element == null || element.isJsonNull()) {
            return defaultVal;
        }
        if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isBoolean()) {
            throw new IllegalArgumentException(key + " is not a boolean");
        }
        return element.getAsBoolean();
    }

    public static JsonArray getArray(JsonObject object, String key, JsonArray defaultVal) {
        JsonElement element = object.get(key);
        if (element == null || element.isJsonNull()) {
            return defaultVal;
        }
        return element.getAsJsonArray();
    }

    public static String toPrettyPrint(JsonElement element) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(element);
    }
}

