/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.abi.util.BizarroIntegers;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.rlp.util.Notation;
import com.esaulpaugh.headlong.rlp.util.NotationParser;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class SuperSerial {
    private static final byte[] TRUE = new byte[]{1};
    private static final byte[] FALSE = new byte[0];
    private static final int SIGN_BIT_MASK = 128;

    public static String serialize(TupleType tupleType, Tuple tuple, boolean machine) {
        tupleType.validate(tuple);
        Object[] objects = SuperSerial.serializeTuple(tupleType, tuple);
        return machine ? Strings.encode(RLPEncoder.encodeSequentially(objects)) : Notation.forObjects(objects).toString();
    }

    public static Tuple deserialize(TupleType tupleType, String str, boolean machine) {
        Tuple in = SuperSerial.deserializeTuple(tupleType, machine ? Strings.decode(str) : RLPEncoder.encodeSequentially(NotationParser.parse(str)));
        tupleType.validate(in);
        return in;
    }

    private static Object[] serializeTuple(TupleType tupleType, Object obj) {
        Tuple tuple = (Tuple)obj;
        int len = tupleType.size();
        Object[] out = new Object[len];
        for (int i = 0; i < len; ++i) {
            out[i] = SuperSerial.serialize(tupleType.get(i), tuple.get(i));
        }
        return out;
    }

    private static Tuple deserializeTuple(TupleType tupleType, byte[] sequence) {
        Iterator<RLPItem> sequenceIterator = RLPDecoder.RLP_STRICT.sequenceIterator(sequence);
        int len = tupleType.size();
        Object[] elements = new Object[len];
        for (int i = 0; i < len; ++i) {
            elements[i] = SuperSerial.deserialize(tupleType.get(i), sequenceIterator.next());
        }
        if (sequenceIterator.hasNext()) {
            throw new IllegalArgumentException("trailing unconsumed items");
        }
        return new Tuple(elements);
    }

    private static Object serialize(ABIType<?> type, Object obj) {
        int typeCode = type.typeCode();
        switch (typeCode) {
            case 0: {
                return (Boolean)obj != false ? TRUE : FALSE;
            }
            case 1: {
                return Integers.toBytes((Byte)obj);
            }
            case 2: {
                return SuperSerial.toSigned(((IntType)type).getBitLength(), BigInteger.valueOf(((Integer)obj).intValue()));
            }
            case 3: {
                return SuperSerial.toSigned(((LongType)type).getBitLength(), BigInteger.valueOf((Long)obj));
            }
            case 4: 
            case 5: {
                return SuperSerial.serializeBigInteger((UnitType)type, typeCode == 4 ? (BigInteger)obj : ((BigDecimal)obj).unscaledValue());
            }
            case 6: {
                return SuperSerial.serializeArray((ArrayType)type, obj);
            }
            case 7: {
                return SuperSerial.serializeTuple((TupleType)type, obj);
            }
        }
        throw new Error();
    }

    private static Object serializeBigInteger(UnitType<?> ut, BigInteger bigInt) {
        return ut.isUnsigned() ? Integers.toBytesUnsigned(bigInt) : SuperSerial.toSigned(ut.getBitLength(), bigInt);
    }

    private static Object deserialize(ABIType<?> type, RLPItem item) {
        int typeCode = type.typeCode();
        if (typeCode < 6 && item.isList()) {
            throw new IllegalArgumentException("RLP list items not allowed for this type: " + type + "\n" + item);
        }
        switch (typeCode) {
            case 0: {
                return item.asBoolean();
            }
            case 1: {
                return item.asByte(false);
            }
            case 2: 
            case 3: {
                return SuperSerial.deserializePrimitive((UnitType)type, item, typeCode == 2);
            }
            case 4: 
            case 5: {
                UnitType ut = (UnitType)type;
                BigInteger bigInt = SuperSerial.deserializeBigInteger(ut, item);
                return typeCode == 4 ? bigInt : new BigDecimal(bigInt, ((BigDecimalType)ut).getScale());
            }
            case 6: {
                return SuperSerial.deserializeArray((ArrayType)type, item);
            }
            case 7: {
                return SuperSerial.deserializeTuple((TupleType)type, item.asBytes());
            }
        }
        throw new Error();
    }

    private static Object deserializePrimitive(UnitType<?> ut, RLPItem item, boolean isInt) {
        if (ut.isUnsigned() || item.dataLength * 8 < ut.getBitLength()) {
            return isInt ? (Number)item.asInt(false) : (Number)item.asLong(false);
        }
        byte[] data = item.data();
        int len = data.length;
        if (len > 0 && (data[0] & 0x80) != 0) {
            return isInt ? (Number)BizarroIntegers.getInt(data, 0, len) : (Number)BizarroIntegers.getLong(data, 0, len);
        }
        return isInt ? (Number)Integers.getInt(data, 0, len, false) : (Number)Integers.getLong(data, 0, len, false);
    }

    private static BigInteger deserializeBigInteger(UnitType<?> ut, RLPItem item) {
        return ut.isUnsigned() ? item.asBigInt(false) : SuperSerial.asSigned(ut.getBitLength(), item);
    }

    private static byte[] toSigned(int typeBits, BigInteger val) {
        int signum = val.signum();
        if (signum == 0) {
            return Strings.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = val.toByteArray();
        return signum < 0 ? SuperSerial.signExtendNegative(bytes, typeBits / 8) : (bytes[0] != 0 ? bytes : Arrays.copyOfRange(bytes, 1, bytes.length));
    }

    private static byte[] signExtendNegative(byte[] negative, int newWidth) {
        byte[] extended = new byte[newWidth];
        Arrays.fill(extended, (byte)-1);
        System.arraycopy(negative, 0, extended, newWidth - negative.length, negative.length);
        return extended;
    }

    private static BigInteger asSigned(int typeBits, RLPItem item) {
        int dataLen = item.dataLength;
        if (dataLen != 0) {
            if (dataLen * 8 < typeBits) {
                byte[] padded = new byte[dataLen + 1];
                item.exportData(padded, 1);
                return new BigInteger(padded);
            }
            if (dataLen > 32) {
                throw new IllegalArgumentException("integer data cannot exceed 32 bytes");
            }
            return item.asBigIntSigned();
        }
        return BigInteger.ZERO;
    }

    private static Object serializeArray(ArrayType<? extends ABIType<?>, ?> arrayType, Object arr) {
        ABIType<?> elementType = arrayType.getElementType();
        switch (elementType.typeCode()) {
            case 0: {
                return SuperSerial.serializeBooleanArray(arr);
            }
            case 1: {
                return SuperSerial.serializeByteArray(arrayType, arr);
            }
            case 2: {
                return SuperSerial.serializeIntArray(arr);
            }
            case 3: {
                return SuperSerial.serializeLongArray(arr);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return SuperSerial.serializeObjectArray(arr, elementType);
            }
        }
        throw new Error();
    }

    private static Object deserializeArray(ArrayType<? extends ABIType<?>, ?> arrayType, RLPItem item) {
        ABIType<?> elementType = arrayType.getElementType();
        switch (elementType.typeCode()) {
            case 0: {
                return SuperSerial.deserializeBooleanArray((RLPList)item);
            }
            case 1: {
                return SuperSerial.deserializeByteArray(arrayType, (RLPString)item);
            }
            case 2: {
                return SuperSerial.deserializeIntArray((RLPList)item);
            }
            case 3: {
                return SuperSerial.deserializeLongArray((RLPList)item);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return SuperSerial.deserializeObjectArray(elementType, (RLPList)item);
            }
        }
        throw new Error();
    }

    private static byte[][] serializeBooleanArray(Object arr) {
        boolean[] booleans = (boolean[])arr;
        int len = booleans.length;
        byte[][] out = new byte[len][];
        for (int i = 0; i < len; ++i) {
            out[i] = booleans[i] ? TRUE : FALSE;
        }
        return out;
    }

    private static boolean[] deserializeBooleanArray(RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        boolean[] in = new boolean[elements.size()];
        int i = 0;
        for (RLPItem e : elements) {
            in[i++] = e.asBoolean();
        }
        return in;
    }

    private static byte[] serializeByteArray(ArrayType<? extends ABIType<?>, ?> arrayType, Object arr) {
        return arrayType.isString() ? Strings.decode((String)arr, 1) : (byte[])arr;
    }

    private static Object deserializeByteArray(ArrayType<? extends ABIType<?>, ?> arrayType, RLPString string) {
        return arrayType.isString() ? (Object)string.asString(1) : string.asBytes();
    }

    private static byte[][] serializeIntArray(Object arr) {
        int[] ints = (int[])arr;
        int len = ints.length;
        byte[][] out = new byte[len][];
        for (int i = 0; i < len; ++i) {
            out[i] = Integers.toBytes(ints[i]);
        }
        return out;
    }

    private static int[] deserializeIntArray(RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        int[] in = new int[elements.size()];
        int i = 0;
        for (RLPItem e : elements) {
            in[i++] = e.asInt(false);
        }
        return in;
    }

    private static byte[][] serializeLongArray(Object arr) {
        long[] longs = (long[])arr;
        int len = longs.length;
        byte[][] out = new byte[len][];
        for (int i = 0; i < len; ++i) {
            out[i] = Integers.toBytes(longs[i]);
        }
        return out;
    }

    private static long[] deserializeLongArray(RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        long[] in = new long[elements.size()];
        int i = 0;
        for (RLPItem e : elements) {
            in[i++] = e.asLong();
        }
        return in;
    }

    private static Object[] serializeObjectArray(Object arr, ABIType<?> elementType) {
        Object[] objects = (Object[])arr;
        int len = objects.length;
        Object[] out = new Object[len];
        for (int i = 0; i < len; ++i) {
            out[i] = SuperSerial.serialize(elementType, objects[i]);
        }
        return out;
    }

    private static Object[] deserializeObjectArray(ABIType<?> elementType, RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        Object[] in = (Object[])Array.newInstance(elementType.clazz(), elements.size());
        int i = 0;
        for (RLPItem e : elements) {
            in[i++] = SuperSerial.deserialize(elementType, e);
        }
        return in;
    }
}

