/*
 * Decompiled with CFR 0.152.
 */
package com.migcomponents.migbase64;

public final class Base64 {
    public static final int NO_FLAGS = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_LINE_SEP = 2;
    public static final int URL_SAFE_CHARS = 4;
    private static final char[] TABLE_STANDARD = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] TABLE_URL_SAFE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();

    public static String encodeToString(byte[] buffer, int off, int len, int flags) {
        byte[] enc = Base64.encodeToBytes(buffer, off, len, flags);
        return new String(enc, 0, 0, enc.length);
    }

    public static byte[] encodeToBytes(byte[] buffer, int bytesOff, int bytesLen, int flags) {
        int charsRemainder;
        boolean noPad = (flags & 1) != 0;
        boolean noLineSep = (flags & 2) != 0;
        char[] table = (flags & 4) != 0 ? TABLE_URL_SAFE : TABLE_STANDARD;
        int bytesChunks = bytesLen / 3;
        int bytesEvenLen = bytesChunks * 3;
        int bytesRemainder = bytesLen - bytesEvenLen;
        int n = bytesRemainder == 1 ? 2 : (charsRemainder = bytesRemainder == 2 ? 3 : 0);
        int rawLen = (bytesChunks << 2) + (noPad ? charsRemainder : (charsRemainder != 0 ? 4 : 0));
        int outLen = noLineSep ? rawLen : rawLen + ((rawLen - 1) / 76 << 1);
        byte[] out = new byte[outLen];
        int lineSepLim = outLen - 2;
        int endEvenBytes = bytesOff + bytesEvenLen;
        int i = bytesOff;
        int o = 0;
        int chungus = 0;
        while (i < endEvenBytes) {
            int v = (buffer[i++] & 0xFF) << 16 | (buffer[i++] & 0xFF) << 8 | buffer[i++] & 0xFF;
            out[o++] = (byte)table[v >>> 18];
            out[o++] = (byte)table[v >>> 12 & 0x3F];
            out[o++] = (byte)table[v >>> 6 & 0x3F];
            out[o++] = (byte)table[v & 0x3F];
            if (noLineSep || ++chungus != 19 || o >= lineSepLim) continue;
            out[o++] = 13;
            out[o++] = 10;
            chungus = 0;
        }
        if (bytesRemainder > 0) {
            boolean twoBytesLeft = false;
            int v = 0;
            switch (bytesRemainder) {
                case 2: {
                    v |= (buffer[endEvenBytes + 1] & 0xFF) << 2;
                    twoBytesLeft = true;
                }
                case 1: {
                    v |= (buffer[endEvenBytes] & 0xFF) << 10;
                }
            }
            int charsLeft = noPad ? charsRemainder : charsRemainder + (twoBytesLeft ? 1 : 2);
            int charsIdx = outLen - charsLeft;
            switch (charsLeft) {
                case 4: {
                    out[charsIdx + 3] = 61;
                }
                case 3: {
                    out[charsIdx + 2] = (byte)(twoBytesLeft ? table[v & 0x3F] : 61);
                }
                case 2: {
                    out[charsIdx + 1] = (byte)table[v >> 6 & 0x3F];
                }
            }
            out[charsIdx] = (byte)table[v >> 12];
        }
        return out;
    }
}

